/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.dao;

import br.com.gertec.tc.server.dao.ExhibitionParam;
import br.com.gertec.tc.server.util.NamedColor;
import br.com.gertec.tc.server.util.Palette;
import br.com.gertec.tc.server.util.jdbc.JdbcConnection;
import br.com.gertec.tc.server.util.jdbc.JdbcResultSet;
import br.com.gertec.tc.server.util.jdbc.JdbcStatment;
import java.util.Objects;
import java.util.regex.Pattern;

public class Exhibition {
    private static final int PROPERTY_COL_BG_COLOR = 0;
    private static final int PROPERTY_COL_MEDIA_TYPE = 1;
    private static final int PROPERTY_COL_MEDIA_PATH = 2;
    private static final int PROPERTY_COL_DESCRIPTION = 3;
    private static final int PROPERTY_COL_BARCODE = 4;
    private static final int PROPERTY_COL_PRICE1 = 5;
    private static final int PROPERTY_COL_PRICE2 = 6;
    private static final int PROPERTY_COL_LABEL1 = 7;
    private static final int PROPERTY_COL_LABEL2 = 8;
    private static final String PROPERTY_DELIMITER = "|";
    static final String TABLE_EXHIB = "EXHIBITION";
    static final String COL_PK_EXHIB_ID = "EXHIB_ID";
    static final String COL_BG_COLOR = "BACKGROUND_COLOR";
    static final String COL_MEDIA_TYPE = "MEDIA_TYPE";
    static final String COL_MEDIA_PATH = "MEDIA_PATH";
    static final String COL_FK_DESCRIPTION = "DESCRIPTION";
    static final String COL_FK_BARCODE = "BARCODE";
    static final String COL_FK_PRICE_1 = "PRICE_1";
    static final String COL_FK_PRICE_2 = "PRICE_2";
    static final String COL_FK_LABEL_1 = "LABEL_1";
    static final String COL_FK_LABEL_2 = "LABEL_2";
    private static ExhibitionDao currentDao = null;
    private final boolean readOnly;
    private boolean modified;
    private boolean linked;
    private Integer id;
    private NamedColor bgColor;
    private MediaType mediaType;
    private String mediaPath;
    private ExhibitionParam description;
    private ExhibitionParam barcode;
    private ExhibitionParam price1;
    private ExhibitionParam price2;
    private ExhibitionParam label1;
    private ExhibitionParam label2;
    private ExhibitionParam gtin;
    private ExhibitionParam regAnvisa;
    private ExhibitionParam numAnvisa;
    private ExhibitionParam codSerial;
    private ExhibitionParam numSerial;
    private ExhibitionParam dateVal;
    private ExhibitionParam data;
    private ExhibitionParam lote;
    private ExhibitionParam numLote;

    public static synchronized H2ExhibitionDao getCurrentDao() {
        if (currentDao == null) {
            throw new IllegalStateException("There is no DAO");
        }
        return (H2ExhibitionDao)currentDao;
    }

    public static synchronized void setCurrentDao(H2ExhibitionDao dao) {
        if (dao == null) {
            throw new IllegalArgumentException("DAO cannot be null");
        }
        currentDao = dao;
        currentDao.init();
    }

    public static synchronized Exhibition get(Integer id) {
        return Exhibition.getCurrentDao().get(id);
    }

    public static synchronized Exhibition combine(Exhibition reference, Exhibition exhibition) {
        if (exhibition == null) {
            return reference;
        }
        Exhibition result = new Exhibition();
        result.setBgColor(exhibition.getBgColor() == null ? reference.getBgColor() : exhibition.getBgColor());
        result.setMediaType(exhibition.getMediaType() == null ? reference.getMediaType() : exhibition.getMediaType());
        result.setMediaPath(exhibition.getMediaPath() == null ? reference.getMediaPath() : exhibition.getMediaPath());
        ExhibitionParam refEparam = reference.getDescription();
        ExhibitionParam tmpEparam = exhibition.getDescription();
        ExhibitionParam resultEparam = tmpEparam == null ? refEparam : ExhibitionParam.combine(refEparam, tmpEparam);
        result.setDescription(resultEparam);
        refEparam = reference.getBarcode();
        tmpEparam = exhibition.getBarcode();
        resultEparam = tmpEparam == null ? refEparam : ExhibitionParam.combine(refEparam, tmpEparam);
        result.setBarcode(resultEparam);
        refEparam = reference.getPrice1();
        tmpEparam = exhibition.getPrice1();
        resultEparam = tmpEparam == null ? refEparam : ExhibitionParam.combine(refEparam, tmpEparam);
        result.setPrice1(resultEparam);
        refEparam = reference.getPrice2();
        tmpEparam = exhibition.getPrice2();
        resultEparam = tmpEparam == null ? refEparam : ExhibitionParam.combine(refEparam, tmpEparam);
        result.setPrice2(resultEparam);
        refEparam = reference.getLabel1();
        tmpEparam = exhibition.getLabel1();
        resultEparam = tmpEparam == null ? refEparam : ExhibitionParam.combine(refEparam, tmpEparam);
        result.setLabel1(resultEparam);
        refEparam = reference.getLabel2();
        tmpEparam = exhibition.getLabel2();
        resultEparam = tmpEparam == null ? refEparam : ExhibitionParam.combine(refEparam, tmpEparam);
        result.setLabel2(resultEparam);
        return result;
    }

    public Exhibition(NamedColor bgColor, MediaType mediaType, String mediaPath, ExhibitionParam description, ExhibitionParam barcode, ExhibitionParam price1, ExhibitionParam price2, ExhibitionParam label1, ExhibitionParam label2) {
        this.readOnly = true;
        this.bgColor = bgColor;
        this.mediaType = mediaType;
        this.mediaPath = mediaPath;
        if (!description.isReadOnly()) {
            throw new IllegalArgumentException("Expected read-only instance arg for description");
        }
        this.description = description;
        if (!barcode.isReadOnly()) {
            throw new IllegalArgumentException("Expected read-only instance arg for barcode");
        }
        this.barcode = barcode;
        if (!price1.isReadOnly()) {
            throw new IllegalArgumentException("Expected read-only instance arg for price1");
        }
        this.price1 = price1;
        if (!price2.isReadOnly()) {
            throw new IllegalArgumentException("Expected read-only instance arg for price2");
        }
        this.price2 = price2;
        if (!label1.isReadOnly()) {
            throw new IllegalArgumentException("Expected read-only instance arg for label1");
        }
        this.label1 = label1;
        if (!label2.isReadOnly()) {
            throw new IllegalArgumentException("Expected read-only instance arg for label2");
        }
        this.label2 = label2;
    }

    public Exhibition(NamedColor bgColor, ExhibitionParam description, ExhibitionParam price1, ExhibitionParam price2, ExhibitionParam gtin, ExhibitionParam barcode, ExhibitionParam regAnvisa, ExhibitionParam numAnvisa, ExhibitionParam codSerial, ExhibitionParam numSerial, ExhibitionParam dateVal, ExhibitionParam data, ExhibitionParam lote, ExhibitionParam numLote) {
        this.readOnly = true;
        this.bgColor = bgColor;
        this.gtin = gtin;
        this.regAnvisa = regAnvisa;
        this.numAnvisa = numAnvisa;
        this.codSerial = codSerial;
        this.numSerial = numSerial;
        this.dateVal = dateVal;
        this.data = data;
        this.lote = lote;
        this.numLote = numLote;
        this.description = description;
        this.barcode = barcode;
        this.price1 = price1;
        this.price2 = price2;
    }

    public Exhibition() {
        this.readOnly = false;
        this.setModified(true);
        this.setLinked(false);
    }

    public Exhibition(String propertyString) {
        this();
        String[] tokens = propertyString.split(Pattern.quote(PROPERTY_DELIMITER));
        block11: for (int i = 0; i <= 8; ++i) {
            String token = tokens[i];
            switch (i) {
                case 0: {
                    this.bgColor = token.isEmpty() ? null : NamedColor.fromId(Short.parseShort(token));
                    continue block11;
                }
                case 1: {
                    this.mediaType = token.isEmpty() ? null : MediaType.valueOf(token);
                    continue block11;
                }
                case 2: {
                    this.mediaPath = token.isEmpty() ? null : token;
                    continue block11;
                }
                case 3: {
                    this.description = token.isEmpty() ? null : new ExhibitionParam(token);
                    continue block11;
                }
                case 4: {
                    this.barcode = token.isEmpty() ? null : new ExhibitionParam(token);
                    continue block11;
                }
                case 5: {
                    this.price1 = token.isEmpty() ? null : new ExhibitionParam(token);
                    continue block11;
                }
                case 6: {
                    this.price2 = token.isEmpty() ? null : new ExhibitionParam(token);
                    continue block11;
                }
                case 7: {
                    this.label1 = token.isEmpty() ? null : new ExhibitionParam(token);
                    continue block11;
                }
                case 8: {
                    this.label2 = token.isEmpty() ? null : new ExhibitionParam(token);
                }
            }
        }
    }

    Exhibition(JdbcResultSet rs) {
        this.readOnly = false;
        this.id = rs.getInt(COL_PK_EXHIB_ID);
        this.bgColor = Palette.getInstance().getColor(rs.getShort(COL_BG_COLOR));
        this.mediaType = rs.getEnum(MediaType.class, COL_MEDIA_TYPE);
        this.mediaPath = rs.getString(COL_MEDIA_PATH);
        this.description = ExhibitionParam.get(rs.getInt(COL_FK_DESCRIPTION));
        this.barcode = ExhibitionParam.get(rs.getInt(COL_FK_BARCODE));
        this.price1 = ExhibitionParam.get(rs.getInt(COL_FK_PRICE_1));
        this.price2 = ExhibitionParam.get(rs.getInt(COL_FK_PRICE_2));
        this.label1 = ExhibitionParam.get(rs.getInt(COL_FK_LABEL_1));
        this.label2 = ExhibitionParam.get(rs.getInt(COL_FK_LABEL_2));
        this.setModified(false);
        this.setLinked(true);
    }

    private void throwIfReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Instance is read-only");
        }
    }

    public Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.throwIfReadOnly();
        this.id = id;
    }

    public boolean isModified() {
        return this.modified;
    }

    private void setModified(boolean modified) {
        this.throwIfReadOnly();
        this.modified = modified;
    }

    public boolean isLinked() {
        return this.linked;
    }

    private void setLinked(boolean linked) {
        this.throwIfReadOnly();
        this.linked = linked;
    }

    public NamedColor getBgColor() {
        return this.bgColor;
    }

    public Exhibition setBgColor(NamedColor bgColor) {
        this.throwIfReadOnly();
        if (!Objects.equals((Object)this.bgColor, (Object)bgColor)) {
            this.bgColor = bgColor;
            this.setModified(true);
        }
        return this;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public Exhibition setMediaType(MediaType mediaType) {
        this.throwIfReadOnly();
        if (!Objects.equals((Object)this.mediaType, (Object)mediaType)) {
            this.mediaType = mediaType;
            this.setModified(true);
        }
        return this;
    }

    public String getMediaPath() {
        return this.mediaPath;
    }

    public Exhibition setMediaPath(String mediaPath) {
        this.throwIfReadOnly();
        if (!Objects.equals(this.mediaPath, mediaPath)) {
            this.mediaPath = mediaPath;
            this.setModified(true);
        }
        return this;
    }

    public ExhibitionParam getDescription() {
        return this.description;
    }

    public Exhibition setDescription(ExhibitionParam description) {
        this.throwIfReadOnly();
        if (!Objects.equals(this.description, description)) {
            this.description = description;
            this.setModified(true);
        }
        return this;
    }

    public ExhibitionParam getBarcode() {
        return this.barcode;
    }

    public Exhibition setBarcode(ExhibitionParam barcode) {
        this.throwIfReadOnly();
        if (!Objects.equals(this.barcode, barcode)) {
            this.barcode = barcode;
            this.setModified(true);
        }
        return this;
    }

    public ExhibitionParam getPrice1() {
        return this.price1;
    }

    public Exhibition setPrice1(ExhibitionParam price1) {
        this.throwIfReadOnly();
        if (!Objects.equals(this.price1, price1)) {
            this.price1 = price1;
            this.setModified(true);
        }
        return this;
    }

    public ExhibitionParam getPrice2() {
        return this.price2;
    }

    public Exhibition setPrice2(ExhibitionParam price2) {
        this.throwIfReadOnly();
        if (!Objects.equals(this.price2, price2)) {
            this.price2 = price2;
            this.setModified(true);
        }
        return this;
    }

    public ExhibitionParam getLabel1() {
        return this.label1;
    }

    public Exhibition setLabel1(ExhibitionParam label1) {
        this.throwIfReadOnly();
        if (!Objects.equals(this.label1, label1)) {
            this.label1 = label1;
            this.setModified(true);
        }
        return this;
    }

    public ExhibitionParam getLabel2() {
        return this.label2;
    }

    public Exhibition setLabel2(ExhibitionParam label2) {
        this.throwIfReadOnly();
        if (!Objects.equals(this.label2, label2)) {
            this.label2 = label2;
            this.setModified(true);
        }
        return this;
    }

    public boolean equals(Object obj) {
        try {
            Exhibition other = (Exhibition)obj;
            return Objects.equals(this.getId(), other.getId());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public void save() {
        this.throwIfReadOnly();
        this.setModified(true);
        Exhibition.getCurrentDao().save(this);
    }

    public void delete() {
        this.throwIfReadOnly();
        if (this.isLinked()) {
            Exhibition.getCurrentDao().delete(this);
        }
    }

    public Exhibition clone() {
        Exhibition e = new Exhibition();
        e.setBgColor(this.getBgColor());
        e.setMediaType(this.getMediaType());
        e.setMediaPath(this.getMediaPath());
        ExhibitionParam ep = this.getDescription();
        e.setDescription(ep != null ? ep.clone() : null);
        ep = this.getBarcode();
        e.setBarcode(ep != null ? ep.clone() : null);
        ep = this.getLabel1();
        e.setLabel1(ep != null ? ep.clone() : null);
        ep = this.getLabel2();
        e.setLabel2(ep != null ? ep.clone() : null);
        ep = this.getPrice1();
        e.setPrice1(ep != null ? ep.clone() : null);
        ep = this.getPrice2();
        e.setPrice2(ep != null ? ep.clone() : null);
        return e;
    }

    public String getPropertyString() {
        StringBuilder sb = new StringBuilder();
        block11: for (int i = 0; i <= 8; ++i) {
            if (i > 0) {
                sb.append(PROPERTY_DELIMITER);
            }
            switch (i) {
                case 0: {
                    sb.append(this.getBgColor() == null ? "" : this.getBgColor().getId());
                    continue block11;
                }
                case 1: {
                    sb.append(this.getMediaType() == null ? "" : this.getMediaType().name());
                    continue block11;
                }
                case 2: {
                    sb.append(this.getMediaPath() == null ? "" : this.getMediaPath());
                    continue block11;
                }
                case 3: {
                    sb.append(this.getDescription() == null ? "" : this.getDescription().getPropertyString());
                    continue block11;
                }
                case 4: {
                    sb.append(this.getBarcode() == null ? "" : this.getBarcode().getPropertyString());
                    continue block11;
                }
                case 5: {
                    sb.append(this.getPrice1() == null ? "" : this.getPrice1().getPropertyString());
                    continue block11;
                }
                case 6: {
                    sb.append(this.getPrice2() == null ? "" : this.getPrice2().getPropertyString());
                    continue block11;
                }
                case 7: {
                    sb.append(this.getLabel1() == null ? "" : this.getLabel1().getPropertyString());
                    continue block11;
                }
                case 8: {
                    sb.append(this.getLabel2() == null ? "" : this.getLabel2().getPropertyString());
                }
            }
        }
        return sb.toString();
    }

    public ExhibitionParam getGTIN() {
        return this.gtin;
    }

    public void setGTIN(ExhibitionParam gTIN) {
        this.gtin = gTIN;
    }

    public ExhibitionParam getRegAnvisa() {
        return this.regAnvisa;
    }

    public void setRegAnvisa(ExhibitionParam regAnvisa) {
        this.regAnvisa = regAnvisa;
    }

    public ExhibitionParam getNumAnvisa() {
        return this.numAnvisa;
    }

    public void setNumAnvisa(ExhibitionParam numAnvisa) {
        this.numAnvisa = numAnvisa;
    }

    public ExhibitionParam getCodSerial() {
        return this.codSerial;
    }

    public void setCodSerial(ExhibitionParam codSerial) {
        this.codSerial = codSerial;
    }

    public ExhibitionParam getNumSerial() {
        return this.numSerial;
    }

    public void setNumSerial(ExhibitionParam numSerial) {
        this.numSerial = numSerial;
    }

    public ExhibitionParam getDateVal() {
        return this.dateVal;
    }

    public void setDateVal(ExhibitionParam dateVal) {
        this.dateVal = dateVal;
    }

    public ExhibitionParam getData() {
        return this.data;
    }

    public void setData(ExhibitionParam data) {
        this.data = data;
    }

    public ExhibitionParam getLote() {
        return this.lote;
    }

    public void setLote(ExhibitionParam lote) {
        this.lote = lote;
    }

    public ExhibitionParam getNumLote() {
        return this.numLote;
    }

    public void setNumLote(ExhibitionParam numLote) {
        this.numLote = numLote;
    }

    public static class H2ExhibitionDao
    implements ExhibitionDao {
        private final JdbcConnection connection;

        public H2ExhibitionDao(JdbcConnection connection) {
            if (connection == null) {
                throw new IllegalArgumentException("null connection");
            }
            this.connection = connection;
        }

        public final JdbcConnection getConnection() {
            return this.connection;
        }

        @Override
        public Exhibition get(Integer id) {
            JdbcConnection connection = this.getConnection();
            if (id == null) {
                return null;
            }
            String sql = String.format("SELECT * FROM %s WHERE %s = ?", Exhibition.TABLE_EXHIB, Exhibition.COL_PK_EXHIB_ID);
            JdbcStatment stmt = connection.prepareStatement(sql);
            stmt.set(1, id);
            JdbcResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                return null;
            }
            Exhibition instance = new Exhibition(rs);
            rs.close();
            stmt.close();
            return instance;
        }

        private void create(Exhibition exhibition) {
            JdbcConnection connection = this.getConnection();
            if (exhibition.getId() != null) {
                throw new IllegalArgumentException("Given bean has an ID");
            }
            if (exhibition.isLinked()) {
                throw new IllegalArgumentException("Instance is linked");
            }
            exhibition.getDescription().save();
            exhibition.getBarcode().save();
            exhibition.getPrice1().save();
            exhibition.getPrice2().save();
            exhibition.getLabel1().save();
            exhibition.getLabel2().save();
            String sql = "INSERT INTO " + Exhibition.TABLE_EXHIB + " (" + Exhibition.COL_BG_COLOR + "," + Exhibition.COL_MEDIA_TYPE + "," + Exhibition.COL_MEDIA_PATH + "," + Exhibition.COL_FK_DESCRIPTION + "," + Exhibition.COL_FK_BARCODE + "," + Exhibition.COL_FK_PRICE_1 + "," + Exhibition.COL_FK_PRICE_2 + "," + Exhibition.COL_FK_LABEL_1 + "," + Exhibition.COL_FK_LABEL_2 + ") VALUES (" + "?" + "," + "?" + "," + "?" + "," + "?" + "," + "?" + "," + "?" + "," + "?" + "," + "?" + "," + "?" + ")";
            JdbcStatment stmt = connection.prepareStatement(sql);
            stmt.set(1, Palette.getInstance().getColorId(exhibition.getBgColor()));
            stmt.set(2, exhibition.getMediaType());
            stmt.set(3, exhibition.getMediaPath());
            stmt.set(4, exhibition.getDescription().getId());
            stmt.set(5, exhibition.getBarcode().getId());
            stmt.set(6, exhibition.getPrice1().getId());
            stmt.set(7, exhibition.getPrice2().getId());
            stmt.set(8, exhibition.getLabel1().getId());
            stmt.set(9, exhibition.getLabel2().getId());
            stmt.execute();
            JdbcResultSet keyRs = stmt.getGeneratedKeys();
            keyRs.next();
            Integer generatedId = keyRs.getInt(1);
            keyRs.close();
            stmt.close();
            exhibition.setId(generatedId);
            exhibition.setModified(false);
            exhibition.setLinked(true);
        }

        @Override
        public void save(Exhibition exhibition) {
            JdbcConnection connection = this.getConnection();
            if (!exhibition.isModified()) {
                return;
            }
            if (!exhibition.isLinked()) {
                this.create(exhibition);
            }
            exhibition.getDescription().save();
            exhibition.getBarcode().save();
            exhibition.getPrice1().save();
            exhibition.getPrice2().save();
            exhibition.getLabel1().save();
            exhibition.getLabel2().save();
            StringBuilder sqlFormat = new StringBuilder("UPDATE %s SET ").append("%s = ?").append(", ").append("%s = ?").append(", ").append("%s = ?").append(", ").append("%s = ?").append(", ").append("%s = ?").append(", ").append("%s = ?").append(", ").append("%s = ?").append(", ").append("%s = ?").append(", ").append("%s = ?").append("WHERE %s = ?");
            String sql = String.format(sqlFormat.toString(), Exhibition.TABLE_EXHIB, Exhibition.COL_BG_COLOR, Exhibition.COL_MEDIA_TYPE, Exhibition.COL_MEDIA_PATH, Exhibition.COL_FK_DESCRIPTION, Exhibition.COL_FK_BARCODE, Exhibition.COL_FK_PRICE_1, Exhibition.COL_FK_PRICE_2, Exhibition.COL_FK_LABEL_1, Exhibition.COL_FK_LABEL_2, Exhibition.COL_PK_EXHIB_ID);
            JdbcStatment stmt = connection.prepareStatement(sql);
            stmt.set(1, Palette.getInstance().getColorId(exhibition.getBgColor()));
            stmt.set(2, exhibition.getMediaType());
            stmt.set(3, exhibition.getMediaPath());
            stmt.set(4, exhibition.getDescription().getId());
            stmt.set(5, exhibition.getBarcode().getId());
            stmt.set(6, exhibition.getPrice1().getId());
            stmt.set(7, exhibition.getPrice2().getId());
            stmt.set(8, exhibition.getLabel1().getId());
            stmt.set(9, exhibition.getLabel2().getId());
            stmt.set(10, exhibition.getId());
            stmt.execute();
            stmt.close();
            exhibition.setModified(false);
        }

        @Override
        public void init() {
            if (!this.getConnection().getTableNames().contains(Exhibition.TABLE_EXHIB)) {
                StringBuilder sqlFormat = new StringBuilder("CREATE TABLE %s (").append("%s INT PRIMARY KEY AUTO_INCREMENT, ").append("%s INT, ").append("%s VARCHAR(100), ").append("%s VARCHAR(100), ").append("%s INT, ").append("%s INT, ").append("%s INT, ").append("%s INT, ").append("%s INT, ").append("%s INT, ").append("FOREIGN KEY(%s) REFERENCES %s(%s) ON DELETE CASCADE, ").append("FOREIGN KEY(%s) REFERENCES %s(%s), ").append("FOREIGN KEY(%s) REFERENCES %s(%s), ").append("FOREIGN KEY(%s) REFERENCES %s(%s), ").append("FOREIGN KEY(%s) REFERENCES %s(%s), ").append("FOREIGN KEY(%s) REFERENCES %s(%s) )");
                String sql = String.format(sqlFormat.toString(), Exhibition.TABLE_EXHIB, Exhibition.COL_PK_EXHIB_ID, Exhibition.COL_BG_COLOR, Exhibition.COL_MEDIA_TYPE, Exhibition.COL_MEDIA_PATH, Exhibition.COL_FK_DESCRIPTION, Exhibition.COL_FK_BARCODE, Exhibition.COL_FK_PRICE_1, Exhibition.COL_FK_PRICE_2, Exhibition.COL_FK_LABEL_1, Exhibition.COL_FK_LABEL_2, Exhibition.COL_FK_DESCRIPTION, "EXHIB_PARAMS", "EPARAMS_ID", Exhibition.COL_FK_BARCODE, "EXHIB_PARAMS", "EPARAMS_ID", Exhibition.COL_FK_PRICE_1, "EXHIB_PARAMS", "EPARAMS_ID", Exhibition.COL_FK_PRICE_2, "EXHIB_PARAMS", "EPARAMS_ID", Exhibition.COL_FK_LABEL_1, "EXHIB_PARAMS", "EPARAMS_ID", Exhibition.COL_FK_LABEL_2, "EXHIB_PARAMS", "EPARAMS_ID");
                JdbcStatment stmt = this.getConnection().prepareStatement(sql);
                stmt.execute();
                stmt.close();
            }
        }

        @Override
        public void delete(Exhibition exhibition) {
            if (!exhibition.isLinked()) {
                throw new IllegalArgumentException("Instance is not linked");
            }
            exhibition.getDescription().delete();
            exhibition.getBarcode().delete();
            exhibition.getPrice1().delete();
            exhibition.getPrice2().delete();
            exhibition.getLabel1().delete();
            exhibition.getLabel2().delete();
            String sql = String.format("DELETE FROM %s WHERE %s = ?", Exhibition.TABLE_EXHIB, Exhibition.COL_PK_EXHIB_ID);
            JdbcStatment stmt = this.getConnection().prepareStatement(sql);
            stmt.set(1, exhibition.getId());
            stmt.execute();
            exhibition.setId(null);
            exhibition.setModified(true);
            exhibition.setLinked(false);
            stmt.close();
        }

        public void alterTableToCascade() {
            String sql = String.format("ALTER TABLE PROD_EXHIB ADD CONSTRAINT CT_DESCRIPTION FOREIGN KEY(EXHIB_ID) REFERENCES EXHIBITION(EXHIB_ID) ON DELETE CASCADE;", new Object[0]);
            JdbcStatment stmt = this.getConnection().prepareStatement(sql);
            stmt.execute();
            stmt.close();
        }
    }

    private static interface ExhibitionDao {
        public Exhibition get(Integer var1);

        public void save(Exhibition var1);

        public void delete(Exhibition var1);

        public void init();
    }

    public static enum MediaType {
        NONE,
        PREIMAGE,
        SERVER_IMAGE,
        TERMINAL_IMAGE;

    }
}

