/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.dao;

import br.com.gertec.tc.server.customer.GifQueryBPG2;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.util.jdbc.JdbcConnection;
import br.com.gertec.tc.server.util.jdbc.JdbcResultSet;
import br.com.gertec.tc.server.util.jdbc.JdbcStatment;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProductExhibition {
    static final String TABLE_PROD_EXHIB = "PROD_EXHIB";
    static final String COL_PROD_BARCODE = "PROD_BARCODE";
    static final String COL_FK_EXHIB_ID = "EXHIB_ID";
    static final String COL_TERMINAL_TYPE = "TERMINAL_TYPE";
    private static ProductExhibitionDao currentDao = null;
    private boolean modified;
    private boolean linked;
    private String barcode;
    private Exhibition exhibition;
    private TerminalType terminalType;

    public static synchronized H2ProductExhibitionDao getCurrentDao() {
        if (currentDao == null) {
            throw new IllegalStateException("There is no DAO");
        }
        return (H2ProductExhibitionDao)currentDao;
    }

    public static synchronized void setCurrentDao(H2ProductExhibitionDao dao) {
        if (dao == null) {
            throw new IllegalArgumentException("DAO cannot be null");
        }
        currentDao = dao;
        currentDao.init();
    }

    public static synchronized Map<TerminalType, Exhibition> getExhibitions(String barcode) {
        return ProductExhibition.getCurrentDao().getExhibitions(barcode);
    }

    public static synchronized boolean hasCustomExhibition(String barcode) {
        return ProductExhibition.getCurrentDao().hasCustomExhibition(barcode);
    }

    public static synchronized Exhibition get(String barcode, TerminalType terminalType) {
        return ProductExhibition.getCurrentDao().get(barcode, terminalType);
    }

    public static synchronized void save(String barcode, TerminalType terminalType, Exhibition exhibition) {
        ProductExhibition.getCurrentDao().save(barcode, terminalType, exhibition);
    }

    public static synchronized void save(String barcode, TerminalType terminalType, Exhibition exhibition, boolean pesquisaPorGif, String tempoExibicao) {
        short descPosX = exhibition.getDescription().getX();
        short descPosY = exhibition.getDescription().getY();
        short descSize = exhibition.getDescription().getFontSize();
        String descColor = exhibition.getDescription().getFgColor().toString();
        short price1PosX = exhibition.getPrice1().getX();
        short price1PosY = exhibition.getPrice1().getY();
        short price1Size = exhibition.getPrice1().getFontSize();
        String price1Color = exhibition.getPrice1().getFgColor().toString();
        short price2PosX = exhibition.getPrice2().getX();
        short price2PosY = exhibition.getPrice2().getY();
        short price2Size = exhibition.getPrice2().getFontSize();
        String price2Color = exhibition.getPrice2().getFgColor().toString();
        short label1PosX = exhibition.getLabel1().getX();
        short label1PosY = exhibition.getLabel1().getY();
        short label1Size = exhibition.getLabel1().getFontSize();
        String label1Color = exhibition.getLabel1().getFgColor().toString();
        short label2PosX = exhibition.getLabel2().getX();
        short label2PosY = exhibition.getLabel2().getY();
        short label2Size = exhibition.getLabel2().getFontSize();
        String label2Color = exhibition.getLabel2().getFgColor().toString();
        String diretorio = exhibition.getMediaPath().toString();
        GifQueryBPG2 teste = new GifQueryBPG2(barcode, diretorio, "DejaVu Sans Bold", descSize, price1Size, price2Size, label1Size, label2Size, descColor, price1Color, price2Color, label1Color, label2Color, descPosX, descPosY, price1PosX, price1PosY, price2PosX, price2PosY, label1PosX, label1PosY, label2PosX, label2PosY, tempoExibicao, terminalType);
        if ((terminalType == TerminalType.TC_406 || terminalType == TerminalType.TC_506_S || terminalType == TerminalType.TC_506_E || terminalType == TerminalType.TC_406_E) && pesquisaPorGif) {
            if (teste.setQueryGif()) {
                ProductExhibition.getCurrentDao().save(barcode, terminalType, exhibition);
            } else {
                ProductExhibition.getCurrentDao().save(barcode, terminalType, exhibition);
            }
        } else if (!(terminalType != TerminalType.TC_406 && terminalType != TerminalType.TC_506_S && terminalType != TerminalType.TC_506_E && terminalType != TerminalType.TC_406_E || pesquisaPorGif)) {
            if (teste.deleteQueryGif(barcode, terminalType)) {
                ProductExhibition.getCurrentDao().save(barcode, terminalType, exhibition);
            } else {
                ProductExhibition.getCurrentDao().save(barcode, terminalType, exhibition);
            }
        }
    }

    public static synchronized void delete(String barcode, TerminalType terminalType) {
        ProductExhibition.getCurrentDao().delete(barcode, terminalType);
    }

    public static synchronized void deleteRow(String barcode) {
        ProductExhibition.getCurrentDao().deleteRow(barcode);
    }

    public static synchronized void delete(String barcode) {
        ProductExhibition.getCurrentDao().delete(barcode);
    }

    ProductExhibition() {
        this.setLinked(false);
        this.setModified(true);
    }

    ProductExhibition(JdbcResultSet rs) {
        this.barcode = rs.getString(COL_PROD_BARCODE);
        this.exhibition = Exhibition.get(rs.getInt(COL_FK_EXHIB_ID));
        this.terminalType = rs.getEnum(TerminalType.class, COL_TERMINAL_TYPE);
        this.setLinked(true);
        this.setModified(false);
    }

    boolean isLinked() {
        return this.linked;
    }

    void setLinked(boolean linked) {
        this.linked = linked;
    }

    boolean isModified() {
        return this.modified;
    }

    void setModified(boolean modified) {
        this.modified = modified;
    }

    String getBarcode() {
        return this.barcode;
    }

    void getBarcode(String barcode) {
        if (!Objects.equals(this.barcode, barcode)) {
            this.barcode = barcode;
            this.setModified(true);
        }
    }

    Exhibition getExhibition() {
        return this.exhibition;
    }

    void setExhibition(Exhibition exhibition) {
        if (!Objects.equals(this.getExhibition(), exhibition)) {
            this.exhibition = exhibition;
            this.setModified(this.modified);
        }
    }

    TerminalType getTerminalType() {
        return this.terminalType;
    }

    void setTerminalType(TerminalType terminalType) {
        if (!Objects.equals((Object)this.terminalType, (Object)terminalType)) {
            this.terminalType = terminalType;
            this.setModified(true);
        }
    }

    public static class H2ProductExhibitionDao
    implements ProductExhibitionDao {
        private final JdbcConnection connection;

        public H2ProductExhibitionDao(JdbcConnection connection) {
            if (connection == null) {
                throw new IllegalArgumentException("null connection");
            }
            this.connection = connection;
        }

        public final JdbcConnection getConnection() {
            return this.connection;
        }

        @Override
        public boolean hasCustomExhibition(String barcode) {
            if (barcode == null) {
                throw new IllegalArgumentException("Barcode cannot be null");
            }
            JdbcConnection connection = this.getConnection();
            String sql = String.format("SELECT COUNT(1) FROM %s WHERE %s = ?", ProductExhibition.TABLE_PROD_EXHIB, ProductExhibition.COL_PROD_BARCODE);
            JdbcStatment stmt = connection.prepareStatement(sql);
            stmt.set(1, barcode);
            JdbcResultSet rs = stmt.executeQuery();
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            stmt.close();
            return count > 0;
        }

        private List<ProductExhibition> get(String barcode) {
            if (barcode == null) {
                throw new IllegalArgumentException("Barcode cannot be null");
            }
            JdbcConnection connection = this.getConnection();
            String sql = String.format("SELECT * FROM %s WHERE %s = ?", ProductExhibition.TABLE_PROD_EXHIB, ProductExhibition.COL_PROD_BARCODE);
            JdbcStatment stmt = connection.prepareStatement(sql);
            stmt.set(1, barcode);
            JdbcResultSet rs = stmt.executeQuery();
            LinkedList<ProductExhibition> exhibitions = new LinkedList<ProductExhibition>();
            while (rs.next()) {
                ProductExhibition pe = new ProductExhibition(rs);
                exhibitions.add(pe);
            }
            rs.close();
            stmt.close();
            return exhibitions;
        }

        @Override
        public Map<TerminalType, Exhibition> getExhibitions(String barcode) {
            List<ProductExhibition> productExhibitions = this.get(barcode);
            LinkedHashMap<TerminalType, Exhibition> exhibitions = new LinkedHashMap<TerminalType, Exhibition>();
            for (ProductExhibition pe : productExhibitions) {
                exhibitions.put(pe.getTerminalType(), pe.getExhibition());
            }
            return exhibitions;
        }

        private ProductExhibition privateGet(String barcode, TerminalType terminalType) {
            if (barcode == null) {
                throw new IllegalArgumentException("Barcode cannot be null");
            }
            if (terminalType == null) {
                throw new IllegalArgumentException("Terminal type cannot be null");
            }
            JdbcConnection connection = this.getConnection();
            String sql = String.format("SELECT * FROM %s WHERE %s = ? AND %s = ?", ProductExhibition.TABLE_PROD_EXHIB, ProductExhibition.COL_PROD_BARCODE, ProductExhibition.COL_TERMINAL_TYPE);
            JdbcStatment stmt = connection.prepareStatement(sql);
            stmt.set(1, barcode);
            stmt.set(2, terminalType);
            JdbcResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                return null;
            }
            ProductExhibition instance = new ProductExhibition(rs);
            rs.close();
            stmt.close();
            return instance;
        }

        @Override
        public Exhibition get(String barcode, TerminalType terminalType) {
            if (terminalType == null) {
                throw new IllegalArgumentException("Terminal type cannot be null");
            }
            ProductExhibition pe = this.privateGet(barcode, terminalType);
            if (pe == null) {
                return null;
            }
            return pe.getExhibition();
        }

        private void create(String barcode, TerminalType terminalType, Exhibition exhibition) {
            if (terminalType == null) {
                throw new IllegalArgumentException("Terminal type cannot be null");
            }
            JdbcConnection connection = this.getConnection();
            exhibition.save();
            String sql = String.format("INSERT INTO %s (%s, %s, %s) VALUES (?, ?, ?)", ProductExhibition.TABLE_PROD_EXHIB, ProductExhibition.COL_PROD_BARCODE, ProductExhibition.COL_TERMINAL_TYPE, ProductExhibition.COL_FK_EXHIB_ID);
            JdbcStatment stmt = connection.prepareStatement(sql);
            stmt.set(1, barcode);
            stmt.set(2, terminalType);
            stmt.set(3, exhibition.getId());
            stmt.execute();
            stmt.close();
        }

        @Override
        public void save(String barcode, TerminalType terminalType, Exhibition exhibition) {
            if (terminalType == null) {
                throw new IllegalArgumentException("Terminal type cannot be null");
            }
            ProductExhibition pe = this.privateGet(barcode, terminalType);
            if (pe == null) {
                this.create(barcode, terminalType, exhibition);
            } else {
                JdbcConnection connection = this.getConnection();
                exhibition.save();
                String sql = String.format("UPDATE %s SET %s = ? WHERE %s = ? AND %s = ?", ProductExhibition.TABLE_PROD_EXHIB, ProductExhibition.COL_FK_EXHIB_ID, ProductExhibition.COL_PROD_BARCODE, ProductExhibition.COL_TERMINAL_TYPE);
                JdbcStatment stmt = connection.prepareStatement(sql);
                stmt.set(1, exhibition.getId());
                stmt.set(2, barcode);
                stmt.set(3, terminalType);
                stmt.execute();
                stmt.close();
            }
        }

        @Override
        public void delete(String barcode, TerminalType terminalType) {
            if (terminalType == null) {
                throw new IllegalArgumentException("Terminal type cannot be null");
            }
            ProductExhibition pe = this.privateGet(barcode, terminalType);
            if (pe != null) {
                pe.getExhibition().delete();
                String sql = String.format("DELETE FROM %s WHERE %s = ? AND %s = ?", ProductExhibition.TABLE_PROD_EXHIB, ProductExhibition.COL_PROD_BARCODE, ProductExhibition.COL_TERMINAL_TYPE);
                JdbcStatment stmt = this.getConnection().prepareStatement(sql);
                stmt.set(1, barcode);
                stmt.set(2, terminalType);
                stmt.execute();
                stmt.close();
            }
        }

        @Override
        public void delete(String barcode) {
            List<ProductExhibition> productExhibitions = this.get(barcode);
            for (ProductExhibition pe : productExhibitions) {
                pe.getExhibition().delete();
            }
            String sql = String.format("DELETE FROM %s WHERE %s = ?", ProductExhibition.TABLE_PROD_EXHIB, ProductExhibition.COL_PROD_BARCODE);
            JdbcStatment stmt = this.getConnection().prepareStatement(sql);
            stmt.set(1, barcode);
            stmt.execute();
            stmt.close();
        }

        @Override
        public void deleteRow(String barcode) {
            String sql = String.format("DELETE FROM %s WHERE %s = ?", ProductExhibition.TABLE_PROD_EXHIB, ProductExhibition.COL_PROD_BARCODE);
            JdbcStatment stmt = this.getConnection().prepareStatement(sql);
            stmt.set(1, barcode);
            stmt.execute();
            stmt.close();
        }

        @Override
        public void init() {
            if (!this.getConnection().getTableNames().contains(ProductExhibition.TABLE_PROD_EXHIB)) {
                StringBuilder sqlFormat = new StringBuilder("CREATE TABLE %s (").append("%s VARCHAR(100), ").append("%s INT, ").append("%s VARCHAR(100), ").append("FOREIGN KEY(%s) REFERENCES %s(%s) ON DELETE CASCADE)");
                String sql = String.format(sqlFormat.toString(), ProductExhibition.TABLE_PROD_EXHIB, ProductExhibition.COL_PROD_BARCODE, ProductExhibition.COL_FK_EXHIB_ID, ProductExhibition.COL_TERMINAL_TYPE, ProductExhibition.COL_FK_EXHIB_ID, "EXHIBITION", ProductExhibition.COL_FK_EXHIB_ID);
                JdbcStatment stmt = this.getConnection().prepareStatement(sql);
                stmt.execute();
                stmt.close();
            }
        }
    }

    private static interface ProductExhibitionDao {
        public boolean hasCustomExhibition(String var1);

        public Map<TerminalType, Exhibition> getExhibitions(String var1);

        public Exhibition get(String var1, TerminalType var2);

        public void save(String var1, TerminalType var2, Exhibition var3);

        public void delete(String var1, TerminalType var2);

        public void delete(String var1);

        public void deleteRow(String var1);

        public void init();
    }
}

