/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.dao;

import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.log.Log;
import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.event.Timer;
import br.org.reconcavo.j18n.J18N;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TextDbProductDao
extends Product.AbstractProductDao {
    private static final int COL_BARCODE = 0;
    private static final int COL_DESCRIPTION = 1;
    private static final int COL_PRICE1 = 2;
    private static final int COL_PRICE2 = 3;
    private static final int MAX_BARCODE_LENGTH = 100;
    private static final int MAX_DESCRIPTION_LENGTH = 128;
    private static final int MAX_PRICE_1_LENGTH = 100;
    private static final int MAX_PRICE_2_LENGTH = 100;
    public final File txtDbFile;
    private final Map<String, Product> map = new LinkedHashMap<String, Product>();
    private List<Product> list = new LinkedList<Product>();
    private final List<Product> readOnlyList = Collections.unmodifiableList(this.list);
    private final List<AutoReloadListener> autoReloadListeners = new LinkedList<AutoReloadListener>();
    private final Timer reloadTimer;
    private final Product.ProductTableDefinition tableDef = new Product.ProductTableDefinition();
    private volatile boolean initialized = false;

    public TextDbProductDao(EventLoop eventLoop, File txtDbFile, long reloadIntervalMillis) {
        if (txtDbFile == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.txtDbFile = txtDbFile;
        this.reloadTimer = new Timer(eventLoop, "DbReloadTimer");
        this.reloadTimer.setSingleshot(false);
        this.reloadTimer.setDelay(reloadIntervalMillis);
        this.reloadTimer.setInterval(reloadIntervalMillis);
        this.reloadTimer.addListener(new Timer.TimerListener(){

            @Override
            public void onTimeout(Timer timer) {
                TextDbProductDao.this.reload();
                Log.debugTag("DB", J18N.tr("DB was automatically reloaded", new Object[0]), new Object[0]);
                TextDbProductDao.this.callAutoReloadListeners();
            }
        });
    }

    public final EventLoop getEventLoop() {
        return this.reloadTimer.getEventLoop();
    }

    public final File getTxtDbFile() {
        return this.txtDbFile;
    }

    public final long getReloadIntervalMillis() {
        return this.reloadTimer.getInterval();
    }

    @Override
    public Product.ProductTableDefinition getTableDefinition() {
        return this.tableDef;
    }

    @Override
    public Product get(String barcode) {
        return this.map.get(barcode);
    }

    @Override
    public List<Product> getAll() {
        return this.readOnlyList;
    }

    @Override
    public void delete(Product product) {
        throw new UnsupportedOperationException("DAO is read-only");
    }

    @Override
    public void save(Product product) {
        throw new UnsupportedOperationException("DAO is read-only");
    }

    private String readCol(String[] cols, int index) {
        if (index > cols.length - 1) {
            return null;
        }
        return cols[index].trim();
    }

    @Override
    public void reload() {
        this.init(true);
    }

    private void init(boolean force) {
        if (force || !this.initialized) {
            this.map.clear();
            this.list.clear();
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.txtDbFile.getAbsolutePath()), StandardCharsets.UTF_8));){
                String line;
                br.mark(1);
                if (br.read() != 65279) {
                    br.reset();
                }
                while ((line = br.readLine()) != null) {
                    if (line.trim().isEmpty() || line.trim().startsWith("#")) continue;
                    Product product = new Product();
                    String[] cols = line.split(Pattern.quote("|"));
                    product.setBarcode(this.readCol(cols, 0)).setDescription(this.readCol(cols, 1)).setPrice1(this.readCol(cols, 2)).setPrice2(this.readCol(cols, 3));
                    product.setLinked(true);
                    product.setModified(false);
                    if (product.getBarcode().length() > 100) {
                        Log.warningTag("DB", J18N.tr("The product was not saved! Maximum allowed barcode length: %s characters!", 100), new Object[0]);
                        continue;
                    }
                    if (product.getDescription().length() > 128) {
                        Log.warningTag("DB", J18N.tr("The product was not saved! Maximum allowed description length: %s characters!", 128), new Object[0]);
                        continue;
                    }
                    if (product.getPrice1().length() > 100) {
                        Log.warningTag("DB", J18N.tr("The product was not saved! Maximum allowed price 1 length: %s characters!", 100), new Object[0]);
                        continue;
                    }
                    if (product.getPrice2() != null && product.getPrice2().length() > 100) {
                        Log.warningTag("DB", J18N.tr("The product was not saved! Maximum allowed price 2 length: %s characters!", 100), new Object[0]);
                        continue;
                    }
                    Product oldProduct = this.map.put(product.getBarcode(), product);
                    if (oldProduct == null) {
                        this.list.add(product);
                        continue;
                    }
                    Log.warningTag("DB", J18N.tr("Duplicate barcode found (%s). Old entry (%s) will be replaced by new one (%s)", product.getBarcode(), oldProduct.toString(), product.toString()), new Object[0]);
                }
                this.reloadTimer.start();
                this.initialized = true;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void init() {
        this.init(false);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void close() {
        this.reloadTimer.stop();
    }

    private void callAutoReloadListeners() {
        this.onAutoReload();
        for (AutoReloadListener listener : this.autoReloadListeners) {
            listener.onAutoReload(this);
        }
    }

    public void addAutoReloadListener(AutoReloadListener listener) {
        if (listener != null && !this.autoReloadListeners.contains(listener)) {
            this.autoReloadListeners.add(listener);
        }
    }

    protected void onAutoReload() {
    }

    public static interface AutoReloadListener {
        public void onAutoReload(TextDbProductDao var1);
    }
}

