/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.ApplicationSettings;
import br.com.gertec.tc.server.gui.UpdateDialog;
import br.com.gertec.tc.server.gui.util.GuiDialog;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;

public class AuthenticationAdminDialog
extends GuiDialog
implements J18N.LocaleChangeListener {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JPanel panel;
    private JLabel lblMsg;
    private JPasswordField passwordField;
    private JButton btnCancel;
    private JButton btnOk;
    private JPanel buttonPane;

    public AuthenticationAdminDialog() {
        this.setTitle(Application.APP_NAME);
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)this.contentPane, "Center");
        this.panel = new JPanel();
        this.panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.panel.setSize(150, 60);
        this.contentPane.add((Component)this.panel, "Center");
        GridBagLayout gblPanel = new GridBagLayout();
        gblPanel.columnWidths = new int[]{0, 0};
        gblPanel.rowHeights = new int[]{0, 0, 0, 0};
        gblPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gblPanel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panel.setLayout(gblPanel);
        this.lblMsg = new JLabel();
        GridBagConstraints gbcLblNewLabel = new GridBagConstraints();
        gbcLblNewLabel.fill = 1;
        gbcLblNewLabel.gridx = 0;
        gbcLblNewLabel.gridy = 0;
        this.panel.add((Component)this.lblMsg, gbcLblNewLabel);
        this.passwordField = new JPasswordField(20);
        this.passwordField.requestFocusInWindow();
        GridBagConstraints gbcPasswordField = new GridBagConstraints();
        gbcPasswordField.fill = 1;
        gbcPasswordField.insets = new Insets(5, 0, 0, 0);
        gbcPasswordField.gridx = 0;
        gbcPasswordField.gridy = 1;
        this.panel.add((Component)this.passwordField, gbcPasswordField);
        this.buttonPane = new JPanel();
        GridBagConstraints gbcButtonPane = new GridBagConstraints();
        gbcButtonPane.insets = new Insets(5, 0, 0, 0);
        gbcButtonPane.fill = 1;
        gbcButtonPane.gridx = 0;
        gbcButtonPane.gridy = 2;
        this.panel.add((Component)this.buttonPane, gbcButtonPane);
        this.buttonPane.setLayout(new GridLayout(0, 2, 5, 0));
        this.btnOk = new JButton();
        this.buttonPane.add(this.btnOk);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AuthenticationAdminDialog.this.allowed()) {
                    GuiUtils.showWarningMessage(AuthenticationAdminDialog.this, J18N.tr("Invalid password", new Object[0]));
                    AuthenticationAdminDialog.this.passwordField.selectAll();
                    AuthenticationAdminDialog.this.passwordField.requestFocus();
                } else {
                    AuthenticationAdminDialog.this.dispose(true);
                    UpdateDialog updDialog = new UpdateDialog();
                    updDialog.setVisible(true);
                    updDialog.requestFocus();
                }
            }
        });
        this.btnCancel = new JButton();
        this.buttonPane.add(this.btnCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthenticationAdminDialog.this.dispose();
            }
        });
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(this.btnCancel);
        this.retranslateUi();
        this.pack();
    }

    private void retranslateUi() {
        this.lblMsg.setText(J18N.tr("Enter the unlock password", new Object[0]));
        this.btnOk.setText(J18N.tr("OK", new Object[0]));
        this.btnCancel.setText(J18N.tr("Cancel", new Object[0]));
    }

    private boolean allowed() {
        ApplicationSettings settings = ApplicationSettings.getInstance();
        String configPassword = settings.getEncryptedProperty("PASSWORD");
        String enteredPassword = String.valueOf(this.passwordField.getPassword());
        return Objects.equals(configPassword, enteredPassword);
    }

    @Override
    public void onLocaleChange(Locale arg0) {
        this.retranslateUi();
    }
}

