/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiTcDialog;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.gui.util.JTextFieldLimit;
import br.com.gertec.tc.server.gui.util.TextField;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.commands.AudioConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.AudioConfigQ;
import br.com.gertec.tc.server.protocol.sc501.commands.RAudioConfig;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetAudioQuery;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetAudioStatus;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetBrightness;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetSensorStatus;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetVolume;
import br.com.gertec.tc.server.protocol.sc504.commands.IDSetAudio;
import br.com.gertec.tc.server.protocol.sc504.commands.IDSetAudioQuery;
import br.com.gertec.tc.server.protocol.sc504.commands.IDSetBrightness;
import br.com.gertec.tc.server.protocol.sc504.commands.IDSetSensor;
import br.com.gertec.tc.server.protocol.sc504.commands.IDSetVolume;
import br.com.gertec.tc.server.protocol.sc504.commands.IDbGetEnableKey;
import br.com.gertec.tc.server.protocol.sc504.commands.IDbGetLEC;
import br.com.gertec.tc.server.protocol.sc504.commands.IDbSetTimeExhib;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvGetTimeExhib;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSetEnableKey;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSetLEC;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetAudioQuery;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetAudioStatus;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetBrightness;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetSensorStatus;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetVolume;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDbGetEnableKey;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDbGetLEC;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetTimeExhib;
import br.com.gertec.tc.server.util.version.DeviceVersion;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConfigMiscDialog
extends GuiTcDialog {
    private static final long serialVersionUID = 1L;
    private final GuiPanel contentPane;
    private final GuiPanel displayTimePanel;
    private final JLabel lblDisplayTime;
    private final JSpinner spinnerDisplayTime;
    private final JLabel lblSeconds;
    private final GuiPanel linePanel;
    private final JLabel lblLine1;
    private final JTextField txtLine1;
    private final JLabel lblLine2;
    private final JTextField txtLine2;
    private final JLabel lblLine3;
    private final JTextField txtLine3;
    private final JLabel lblLine4;
    private final JTextField txtLine4;
    private final GuiPanel miscPanel;
    private final GuiPanel miscPanelTC504;
    private final GuiPanel miscPanelQuery;
    private final JCheckBox chkSensor;
    private final JLabel lblBrightness;
    private final JLabel lblBrightnessPercent;
    private final JSlider slBrightness;
    private final JLabel lblVolume;
    private final JLabel lblVolumePercent;
    private final JSlider slVol;
    private final JCheckBox chkAudio;
    private final JCheckBox chkAudioQuery;
    private final JCheckBox chkCard;
    private final JCheckBox chkKey;
    private final JButton btnOk;
    private final JButton btnCancel;

    public ConfigMiscDialog(AbstractTcConnection connection) {
        super(connection);
        this.setTitle(J18N.tr("Miscellaneous - %s (%s)", connection.getInetAddress().getHostAddress(), connection.getTerminal().getTcName()));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPane = new GuiPanel();
        this.getContentPane().add((Component)this.contentPane, "Center");
        GridBagLayout gblContentPane = new GridBagLayout();
        gblContentPane.columnWidths = new int[]{0, 0};
        gblContentPane.rowHeights = new int[]{0, 0, 0, 0};
        gblContentPane.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gblContentPane.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.contentPane.setLayout(gblContentPane);
        this.displayTimePanel = new GuiPanel();
        GridBagConstraints gbcDisplayTimePanel = new GridBagConstraints();
        gbcDisplayTimePanel.fill = 2;
        gbcDisplayTimePanel.insets = new Insets(5, 5, 0, 5);
        gbcDisplayTimePanel.gridx = 0;
        gbcDisplayTimePanel.gridy = 0;
        this.contentPane.add((Component)this.displayTimePanel, gbcDisplayTimePanel);
        GridBagLayout gblDisplayTimePanel = new GridBagLayout();
        gblDisplayTimePanel.columnWidths = new int[]{0, 0, 0, 0};
        gblDisplayTimePanel.rowHeights = new int[]{0, 0};
        gblDisplayTimePanel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gblDisplayTimePanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.displayTimePanel.setLayout(gblDisplayTimePanel);
        this.displayTimePanel.setBorder(BorderFactory.createTitledBorder(J18N.tr("Terminal settings", new Object[0]) + ":"));
        this.lblDisplayTime = new JLabel(J18N.tr("Display Time", new Object[0]) + ":");
        GridBagConstraints gbcLblDisplayTime = new GridBagConstraints();
        gbcLblDisplayTime.anchor = 17;
        gbcLblDisplayTime.gridx = 0;
        gbcLblDisplayTime.gridy = 1;
        this.displayTimePanel.add((Component)this.lblDisplayTime, gbcLblDisplayTime);
        this.spinnerDisplayTime = new JSpinner();
        this.spinnerDisplayTime.setModel(new SpinnerNumberModel(3, 1, 30, 1));
        ((JSpinner.DefaultEditor)this.spinnerDisplayTime.getEditor()).getTextField().setEditable(false);
        GridBagConstraints gbcSpinnerDisplayTime = new GridBagConstraints();
        gbcSpinnerDisplayTime.fill = 2;
        gbcSpinnerDisplayTime.insets = new Insets(0, 5, 0, 0);
        gbcSpinnerDisplayTime.gridx = 1;
        gbcSpinnerDisplayTime.gridy = 1;
        this.displayTimePanel.add((Component)this.spinnerDisplayTime, gbcSpinnerDisplayTime);
        this.lblSeconds = new JLabel(J18N.tr("Seconds", new Object[0]));
        GridBagConstraints gbcLblSeconds = new GridBagConstraints();
        gbcLblSeconds.insets = new Insets(0, 5, 0, 0);
        gbcLblSeconds.anchor = 17;
        gbcLblSeconds.gridx = 2;
        gbcLblSeconds.gridy = 1;
        this.displayTimePanel.add((Component)this.lblSeconds, gbcLblSeconds);
        this.chkSensor = new JCheckBox(J18N.tr("Enable presence sensor", new Object[0]));
        GridBagConstraints gbcChkSensor = new GridBagConstraints();
        gbcChkSensor.anchor = 17;
        gbcChkSensor.gridwidth = 3;
        gbcChkSensor.gridx = 0;
        gbcChkSensor.gridy = 2;
        this.displayTimePanel.add((Component)this.chkSensor, gbcChkSensor);
        this.chkSensor.setHorizontalAlignment(2);
        this.lblBrightness = new JLabel(J18N.tr("Brightness", new Object[0]) + ":");
        GridBagConstraints gbcLblBrightness = new GridBagConstraints();
        gbcLblBrightness.anchor = 17;
        gbcLblBrightness.insets = new Insets(5, 0, 0, 0);
        gbcLblBrightness.gridx = 0;
        gbcLblBrightness.gridy = 3;
        this.displayTimePanel.add((Component)this.lblBrightness, gbcLblBrightness);
        this.lblBrightnessPercent = new JLabel("%");
        GridBagConstraints gbcLblBrightnessPercent = new GridBagConstraints();
        gbcLblBrightnessPercent.insets = new Insets(5, 5, 0, 0);
        gbcLblBrightnessPercent.gridx = 1;
        gbcLblBrightnessPercent.gridy = 3;
        this.displayTimePanel.add((Component)this.lblBrightnessPercent, gbcLblBrightnessPercent);
        this.slBrightness = new JSlider();
        this.slBrightness.setMinorTickSpacing(0);
        this.slBrightness.setMajorTickSpacing(100);
        this.slBrightness.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ConfigMiscDialog.this.onUiChange();
            }
        });
        GridBagConstraints gbcSlBrightness = new GridBagConstraints();
        gbcSlBrightness.fill = 2;
        gbcSlBrightness.insets = new Insets(5, 5, 0, 0);
        gbcSlBrightness.gridx = 2;
        gbcSlBrightness.gridy = 3;
        this.displayTimePanel.add((Component)this.slBrightness, gbcSlBrightness);
        this.miscPanel = new GuiPanel();
        GridBagConstraints gbcMiscPanel = new GridBagConstraints();
        gbcMiscPanel.insets = new Insets(5, 5, 0, 5);
        gbcMiscPanel.fill = 2;
        gbcMiscPanel.gridx = 0;
        gbcMiscPanel.gridy = 3;
        this.contentPane.add((Component)this.miscPanel, gbcMiscPanel);
        GridBagLayout gblMiscPanel = new GridBagLayout();
        gblMiscPanel.columnWidths = new int[]{0, 67, 0, 0};
        gblMiscPanel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gblMiscPanel.columnWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        gblMiscPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.miscPanel.setLayout(gblMiscPanel);
        this.miscPanel.setBorder(BorderFactory.createTitledBorder(J18N.tr("Media and advertising settings", new Object[0]) + ":"));
        this.chkAudio = new JCheckBox(J18N.tr("Enable audio", new Object[0]));
        this.chkAudio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigMiscDialog.this.onUiChange();
                if (ConfigMiscDialog.this.slVol.getValue() == 0 && ConfigMiscDialog.this.chkAudio.isSelected()) {
                    ConfigMiscDialog.this.slVol.setValue(50);
                }
            }
        });
        GridBagConstraints gbcChkAudio = new GridBagConstraints();
        gbcChkAudio.anchor = 17;
        gbcChkAudio.gridwidth = 3;
        gbcChkAudio.insets = new Insets(5, 0, 0, 0);
        gbcChkAudio.gridx = 0;
        gbcChkAudio.gridy = 3;
        this.miscPanel.add((Component)this.chkAudio, gbcChkAudio);
        this.chkAudio.setHorizontalAlignment(2);
        this.lblVolume = new JLabel(J18N.tr("M\u00eddia Volume", new Object[0]) + ":");
        GridBagConstraints gbcLblVolume = new GridBagConstraints();
        gbcLblVolume.anchor = 17;
        gbcLblVolume.insets = new Insets(5, 0, 0, 0);
        gbcLblVolume.gridx = 0;
        gbcLblVolume.gridy = 4;
        this.miscPanel.add((Component)this.lblVolume, gbcLblVolume);
        this.lblVolumePercent = new JLabel("%");
        GridBagConstraints gbcLblVolumePercent = new GridBagConstraints();
        gbcLblVolumePercent.insets = new Insets(5, 5, 0, 0);
        gbcLblVolumePercent.gridx = 1;
        gbcLblVolumePercent.gridy = 4;
        this.miscPanel.add((Component)this.lblVolumePercent, gbcLblVolumePercent);
        this.slVol = new JSlider();
        this.slVol.setMinorTickSpacing(0);
        this.slVol.setMajorTickSpacing(100);
        this.slVol.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ConfigMiscDialog.this.onUiChange();
            }
        });
        GridBagConstraints gbcSlVol = new GridBagConstraints();
        gbcSlVol.insets = new Insets(5, 5, 0, 0);
        gbcSlVol.fill = 2;
        gbcSlVol.gridx = 2;
        gbcSlVol.gridy = 4;
        this.miscPanel.add((Component)this.slVol, gbcSlVol);
        this.miscPanelQuery = new GuiPanel();
        GridBagConstraints gbcMiscQueryPanel = new GridBagConstraints();
        gbcMiscQueryPanel.insets = new Insets(5, 5, 0, 5);
        gbcMiscQueryPanel.fill = 2;
        gbcMiscQueryPanel.gridx = 0;
        gbcMiscQueryPanel.gridy = 6;
        this.contentPane.add((Component)this.miscPanelQuery, gbcMiscQueryPanel);
        GridBagLayout gblMiscQueryPanel = new GridBagLayout();
        gblMiscQueryPanel.columnWidths = new int[]{0, 67, 0, 0};
        gblMiscQueryPanel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gblMiscQueryPanel.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gblMiscQueryPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.miscPanelQuery.setLayout(gblMiscQueryPanel);
        this.miscPanelQuery.setBorder(BorderFactory.createTitledBorder(J18N.tr("Audios for Query (Accessibility)", new Object[0]) + ":"));
        this.chkAudioQuery = new JCheckBox(J18N.tr("Enable Query Audios", new Object[0]) + "                      ");
        this.chkAudioQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigMiscDialog.this.onUiChange();
                if (ConfigMiscDialog.this.slVol.getValue() == 0 && ConfigMiscDialog.this.chkAudioQuery.isSelected()) {
                    ConfigMiscDialog.this.slVol.setValue(50);
                }
            }
        });
        GridBagConstraints gbcChkAudioQuery = new GridBagConstraints();
        gbcChkAudioQuery.anchor = 17;
        gbcChkAudioQuery.gridwidth = 3;
        gbcChkAudioQuery.insets = new Insets(5, 0, 0, 0);
        gbcChkAudioQuery.gridx = 0;
        gbcChkAudioQuery.gridy = 6;
        this.miscPanelQuery.add((Component)this.chkAudioQuery, gbcChkAudioQuery);
        this.chkAudioQuery.setHorizontalAlignment(2);
        this.linePanel = new GuiPanel();
        GridBagConstraints gbcLinePanel = new GridBagConstraints();
        gbcLinePanel.insets = new Insets(5, 5, 0, 5);
        gbcLinePanel.fill = 1;
        gbcLinePanel.gridx = 0;
        gbcLinePanel.gridy = 1;
        this.contentPane.add((Component)this.linePanel, gbcLinePanel);
        GridBagLayout gblLinePanel = new GridBagLayout();
        gblLinePanel.columnWidths = new int[]{0, 0, 0};
        gblLinePanel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gblLinePanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gblLinePanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.linePanel.setLayout(gblLinePanel);
        this.lblLine1 = new JLabel(J18N.tr("Line %d", 1) + ":");
        GridBagConstraints gbcLblLine1 = new GridBagConstraints();
        gbcLblLine1.anchor = 17;
        gbcLblLine1.gridx = 0;
        gbcLblLine1.gridy = 0;
        this.linePanel.add((Component)this.lblLine1, gbcLblLine1);
        this.txtLine1 = new CustomUiTextField();
        GridBagConstraints gbcTxtLine1 = new GridBagConstraints();
        gbcTxtLine1.insets = new Insets(0, 5, 0, 0);
        gbcTxtLine1.fill = 2;
        gbcTxtLine1.gridx = 1;
        gbcTxtLine1.gridy = 0;
        this.linePanel.add((Component)this.txtLine1, gbcTxtLine1);
        this.txtLine1.setColumns(10);
        this.txtLine1.setDocument(new JTextFieldLimit(20));
        this.lblLine2 = new JLabel(J18N.tr("Line %d", 2) + ":");
        GridBagConstraints gbcLblLine2 = new GridBagConstraints();
        gbcLblLine2.anchor = 17;
        gbcLblLine2.insets = new Insets(5, 0, 0, 0);
        gbcLblLine2.gridx = 0;
        gbcLblLine2.gridy = 1;
        this.linePanel.add((Component)this.lblLine2, gbcLblLine2);
        this.txtLine2 = new CustomUiTextField();
        GridBagConstraints gbcTxtLine2 = new GridBagConstraints();
        gbcTxtLine2.fill = 2;
        gbcTxtLine2.insets = new Insets(5, 5, 0, 0);
        gbcTxtLine2.gridx = 1;
        gbcTxtLine2.gridy = 1;
        this.linePanel.add((Component)this.txtLine2, gbcTxtLine2);
        this.txtLine2.setColumns(10);
        this.txtLine2.setDocument(new JTextFieldLimit(20));
        this.lblLine3 = new JLabel(J18N.tr("Line %d", 3) + ":");
        GridBagConstraints gbcLblLine3 = new GridBagConstraints();
        gbcLblLine3.anchor = 17;
        gbcLblLine3.insets = new Insets(5, 0, 0, 0);
        gbcLblLine3.gridx = 0;
        gbcLblLine3.gridy = 2;
        this.linePanel.add((Component)this.lblLine3, gbcLblLine3);
        this.txtLine3 = new CustomUiTextField();
        GridBagConstraints gbcTxtLine3 = new GridBagConstraints();
        gbcTxtLine3.fill = 2;
        gbcTxtLine3.insets = new Insets(5, 5, 0, 0);
        gbcTxtLine3.gridx = 1;
        gbcTxtLine3.gridy = 2;
        this.linePanel.add((Component)this.txtLine3, gbcTxtLine3);
        this.txtLine3.setColumns(10);
        this.txtLine3.setDocument(new JTextFieldLimit(20));
        this.lblLine4 = new JLabel(J18N.tr("Line %d", 4) + ":");
        GridBagConstraints gbcLblLine4 = new GridBagConstraints();
        gbcLblLine4.anchor = 17;
        gbcLblLine4.insets = new Insets(5, 0, 0, 0);
        gbcLblLine4.gridx = 0;
        gbcLblLine4.gridy = 3;
        this.linePanel.add((Component)this.lblLine4, gbcLblLine4);
        this.txtLine4 = new CustomUiTextField();
        GridBagConstraints gbcTxtLine4 = new GridBagConstraints();
        gbcTxtLine4.insets = new Insets(5, 5, 0, 0);
        gbcTxtLine4.fill = 2;
        gbcTxtLine4.gridx = 1;
        gbcTxtLine4.gridy = 3;
        this.linePanel.add((Component)this.txtLine4, gbcTxtLine4);
        this.txtLine4.setColumns(10);
        this.txtLine4.setDocument(new JTextFieldLimit(20));
        this.miscPanelTC504 = new GuiPanel();
        GridBagConstraints gbcMiscPanelTC504 = new GridBagConstraints();
        gbcMiscPanelTC504.insets = new Insets(5, 5, 0, 5);
        gbcMiscPanelTC504.fill = 1;
        gbcMiscPanelTC504.gridx = 0;
        gbcMiscPanelTC504.gridy = 2;
        this.contentPane.add((Component)this.miscPanelTC504, gbcMiscPanelTC504);
        GridBagLayout gblMiscPanelTC504 = new GridBagLayout();
        gblMiscPanelTC504.columnWidths = new int[]{0, 67, 0, 0};
        gblMiscPanelTC504.rowHeights = new int[]{0, 0, 0, 0, 0};
        gblMiscPanelTC504.columnWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        gblMiscPanelTC504.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.miscPanelTC504.setLayout(gblMiscPanelTC504);
        this.chkKey = new JCheckBox(J18N.tr("Enable keyboard", new Object[0]));
        GridBagConstraints gbcChkKey = new GridBagConstraints();
        gbcChkKey.anchor = 17;
        gbcChkKey.gridwidth = 3;
        gbcChkKey.insets = new Insets(5, 0, 0, 0);
        gbcChkKey.gridx = 0;
        gbcChkKey.gridy = 2;
        this.miscPanelTC504.add((Component)this.chkKey, gbcChkKey);
        this.chkKey.setHorizontalAlignment(2);
        this.chkCard = new JCheckBox(J18N.tr("Enable card", new Object[0]));
        GridBagConstraints gbcChkCard = new GridBagConstraints();
        gbcChkCard.anchor = 17;
        gbcChkCard.gridwidth = 3;
        gbcChkCard.insets = new Insets(5, 0, 0, 0);
        gbcChkCard.gridx = 0;
        gbcChkCard.gridy = 0;
        this.miscPanelTC504.add((Component)this.chkCard, gbcChkCard);
        this.chkCard.setHorizontalAlignment(2);
        GuiPanel buttonPane = new GuiPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        ActionListener okActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigMiscDialog.this.save();
            }
        };
        ActionListener cancelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigMiscDialog.this.dispose();
            }
        };
        this.btnOk = new JButton(J18N.tr("Save", new Object[0]));
        this.btnOk.addActionListener(okActionListener);
        ((Container)buttonPane).add(this.btnOk);
        this.btnCancel = new JButton(J18N.tr("Cancel", new Object[0]));
        this.btnCancel.addActionListener(cancelActionListener);
        ((Container)buttonPane).add(this.btnCancel);
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(this.btnCancel);
        this.init();
    }

    private void init() {
        this.contentPane.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.initGui();
        this.registerListeners();
        this.requestTerminalInfo();
        this.onUiChange();
        this.pack();
    }

    private void initGui() {
        AbstractTcConnection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        TerminalType terminalType = connection.getTerminalType();
        switch (terminalType) {
            case TC_506_MIDIA: 
            case TC_508: 
            case GB_600: 
            case GB_601: {
                this.displayTimePanel.setVisible(true);
                this.miscPanelQuery.setVisible(DeviceVersion.isNewVersion(connection.getTerminalType(), connection.getTerminal().getTerminalVersion()));
                this.miscPanel.setVisible(true);
                this.linePanel.setVisible(false);
                this.miscPanelTC504.setVisible(false);
                break;
            }
            case TC_504: {
                this.displayTimePanel.setVisible(false);
                this.miscPanelQuery.setVisible(false);
                this.miscPanel.setVisible(false);
                this.linePanel.setVisible(false);
                this.miscPanelTC504.setVisible(true);
                break;
            }
            case TC_406: {
                this.displayTimePanel.setVisible(false);
                this.miscPanelQuery.setVisible(true);
                this.miscPanel.setVisible(false);
                this.linePanel.setVisible(false);
                this.miscPanelTC504.setVisible(false);
            }
            case TC_506_S: 
            case TC_506_E: 
            case TC_406_E: {
                this.displayTimePanel.setVisible(false);
                this.miscPanelQuery.setVisible(true);
                this.miscPanel.setVisible(false);
                this.linePanel.setVisible(false);
                this.miscPanelTC504.setVisible(false);
            }
            default: {
                this.miscPanel.setVisible(false);
                this.miscPanelTC504.setVisible(false);
            }
        }
    }

    private void registerListeners() {
        if (this.getConnection() == null) {
            return;
        }
        this.registerSc504CommandListener((short)171, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDGetSensorStatus response = (RIDGetSensorStatus)command;
                ConfigMiscDialog.this.chkSensor.setSelected(response.isEnabled());
            }
        });
        this.registerSc504CommandListener((short)52, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDbGetEnableKey response = (RIDbGetEnableKey)command;
                ConfigMiscDialog.this.chkKey.setSelected(response.isEnabled());
            }
        });
        this.registerSc504CommandListener((short)68, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDbGetLEC response = (RIDbGetLEC)command;
                ConfigMiscDialog.this.chkCard.setSelected(response.isEnabled());
            }
        });
        this.registerSc504CommandListener((short)175, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDGetAudioStatus response = (RIDGetAudioStatus)command;
                ConfigMiscDialog.this.chkAudio.setSelected(response.isEnabled());
            }
        });
        this.registerSc504CommandListener((short)179, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDGetVolume response = (RIDGetVolume)command;
                ConfigMiscDialog.this.slVol.setValue(response.getVolume());
                ConfigMiscDialog.this.lblVolumePercent.setText(response.getVolume() + "%");
            }
        });
        this.registerSc504CommandListener((short)183, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDGetBrightness response = (RIDGetBrightness)command;
                ConfigMiscDialog.this.slBrightness.setValue(response.getBrightness());
                ConfigMiscDialog.this.lblBrightnessPercent.setText(response.getBrightness() + "%");
            }
        });
        this.registerSc504CommandListener((short)42, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDvGetTimeExhib response = (RIDvGetTimeExhib)command;
                ConfigMiscDialog.this.spinnerDisplayTime.setValue(response.getExhibitionTime());
                ConfigMiscDialog.this.contentPane.setEnabled(true);
                ConfigMiscDialog.this.btnOk.setEnabled(true);
                ConfigMiscDialog.this.onUiChange();
            }
        });
        this.registerSc504CommandListener((short)40, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                ConfigMiscDialog.this.dispose(true);
            }
        });
        this.registerSc504CommandListener((short)213, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDGetAudioQuery response = (RIDGetAudioQuery)command;
                ConfigMiscDialog.this.chkAudioQuery.setSelected(response.isEnabled());
            }
        });
        this.registerSc501CommandListener("#audioconfig", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                AudioConfig response = (AudioConfig)command;
                connection.getTerminal().setAudioStatus(response.getAudioStatus());
                ConfigMiscDialog.this.chkAudioQuery.setSelected(response.getAudioStatus());
                ConfigMiscDialog.this.contentPane.setEnabled(true);
                ConfigMiscDialog.this.btnOk.setEnabled(true);
            }
        });
    }

    private void requestTerminalInfo() {
        AbstractTcConnection connection = this.getConnection();
        if (connection instanceof Sc501Connection) {
            connection.writeCommand(new AudioConfigQ());
        } else if (connection instanceof Sc504Connection) {
            if (connection.getTerminalType() != TerminalType.TC_504) {
                connection.writeCommand(new IDGetAudioStatus());
                connection.writeCommand(new IDGetBrightness());
                connection.writeCommand(new IDGetSensorStatus());
                connection.writeCommand(new IDGetVolume());
                if (DeviceVersion.isNewVersion(connection.getTerminalType(), connection.getTerminal().getTerminalVersion())) {
                    connection.writeCommand(new IDGetAudioQuery());
                }
            } else {
                connection.writeCommand(new IDbGetEnableKey());
                connection.writeCommand(new IDbGetLEC());
            }
            connection.writeCommand(new IDvGetTimeExhib());
        } else {
            throw new UnsupportedOperationException("Unsupported connection type: " + connection.getClass().getName());
        }
    }

    private void save() {
        this.contentPane.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
        AbstractTcConnection connection = this.getConnection();
        if (connection instanceof Sc501Connection) {
            connection.writeCommand(new RAudioConfig(this.chkAudioQuery.isSelected()));
            this.dispose();
            GuiUtils.showWarningMessage(null, J18N.tr("Settings saved! The terminal will restart", new Object[0]));
            connection.close();
        } else if (connection instanceof Sc504Connection) {
            if (connection.getTerminal().getType() != TerminalType.TC_504) {
                connection.writeCommand(new IDSetSensor(this.chkSensor.isSelected()));
                if (this.chkAudio.isSelected()) {
                    connection.writeCommand(new IDSetAudio(this.chkAudio.isSelected()));
                    connection.writeCommand(new IDSetVolume(this.slVol.getValue()));
                } else {
                    connection.writeCommand(new IDSetAudio(this.chkAudio.isSelected()));
                }
                connection.writeCommand(new IDSetBrightness(this.slBrightness.getValue()));
                if (DeviceVersion.isNewVersion(connection.getTerminalType(), connection.getTerminal().getTerminalVersion())) {
                    connection.writeCommand(new IDSetAudioQuery(this.chkAudioQuery.isSelected()));
                }
            } else {
                connection.writeCommand(new IDvSetEnableKey(this.chkKey.isSelected()));
                connection.writeCommand(new IDvSetLEC(this.chkCard.isSelected()));
            }
            connection.writeCommand(new IDbSetTimeExhib(Short.parseShort(this.spinnerDisplayTime.getValue().toString())));
            this.dispose();
            GuiUtils.showWarningMessage(null, J18N.tr("Settings saved! The terminal will restart", new Object[0]));
            connection.close();
        } else {
            throw new UnsupportedOperationException("Unsupported connection type: " + connection.getClass().getName());
        }
    }

    private void onUiChange() {
        this.lblBrightnessPercent.setText(this.slBrightness.getValue() + "%");
        this.lblVolumePercent.setText(this.slVol.getValue() + "%");
        this.slVol.setEnabled(this.chkAudio.isSelected());
        this.lblVolumePercent.setEnabled(this.chkAudio.isSelected());
        this.lblVolume.setEnabled(this.chkAudio.isSelected());
        AbstractTcConnection connection = this.getConnection();
        boolean readyTosave = connection.getTerminal().getType().getSc504Id() != null || connection.getTerminal().getType().getSc501Id() != null;
        this.btnOk.setEnabled(readyTosave);
    }

    private class CustomUiTextField
    extends TextField {
        private static final long serialVersionUID = 1L;

        private CustomUiTextField() {
        }

        @Override
        protected void onChange() {
            super.onChange();
            ConfigMiscDialog.this.onUiChange();
        }
    }
}

