/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiTcDialog;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.gui.util.JTextFieldLimit;
import br.com.gertec.tc.server.gui.util.TextField;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.commands.Config02;
import br.com.gertec.tc.server.protocol.sc501.commands.ExtConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.ExtConfigQ;
import br.com.gertec.tc.server.protocol.sc501.commands.RUpdConfig;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetAudioStatus;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetBrightness;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetSensorStatus;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetVolume;
import br.com.gertec.tc.server.protocol.sc504.commands.IDbGetEnableKey;
import br.com.gertec.tc.server.protocol.sc504.commands.IDbGetLEC;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvGetTimeExhib;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfigTCP501Dialog
extends GuiTcDialog {
    private static final long serialVersionUID = 1L;
    private static final String IP_REGEX = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private final GuiPanel contentPane;
    private final GuiPanel linePanel;
    private final JLabel lblGateway;
    private final JTextField txtGateway;
    private final JLabel lblNometerminal;
    private final JTextField txtNomeTerminal;
    private final JButton btnOk;
    private final JButton btnCancel;

    private static boolean validateInput(JTextField field) {
        String text = field.getText();
        Pattern pattern = Pattern.compile(IP_REGEX);
        Matcher m = pattern.matcher(text);
        if (m.matches()) {
            field.setForeground(Color.BLACK);
            return true;
        }
        field.setForeground(Color.RED);
        return false;
    }

    public ConfigTCP501Dialog(AbstractTcConnection connection) {
        super(connection);
        this.setTitle(J18N.tr(J18N.tr("Gateway / Terminal", new Object[0]) + " - %s (%s)", connection.getInetAddress().getHostAddress(), connection.getTerminal().getTcName()));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPane = new GuiPanel();
        this.getContentPane().add((Component)this.contentPane, "Center");
        GridBagLayout gblContentPane = new GridBagLayout();
        gblContentPane.columnWidths = new int[]{0, 0};
        gblContentPane.rowHeights = new int[]{0, 0, 0, 0};
        gblContentPane.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gblContentPane.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.contentPane.setLayout(gblContentPane);
        this.linePanel = new GuiPanel();
        GridBagConstraints gbcLinePanel = new GridBagConstraints();
        gbcLinePanel.insets = new Insets(5, 5, 0, 5);
        gbcLinePanel.fill = 1;
        gbcLinePanel.gridx = 0;
        gbcLinePanel.gridy = 1;
        this.contentPane.add((Component)this.linePanel, gbcLinePanel);
        GridBagLayout gblLinePanel = new GridBagLayout();
        gblLinePanel.columnWidths = new int[]{0, 0, 0};
        gblLinePanel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gblLinePanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gblLinePanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.linePanel.setLayout(gblLinePanel);
        this.lblNometerminal = new JLabel(J18N.tr("Name Terminal", new Object[0]) + ":");
        GridBagConstraints gbcLblNometerminal = new GridBagConstraints();
        gbcLblNometerminal.anchor = 17;
        gbcLblNometerminal.gridx = 0;
        gbcLblNometerminal.gridy = 0;
        this.linePanel.add((Component)this.lblNometerminal, gbcLblNometerminal);
        this.txtNomeTerminal = new CustomUiTextField();
        GridBagConstraints gbcTxtNomeTerminal = new GridBagConstraints();
        gbcTxtNomeTerminal.insets = new Insets(0, 5, 0, 0);
        gbcTxtNomeTerminal.fill = 2;
        gbcTxtNomeTerminal.gridx = 1;
        gbcTxtNomeTerminal.gridy = 0;
        this.linePanel.add((Component)this.txtNomeTerminal, gbcTxtNomeTerminal);
        this.txtNomeTerminal.setColumns(10);
        this.txtNomeTerminal.setDocument(new JTextFieldLimit(20));
        this.lblGateway = new JLabel(J18N.tr("Gateway", new Object[0]) + ":");
        GridBagConstraints gbcLblGateway = new GridBagConstraints();
        gbcLblGateway.anchor = 17;
        gbcLblGateway.insets = new Insets(5, 0, 0, 0);
        gbcLblGateway.gridx = 0;
        gbcLblGateway.gridy = 1;
        this.linePanel.add((Component)this.lblGateway, gbcLblGateway);
        this.txtGateway = new CustomUiTextField();
        GridBagConstraints gbcTxtGateway = new GridBagConstraints();
        gbcTxtGateway.fill = 2;
        gbcTxtGateway.insets = new Insets(5, 5, 0, 0);
        gbcTxtGateway.gridx = 1;
        gbcTxtGateway.gridy = 1;
        this.linePanel.add((Component)this.txtGateway, gbcTxtGateway);
        this.txtGateway.setColumns(10);
        this.txtGateway.setDocument(new JTextFieldLimit(20));
        GuiPanel buttonPane = new GuiPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        ActionListener okActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigTCP501Dialog.this.save();
            }
        };
        ActionListener cancelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigTCP501Dialog.this.dispose();
            }
        };
        this.btnOk = new JButton(J18N.tr("Save", new Object[0]));
        this.btnOk.addActionListener(okActionListener);
        ((Container)buttonPane).add(this.btnOk);
        this.btnCancel = new JButton(J18N.tr("Cancel", new Object[0]));
        this.btnCancel.addActionListener(cancelActionListener);
        ((Container)buttonPane).add(this.btnCancel);
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(this.btnCancel);
        this.init();
    }

    private void init() {
        this.contentPane.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.initGui();
        this.registerListeners();
        this.requestTerminalInfo();
        this.onUiChange();
        this.pack();
    }

    private void initGui() {
        AbstractTcConnection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        TerminalType terminalType = connection.getTerminalType();
        switch (terminalType) {
            case TC_506_MIDIA: 
            case TC_508: {
                this.linePanel.setVisible(false);
                break;
            }
            case TC_504: {
                this.linePanel.setVisible(false);
                break;
            }
        }
    }

    private void registerListeners() {
        if (this.getConnection() == null) {
            return;
        }
        this.registerSc501CommandListener("#config02", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Config02 response = (Config02)command;
                response.getParams();
                ConfigTCP501Dialog.this.contentPane.setEnabled(true);
                ConfigTCP501Dialog.this.btnOk.setEnabled(true);
            }
        });
        this.registerSc501CommandListener("#extconfig", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                ExtConfig response = (ExtConfig)command;
                ExtConfig.ConfigParams sc501Params = new ExtConfig.ConfigParams(response.getParams());
                ConfigTCP501Dialog.this.txtGateway.setText(sc501Params.gateway);
                ConfigTCP501Dialog.this.txtNomeTerminal.setText(sc501Params.terminalName);
                ConfigTCP501Dialog.this.onUiChange();
                ConfigTCP501Dialog.this.contentPane.setEnabled(true);
                ConfigTCP501Dialog.this.btnOk.setEnabled(true);
            }
        });
        this.registerSc501CommandListener("#rupdconfig_error\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Log.error(J18N.tr("Error configuring Terminal update parameters", new Object[0]), new Object[0]);
            }
        });
    }

    private void requestTerminalInfo() {
        AbstractTcConnection connection = this.getConnection();
        if (connection instanceof Sc501Connection) {
            connection.writeCommand(new ExtConfigQ());
        } else if (connection instanceof Sc504Connection) {
            if (connection.getTerminalType() != TerminalType.TC_504) {
                connection.writeCommand(new IDGetAudioStatus());
                connection.writeCommand(new IDGetBrightness());
                connection.writeCommand(new IDGetSensorStatus());
                connection.writeCommand(new IDGetVolume());
            } else {
                connection.writeCommand(new IDbGetEnableKey());
                connection.writeCommand(new IDbGetLEC());
            }
            connection.writeCommand(new IDvGetTimeExhib());
        } else {
            throw new UnsupportedOperationException("Unsupported connection type: " + connection.getClass().getName());
        }
    }

    private void save() {
        this.contentPane.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
        AbstractTcConnection connection = this.getConnection();
        if (!(connection instanceof Sc501Connection)) {
            throw new UnsupportedOperationException("Unsupported connection type: " + connection.getClass().getName());
        }
        RUpdConfig request = new RUpdConfig(new RUpdConfig.UpdConfigParams(this.txtGateway.getText(), this.txtNomeTerminal.getText()));
        connection.writeCommand(request);
        connection.close();
        GuiUtils.showWarningMessage(null, J18N.tr("Settings saved! The terminal will restart", new Object[0]));
        this.dispose();
    }

    private void onUiChange() {
        AbstractTcConnection connection = this.getConnection();
        boolean readyTosave = connection.getTerminal().getType().getSc504Id() != null || connection.getTerminal().getType().getSc501Id() != null && !this.txtGateway.getText().isEmpty();
        ConfigTCP501Dialog.validateInput(this.txtGateway);
        this.btnOk.setEnabled(readyTosave);
    }

    private class CustomUiTextField
    extends TextField {
        private static final long serialVersionUID = 1L;

        private CustomUiTextField() {
        }

        @Override
        protected void onChange() {
            super.onChange();
            ConfigTCP501Dialog.this.onUiChange();
        }
    }
}

