/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiTcDialog;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.gui.util.TextField;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.commands.ExtConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.ExtConfigQ;
import br.com.gertec.tc.server.protocol.sc501.commands.RExtConf;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvGetSetupTCP;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSetSetupTCP;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetSetupTCP;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvSetSetupTCP;
import br.com.gertec.tc.server.protocol.sc504.params.ArgSetupTcp;
import br.com.gertec.tc.server.util.Util;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ConfigTcpIpDialog
extends GuiTcDialog {
    private static final long serialVersionUID = 1L;
    private static final String IP_REGEX = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private final JPanel contentPanel = new GuiPanel();
    private final JRadioButton rbFixed;
    private final JRadioButton rbDynamic;
    private final JLabel lblIp;
    private final JTextField txtIp;
    private final JLabel lblNetmask;
    private final JTextField txtNetMask;
    private final JLabel lblGateway;
    private final JTextField txtGateway;
    private final JLabel lblTerminalName;
    private final JTextField txtTerminalName;
    private final JLabel lblDns;
    private final JTextField txtDns;
    private final JLabel lblMac;
    private final JTextField txtMac;
    private final GuiPanel ipModePanel;
    private final TitledBorder ipModeTitledBoder;
    private final GuiPanel settingsPanel;
    private final TitledBorder settingsTitledBorder;
    private final JButton btnOk;
    private final JButton btnCancel;
    private ExtConfig.ConfigParams sc501Params1;
    private ArgSetupTcp sc504Params;

    private static boolean validateInput(JTextField field) {
        String text = field.getText();
        Pattern pattern = Pattern.compile(IP_REGEX);
        Matcher m = pattern.matcher(text);
        if (m.matches()) {
            field.setForeground(Color.BLACK);
            return true;
        }
        field.setForeground(Color.RED);
        return false;
    }

    public ConfigTcpIpDialog(AbstractTcConnection connection) {
        super(connection);
        this.setTitle(J18N.tr("TCP/IP configuration - %s (%s)", connection.getInetAddress().getHostAddress(), connection.getTerminal().getTcName()));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gblContentPanel = new GridBagLayout();
        gblContentPanel.columnWeights = new double[]{1.0};
        gblContentPanel.rowWeights = new double[]{0.0, 1.0};
        gblContentPanel.rowHeights = new int[]{0, 0};
        this.contentPanel.setLayout(gblContentPanel);
        ButtonGroup group = new ButtonGroup();
        ActionListener radioActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigTcpIpDialog.this.settingsPanel.setEnabled(ConfigTcpIpDialog.this.rbFixed.isSelected());
                ConfigTcpIpDialog.this.onUiChange();
                ConfigTcpIpDialog.this.pack();
            }
        };
        this.ipModePanel = new GuiPanel();
        this.ipModeTitledBoder = new TitledBorder(null, J18N.tr("IP mode", new Object[0]), 4, 2, null, null);
        this.ipModePanel.setBorder(this.ipModeTitledBoder);
        GridBagConstraints gbcIpModePanel = new GridBagConstraints();
        gbcIpModePanel.fill = 1;
        gbcIpModePanel.gridx = 0;
        gbcIpModePanel.gridy = 0;
        this.contentPanel.add((Component)this.ipModePanel, gbcIpModePanel);
        GridBagLayout gblIpModePanel = new GridBagLayout();
        gblIpModePanel.columnWidths = new int[]{0, 0};
        gblIpModePanel.rowHeights = new int[]{0, 0, 0};
        gblIpModePanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gblIpModePanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.ipModePanel.setLayout(gblIpModePanel);
        this.rbDynamic = new JRadioButton(J18N.tr("Dynamic IP", new Object[0]));
        this.rbDynamic.addActionListener(radioActionListener);
        GridBagConstraints gbcRbDynamic = new GridBagConstraints();
        gbcRbDynamic.anchor = 17;
        gbcRbDynamic.insets = new Insets(5, 5, 0, 5);
        gbcRbDynamic.gridx = 0;
        gbcRbDynamic.gridy = 0;
        this.ipModePanel.add((Component)this.rbDynamic, gbcRbDynamic);
        group.add(this.rbDynamic);
        this.rbFixed = new JRadioButton(J18N.tr("Fixed IP", new Object[0]));
        this.rbFixed.addActionListener(radioActionListener);
        GridBagConstraints gbcRbFixed = new GridBagConstraints();
        gbcRbFixed.insets = new Insets(5, 5, 5, 5);
        gbcRbFixed.anchor = 17;
        gbcRbFixed.gridx = 0;
        gbcRbFixed.gridy = 1;
        this.ipModePanel.add((Component)this.rbFixed, gbcRbFixed);
        group.add(this.rbFixed);
        this.settingsPanel = new GuiPanel();
        this.settingsTitledBorder = new TitledBorder(null, J18N.tr("Terminal settings", new Object[0]), 4, 2, null, null);
        this.settingsPanel.setBorder(this.settingsTitledBorder);
        GridBagConstraints gbcFixedIpPanel = new GridBagConstraints();
        gbcFixedIpPanel.insets = new Insets(5, 0, 0, 0);
        gbcFixedIpPanel.fill = 1;
        gbcFixedIpPanel.gridx = 0;
        gbcFixedIpPanel.gridy = 1;
        this.contentPanel.add((Component)this.settingsPanel, gbcFixedIpPanel);
        GridBagLayout gblFixedIpPanel = new GridBagLayout();
        gblFixedIpPanel.columnWidths = new int[]{0, 0, 0};
        gblFixedIpPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gblFixedIpPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gblFixedIpPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.settingsPanel.setLayout(gblFixedIpPanel);
        this.lblIp = new JLabel(J18N.tr("IP", new Object[0]) + ":");
        GridBagConstraints gbcLblIp = new GridBagConstraints();
        gbcLblIp.anchor = 17;
        gbcLblIp.insets = new Insets(5, 5, 0, 0);
        gbcLblIp.gridx = 0;
        gbcLblIp.gridy = 0;
        this.settingsPanel.add((Component)this.lblIp, gbcLblIp);
        this.txtIp = new CustomUiTextField();
        GridBagConstraints gbcTxtIp = new GridBagConstraints();
        gbcTxtIp.fill = 2;
        gbcTxtIp.insets = new Insets(5, 5, 0, 5);
        gbcTxtIp.gridx = 1;
        gbcTxtIp.gridy = 0;
        this.settingsPanel.add((Component)this.txtIp, gbcTxtIp);
        this.txtIp.setHorizontalAlignment(2);
        this.txtIp.setColumns(15);
        this.lblNetmask = new JLabel(J18N.tr("Netmask", new Object[0]) + ":");
        GridBagConstraints gbcLblNetmask = new GridBagConstraints();
        gbcLblNetmask.anchor = 17;
        gbcLblNetmask.insets = new Insets(5, 5, 0, 0);
        gbcLblNetmask.gridx = 0;
        gbcLblNetmask.gridy = 1;
        this.settingsPanel.add((Component)this.lblNetmask, gbcLblNetmask);
        this.txtNetMask = new CustomUiTextField();
        GridBagConstraints gbcTxtNetMask = new GridBagConstraints();
        gbcTxtNetMask.fill = 2;
        gbcTxtNetMask.insets = new Insets(5, 5, 0, 5);
        gbcTxtNetMask.gridx = 1;
        gbcTxtNetMask.gridy = 1;
        this.settingsPanel.add((Component)this.txtNetMask, gbcTxtNetMask);
        this.txtNetMask.setColumns(15);
        this.lblGateway = new JLabel(J18N.tr("Gateway", new Object[0]) + ":");
        GridBagConstraints gbcLblGateway = new GridBagConstraints();
        gbcLblGateway.anchor = 17;
        gbcLblGateway.insets = new Insets(5, 5, 0, 0);
        gbcLblGateway.gridx = 0;
        gbcLblGateway.gridy = 2;
        this.settingsPanel.add((Component)this.lblGateway, gbcLblGateway);
        this.txtGateway = new CustomUiTextField();
        GridBagConstraints gbcTxtGateway = new GridBagConstraints();
        gbcTxtGateway.fill = 2;
        gbcTxtGateway.insets = new Insets(5, 5, 0, 5);
        gbcTxtGateway.gridx = 1;
        gbcTxtGateway.gridy = 2;
        this.settingsPanel.add((Component)this.txtGateway, gbcTxtGateway);
        this.txtGateway.setColumns(15);
        this.lblTerminalName = new JLabel(J18N.tr("Terminal name", new Object[0]) + ":");
        GridBagConstraints gbcLblTerminalName = new GridBagConstraints();
        gbcLblTerminalName.anchor = 17;
        gbcLblTerminalName.insets = new Insets(5, 5, 0, 0);
        gbcLblTerminalName.gridx = 0;
        gbcLblTerminalName.gridy = 3;
        this.settingsPanel.add((Component)this.lblTerminalName, gbcLblTerminalName);
        this.txtTerminalName = new CustomUiTextField();
        GridBagConstraints gbcTxtTerminalName = new GridBagConstraints();
        gbcTxtTerminalName.fill = 2;
        gbcTxtTerminalName.insets = new Insets(5, 5, 0, 5);
        gbcTxtTerminalName.gridx = 1;
        gbcTxtTerminalName.gridy = 3;
        this.settingsPanel.add((Component)this.txtTerminalName, gbcTxtTerminalName);
        this.txtTerminalName.setColumns(15);
        this.lblDns = new JLabel(J18N.tr("DNS", new Object[0]) + ":");
        GridBagConstraints gbcLblDns = new GridBagConstraints();
        gbcLblDns.anchor = 17;
        gbcLblDns.insets = new Insets(5, 5, 0, 0);
        gbcLblDns.gridx = 0;
        gbcLblDns.gridy = 4;
        this.settingsPanel.add((Component)this.lblDns, gbcLblDns);
        this.txtDns = new CustomUiTextField();
        GridBagConstraints gbcTxtDNS = new GridBagConstraints();
        gbcTxtDNS.fill = 2;
        gbcTxtDNS.insets = new Insets(5, 5, 0, 5);
        gbcTxtDNS.gridx = 1;
        gbcTxtDNS.gridy = 4;
        this.settingsPanel.add((Component)this.txtDns, gbcTxtDNS);
        this.txtDns.setColumns(15);
        this.lblMac = new JLabel(J18N.tr("MAC", new Object[0]) + ":");
        GridBagConstraints gbcLblMac = new GridBagConstraints();
        gbcLblMac.anchor = 17;
        gbcLblMac.insets = new Insets(5, 5, 5, 0);
        gbcLblMac.gridx = 0;
        gbcLblMac.gridy = 5;
        this.settingsPanel.add((Component)this.lblMac, gbcLblMac);
        this.txtMac = new CustomUiTextField();
        this.txtMac.setColumns(15);
        this.txtMac.setEditable(false);
        GridBagConstraints gbcTxtMac = new GridBagConstraints();
        gbcTxtMac.insets = new Insets(5, 5, 5, 5);
        gbcTxtMac.fill = 2;
        gbcTxtMac.gridx = 1;
        gbcTxtMac.gridy = 5;
        this.settingsPanel.add((Component)this.txtMac, gbcTxtMac);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btnOk = new JButton(J18N.tr("Save", new Object[0]));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigTcpIpDialog.this.save();
            }
        });
        buttonPane.add(this.btnOk);
        this.btnCancel = new JButton(J18N.tr("Cancel", new Object[0]));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigTcpIpDialog.this.dispose();
            }
        });
        buttonPane.add(this.btnCancel);
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(this.btnCancel);
        this.init();
    }

    private void init() {
        AbstractTcConnection connection = this.getConnection();
        if (connection.getTerminal().getMacAddress() != null) {
            this.txtMac.setText(connection.getTerminal().getMacAddress());
        } else {
            this.lblMac.setVisible(false);
            this.txtMac.setVisible(false);
        }
        this.lblDns.setVisible(connection.isSc504());
        this.txtDns.setVisible(connection.isSc504());
        this.registerListeners();
        this.requestTerminalInfo();
        this.onUiChange();
        this.contentPanel.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.pack();
    }

    private void registerListeners() {
        this.registerSc501CommandListener("#extconfig", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                ConfigTcpIpDialog.this.contentPanel.setEnabled(true);
                ConfigTcpIpDialog.this.btnOk.setEnabled(true);
                ExtConfig response = (ExtConfig)command;
                ConfigTcpIpDialog.this.sc501Params1 = new ExtConfig.ConfigParams(response.getParams());
                if (((ConfigTcpIpDialog)ConfigTcpIpDialog.this).sc501Params1.dynamicIp) {
                    ConfigTcpIpDialog.this.rbDynamic.setSelected(true);
                    ConfigTcpIpDialog.this.rbDynamic.doClick();
                } else {
                    ConfigTcpIpDialog.this.rbFixed.setSelected(true);
                    ConfigTcpIpDialog.this.rbFixed.doClick();
                }
                ConfigTcpIpDialog.this.txtIp.setText(((ConfigTcpIpDialog)ConfigTcpIpDialog.this).sc501Params1.terminalIp);
                ConfigTcpIpDialog.this.txtNetMask.setText(((ConfigTcpIpDialog)ConfigTcpIpDialog.this).sc501Params1.netmask);
                ConfigTcpIpDialog.this.txtGateway.setText(((ConfigTcpIpDialog)ConfigTcpIpDialog.this).sc501Params1.gateway);
                ConfigTcpIpDialog.this.txtTerminalName.setText(((ConfigTcpIpDialog)ConfigTcpIpDialog.this).sc501Params1.terminalName);
                ConfigTcpIpDialog.this.onUiChange();
            }
        });
        this.registerSc501CommandListener("#rextconf_ok\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                connection.sendRestartTerminal();
                ConfigTcpIpDialog.this.dispose(true);
            }
        });
        this.registerSc501CommandListener("#rextconf_error\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Log.error(J18N.tr("Terminal parameterization error", new Object[0]), new Object[0]);
            }
        });
        this.registerSc504CommandListener((short)26, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                ConfigTcpIpDialog.this.contentPanel.setEnabled(true);
                ConfigTcpIpDialog.this.btnOk.setEnabled(true);
                RIDvGetSetupTCP response = (RIDvGetSetupTCP)command;
                ConfigTcpIpDialog.this.sc504Params = response.getArgSetupTcp();
                ConfigTcpIpDialog.this.txtGateway.setText(Util.getIpV4String(ConfigTcpIpDialog.this.sc504Params.getGateway()));
                ConfigTcpIpDialog.this.txtIp.setText(Util.getIpV4String(ConfigTcpIpDialog.this.sc504Params.getTerminalIp()));
                ConfigTcpIpDialog.this.txtDns.setText(Util.getIpV4String(ConfigTcpIpDialog.this.sc504Params.getNameServer()));
                ConfigTcpIpDialog.this.txtNetMask.setText(Util.getIpV4String(ConfigTcpIpDialog.this.sc504Params.getNetmask()));
                ConfigTcpIpDialog.this.txtTerminalName.setText(ConfigTcpIpDialog.this.sc504Params.getTerminalName());
                if (ConfigTcpIpDialog.this.sc504Params.isDhcpEnabled()) {
                    ConfigTcpIpDialog.this.rbDynamic.setSelected(true);
                    ConfigTcpIpDialog.this.rbDynamic.doClick();
                } else {
                    ConfigTcpIpDialog.this.rbFixed.setSelected(true);
                    ConfigTcpIpDialog.this.rbFixed.doClick();
                }
                ConfigTcpIpDialog.this.onUiChange();
            }
        });
        this.registerSc504CommandListener((short)24, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDvSetSetupTCP ridv = (RIDvSetSetupTCP)command;
                if (ridv.isSuccess()) {
                    connection.sendRestartTerminal();
                    ConfigTcpIpDialog.this.dispose(true);
                } else {
                    GuiUtils.showErrorMessage(ConfigTcpIpDialog.this, J18N.tr("Error saving settings", new Object[0]));
                }
            }
        });
    }

    public void requestTerminalInfo() {
        AbstractTcConnection connection = this.getConnection();
        if (connection.getTerminal().isSc501()) {
            connection.writeCommand(new ExtConfigQ());
        } else if (connection.isSc504()) {
            connection.writeCommand(new IDvGetSetupTCP());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void save() {
        this.contentPanel.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
        AbstractTcConnection connection = this.getConnection();
        if (connection.isSc501()) {
            ExtConfig.ConfigParams params1 = new ExtConfig.ConfigParams(this.sc501Params1);
            params1.dynamicIp = this.rbDynamic.isSelected();
            params1.terminalIp = this.txtIp.getText();
            params1.netmask = this.txtNetMask.getText();
            params1.gateway = this.txtGateway.getText();
            params1.terminalName = this.txtTerminalName.getText();
            RExtConf request1 = new RExtConf(params1);
            connection.writeCommand(request1);
            if (connection.getTerminalType().equals((Object)TerminalType.TC_406)) {
                Log.debug("Sending TCP/IP config to a G2 terminal", new Object[0]);
            } else if (connection.getTerminalType().equals((Object)TerminalType.TC_506_S)) {
                Log.debug("Sending TCP/IP config to a TC-506S terminal", new Object[0]);
            }
            this.dispose();
            connection.close();
            GuiUtils.showWarningMessage(null, J18N.tr("Settings saved! The terminal will restart", new Object[0]));
        } else if (connection.isSc504()) {
            IDvSetSetupTCP request = new IDvSetSetupTCP(this.txtIp.getText(), Util.getIpV4String(this.sc504Params.getServerIp()), this.txtNetMask.getText(), this.txtGateway.getText(), this.txtDns.getText(), this.rbDynamic.isSelected(), this.sc504Params.isServerSearchEnabled(), this.sc504Params.getServerPort(), this.txtTerminalName.getText(), this.sc504Params.getFtpServer(), this.sc504Params.getFtpUser(), this.sc504Params.getFtpPassword());
            connection.writeCommand(request);
            connection.sendRestartTerminal();
            GuiUtils.showWarningMessage(null, J18N.tr("Settings saved! The terminal will restart", new Object[0]));
            connection.close();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void onUiChange() {
        boolean readyToSave = true;
        if (!this.rbDynamic.isSelected()) {
            readyToSave = readyToSave && !this.txtMac.getText().isEmpty();
            readyToSave = readyToSave && !this.txtTerminalName.getText().isEmpty();
            readyToSave = readyToSave && ConfigTcpIpDialog.validateInput(this.txtIp);
            readyToSave = readyToSave && ConfigTcpIpDialog.validateInput(this.txtNetMask);
            boolean bl = readyToSave = readyToSave && ConfigTcpIpDialog.validateInput(this.txtGateway);
            if (this.txtDns.isVisible()) {
                readyToSave = readyToSave && ConfigTcpIpDialog.validateInput(this.txtDns);
            }
        }
    }

    private class CustomUiTextField
    extends TextField {
        private static final long serialVersionUID = 1L;

        private CustomUiTextField() {
        }

        @Override
        protected void onChange() {
            super.onChange();
            ConfigTcpIpDialog.this.onUiChange();
        }
    }
}

