/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiTcDialog;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.gui.util.PasswordField;
import br.com.gertec.tc.server.gui.util.TextField;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.WiFiSecurity;
import br.com.gertec.tc.server.protocol.WifiMode;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.commands.RWlanConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.WlanConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.WlanConfigQ;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvGetSetupWiFi;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvGetSetupWiFiTc504;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSetSetupWiFi;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSetSetupWiFiTc504;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetSetupWiFi;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetSetupWiFiTc504;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvSetSetupWiFi;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvSetSetupWiFiTc504;
import br.com.gertec.tc.server.protocol.sc504.params.ArgSetupWiFi;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ConfigWiFiDialog
extends GuiTcDialog {
    private static final long serialVersionUID = 1L;
    private JPanel contentPanel = new GuiPanel();
    private JLabel lblSsid;
    private JTextField txtSsid;
    private JLabel lblMode;
    private JComboBox<WifiMode> cmbMode;
    private JLabel lblChannel;
    private JSpinner spinnerChannel;
    private JLabel lblSecurity;
    private JComboBox<WiFiSecurity> cmbSecurity;
    private JLabel lblPassword;
    private JPasswordField txtPassword;
    private JCheckBox chkShowPassword;
    private JButton btnOk;
    private JButton btnCancel;
    private ArgSetupWiFi sc504Config;
    private WlanConfig.ConfigParams sc501Config;
    private JLabel lblNewLabel;

    private ConfigWiFiDialog() {
        super((AbstractTcConnection)null, true);
        this.initGui();
    }

    public ConfigWiFiDialog(AbstractTcConnection connection) {
        super(connection);
        this.initGui();
    }

    private void initGui() {
        AbstractTcConnection connection = this.getConnection();
        if (connection != null) {
            this.setTitle(J18N.tr("WiFi Configuration - %s (%s)", connection.getInetAddress().getHostAddress(), connection.getTerminal().getTcName()));
        }
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gblContentPanel = new GridBagLayout();
        gblContentPanel.columnWeights = new double[]{0.0, 1.0};
        this.contentPanel.setLayout(gblContentPanel);
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.lblNewLabel = new JLabel(J18N.tr("Please, verify if your device suports wifi.", new Object[0]));
        this.lblNewLabel.setForeground(UIManager.getColor("OptionPane.warningDialog.titlePane.foreground"));
        this.lblNewLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.lblNewLabel.setOpaque(true);
        this.lblNewLabel.setBackground(UIManager.getColor("OptionPane.warningDialog.titlePane.background"));
        GridBagConstraints gbcLblNewLabel = new GridBagConstraints();
        gbcLblNewLabel.gridwidth = 2;
        gbcLblNewLabel.gridx = 0;
        gbcLblNewLabel.gridy = 0;
        this.contentPanel.add((Component)this.lblNewLabel, gbcLblNewLabel);
        this.lblSsid = new JLabel(J18N.tr("SSID", new Object[0]) + ":");
        GridBagConstraints gbcLblSsid = new GridBagConstraints();
        gbcLblSsid.insets = new Insets(5, 0, 0, 0);
        gbcLblSsid.anchor = 17;
        gbcLblSsid.gridx = 0;
        gbcLblSsid.gridy = 1;
        this.contentPanel.add((Component)this.lblSsid, gbcLblSsid);
        this.txtSsid = new CustomUiTextField();
        this.txtSsid.setColumns(12);
        GridBagConstraints gbcTxtSsid = new GridBagConstraints();
        gbcTxtSsid.fill = 2;
        gbcTxtSsid.gridx = 1;
        gbcTxtSsid.gridy = 1;
        gbcTxtSsid.insets = new Insets(5, 5, 0, 0);
        this.contentPanel.add((Component)this.txtSsid, gbcTxtSsid);
        this.lblMode = new JLabel(J18N.tr("Mode", new Object[0]) + ":");
        GridBagConstraints gbcLblMode = new GridBagConstraints();
        gbcLblMode.insets = new Insets(5, 0, 0, 0);
        gbcLblMode.anchor = 17;
        gbcLblMode.gridx = 0;
        gbcLblMode.gridy = 2;
        this.contentPanel.add((Component)this.lblMode, gbcLblMode);
        this.cmbMode = new JComboBox();
        this.cmbMode.addItem(WifiMode.INFRASTRUCTURE);
        this.cmbMode.addItem(WifiMode.AD_HOC);
        this.cmbMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConfigWiFiDialog.this.onUiChange();
            }
        });
        GridBagConstraints gbcCmbMode = new GridBagConstraints();
        gbcCmbMode.insets = new Insets(5, 5, 0, 0);
        gbcCmbMode.fill = 2;
        gbcCmbMode.gridx = 1;
        gbcCmbMode.gridy = 2;
        this.contentPanel.add(this.cmbMode, gbcCmbMode);
        GridBagConstraints gbcLblChannel = new GridBagConstraints();
        gbcLblChannel.insets = new Insets(5, 0, 0, 0);
        gbcLblChannel.anchor = 17;
        gbcLblChannel.gridx = 0;
        gbcLblChannel.gridy = 3;
        this.lblChannel = new JLabel(J18N.tr("Channel", new Object[0]) + ":");
        this.contentPanel.add((Component)this.lblChannel, gbcLblChannel);
        GridBagConstraints gbcSpinnerChannel = new GridBagConstraints();
        gbcSpinnerChannel.insets = new Insets(5, 5, 0, 0);
        gbcSpinnerChannel.fill = 2;
        gbcSpinnerChannel.gridx = 1;
        gbcSpinnerChannel.gridy = 3;
        this.spinnerChannel = new JSpinner(new SpinnerNumberModel(6, 1, 13, 1));
        this.contentPanel.add((Component)this.spinnerChannel, gbcSpinnerChannel);
        GridBagConstraints gbcLblSecurity = new GridBagConstraints();
        gbcLblSecurity.insets = new Insets(5, 0, 0, 0);
        gbcLblSecurity.anchor = 17;
        gbcLblSecurity.gridx = 0;
        gbcLblSecurity.gridy = 4;
        this.lblSecurity = new JLabel(J18N.tr("Security", new Object[0]) + ":");
        this.contentPanel.add((Component)this.lblSecurity, gbcLblSecurity);
        GridBagConstraints gbcCmbSecurity = new GridBagConstraints();
        gbcCmbSecurity.insets = new Insets(5, 5, 0, 0);
        gbcCmbSecurity.fill = 2;
        gbcCmbSecurity.gridx = 1;
        gbcCmbSecurity.gridy = 4;
        this.cmbSecurity = new JComboBox();
        this.cmbSecurity.addItem(WiFiSecurity.NONE);
        this.cmbSecurity.addItem(WiFiSecurity.WEP);
        this.cmbSecurity.addItem(WiFiSecurity.WPA);
        this.cmbSecurity.addItem(WiFiSecurity.WPA2);
        this.cmbSecurity.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConfigWiFiDialog.this.onUiChange();
            }
        });
        this.contentPanel.add(this.cmbSecurity, gbcCmbSecurity);
        GridBagConstraints gbcLblPassword = new GridBagConstraints();
        gbcLblPassword.insets = new Insets(5, 0, 0, 0);
        gbcLblPassword.anchor = 17;
        gbcLblPassword.gridx = 0;
        gbcLblPassword.gridy = 5;
        this.lblPassword = new JLabel(J18N.tr("Password", new Object[0]) + ":");
        this.contentPanel.add((Component)this.lblPassword, gbcLblPassword);
        GridBagConstraints gbcTxtPassword = new GridBagConstraints();
        gbcTxtPassword.insets = new Insets(5, 5, 0, 0);
        gbcTxtPassword.fill = 2;
        gbcTxtPassword.gridx = 1;
        gbcTxtPassword.gridy = 5;
        this.txtPassword = new CustomUiPasswordField();
        this.txtPassword.setEchoChar('*');
        this.txtPassword.setColumns(10);
        this.contentPanel.add((Component)this.txtPassword, gbcTxtPassword);
        GridBagConstraints gbcChkPassword = new GridBagConstraints();
        gbcChkPassword.insets = new Insets(5, 5, 0, 0);
        gbcChkPassword.fill = 2;
        this.chkShowPassword = new JCheckBox(J18N.tr("Show Password", new Object[0]));
        gbcChkPassword.gridx = 1;
        gbcChkPassword.gridy = 6;
        this.chkShowPassword.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    ConfigWiFiDialog.this.txtPassword.setEchoChar('*');
                } else {
                    ConfigWiFiDialog.this.txtPassword.setEchoChar('\u0000');
                }
            }
        });
        this.contentPanel.add((Component)this.chkShowPassword, gbcChkPassword);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btnOk = new JButton(J18N.tr("OK", new Object[0]));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWiFiDialog.this.save();
            }
        });
        this.btnCancel = new JButton(J18N.tr("Cancel", new Object[0]));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWiFiDialog.this.dispose();
            }
        });
        buttonPane.add(this.btnCancel);
        buttonPane.add(this.btnOk);
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(this.btnCancel);
        this.init();
    }

    private void init() {
        this.contentPanel.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.registerListeners();
        this.requestTerminalInfo();
        this.onUiChange();
        this.pack();
    }

    private void registerListeners() {
        AbstractTcConnection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        this.registerSc501CommandListener("#wlanconfig", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                ConfigWiFiDialog.this.chkShowPassword.setEnabled(true);
                ConfigWiFiDialog.this.contentPanel.setEnabled(true);
                ConfigWiFiDialog.this.btnOk.setEnabled(true);
                WlanConfig response = (WlanConfig)command;
                ConfigWiFiDialog.this.sc501Config = response.getParams();
                ConfigWiFiDialog.this.txtSsid.setText(((ConfigWiFiDialog)ConfigWiFiDialog.this).sc501Config.ssid);
                ConfigWiFiDialog.this.spinnerChannel.setValue(((ConfigWiFiDialog)ConfigWiFiDialog.this).sc501Config.channel);
                ConfigWiFiDialog.this.cmbSecurity.setSelectedItem((Object)((ConfigWiFiDialog)ConfigWiFiDialog.this).sc501Config.wifiSecurity);
                ConfigWiFiDialog.this.cmbMode.setSelectedItem((Object)((ConfigWiFiDialog)ConfigWiFiDialog.this).sc501Config.wifiMode);
                ConfigWiFiDialog.this.txtPassword.setText(((ConfigWiFiDialog)ConfigWiFiDialog.this).sc501Config.wepKey);
                ConfigWiFiDialog.this.onUiChange();
            }
        });
        this.registerSc501CommandListener("#rwlanconfig_ok\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                GuiUtils.showInfoMessage(ConfigWiFiDialog.this, J18N.tr("Settings saved", new Object[0]));
                connection.sendRestartTerminal();
                ConfigWiFiDialog.this.dispose(true);
            }
        });
        if (connection.getTerminalType() == TerminalType.TC_504) {
            this.registerListenerTc504();
        } else {
            this.registerListenerSc504();
        }
    }

    private void registerListenerSc504() {
        this.registerSc504CommandListener((short)154, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDvGetSetupWiFi config = (RIDvGetSetupWiFi)command;
                ConfigWiFiDialog.this.sc504Config = config.getArgSetupWiFi();
                ConfigWiFiDialog.this.contentPanel.setEnabled(true);
                ConfigWiFiDialog.this.btnOk.setEnabled(true);
                ConfigWiFiDialog.this.txtSsid.setText(ConfigWiFiDialog.this.sc504Config.getSsid());
                ConfigWiFiDialog.this.cmbMode.setSelectedItem((Object)ConfigWiFiDialog.this.sc504Config.getMode());
                ConfigWiFiDialog.this.spinnerChannel.setValue(ConfigWiFiDialog.this.sc504Config.getChannel());
                ConfigWiFiDialog.this.cmbSecurity.setSelectedItem((Object)ConfigWiFiDialog.this.sc504Config.getSecurity());
                ConfigWiFiDialog.this.txtPassword.setText(ConfigWiFiDialog.this.sc504Config.getKey());
                ConfigWiFiDialog.this.onUiChange();
            }
        });
        this.registerSc504CommandListener((short)152, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDvSetSetupWiFi ridv = (RIDvSetSetupWiFi)command;
                if (ridv.isSuccess()) {
                    GuiUtils.showInfoMessage(ConfigWiFiDialog.this, J18N.tr("Settings saved", new Object[0]));
                    ConfigWiFiDialog.this.dispose(true);
                } else {
                    GuiUtils.showWarningMessage(ConfigWiFiDialog.this, J18N.tr("Error while saving settings", new Object[0]));
                }
            }
        });
    }

    private void registerListenerTc504() {
        this.registerSc504CommandListener((short)152, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDvGetSetupWiFiTc504 config = (RIDvGetSetupWiFiTc504)command;
                ConfigWiFiDialog.this.sc504Config = config.getArgSetupWiFi();
                ConfigWiFiDialog.this.contentPanel.setEnabled(true);
                ConfigWiFiDialog.this.btnOk.setEnabled(true);
                ConfigWiFiDialog.this.txtSsid.setText(ConfigWiFiDialog.this.sc504Config.getSsid());
                ConfigWiFiDialog.this.cmbMode.setSelectedItem((Object)ConfigWiFiDialog.this.sc504Config.getMode());
                ConfigWiFiDialog.this.spinnerChannel.setValue(ConfigWiFiDialog.this.sc504Config.getChannel());
                ConfigWiFiDialog.this.cmbSecurity.setSelectedItem((Object)ConfigWiFiDialog.this.sc504Config.getSecurity());
                ConfigWiFiDialog.this.txtPassword.setText(ConfigWiFiDialog.this.sc504Config.getKey());
                ConfigWiFiDialog.this.onUiChange();
            }
        });
        this.registerSc504CommandListener((short)154, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDvSetSetupWiFiTc504 ridv = (RIDvSetSetupWiFiTc504)command;
                if (ridv.isSuccess()) {
                    GuiUtils.showInfoMessage(ConfigWiFiDialog.this, J18N.tr("Settings saved", new Object[0]));
                    ConfigWiFiDialog.this.dispose(true);
                } else {
                    GuiUtils.showWarningMessage(ConfigWiFiDialog.this, J18N.tr("Error while saving settings", new Object[0]));
                }
            }
        });
    }

    public void requestTerminalInfo() {
        AbstractTcConnection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        if (connection instanceof Sc501Connection) {
            connection.writeCommand(new WlanConfigQ());
        } else if (connection instanceof Sc504Connection) {
            if (connection.getTerminalType() == TerminalType.TC_504) {
                connection.writeCommand(new IDvGetSetupWiFiTc504());
            } else {
                connection.writeCommand(new IDvGetSetupWiFi());
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void save() {
        this.contentPanel.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
        AbstractTcConnection connection = this.getConnection();
        if (connection.isSc501()) {
            RWlanConfig request = new RWlanConfig(true, (WifiMode)((Object)this.cmbMode.getSelectedItem()), this.txtSsid.getText(), Byte.parseByte("" + this.spinnerChannel.getValue().toString()), (WiFiSecurity)((Object)this.cmbSecurity.getSelectedItem()), new String(this.txtPassword.getPassword()));
            connection.writeCommand(request);
            connection.sendRestartTerminal();
        } else if (connection.isSc504()) {
            if (connection.getTerminalType() == TerminalType.TC_504) {
                IDvSetSetupWiFiTc504 request = new IDvSetSetupWiFiTc504(true, (WifiMode)((Object)this.cmbMode.getSelectedItem()), this.txtSsid.getText(), (Integer)this.spinnerChannel.getValue(), (WiFiSecurity)((Object)this.cmbSecurity.getSelectedItem()), new String(this.txtPassword.getPassword()));
                connection.writeCommand(request);
            } else {
                IDvSetSetupWiFi request = new IDvSetSetupWiFi(true, (WifiMode)((Object)this.cmbMode.getSelectedItem()), this.txtSsid.getText(), (Integer)this.spinnerChannel.getValue(), (WiFiSecurity)((Object)this.cmbSecurity.getSelectedItem()), new String(this.txtPassword.getPassword()));
                connection.writeCommand(request);
                connection.sendRestartTerminal();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void onUiChange() {
        boolean valid = !this.txtSsid.getText().isEmpty();
        WiFiSecurity wifiSecurity = (WiFiSecurity)((Object)this.cmbSecurity.getSelectedItem());
        if (wifiSecurity != null) {
            this.txtPassword.setEnabled(wifiSecurity != WiFiSecurity.NONE);
            this.chkShowPassword.setEnabled(wifiSecurity != WiFiSecurity.NONE);
            valid = valid && (wifiSecurity == WiFiSecurity.NONE || wifiSecurity != WiFiSecurity.NONE && this.txtPassword.getPassword().length > 0);
            this.btnOk.setEnabled(valid);
        } else {
            this.btnOk.setEnabled(false);
        }
    }

    public class CustomUiPasswordField
    extends PasswordField {
        private static final long serialVersionUID = 229648600420367155L;

        @Override
        protected void onChange() {
            super.onChange();
            ConfigWiFiDialog.this.onUiChange();
        }
    }

    public class CustomUiTextField
    extends TextField {
        private static final long serialVersionUID = -9170057195415691870L;

        @Override
        protected void onChange() {
            super.onChange();
            ConfigWiFiDialog.this.onUiChange();
        }
    }
}

