/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.ApplicationSettings;
import br.com.gertec.tc.server.customer.GenerateImage;
import br.com.gertec.tc.server.customer.GifQueryBPG2;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.dao.ExhibitionParam;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.dao.ProductExhibition;
import br.com.gertec.tc.server.gui.SwingUtils;
import br.com.gertec.tc.server.gui.util.ButtonRenderer;
import br.com.gertec.tc.server.gui.util.EnumCombo;
import br.com.gertec.tc.server.gui.util.NamedColorChooser;
import br.com.gertec.tc.server.gui.util.NumberSpinnerEditor;
import br.com.gertec.tc.server.gui.util.TextField;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.util.BDUtils;
import br.com.gertec.tc.server.util.FileUtilities;
import br.com.gertec.tc.server.util.NamedColor;
import br.org.reconcavo.j18n.J18N;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableRowSorter;

public class ExhibitionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    ApplicationSettings settings;
    GenerateImage gImage;
    GifQueryBPG2 teste = new GifQueryBPG2();
    FileUtilities tempFile = new FileUtilities();
    final File baseDir = this.tempFile.getTemporaryCustomer();
    private static File lastDir = new File(System.getProperty("user.home"));
    private final ExhibitionTable exhibitionTable;
    private final TextField txtTerminalImage;
    private final TextField txtServerImage;
    private final JButton buttonBgColor;
    private final EnumCombo<Exhibition.MediaType> cmbMediaType;
    private final JPanel serverImgPanel;
    private final JLabel lblMedia;
    private final JLabel lblBgColor;
    private final TerminalType terminalType;
    private JScrollPane scrollPane;
    private JButton btnRestoreDefaults;
    public static DefaultTableModel dm;
    private JButton btnPreview;
    private JLabel lblPreImage;
    private JButton btnBrowse;
    public Product product;

    public ExhibitionPanel(final TerminalType terminalType, final Product product) {
        this.product = product;
        switch (terminalType) {
            case TC_504: 
            case TC_506_MIDIA: 
            case TC_508: 
            case TC_406: 
            case TC_406_E: 
            case TC_506_E: 
            case TC_505: 
            case TC_506_S: 
            case TC_507: 
            case GB_600: 
            case GB_601: {
                this.terminalType = terminalType;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported terminal type: " + terminalType.name());
            }
        }
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{70, 38, 207, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.scrollPane = new JScrollPane();
        GridBagConstraints gbcScrollPane = new GridBagConstraints();
        gbcScrollPane.insets = new Insets(0, 0, 5, 5);
        gbcScrollPane.fill = 1;
        gbcScrollPane.gridwidth = 4;
        gbcScrollPane.gridx = 0;
        gbcScrollPane.gridy = 0;
        this.add((Component)this.scrollPane, gbcScrollPane);
        this.exhibitionTable = new ExhibitionTable(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEdit() {
                ExhibitionPanel.this.onGuiChange();
            }
        };
        this.scrollPane.setViewportView(this.exhibitionTable);
        this.exhibitionTable.setBorder(null);
        this.exhibitionTable.setFillsViewportHeight(true);
        this.lblBgColor = new JLabel(J18N.tr("Background Color", new Object[0]) + ":");
        GridBagConstraints gbcLblBgColor = new GridBagConstraints();
        gbcLblBgColor.anchor = 17;
        gbcLblBgColor.insets = new Insets(5, 0, 5, 5);
        gbcLblBgColor.gridx = 0;
        gbcLblBgColor.gridy = 1;
        this.add((Component)this.lblBgColor, gbcLblBgColor);
        this.buttonBgColor = new JButton();
        GridBagConstraints gbcButtonBgColor = new GridBagConstraints();
        gbcButtonBgColor.insets = new Insets(5, 5, 5, 0);
        gbcButtonBgColor.fill = 2;
        gbcButtonBgColor.gridwidth = 4;
        gbcButtonBgColor.gridx = 2;
        gbcButtonBgColor.gridy = 1;
        this.add((Component)this.buttonBgColor, gbcButtonBgColor);
        JLabel lblMediaType = new JLabel(J18N.tr("Media type", new Object[0]) + ":");
        GridBagConstraints gbcLblMediaType = new GridBagConstraints();
        gbcLblMediaType.anchor = 17;
        gbcLblMediaType.insets = new Insets(5, 0, 5, 5);
        gbcLblMediaType.gridx = 0;
        gbcLblMediaType.gridy = 2;
        this.add((Component)lblMediaType, gbcLblMediaType);
        this.cmbMediaType = new EnumCombo<Exhibition.MediaType>(Exhibition.MediaType.class);
        GridBagConstraints gbcCmbMediaType = new GridBagConstraints();
        gbcCmbMediaType.gridwidth = 2;
        gbcCmbMediaType.insets = new Insets(5, 5, 5, 5);
        gbcCmbMediaType.fill = 2;
        gbcCmbMediaType.gridx = 2;
        gbcCmbMediaType.gridy = 2;
        this.add(this.cmbMediaType, gbcCmbMediaType);
        gbcCmbMediaType.anchor = 17;
        this.lblPreImage = new JLabel(J18N.tr("Time exhibition", new Object[0]) + ":");
        GridBagConstraints gbcLblPreImage = new GridBagConstraints();
        gbcLblPreImage.insets = new Insets(0, 0, 5, 5);
        gbcLblPreImage.gridx = 0;
        gbcLblPreImage.gridy = 3;
        this.add((Component)this.lblPreImage, gbcLblPreImage);
        this.txtTerminalImage = new TextField(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                ExhibitionPanel.this.onGuiChange();
            }
        };
        GridBagConstraints gbcTxtTerminalImage = new GridBagConstraints();
        gbcTxtTerminalImage.gridwidth = 2;
        gbcTxtTerminalImage.insets = new Insets(5, 5, 5, 5);
        gbcTxtTerminalImage.fill = 1;
        gbcTxtTerminalImage.gridx = 2;
        gbcTxtTerminalImage.gridy = 3;
        this.add((Component)this.txtTerminalImage, gbcTxtTerminalImage);
        this.txtTerminalImage.setColumns(10);
        this.serverImgPanel = new JPanel();
        GridBagConstraints gbcServerImgPanel = new GridBagConstraints();
        gbcServerImgPanel.insets = new Insets(5, 5, 5, 5);
        gbcServerImgPanel.fill = 13;
        gbcServerImgPanel.gridx = 2;
        gbcServerImgPanel.gridy = 6;
        this.add((Component)this.serverImgPanel, gbcServerImgPanel);
        GridBagLayout gblServerImgPanel = new GridBagLayout();
        gblServerImgPanel.columnWidths = new int[]{0, 0, 0};
        gblServerImgPanel.rowHeights = new int[]{0, 0};
        gblServerImgPanel.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gblServerImgPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.serverImgPanel.setLayout(gblServerImgPanel);
        this.lblMedia = new JLabel(J18N.tr("Media", new Object[0]) + ":*");
        GridBagConstraints gbcLblMedia = new GridBagConstraints();
        gbcLblMedia.anchor = 17;
        gbcLblMedia.insets = new Insets(5, 0, 5, 5);
        gbcLblMedia.gridx = 0;
        gbcLblMedia.gridy = 7;
        this.add((Component)this.lblMedia, gbcLblMedia);
        this.txtServerImage = new TextField();
        GridBagConstraints gbcTxtServerImage = new GridBagConstraints();
        gbcTxtServerImage.fill = 1;
        gbcTxtServerImage.insets = new Insets(0, 0, 5, 5);
        gbcTxtServerImage.gridx = 2;
        gbcTxtServerImage.gridy = 7;
        this.add((Component)this.txtServerImage, gbcTxtServerImage);
        this.txtServerImage.setEditable(false);
        this.txtServerImage.setColumns(10);
        this.btnBrowse = new JButton(J18N.tr("Browse", new Object[0]) + "...");
        GridBagConstraints gbcBtnBrowse = new GridBagConstraints();
        gbcBtnBrowse.insets = new Insets(0, 0, 5, 5);
        gbcBtnBrowse.gridx = 3;
        gbcBtnBrowse.gridy = 7;
        this.add((Component)this.btnBrowse, gbcBtnBrowse);
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.setLanguageFileChooser();
                JFileChooser fileChooser = new JFileChooser();
                JList list = SwingUtils.getDescendantOfType(JList.class, fileChooser, "Enabled", true);
                JPopupMenu popup = list.getComponentPopupMenu();
                popup.remove(0);
                this.disableComponent(fileChooser);
                fileChooser.setCurrentDirectory(lastDir);
                fileChooser.setMultiSelectionEnabled(false);
                fileChooser.setAcceptAllFileFilterUsed(false);
                switch (terminalType) {
                    case TC_506_E: {
                        fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("Supported image files", new Object[0]), "jpg", "bmp", "gif"));
                        break;
                    }
                    case TC_406_E: {
                        fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("Supported image files", new Object[0]), "jpg", "bmp", "gif"));
                        break;
                    }
                    default: {
                        fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("Supported image files", new Object[0]), "jpg", "png", "bmp", "gif"));
                    }
                }
                int result = fileChooser.showOpenDialog(ExhibitionPanel.this);
                if (fileChooser.getSelectedFile() != null && fileChooser.getSelectedFile().toString().indexOf(".gif") != -1) {
                    JOptionPane.showMessageDialog(null, J18N.tr("This terminal doesn't support GIF images, but the 1st animation frame will be converted and sent to the terminal", new Object[0]));
                }
                if (result == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    lastDir = selectedFile.getParentFile();
                    ExhibitionPanel.this.txtServerImage.setText(selectedFile.getAbsolutePath());
                    ExhibitionPanel.this.onGuiChange();
                }
                if (!ExhibitionPanel.this.txtServerImage.getText().isEmpty()) {
                    ExhibitionPanel.this.btnPreview.setEnabled(true);
                }
            }

            public void disableComponent(Container c) {
                int len = c.getComponentCount();
                for (int i = 0; i < len; ++i) {
                    Component comp = c.getComponent(i);
                    if (comp instanceof JToggleButton) {
                        comp.setEnabled(false);
                        continue;
                    }
                    if (!(comp instanceof Container)) continue;
                    this.disableComponent((Container)comp);
                }
            }

            private void setLanguageFileChooser() {
                UIManager.put("FileChooser.openDialogTitleText", J18N.tr("Open", new Object[0]));
                UIManager.put("FileChooser.lookInLabelText", J18N.tr("Look in:", new Object[0]));
                UIManager.put("FileChooser.fileNameLabelText", J18N.tr("File Name:", new Object[0]));
                UIManager.put("FileChooser.filesOfTypeLabelText", J18N.tr("Files of Type:", new Object[0]));
                UIManager.put("FileChooser.openButtonText", J18N.tr("Open", new Object[0]));
                UIManager.put("FileChooser.cancelButtonText", J18N.tr("Cancel", new Object[0]));
                UIManager.put("FileChooser.upFolderToolTipText", J18N.tr("Up One Level", new Object[0]));
                UIManager.put("FileChooser.newFolderToolTipText", J18N.tr("Create New Folder", new Object[0]));
                UIManager.put("FileChooser.listViewButtonToolTipText", J18N.tr("List", new Object[0]));
                UIManager.put("FileChooser.detailsViewButtonToolTipText", J18N.tr("Details", new Object[0]));
                UIManager.put("FileChooser.openButtonToolTipText", J18N.tr("Open selected file", new Object[0]));
                UIManager.put("FileChooser.cancelButtonToolTipText", J18N.tr("Abort file chooser dialog", new Object[0]));
                UIManager.put("FileChooser.newFolderErrorText", J18N.tr("Error creating new folder", new Object[0]));
                UIManager.put("FileChooser.viewMenuLabelText", J18N.tr("View", new Object[0]));
                UIManager.put("FileChooser.refreshActionLabelText", J18N.tr("Refresh", new Object[0]));
                UIManager.put("FileChooser.newFolderActionLabelText", J18N.tr("New Folder", new Object[0]));
                UIManager.put("FileChooser.detailsViewActionLabelText", J18N.tr("Details", new Object[0]));
                UIManager.put("FileChooser.listViewActionLabelText", J18N.tr("List", new Object[0]));
                UIManager.put("FileChooser.acceptAllFileFilterText", J18N.tr("All Files", new Object[0]));
            }
        });
        this.btnPreview = new JButton(J18N.tr("Preview", new Object[0]));
        this.btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String label2;
                String price2;
                String price;
                String description;
                String barcode = "";
                try {
                    barcode = ExhibitionPanel.this.getBarcodeFromTxt();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    System.out.println("Erro ao obter o c\u00f3digo de barras do produto.");
                }
                GuiData data = ExhibitionPanel.this.getGuiData();
                Product product = Product.get(barcode);
                String diretory = ExhibitionPanel.this.txtServerImage.getText();
                String fontText = "TimesRoman";
                String label1 = "";
                if (product == null) {
                    description = "Produto n\u00e3o encontrado";
                    price = "";
                    price2 = "";
                    label1 = "";
                    label2 = "";
                } else {
                    description = product.getDescription() == null ? BDUtils.NO_DESCRIPTION : product.getDescription();
                    price = product.getPrice1() == null && product.getPrice2().equals("") || product.getPrice1() == null ? BDUtils.NO_PRICE_1 : product.getPrice1();
                    price2 = product.getPrice2();
                    label1 = Application.SETTINGS.getProperty("LABEL1");
                    label2 = Application.SETTINGS.getProperty("LABEL2");
                }
                String colorDesc = data.exhibition.getDescription().getFgColor().name();
                short descSizeText = data.exhibition.getDescription().getFontSize();
                short desPosX = data.exhibition.getDescription().getX();
                short desPosY = data.exhibition.getDescription().getY();
                String colorPrice = data.exhibition.getPrice1().getFgColor().name();
                short priceSizeText = data.exhibition.getPrice1().getFontSize();
                short pricePosX = data.exhibition.getPrice1().getX();
                short pricePosY = data.exhibition.getPrice1().getY();
                String colorPrice2 = data.exhibition.getPrice2().getFgColor().name();
                short price2SizeText = data.exhibition.getPrice2().getFontSize();
                short price2PosX = data.exhibition.getPrice2().getX();
                short price2PosY = data.exhibition.getPrice2().getY();
                String colorLabel1 = data.exhibition.getLabel1().getFgColor().name();
                short label1SizeText = data.exhibition.getLabel1().getFontSize();
                short label1PosX = data.exhibition.getLabel1().getX();
                short label1PosY = data.exhibition.getLabel1().getY();
                String colorLabel2 = data.exhibition.getLabel2().getFgColor().name();
                short label2SizeText = data.exhibition.getLabel2().getFontSize();
                short label2PosX = data.exhibition.getLabel2().getX();
                short label2PosY = data.exhibition.getLabel2().getY();
                try {
                    ExhibitionPanel.this.gImage = ExhibitionPanel.this.getTerminalType() == TerminalType.TC_505 || ExhibitionPanel.this.getTerminalType() == TerminalType.TC_507 ? new GenerateImage(description, price, price2, 128, 64) : new GenerateImage(diretory, fontText, descSizeText, priceSizeText, price2SizeText, label1SizeText, label2SizeText, colorDesc, colorPrice, colorPrice2, colorLabel1, colorLabel2, desPosX, desPosY, description, pricePosX, pricePosY, price2PosX, price2PosY, price, price2, label1PosX, label1PosY, label2PosX, label2PosY, label1, label2, 1);
                }
                catch (IOException ioeException) {
                    ioeException.printStackTrace();
                    System.out.println("Erro ao gerar a imagem de pr\u00e9-visualiza\u00e7\u00e3o!");
                }
                ExhibitionPanel.this.gImage.showQueryImage();
            }
        });
        GridBagConstraints gbcBtnPreview = new GridBagConstraints();
        gbcBtnPreview.fill = 2;
        gbcBtnPreview.insets = new Insets(0, 0, 0, 5);
        gbcBtnPreview.gridx = 0;
        gbcBtnPreview.gridy = 9;
        this.add((Component)this.btnPreview, gbcBtnPreview);
        this.btnRestoreDefaults = new JButton(J18N.tr("Restore defaults", new Object[0]));
        this.btnRestoreDefaults.addActionListener(new ActionListener(){

            private Exhibition getDefaultExhibition() {
                TerminalType terminalType2 = ExhibitionPanel.this.getTerminalType();
                switch (terminalType2) {
                    case TC_504: {
                        return ApplicationSettings.DEFAULT_EXHIBITION_TC504;
                    }
                    case TC_506_MIDIA: {
                        return ApplicationSettings.DEFAULT_EXHIBITION_TC506M;
                    }
                    case TC_508: {
                        return ApplicationSettings.DEFAULT_EXHIBITION_TC508;
                    }
                    case TC_406: {
                        return ApplicationSettings.DEFAULT_EXHIBITION_TC406;
                    }
                    case TC_505: {
                        return ApplicationSettings.DEFAULT_EXHIBITION_TC505;
                    }
                    case TC_506_S: {
                        return ApplicationSettings.DEFAULT_EXHIBITION_TC506S;
                    }
                    case TC_506_E: {
                        return ApplicationSettings.DEFAULT_EXHIBITION_TC506E;
                    }
                    case TC_406_E: {
                        return ApplicationSettings.DEFAULT_EXHIBITION_TC406E;
                    }
                    case TC_507: {
                        return ApplicationSettings.DEFAULT_EXHIBITION_TC507;
                    }
                    case GB_600: {
                        return ApplicationSettings.DEFAULT_EXHIBITION_GB600;
                    }
                    case GB_601: {
                        return ApplicationSettings.DEFAULT_EXHIBITION_GB601;
                    }
                }
                throw new UnsupportedOperationException();
            }

            private ExhibitionParam getDefaultNotFoundExhibition() {
                TerminalType terminalType2 = ExhibitionPanel.this.getTerminalType();
                switch (terminalType2) {
                    case TC_504: {
                        return ApplicationSettings.DEFAULT_EXHIB_PARAM_NOT_FOUND_TC504;
                    }
                    case TC_506_MIDIA: {
                        return ApplicationSettings.DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506M;
                    }
                    case TC_508: {
                        return ApplicationSettings.DEFAULT_EXHIB_PARAM_NOT_FOUND_TC508;
                    }
                    case TC_505: {
                        return ApplicationSettings.DEFAULT_EXHIB_PARAM_NOT_FOUND_TC505;
                    }
                    case TC_506_S: {
                        return ApplicationSettings.DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506S;
                    }
                    case TC_506_E: {
                        return ApplicationSettings.DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506E;
                    }
                    case TC_406_E: {
                        return ApplicationSettings.DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406E;
                    }
                    case TC_507: {
                        return ApplicationSettings.DEFAULT_EXHIB_PARAM_NOT_FOUND_TC507;
                    }
                    case TC_406: {
                        return ApplicationSettings.DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406;
                    }
                    case GB_600: {
                        return ApplicationSettings.DEFAULT_EXHIB_PARAM_NOT_FOUND_GB600;
                    }
                    case GB_601: {
                        return ApplicationSettings.DEFAULT_EXHIB_PARAM_NOT_FOUND_GB601;
                    }
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(ExhibitionPanel.this, J18N.tr("Default properties will be restored. Do you want to proceed?", new Object[0]), Application.APP_NAME, 0, 2);
                if (result == 0) {
                    Window w = SwingUtilities.windowForComponent(ExhibitionPanel.this.btnRestoreDefaults);
                    if (product != null) {
                        try {
                            ProductExhibition.deleteRow(product.getBarcode());
                            if (ExhibitionPanel.this.teste.searchGif(product.getBarcode(), terminalType)) {
                                ExhibitionPanel.this.teste.deleteQueryGif(product.getBarcode(), terminalType);
                            }
                            w.dispose();
                        }
                        catch (NullPointerException nullPointerException) {}
                    } else {
                        ExhibitionPanel.this.load(this.getDefaultExhibition(), this.getDefaultNotFoundExhibition());
                    }
                }
            }
        });
        GridBagConstraints gbcBtnRestoreDefaults = new GridBagConstraints();
        gbcBtnRestoreDefaults.insets = new Insets(5, 5, 0, 5);
        gbcBtnRestoreDefaults.anchor = 13;
        gbcBtnRestoreDefaults.gridx = 3;
        gbcBtnRestoreDefaults.gridy = 9;
        this.add((Component)this.btnRestoreDefaults, gbcBtnRestoreDefaults);
        this.init();
    }

    public final TerminalType getTerminalType() {
        return this.terminalType;
    }

    public void load(Exhibition exhibition, ExhibitionParam notFoundExhibitionParam) {
        this.exhibitionTable.load(this.getTerminalType(), exhibition, notFoundExhibitionParam);
        this.buttonBgColor.setText(exhibition.getBgColor().name());
        Exhibition.MediaType mediaType = exhibition.getMediaType();
        this.cmbMediaType.setSelectedItem((Object)mediaType);
        if (mediaType != null) {
            switch (mediaType) {
                case SERVER_IMAGE: {
                    File serverImageFile;
                    String serverImagePath = exhibition.getMediaPath();
                    File file = serverImageFile = serverImagePath != null && !serverImagePath.isEmpty() ? new File(serverImagePath) : null;
                    if (serverImageFile != null && serverImageFile.exists()) {
                        lastDir = serverImageFile.getParentFile();
                        if (this.terminalType == TerminalType.TC_406 || this.terminalType == TerminalType.TC_506_S || this.terminalType == TerminalType.TC_506_E || this.terminalType == TerminalType.TC_406_E) {
                            this.btnPreview.setEnabled(true);
                        }
                    } else {
                        serverImagePath = "";
                    }
                    this.txtServerImage.setText(serverImagePath);
                    break;
                }
                case TERMINAL_IMAGE: {
                    this.txtTerminalImage.setText(exhibition.getMediaPath());
                    break;
                }
            }
        }
    }

    public GuiData getGuiData() {
        return new GuiData();
    }

    private void init() {
        this.cmbMediaType.setSelectedItem((Object)Exhibition.MediaType.NONE);
        Exhibition productExhibition = null;
        boolean productConfig = false;
        try {
            productExhibition = ProductExhibition.get(this.getBarcodeFromTxt(), this.getTerminalType());
            productConfig = productExhibition != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        switch (this.getTerminalType()) {
            case TC_504: {
                this.cmbMediaType.removeItem((Object)Exhibition.MediaType.PREIMAGE);
                this.cmbMediaType.removeItem((Object)Exhibition.MediaType.TERMINAL_IMAGE);
                break;
            }
            case TC_506_MIDIA: {
                this.cmbMediaType.removeItem((Object)Exhibition.MediaType.TERMINAL_IMAGE);
                this.cmbMediaType.removeItem((Object)Exhibition.MediaType.PREIMAGE);
                break;
            }
            case TC_508: {
                this.cmbMediaType.removeItem((Object)Exhibition.MediaType.PREIMAGE);
                this.cmbMediaType.removeItem((Object)Exhibition.MediaType.TERMINAL_IMAGE);
                break;
            }
            case TC_406: {
                this.mudaTabelaPadraoBPG2();
                break;
            }
            case TC_506_S: {
                this.mudaTabelaPadraoTc506S();
                break;
            }
            case TC_506_E: {
                this.mudaTabelaPadraoTc506E();
                break;
            }
            case TC_406_E: {
                this.mudaTabelaPadraoBPG2E();
                break;
            }
            case TC_505: {
                this.mudaTabelaPadraoSC501();
                if (productConfig) {
                    this.cmbMediaType.setSelectedIndex(productExhibition.getMediaType() == Exhibition.MediaType.TERMINAL_IMAGE ? 1 : 0);
                    break;
                }
                this.cmbMediaType.setSelectedIndex(ApplicationSettings.DEFAULT_EXHIBITION_TC505.getMediaType() == Exhibition.MediaType.TERMINAL_IMAGE ? 1 : 0);
                break;
            }
            case TC_507: {
                this.mudaTabelaPadraoSC501();
                if (productConfig) {
                    this.cmbMediaType.setSelectedIndex(productExhibition.getMediaType() == Exhibition.MediaType.TERMINAL_IMAGE ? 1 : 0);
                    break;
                }
                this.cmbMediaType.setSelectedIndex(ApplicationSettings.DEFAULT_EXHIBITION_TC507.getMediaType() == Exhibition.MediaType.TERMINAL_IMAGE ? 1 : 0);
                break;
            }
            case GB_600: {
                this.mudaTabelaPadraoGB600();
                break;
            }
            case GB_601: {
                this.mudaTabelaPadraoGB601();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + this.getTerminalType().name());
            }
        }
        this.cmbMediaType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Exhibition.MediaType mediaType = (Exhibition.MediaType)((Object)ExhibitionPanel.this.cmbMediaType.getSelectedItem());
                this.mudaParametrosDeExibicao(mediaType);
                ExhibitionPanel.this.onGuiChange();
            }

            private void mudaParametrosDeExibicao(Exhibition.MediaType mediaType) {
                TerminalType terminalType = ExhibitionPanel.this.getTerminalType();
                switch (terminalType) {
                    case TC_406: {
                        this.tc406Dialog(mediaType);
                        break;
                    }
                    case TC_505: {
                        this.sc501Dialog(mediaType);
                        break;
                    }
                    case TC_506_S: {
                        this.tc506sDialog(mediaType);
                        break;
                    }
                    case TC_506_E: {
                        this.tc506eDialog(mediaType);
                        break;
                    }
                    case TC_406_E: {
                        this.tc406eDialog(mediaType);
                        break;
                    }
                    case TC_507: {
                        this.sc501Dialog(mediaType);
                        break;
                    }
                    case TC_504: {
                        this.tc504Dialog(mediaType);
                        break;
                    }
                    case TC_506_MIDIA: {
                        this.tc506MidiaDialog(mediaType);
                        break;
                    }
                    case TC_508: {
                        this.tc508Dialog(mediaType);
                        break;
                    }
                    case GB_600: {
                        this.gb600MidiaDialog(mediaType);
                        break;
                    }
                    case GB_601: {
                        this.gb601MidiaDialog(mediaType);
                        break;
                    }
                }
            }

            private void sc501Dialog(Exhibition.MediaType mediaType) {
                switch (mediaType) {
                    case SERVER_IMAGE: {
                        this.todosComponentesInivisiveis();
                        ExhibitionPanel.this.btnPreview.setVisible(true);
                        ExhibitionPanel.this.exhibitionTable.setVisible(false);
                        break;
                    }
                    case NONE: {
                        this.todosComponentesInivisiveis();
                        ExhibitionPanel.this.exhibitionTable.setVisible(false);
                        break;
                    }
                    case PREIMAGE: {
                        break;
                    }
                }
            }

            private void tc406Dialog(Exhibition.MediaType mediaType) {
                switch (mediaType) {
                    case SERVER_IMAGE: {
                        ExhibitionPanel.this.exhibitionTable.setVisible(true);
                        ExhibitionPanel.this.buttonBgColor.setVisible(false);
                        ExhibitionPanel.this.lblBgColor.setVisible(false);
                        ExhibitionPanel.this.txtServerImage.setVisible(true);
                        ExhibitionPanel.this.lblMedia.setVisible(true);
                        ExhibitionPanel.this.btnBrowse.setVisible(true);
                        ExhibitionPanel.this.btnPreview.setVisible(true);
                        ExhibitionPanel.this.btnPreview.setEnabled(false);
                        ExhibitionPanel.this.txtTerminalImage.setVisible(false);
                        ExhibitionPanel.this.lblPreImage.setVisible(false);
                        break;
                    }
                    case NONE: {
                        this.todosComponentesInivisiveis();
                        ExhibitionPanel.this.exhibitionTable.setVisible(false);
                    }
                    case PREIMAGE: {
                        break;
                    }
                }
            }

            private void tc506eDialog(Exhibition.MediaType mediaType) {
                switch (mediaType) {
                    case SERVER_IMAGE: {
                        ExhibitionPanel.this.exhibitionTable.setVisible(true);
                        ExhibitionPanel.this.buttonBgColor.setVisible(false);
                        ExhibitionPanel.this.lblBgColor.setVisible(false);
                        ExhibitionPanel.this.txtServerImage.setVisible(true);
                        ExhibitionPanel.this.lblMedia.setVisible(true);
                        ExhibitionPanel.this.btnBrowse.setVisible(true);
                        ExhibitionPanel.this.btnPreview.setVisible(true);
                        ExhibitionPanel.this.btnPreview.setEnabled(false);
                        ExhibitionPanel.this.txtTerminalImage.setVisible(false);
                        ExhibitionPanel.this.lblPreImage.setVisible(false);
                        break;
                    }
                    case NONE: {
                        this.todosComponentesInivisiveis();
                        ExhibitionPanel.this.exhibitionTable.setVisible(false);
                    }
                    case PREIMAGE: {
                        break;
                    }
                }
            }

            private void tc406eDialog(Exhibition.MediaType mediaType) {
                switch (mediaType) {
                    case SERVER_IMAGE: {
                        ExhibitionPanel.this.exhibitionTable.setVisible(true);
                        ExhibitionPanel.this.buttonBgColor.setVisible(false);
                        ExhibitionPanel.this.lblBgColor.setVisible(false);
                        ExhibitionPanel.this.txtServerImage.setVisible(true);
                        ExhibitionPanel.this.lblMedia.setVisible(true);
                        ExhibitionPanel.this.btnBrowse.setVisible(true);
                        ExhibitionPanel.this.btnPreview.setVisible(true);
                        ExhibitionPanel.this.btnPreview.setEnabled(false);
                        ExhibitionPanel.this.txtTerminalImage.setVisible(false);
                        ExhibitionPanel.this.lblPreImage.setVisible(false);
                        break;
                    }
                    case NONE: {
                        this.todosComponentesInivisiveis();
                        ExhibitionPanel.this.exhibitionTable.setVisible(false);
                    }
                    case PREIMAGE: {
                        break;
                    }
                }
            }

            private void tc506sDialog(Exhibition.MediaType mediaType) {
                switch (mediaType) {
                    case SERVER_IMAGE: {
                        ExhibitionPanel.this.exhibitionTable.setVisible(true);
                        ExhibitionPanel.this.buttonBgColor.setVisible(false);
                        ExhibitionPanel.this.lblBgColor.setVisible(false);
                        ExhibitionPanel.this.txtServerImage.setVisible(true);
                        ExhibitionPanel.this.lblMedia.setVisible(true);
                        ExhibitionPanel.this.btnBrowse.setVisible(true);
                        ExhibitionPanel.this.btnPreview.setVisible(true);
                        ExhibitionPanel.this.btnPreview.setEnabled(false);
                        ExhibitionPanel.this.txtTerminalImage.setVisible(false);
                        ExhibitionPanel.this.lblPreImage.setVisible(false);
                        break;
                    }
                    case NONE: {
                        this.todosComponentesInivisiveis();
                        ExhibitionPanel.this.exhibitionTable.setVisible(false);
                    }
                    case PREIMAGE: {
                        break;
                    }
                }
            }

            private void tc504Dialog(Exhibition.MediaType mediaType) {
                switch (mediaType) {
                    case SERVER_IMAGE: {
                        this.todosComponentesInivisiveis();
                        ExhibitionPanel.this.txtServerImage.setVisible(true);
                        ExhibitionPanel.this.lblMedia.setVisible(true);
                        ExhibitionPanel.this.btnBrowse.setVisible(true);
                        break;
                    }
                    case NONE: {
                        this.todosComponentesInivisiveis();
                        ExhibitionPanel.this.filterTable(J18N.tr("Description", new Object[0]), J18N.tr("Barcode", new Object[0]), J18N.tr("Label 1", new Object[0]), J18N.tr("Price 1", new Object[0]), J18N.tr("Label 2", new Object[0]), J18N.tr("Price 2", new Object[0]));
                        break;
                    }
                    case PREIMAGE: {
                        break;
                    }
                }
            }

            private void tc506MidiaDialog(Exhibition.MediaType mediaType) {
                switch (mediaType) {
                    case SERVER_IMAGE: {
                        ExhibitionPanel.this.lblBgColor.setVisible(true);
                        ExhibitionPanel.this.txtServerImage.setVisible(true);
                        ExhibitionPanel.this.lblMedia.setVisible(true);
                        ExhibitionPanel.this.txtTerminalImage.setVisible(false);
                        ExhibitionPanel.this.lblPreImage.setVisible(false);
                        ExhibitionPanel.this.btnPreview.setVisible(false);
                        ExhibitionPanel.this.btnBrowse.setVisible(true);
                        ExhibitionPanel.this.buttonBgColor.setVisible(false);
                        ExhibitionPanel.this.lblBgColor.setVisible(false);
                        break;
                    }
                    case NONE: {
                        this.todosComponentesInivisiveis();
                        ExhibitionPanel.this.buttonBgColor.setVisible(true);
                        ExhibitionPanel.this.filterTable(J18N.tr("Description", new Object[0]), J18N.tr("Barcode", new Object[0]), J18N.tr("Label 1", new Object[0]), J18N.tr("Price 1", new Object[0]), J18N.tr("Label 2", new Object[0]), J18N.tr("Price 2", new Object[0]));
                        break;
                    }
                    case PREIMAGE: {
                        break;
                    }
                }
            }

            private void tc508Dialog(Exhibition.MediaType mediaType) {
                switch (mediaType) {
                    case SERVER_IMAGE: {
                        ExhibitionPanel.this.txtServerImage.setVisible(true);
                        ExhibitionPanel.this.lblMedia.setVisible(true);
                        ExhibitionPanel.this.btnBrowse.setVisible(true);
                        ExhibitionPanel.this.buttonBgColor.setVisible(false);
                        ExhibitionPanel.this.lblBgColor.setVisible(false);
                        ExhibitionPanel.this.txtTerminalImage.setVisible(false);
                        ExhibitionPanel.this.lblPreImage.setVisible(false);
                        ExhibitionPanel.this.btnPreview.setVisible(false);
                        break;
                    }
                    case NONE: {
                        this.todosComponentesInivisiveis();
                        ExhibitionPanel.this.buttonBgColor.setVisible(true);
                        ExhibitionPanel.this.filterTable(J18N.tr("Description", new Object[0]), J18N.tr("Barcode", new Object[0]), J18N.tr("Label 1", new Object[0]), J18N.tr("Price 1", new Object[0]), J18N.tr("Label 2", new Object[0]), J18N.tr("Price 2", new Object[0]));
                        break;
                    }
                    case PREIMAGE: {
                        break;
                    }
                }
            }

            public void gb600MidiaDialog(Exhibition.MediaType mediaType) {
                switch (mediaType) {
                    case SERVER_IMAGE: {
                        ExhibitionPanel.this.exhibitionTable.setVisible(true);
                        ExhibitionPanel.this.buttonBgColor.setVisible(true);
                        ExhibitionPanel.this.lblBgColor.setVisible(true);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    case PREIMAGE: {
                        break;
                    }
                    case TERMINAL_IMAGE: {
                        ExhibitionPanel.this.exhibitionTable.setVisible(false);
                        ExhibitionPanel.this.buttonBgColor.setVisible(false);
                        ExhibitionPanel.this.lblBgColor.setVisible(false);
                    }
                }
            }

            public void gb601MidiaDialog(Exhibition.MediaType mediaType) {
                switch (mediaType) {
                    case SERVER_IMAGE: {
                        ExhibitionPanel.this.exhibitionTable.setVisible(true);
                        ExhibitionPanel.this.buttonBgColor.setVisible(true);
                        ExhibitionPanel.this.lblBgColor.setVisible(true);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    case PREIMAGE: {
                        break;
                    }
                    case TERMINAL_IMAGE: {
                        ExhibitionPanel.this.exhibitionTable.setVisible(false);
                        ExhibitionPanel.this.buttonBgColor.setVisible(false);
                        ExhibitionPanel.this.lblBgColor.setVisible(false);
                    }
                }
            }

            private void todosComponentesInivisiveis() {
                ExhibitionPanel.this.txtServerImage.setVisible(false);
                ExhibitionPanel.this.txtServerImage.setText("");
                ExhibitionPanel.this.lblMedia.setVisible(false);
                ExhibitionPanel.this.txtServerImage.setVisible(false);
                ExhibitionPanel.this.txtTerminalImage.setVisible(false);
                ExhibitionPanel.this.txtTerminalImage.setText("");
                ExhibitionPanel.this.lblPreImage.setVisible(false);
                ExhibitionPanel.this.btnPreview.setVisible(false);
                ExhibitionPanel.this.btnBrowse.setVisible(false);
                ExhibitionPanel.this.buttonBgColor.setVisible(false);
                ExhibitionPanel.this.lblBgColor.setVisible(false);
            }
        });
        this.buttonBgColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamedColor defaultColor = NamedColor.fromName(ExhibitionPanel.this.buttonBgColor.getText());
                NamedColor selectedColor = NamedColorChooser.showDialog(defaultColor, true);
                ExhibitionPanel.this.buttonBgColor.setText(selectedColor.name());
                ExhibitionPanel.this.onGuiChange();
            }
        });
        Application.EVENT_LOOP.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExhibitionPanel.this.onGuiChange();
            }
        });
    }

    private void mudaTabelaPadraoBPG2() {
        dm = (DefaultTableModel)this.exhibitionTable.getModel();
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.PREIMAGE);
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.TERMINAL_IMAGE);
        this.exhibitionTable.getColumnModel().getColumn(3).setMaxWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(3).setMinWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(3).setMaxWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(3).setMinWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(6).setMaxWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(6).setMinWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(6).setMaxWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(6).setMinWidth(0);
        this.filterTable(J18N.tr("Description", new Object[0]), J18N.tr("Label 1", new Object[0]), J18N.tr("Price 1", new Object[0]), J18N.tr("Label 2", new Object[0]), J18N.tr("Price 2", new Object[0]));
    }

    private void mudaTabelaPadraoTc506S() {
        dm = (DefaultTableModel)this.exhibitionTable.getModel();
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.PREIMAGE);
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.TERMINAL_IMAGE);
        this.exhibitionTable.getColumnModel().getColumn(3).setMaxWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(3).setMinWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(3).setMaxWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(3).setMinWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(6).setMaxWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(6).setMinWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(6).setMaxWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(6).setMinWidth(0);
        this.filterTable(J18N.tr("Description", new Object[0]), J18N.tr("Label 1", new Object[0]), J18N.tr("Price 1", new Object[0]), J18N.tr("Label 2", new Object[0]), J18N.tr("Price 2", new Object[0]));
    }

    private void mudaTabelaPadraoBPG2E() {
        dm = (DefaultTableModel)this.exhibitionTable.getModel();
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.PREIMAGE);
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.TERMINAL_IMAGE);
        this.exhibitionTable.getColumnModel().getColumn(3).setMaxWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(3).setMinWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(3).setMaxWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(3).setMinWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(6).setMaxWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(6).setMinWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(6).setMaxWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(6).setMinWidth(0);
        this.filterTable(J18N.tr("Description", new Object[0]), J18N.tr("Label 1", new Object[0]), J18N.tr("Price 1", new Object[0]), J18N.tr("Label 2", new Object[0]), J18N.tr("Price 2", new Object[0]));
    }

    private void mudaTabelaPadraoTc506E() {
        dm = (DefaultTableModel)this.exhibitionTable.getModel();
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.PREIMAGE);
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.TERMINAL_IMAGE);
        this.exhibitionTable.getColumnModel().getColumn(3).setMaxWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(3).setMinWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(3).setMaxWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(3).setMinWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(6).setMaxWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(6).setMinWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(6).setMaxWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(6).setMinWidth(0);
        this.filterTable(J18N.tr("Description", new Object[0]), J18N.tr("Label 1", new Object[0]), J18N.tr("Price 1", new Object[0]), J18N.tr("Label 2", new Object[0]), J18N.tr("Price 2", new Object[0]));
    }

    private void mudaTabelaPadraoSC501() {
        dm = (DefaultTableModel)this.exhibitionTable.getModel();
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.PREIMAGE);
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.TERMINAL_IMAGE);
        this.exhibitionTable.getColumnModel().getColumn(3).setMaxWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(3).setMinWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(3).setMaxWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(3).setMinWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(6).setMaxWidth(0);
        this.exhibitionTable.getColumnModel().getColumn(6).setMinWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(6).setMaxWidth(0);
        this.exhibitionTable.getTableHeader().getColumnModel().getColumn(6).setMinWidth(0);
        this.filterTable(J18N.tr("Description", new Object[0]), J18N.tr("Price 1", new Object[0]), J18N.tr("Price 2", new Object[0]));
    }

    private void mudaTabelaPadraoGB600() {
        dm = (DefaultTableModel)this.exhibitionTable.getModel();
        this.cmbMediaType.setSelectedItem((Object)Exhibition.MediaType.SERVER_IMAGE);
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.PREIMAGE);
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.NONE);
        this.lblBgColor.setVisible(false);
        this.buttonBgColor.setVisible(false);
        this.lblPreImage.setVisible(false);
        this.txtTerminalImage.setVisible(false);
        this.btnPreview.setVisible(false);
        this.txtServerImage.setVisible(false);
        this.btnBrowse.setVisible(false);
        this.lblMedia.setVisible(false);
    }

    private void mudaTabelaPadraoGB601() {
        dm = (DefaultTableModel)this.exhibitionTable.getModel();
        this.cmbMediaType.setSelectedItem((Object)Exhibition.MediaType.TERMINAL_IMAGE);
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.PREIMAGE);
        this.cmbMediaType.removeItem((Object)Exhibition.MediaType.NONE);
        this.lblPreImage.setVisible(false);
        this.txtTerminalImage.setVisible(false);
        this.btnPreview.setVisible(false);
        this.lblMedia.setVisible(false);
        this.txtServerImage.setVisible(false);
        this.btnBrowse.setVisible(false);
        this.buttonBgColor.setVisible(false);
        this.lblBgColor.setVisible(false);
        this.exhibitionTable.setVisible(false);
    }

    public boolean isGuiValid() {
        Exhibition.MediaType mediaType = (Exhibition.MediaType)((Object)this.cmbMediaType.getSelectedItem());
        if (mediaType == null) {
            return false;
        }
        switch (mediaType) {
            case SERVER_IMAGE: {
                boolean valid = !this.txtServerImage.getText().isEmpty();
                this.txtServerImage.setValid(valid);
                return valid;
            }
            case TERMINAL_IMAGE: {
                boolean valid = !this.txtTerminalImage.getText().isEmpty();
                this.txtTerminalImage.setValid(valid);
                return valid;
            }
        }
        return true;
    }

    public boolean isGuiGB600Valid() {
        Exhibition.MediaType mediaType = (Exhibition.MediaType)((Object)this.cmbMediaType.getSelectedItem());
        if (mediaType == null) {
            return false;
        }
        switch (mediaType) {
            case SERVER_IMAGE: {
                boolean valid = true;
                this.txtServerImage.setValid(valid);
                return valid;
            }
            case TERMINAL_IMAGE: {
                boolean valid = true;
                this.txtTerminalImage.setValid(valid);
                return valid;
            }
        }
        return true;
    }

    public boolean isGui501Valid() {
        Exhibition.MediaType mediaType = (Exhibition.MediaType)((Object)this.cmbMediaType.getSelectedItem());
        if (mediaType == null) {
            return false;
        }
        switch (mediaType) {
            case SERVER_IMAGE: {
                boolean valid = true;
                this.txtServerImage.setValid(valid);
                return valid;
            }
            case TERMINAL_IMAGE: {
                boolean valid = true;
                this.txtTerminalImage.setValid(valid);
                return valid;
            }
        }
        return true;
    }

    public String getTempoExibicao() {
        if (this.terminalType == TerminalType.TC_406) {
            return String.valueOf(5);
        }
        if (this.terminalType == TerminalType.TC_506_S) {
            return String.valueOf(5);
        }
        if (this.terminalType == TerminalType.TC_506_E) {
            return String.valueOf(5);
        }
        if (this.terminalType == TerminalType.TC_406_E) {
            return String.valueOf(5);
        }
        return this.txtTerminalImage.getText();
    }

    public boolean tryParseToInt(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean getEnvioDeMidia() {
        Exhibition.MediaType mediaType = (Exhibition.MediaType)((Object)this.cmbMediaType.getSelectedItem());
        switch (mediaType) {
            case SERVER_IMAGE: {
                return true;
            }
        }
        return false;
    }

    public String getCaminhoImagem() {
        return this.txtTerminalImage.getText();
    }

    private void filterTable(String filter, String filter2, String filter3, String filter4, String filter5, String filter6) {
        TableRowSorter<DefaultTableModel> tr = new TableRowSorter<DefaultTableModel>(dm);
        this.exhibitionTable.setRowSorter(tr);
        ArrayList filters = new ArrayList(2);
        filters.add(RowFilter.regexFilter(filter, new int[0]));
        filters.add(RowFilter.regexFilter(filter2, new int[0]));
        filters.add(RowFilter.regexFilter(filter3, new int[0]));
        filters.add(RowFilter.regexFilter(filter4, new int[0]));
        filters.add(RowFilter.regexFilter(filter5, new int[0]));
        filters.add(RowFilter.regexFilter(filter6, new int[0]));
        RowFilter serviceFilter = RowFilter.orFilter(filters);
        tr.setRowFilter(serviceFilter);
    }

    private void filterTable(String filter, String filter2, String filter3) {
        TableRowSorter<DefaultTableModel> tr = new TableRowSorter<DefaultTableModel>(dm);
        this.exhibitionTable.setRowSorter(tr);
        ArrayList filters = new ArrayList(2);
        filters.add(RowFilter.regexFilter(filter, new int[0]));
        filters.add(RowFilter.regexFilter(filter2, new int[0]));
        filters.add(RowFilter.regexFilter(filter3, new int[0]));
        RowFilter serviceFilter = RowFilter.orFilter(filters);
        tr.setRowFilter(serviceFilter);
    }

    private void filterTable(String filter, String filter2, String filter3, String filter4, String filter5) {
        TableRowSorter<DefaultTableModel> tr = new TableRowSorter<DefaultTableModel>(dm);
        this.exhibitionTable.setRowSorter(tr);
        ArrayList filters = new ArrayList(2);
        filters.add(RowFilter.regexFilter(filter, new int[0]));
        filters.add(RowFilter.regexFilter(filter2, new int[0]));
        filters.add(RowFilter.regexFilter(filter3, new int[0]));
        filters.add(RowFilter.regexFilter(filter4, new int[0]));
        filters.add(RowFilter.regexFilter(filter5, new int[0]));
        RowFilter serviceFilter = RowFilter.orFilter(filters);
        tr.setRowFilter(serviceFilter);
    }

    protected void onGuiChange() {
    }

    public String getBarcodeFromTxt() throws IOException {
        BufferedReader bf = new BufferedReader(new FileReader(this.baseDir + "/\\codeBar.txt"));
        String barcode = bf.readLine();
        bf.close();
        return barcode;
    }

    public class GuiData {
        public Exhibition exhibition;
        public ExhibitionParam notFoundExhibitionParam;

        private GuiData() {
            String mediaPath;
            this.exhibition = ExhibitionPanel.this.exhibitionTable.getExhibition();
            this.exhibition.setBgColor(NamedColor.fromName(ExhibitionPanel.this.buttonBgColor.getText()));
            this.exhibition.setMediaType((Exhibition.MediaType)((Object)ExhibitionPanel.this.cmbMediaType.getSelectedItem()));
            switch (this.exhibition.getMediaType()) {
                case SERVER_IMAGE: {
                    mediaPath = ExhibitionPanel.this.txtServerImage.getText();
                    break;
                }
                case TERMINAL_IMAGE: {
                    mediaPath = ExhibitionPanel.this.txtTerminalImage.getText();
                    break;
                }
                default: {
                    mediaPath = "";
                }
            }
            this.exhibition.setMediaPath(mediaPath);
            this.notFoundExhibitionParam = ExhibitionPanel.this.exhibitionTable.getNotFoundExhibitionParam();
        }
    }

    public static class ExhibitionTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        private static final NumberSpinnerEditor DEFAULT_NUMBER_SPINNER_EDITOR = new NumberSpinnerEditor(-1, -1, Integer.MAX_VALUE, 1);
        private static final DefaultCellEditor DEFAULT_FONT_EDITOR;
        private final ExhibitionTableModel model = new ExhibitionTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEdit() {
                this.onEdit();
            }
        };
        private final NumberSpinnerEditor fontSizeEditor = new NumberSpinnerEditor(1, 1, 72, 1);
        private final ButtonRenderer.ButtonColorEditor colorEditor = new ButtonRenderer.ButtonColorEditor(new JCheckBox());
        private TerminalType terminalType;
        private NumberSpinnerEditor xEditor = DEFAULT_NUMBER_SPINNER_EDITOR;
        private NumberSpinnerEditor yEditor = DEFAULT_NUMBER_SPINNER_EDITOR;

        public ExhibitionTable() {
            this.setModel(this.model);
            this.putClientProperty("terminateEditOnFocusLost", true);
            this.getTableHeader().setReorderingAllowed(false);
            this.setAutoCreateRowSorter(false);
            this.setPreferredScrollableViewportSize(this.getPreferredSize());
            this.setFillsViewportHeight(true);
            this.setSelectionMode(0);
        }

        public Exhibition getExhibition() {
            return this.model.getExhibition();
        }

        public ExhibitionParam getNotFoundExhibitionParam() {
            return this.model.getNotFoundExhibitionParam();
        }

        public TerminalType getTerminalType() {
            return this.terminalType;
        }

        public void load(TerminalType terminalType, Exhibition exhibition, ExhibitionParam notFoundExhibitionParam) {
            this.model.load(exhibition, notFoundExhibitionParam);
            if (!Objects.equals((Object)this.terminalType, (Object)terminalType)) {
                if (terminalType == null) {
                    this.xEditor = DEFAULT_NUMBER_SPINNER_EDITOR;
                    this.yEditor = DEFAULT_NUMBER_SPINNER_EDITOR;
                } else {
                    this.xEditor = new NumberSpinnerEditor(-1, -1, terminalType.getDisplayWidth(), 1);
                    this.yEditor = new NumberSpinnerEditor(-1, -1, terminalType.getDisplayHeight(), 1);
                }
                this.terminalType = terminalType;
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 3 && this.terminalType == TerminalType.TC_508) {
                return false;
            }
            return super.isCellEditable(row, column);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            switch (column) {
                case 1: {
                    return this.xEditor;
                }
                case 2: {
                    return this.yEditor;
                }
                case 5: 
                case 6: {
                    return this.colorEditor;
                }
                case 4: {
                    return this.fontSizeEditor;
                }
                case 3: {
                    if (this.getTerminalType() != TerminalType.TC_508) {
                        if (this.getTerminalType() == TerminalType.TC_504) {
                            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                            String[] fonts = ge.getAvailableFontFamilyNames();
                            DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>(fonts);
                            JComboBox<String> comboBox = new JComboBox<String>();
                            comboBox.setModel(comboBoxModel);
                            return new DefaultCellEditor(comboBox);
                        }
                        return DEFAULT_FONT_EDITOR;
                    }
                    return super.getCellEditor(row, column);
                }
            }
            return super.getCellEditor(row, column);
        }

        protected void onEdit() {
        }

        static {
            DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>(new String[]{"c0583bt_.pfb", "c0611bt_.pfb", "c0632bt_.pfb", "c0633bt_.pfb", "c0648bt_.pfb", "c0649bt_.pfb", "courbi.pfa", "courb.pfa", "couri.pfa", "cour.pfa", "cursor.pfa", "DejaVuSans-BoldOblique.ttf", "DejaVuSans-Bold.ttf", "DejaVuSansMono-BoldOblique.ttf", "DejaVuSansMono-Bold.ttf", "DejaVuSansMono-Oblique.ttf", "DejaVuSansMono.ttf", "DejaVuSans-Oblique.ttf", "DejaVuSans.ttf", "DejaVuSerif-BoldOblique.ttf", "DejaVuSerif-Bold.ttf", "DejaVuSerif-Oblique.ttf", "DejaVuSerif.ttf", "fixed_120_50.qpf", "fixed_70_50.qpf", "helvetica_100_50i.qpf", "helvetica_100_50.qpf", "helvetica_100_75i.qpf", "helvetica_100_75.qpf", "helvetica_120_50i.qpf", "helvetica_120_50.qpf", "helvetica_120_75i.qpf", "helvetica_120_75.qpf", "helvetica_140_50i.qpf", "helvetica_140_50.qpf", "helvetica_140_75i.qpf", "helvetica_140_75.qpf", "helvetica_180_50i.qpf", "helvetica_180_50.qpf", "helvetica_180_75i.qpf", "helvetica_180_75.qpf", "helvetica_240_50i.qpf", "helvetica_240_50.qpf", "helvetica_240_75i.qpf", "helvetica_240_75.qpf", "helvetica_80_50i.qpf", "helvetica_80_50.qpf", "helvetica_80_75i.qpf", "helvetica_80_75.qpf", "japanese_230_50.qpf", "l047013t.pfa", "l047016t.pfa", "l047033t.pfa", "l047036t.pfa", "l048013t.pfa", "l048016t.pfa", "l048033t.pfa", "l048036t.pfa", "l049013t.pfa", "l049016t.pfa", "l049033t.pfa", "l049036t.pfa", "micro_40_50.qpf", "SWZ721MI.TTF", "swz721m.ttf", "unifont_160_50.qpf", "UTBI____.pfa", "UTB_____.pfa", "UTI_____.pfa", "UTRG____.pfa", "VeraBd.ttf", "VeraBI.ttf", "VeraIt.ttf", "VeraMoBd.ttf", "VeraMoBI.ttf", "VeraMoIt.ttf", "VeraMono.ttf", "VeraSeBd.ttf", "VeraSe.ttf", "Vera.ttf"});
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.setModel(comboBoxModel);
            DEFAULT_FONT_EDITOR = new DefaultCellEditor(comboBox);
        }

        public static class ExhibitionTableModel
        extends DefaultTableModel {
            private static final long serialVersionUID = 1L;
            public Exhibition exhibition = new Exhibition();
            public static final int COL_PROPERTY = 0;
            public static final int COL_X = 1;
            public static final int COL_Y = 2;
            public static final int COL_FONT = 3;
            public static final int COL_FONT_SIZE = 4;
            public static final int COL_FOREGROUND = 5;
            public static final int COL_BACKGROUND = 6;
            public static final int ROW_DESCRIPTION = 0;
            public static final int ROW_BARCODE = 1;
            public static final int ROW_LABEL1 = 2;
            public static final int ROW_PRICE1 = 3;
            public static final int ROW_LABEL2 = 4;
            public static final int ROW_PRICE2 = 5;
            public static final int ROW_NOT_FOUND = 6;
            private final Map<Integer, Boolean> editableMap = new LinkedHashMap<Integer, Boolean>();
            private ExhibitionParam notFoundExhibParam = new ExhibitionParam();

            public ExhibitionTableModel() {
                this.editableMap.put(0, false);
                this.editableMap.put(1, true);
                this.editableMap.put(2, true);
                this.editableMap.put(3, true);
                this.editableMap.put(4, true);
                this.editableMap.put(5, true);
                this.editableMap.put(6, true);
            }

            private boolean isColEditable(int colIndex) {
                return this.editableMap.get(colIndex);
            }

            public void setColEditable(int colIndex, boolean editable) {
                if (colIndex < 0 || colIndex >= this.getColumnCount()) {
                    throw new IndexOutOfBoundsException();
                }
                this.editableMap.put(colIndex, editable);
                this.fireTableStructureChanged();
            }

            public void load(Exhibition exhibition, ExhibitionParam notFoundExhibParam) {
                this.exhibition = exhibition.clone();
                this.notFoundExhibParam = notFoundExhibParam != null ? notFoundExhibParam.clone() : null;
                this.fireTableDataChanged();
            }

            @Override
            public int getRowCount() {
                return this.notFoundExhibParam == null ? 6 : 7;
            }

            @Override
            public int getColumnCount() {
                return 7;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return J18N.tr("Property", new Object[0]);
                    }
                    case 1: {
                        return "X";
                    }
                    case 2: {
                        return "Y";
                    }
                    case 3: {
                        return J18N.tr("Font", new Object[0]);
                    }
                    case 4: {
                        return J18N.tr("Font size", new Object[0]);
                    }
                    case 5: {
                        return J18N.tr("Foreground", new Object[0]);
                    }
                    case 6: {
                        return J18N.tr("Background", new Object[0]);
                    }
                }
                throw new IndexOutOfBoundsException(String.format("col: %d", column));
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return this.isColEditable(column);
            }

            private ExhibitionParam getExhibitionParam(int row) {
                switch (row) {
                    case 0: {
                        return this.exhibition.getDescription();
                    }
                    case 1: {
                        return this.exhibition.getBarcode();
                    }
                    case 2: {
                        return this.exhibition.getLabel1();
                    }
                    case 4: {
                        return this.exhibition.getLabel2();
                    }
                    case 3: {
                        return this.exhibition.getPrice1();
                    }
                    case 5: {
                        return this.exhibition.getPrice2();
                    }
                    case 6: {
                        return this.notFoundExhibParam;
                    }
                }
                throw new IndexOutOfBoundsException(String.format("row: %d", row));
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (column == 0) {
                    switch (row) {
                        case 0: {
                            return J18N.tr("Description", new Object[0]);
                        }
                        case 1: {
                            return J18N.tr("Barcode", new Object[0]);
                        }
                        case 2: {
                            return J18N.tr("Label 1", new Object[0]);
                        }
                        case 4: {
                            return J18N.tr("Label 2", new Object[0]);
                        }
                        case 3: {
                            return J18N.tr("Price 1", new Object[0]);
                        }
                        case 5: {
                            return J18N.tr("Price 2", new Object[0]);
                        }
                        case 6: {
                            return J18N.tr("NOT FOUND", new Object[0]);
                        }
                    }
                    throw new IndexOutOfBoundsException(String.format("row: %d, col: %d", row, column));
                }
                ExhibitionParam exhibitionParam = this.getExhibitionParam(row);
                if (exhibitionParam == null) {
                    return null;
                }
                switch (column) {
                    case 1: {
                        return exhibitionParam.getX();
                    }
                    case 2: {
                        return exhibitionParam.getY();
                    }
                    case 3: {
                        return exhibitionParam.getFont();
                    }
                    case 4: {
                        return exhibitionParam.getFontSize();
                    }
                    case 5: {
                        return exhibitionParam.getFgColor();
                    }
                    case 6: {
                        return exhibitionParam.getBgColor();
                    }
                }
                throw new IndexOutOfBoundsException(String.format("row: %d, col: %d", row, column));
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                ExhibitionParam exhibitionParam = this.getExhibitionParam(row);
                switch (column) {
                    case 1: {
                        exhibitionParam.setX(((Number)aValue).shortValue());
                        break;
                    }
                    case 2: {
                        exhibitionParam.setY(((Number)aValue).shortValue());
                        break;
                    }
                    case 3: {
                        exhibitionParam.setFont((String)aValue);
                        break;
                    }
                    case 4: {
                        exhibitionParam.setFontSize(((Number)aValue).shortValue());
                        break;
                    }
                    case 5: {
                        exhibitionParam.setFgColor((NamedColor)((Object)aValue));
                        break;
                    }
                    case 6: {
                        exhibitionParam.setBgColor((NamedColor)((Object)aValue));
                        break;
                    }
                    default: {
                        super.setValueAt(aValue, row, column);
                    }
                }
                this.onEdit();
            }

            public void setValueAtNull(int row, int column) {
                ExhibitionParam exhibitionParam = this.getExhibitionParam(row);
                switch (column) {
                    case 1: {
                        exhibitionParam.setX(((Number)0).shortValue());
                        break;
                    }
                    case 2: {
                        exhibitionParam.setY(((Number)0).shortValue());
                        break;
                    }
                    case 3: {
                        exhibitionParam.setFont("");
                        break;
                    }
                    case 4: {
                        exhibitionParam.setFontSize(((Number)0).shortValue());
                        break;
                    }
                    case 5: {
                        exhibitionParam.setFgColor(NamedColor.BLUE);
                        break;
                    }
                    case 6: {
                        exhibitionParam.setBgColor(NamedColor.BLUE);
                        break;
                    }
                    default: {
                        super.setValueAt(null, row, column);
                    }
                }
                this.onEdit();
            }

            public Exhibition getExhibition() {
                return this.exhibition;
            }

            public ExhibitionParam getNotFoundExhibitionParam() {
                return this.notFoundExhibParam;
            }

            protected void onEdit() {
            }
        }
    }
}

