/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.gui.util.GuiDialog;
import br.com.gertec.tc.server.util.PDFDocumentDrawer;
import br.com.gertec.tc.server.util.Resources;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class HelpDialog
extends GuiDialog {
    private static final long serialVersionUID = 7330816352881766916L;
    private final JPanel contentPanel = new JPanel();
    private final JLabel label;
    private final ImageIcon image;
    private final JButton okButton;
    private final JPanel pdfViewer;
    private final JScrollPane scrollPane;

    public HelpDialog() {
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.image = Resources.getImageIcon("/res/app-icon.png");
        GridBagLayout gblContentPanel = new GridBagLayout();
        gblContentPanel.columnWidths = new int[]{164, 0, 0};
        gblContentPanel.rowHeights = new int[]{183, 0, 0};
        gblContentPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gblContentPanel.rowWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gblContentPanel);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.label = new JLabel("", this.image, 0);
        this.label.setBorder(null);
        this.label.setHorizontalTextPosition(0);
        this.label.setVerticalTextPosition(3);
        GridBagConstraints gbcLabel = new GridBagConstraints();
        gbcLabel.fill = 1;
        gbcLabel.gridx = 0;
        gbcLabel.gridy = 0;
        this.contentPanel.add((Component)this.label, gbcLabel);
        this.scrollPane = new JScrollPane();
        GridBagConstraints gbcScrollPane = new GridBagConstraints();
        gbcScrollPane.insets = new Insets(0, 5, 0, 0);
        gbcScrollPane.fill = 1;
        gbcScrollPane.gridx = 1;
        gbcScrollPane.gridy = 0;
        this.contentPanel.add((Component)this.scrollPane, gbcScrollPane);
        this.pdfViewer = new JPanel();
        this.pdfViewer.setLayout(new BoxLayout(this.pdfViewer, 3));
        this.scrollPane.setViewportView(this.pdfViewer);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.okButton = new JButton();
        this.okButton.setHorizontalAlignment(4);
        ActionListener closeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpDialog.this.dispose();
            }
        };
        this.okButton.addActionListener(closeListener);
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.getRootPane().registerKeyboardAction(closeListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.createProgress();
    }

    private void retranslateUi() {
        this.setTitle(Application.APP_NAME + J18N.tr("Manual", new Object[0]));
        PDFDocumentDrawer pdfDocument = new PDFDocumentDrawer("/res/Manual_Usuario_TCServer_R03.23.pdf");
        List<Object> pages = new ArrayList();
        try {
            pages = pdfDocument.open();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (BufferedImage bufferedImage : pages) {
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            this.pdfViewer.add(new JLabel(imageIcon));
        }
        this.scrollPane.setPreferredSize(new Dimension(((BufferedImage)pages.get(0)).getWidth(), ((BufferedImage)pages.get(0)).getHeight() - 200));
        this.scrollPane.add(this.pdfViewer);
        this.scrollPane.setViewportView(this.pdfViewer);
        this.okButton.setText(J18N.tr("OK", new Object[0]));
        this.setLocation(this.contentPanel.getParent().getParent().getWidth() / 2, 0);
        pdfDocument.close();
        pdfDocument = null;
    }

    private void createProgress() {
        final JDialog dlg = new JDialog();
        final JProgressBar dpb = new JProgressBar();
        dlg.setTitle(J18N.tr("Loading manual", new Object[0]));
        dlg.setModal(true);
        dlg.setLocationRelativeTo(this.contentPanel.getParent().getParent());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Application.EVENT_LOOP.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dpb.setIndeterminate(true);
                            dlg.add("Center", dpb);
                            dlg.setDefaultCloseOperation(0);
                            dlg.setSize(300, 50);
                            dlg.setVisible(true);
                        }
                    });
                    HelpDialog.this.retranslateUi();
                    Application.EVENT_LOOP.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HelpDialog.this.pack();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    dlg.setVisible(false);
                }
            }
        };
        Thread fetchThread = new Thread(runnable);
        fetchThread.setName("manual-fetch-thread");
        fetchThread.start();
    }
}

