/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.gui.AboutDialog;
import br.com.gertec.tc.server.gui.ApplicationLogDialog;
import br.com.gertec.tc.server.gui.AuthenticationAdminDialog;
import br.com.gertec.tc.server.gui.AuthenticationDialog;
import br.com.gertec.tc.server.gui.ChangePasswordDialog;
import br.com.gertec.tc.server.gui.ProductListPanel;
import br.com.gertec.tc.server.gui.ServerPanel;
import br.com.gertec.tc.server.gui.TcGroupManagerDialog;
import br.com.gertec.tc.server.gui.TcTree;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.Sc501Server;
import br.com.gertec.tc.server.protocol.sc501.listener.Sc501ServerListener;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.Sc504Server;
import br.com.gertec.tc.server.protocol.sc504.listener.Sc504ServerListener;
import br.com.gertec.tc.server.util.DataBlock;
import br.com.gertec.tc.server.util.Resources;
import br.org.reconcavo.event.comm.socket.SocketConnection;
import br.org.reconcavo.event.comm.socket.TcpServer;
import br.org.reconcavo.j18n.J18N;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class MainApplicationWindow
extends JFrame
implements J18N.LocaleChangeListener {
    private static final long serialVersionUID = 1L;
    private static final int INDEX_TAB_SERVER = 0;
    private static final int INDEX_TAB_PRODUCTS = 1;
    private final TrayIcon trayIcon;
    private final SystemTray tray;
    private final JMenu menuSettings;
    private final JMenu mntmLanguage;
    private final JRadioButtonMenuItem rdbtnmntmEnglish;
    private final JRadioButtonMenuItem rdbtnmntmSpanish;
    private final JRadioButtonMenuItem rdbtnmntmPortuguese;
    private final JMenu mntmSecurity;
    private final JMenuItem mntmChangePassword;
    private final JCheckBoxMenuItem chckbxmntmLockOnMinimize;
    private final JCheckBoxMenuItem chckbxmntmMinimizeToTray;
    private final JCheckBoxMenuItem chckbxmntmAutoInit501;
    private final JCheckBoxMenuItem chckbxmntmAutoInit504;
    private final JCheckBoxMenuItem chckbxmntmAutoInitHttp;
    private final JMenuItem mntmTerminalGrouping;
    private final JMenu menuReports;
    private final JMenuItem mntmApplicationLog;
    private final JMenu menuUpdate;
    private final JMenuItem mntmUpdateDevices;
    private final JMenu menuHelp;
    private final JMenuItem mntmAbout;
    private final JMenuItem mntmHelp;
    private final JPanel clientPanel;
    private final JTabbedPane tabbedPane;
    private final ServerPanel serverPanel;
    private final ProductListPanel productListPanel;
    private final JLabel lblConnectedClients;
    private final TcTree tcTree;
    private final JScrollPane scrollPane;
    private final JPanel panel;
    private final JCheckBox chkShowName;
    private final JCheckBox chkShowType;
    private final JLabel lblTotal;
    private final JLabel lblMsgWarning;
    private boolean authDialogVisible = false;
    private boolean launched = false;
    private boolean inTray = false;
    private boolean authorized = false;
    private final String msgWarning = "Audio evaluation period expired.";

    public MainApplicationWindow() {
        J18N.registerListener(this);
        this.setState(6);
        this.setDefaultCloseOperation(3);
        JMenuBar menuBar = new JMenuBar();
        this.menuSettings = new JMenu();
        menuBar.add(this.menuSettings);
        this.mntmLanguage = new JMenu();
        this.menuSettings.add(this.mntmLanguage);
        ButtonGroup bGroup = new ButtonGroup();
        this.rdbtnmntmEnglish = new JRadioButtonMenuItem();
        this.rdbtnmntmEnglish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                J18N.setCurrentLocale("en");
            }
        });
        bGroup.add(this.rdbtnmntmEnglish);
        this.mntmLanguage.add(this.rdbtnmntmEnglish);
        this.rdbtnmntmSpanish = new JRadioButtonMenuItem();
        this.rdbtnmntmSpanish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                J18N.setCurrentLocale("es");
            }
        });
        bGroup.add(this.rdbtnmntmSpanish);
        this.mntmLanguage.add(this.rdbtnmntmSpanish);
        this.rdbtnmntmPortuguese = new JRadioButtonMenuItem();
        this.rdbtnmntmPortuguese.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                J18N.setCurrentLocale("pt-BR");
            }
        });
        bGroup.add(this.rdbtnmntmPortuguese);
        this.mntmLanguage.add(this.rdbtnmntmPortuguese);
        this.rdbtnmntmEnglish.setSelected(J18N.getCurrentLocale().toLanguageTag().equals("en"));
        this.rdbtnmntmSpanish.setSelected(J18N.getCurrentLocale().toLanguageTag().equals("es"));
        this.rdbtnmntmPortuguese.setSelected(J18N.getCurrentLocale().toLanguageTag().equals("pt-BR"));
        this.mntmSecurity = new JMenu();
        this.menuSettings.add(this.mntmSecurity);
        this.mntmChangePassword = new JMenuItem();
        this.mntmChangePassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangePasswordDialog changePassswordDialog = new ChangePasswordDialog();
                changePassswordDialog.setTitle(J18N.tr("Change password", new Object[0]));
                changePassswordDialog.setLocationRelativeTo(MainApplicationWindow.this);
                changePassswordDialog.setVisible(true);
            }
        });
        this.mntmSecurity.add(this.mntmChangePassword);
        this.chckbxmntmLockOnMinimize = new JCheckBoxMenuItem();
        this.chckbxmntmLockOnMinimize.setSelected(Application.SETTINGS.getBoolean("LOCK_ON_MINIMIZE"));
        this.chckbxmntmLockOnMinimize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean lockOnMinimize = e.getStateChange() == 1;
                Application.SETTINGS.setProperty("LOCK_ON_MINIMIZE", lockOnMinimize);
            }
        });
        this.mntmSecurity.add(this.chckbxmntmLockOnMinimize);
        this.chckbxmntmMinimizeToTray = new JCheckBoxMenuItem();
        this.chckbxmntmMinimizeToTray.setSelected(Application.SETTINGS.getBoolean("MINIMIZE_TO_TRAY"));
        this.chckbxmntmMinimizeToTray.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean minimizeToTray = e.getStateChange() == 1;
                Application.SETTINGS.setProperty("MINIMIZE_TO_TRAY", minimizeToTray);
            }
        });
        this.menuSettings.add(this.chckbxmntmMinimizeToTray);
        this.menuSettings.addSeparator();
        this.chckbxmntmAutoInit501 = new JCheckBoxMenuItem();
        this.chckbxmntmAutoInit501.setSelected(Application.SETTINGS.getBoolean("AUTO_INIT_501"));
        this.chckbxmntmAutoInit501.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Application.SETTINGS.setProperty("AUTO_INIT_501", e.getStateChange() == 1);
            }
        });
        this.menuSettings.add(this.chckbxmntmAutoInit501);
        this.chckbxmntmAutoInit504 = new JCheckBoxMenuItem();
        this.chckbxmntmAutoInit504.setSelected(Application.SETTINGS.getBoolean("AUTO_INIT_504"));
        this.chckbxmntmAutoInit504.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Application.SETTINGS.setProperty("AUTO_INIT_504", e.getStateChange() == 1);
            }
        });
        this.menuSettings.add(this.chckbxmntmAutoInit504);
        this.chckbxmntmAutoInitHttp = new JCheckBoxMenuItem();
        this.chckbxmntmAutoInitHttp.setSelected(Application.SETTINGS.getBoolean("AUTO_INIT_HTTP"));
        this.chckbxmntmAutoInitHttp.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Application.SETTINGS.setProperty("AUTO_INIT_HTTP", e.getStateChange() == 1);
            }
        });
        this.menuSettings.add(this.chckbxmntmAutoInitHttp);
        this.menuSettings.addSeparator();
        this.mntmTerminalGrouping = new JMenuItem();
        this.mntmTerminalGrouping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TcGroupManagerDialog dialog = new TcGroupManagerDialog(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void onClose(Object result) {
                        if (result != null) {
                            MainApplicationWindow.this.tcTree.reload();
                        }
                    }
                };
                dialog.setLocationRelativeTo(MainApplicationWindow.this);
                dialog.setVisible(true);
            }
        });
        this.menuSettings.add(this.mntmTerminalGrouping);
        this.menuReports = new JMenu();
        menuBar.add(this.menuReports);
        this.mntmApplicationLog = new JMenuItem();
        this.mntmApplicationLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationLogDialog dialog = new ApplicationLogDialog(Application.getDbLogStream());
                dialog.setLocationRelativeTo(MainApplicationWindow.this);
                dialog.setVisible(true);
            }
        });
        this.menuReports.add(this.mntmApplicationLog);
        this.menuUpdate = new JMenu();
        menuBar.add(this.menuUpdate);
        this.mntmUpdateDevices = new JMenuItem();
        this.mntmUpdateDevices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthenticationAdminDialog adminAccess = new AuthenticationAdminDialog();
                adminAccess.setVisible(true);
                adminAccess.requestFocus();
            }
        });
        this.menuUpdate.add(this.mntmUpdateDevices);
        this.menuHelp = new JMenu();
        menuBar.add(this.menuHelp);
        this.mntmAbout = new JMenuItem();
        this.mntmAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog cr = new AboutDialog();
                cr.setDefaultCloseOperation(2);
                cr.setLocationRelativeTo(null);
                cr.setVisible(true);
            }
        });
        this.mntmHelp = new JMenuItem();
        this.mntmHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop desktop = Desktop.getDesktop();
                    File file = new File(Application.APP_DIR.getAbsolutePath() + File.separator + "Manual_Usuario_TCServer_R03.23.pdf");
                    desktop.open(file);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.menuHelp.add(this.mntmAbout);
        this.menuHelp.add(this.mntmHelp);
        this.setJMenuBar(menuBar);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setMinimumSize(new Dimension(320, 100));
        this.clientPanel = new JPanel();
        this.clientPanel.setMinimumSize(new Dimension(200, 100));
        this.serverPanel = new ServerPanel();
        this.serverPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tabbedPane.addTab(J18N.tr("Server", new Object[0]), null, this.serverPanel, null);
        this.productListPanel = new ProductListPanel();
        this.productListPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tabbedPane.addTab(J18N.tr("Products", new Object[0]), null, this.productListPanel, null);
        this.tabbedPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MainApplicationWindow.this.tabbedPane.getSelectedIndex() == 1) {
                    try {
                        MainApplicationWindow.this.productListPanel.makeRefresh();
                        Thread.sleep(1000L);
                        MainApplicationWindow.this.productListPanel.makeRefresh();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JSplitPane splitPane = new JSplitPane(1, this.clientPanel, this.tabbedPane);
        GridBagLayout gblClientPanel = new GridBagLayout();
        gblClientPanel.columnWidths = new int[]{127, 0};
        gblClientPanel.rowHeights = new int[]{15, 0, 0, 0};
        gblClientPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gblClientPanel.rowWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.clientPanel.setLayout(gblClientPanel);
        this.lblConnectedClients = new JLabel();
        this.lblConnectedClients.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbcLblConnectedClients = new GridBagConstraints();
        gbcLblConnectedClients.fill = 2;
        gbcLblConnectedClients.gridx = 0;
        gbcLblConnectedClients.gridy = 0;
        this.clientPanel.add((Component)this.lblConnectedClients, gbcLblConnectedClients);
        this.scrollPane = new JScrollPane();
        GridBagConstraints gbcScrollPane = new GridBagConstraints();
        gbcScrollPane.fill = 1;
        gbcScrollPane.gridx = 0;
        gbcScrollPane.gridy = 1;
        this.clientPanel.add((Component)this.scrollPane, gbcScrollPane);
        this.tcTree = new TcTree();
        this.scrollPane.setViewportView(this.tcTree);
        this.panel = new JPanel();
        this.panel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbcPanel = new GridBagConstraints();
        gbcPanel.fill = 1;
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 2;
        this.clientPanel.add((Component)this.panel, gbcPanel);
        this.lblMsgWarning = new JLabel();
        this.lblMsgWarning.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbcLblMsg = new GridBagConstraints();
        gbcLblMsg.fill = 2;
        gbcLblMsg.gridx = 0;
        gbcLblMsg.gridy = 3;
        this.clientPanel.add((Component)this.lblMsgWarning, gbcLblMsg);
        this.chkShowType = new JCheckBox();
        this.chkShowType.setHorizontalAlignment(0);
        this.chkShowType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MainApplicationWindow.this.tcTree.setTypeVisible(MainApplicationWindow.this.chkShowType.isSelected());
                Application.SETTINGS.setProperty("SHOW_TERMINAL_TYPE", MainApplicationWindow.this.chkShowType.isSelected());
            }
        });
        this.chkShowType.setSelected(Application.SETTINGS.getBoolean("SHOW_TERMINAL_TYPE"));
        this.chkShowName = new JCheckBox();
        this.chkShowName.setHorizontalAlignment(0);
        this.chkShowName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MainApplicationWindow.this.tcTree.setNameVisible(MainApplicationWindow.this.chkShowName.isSelected());
                Application.SETTINGS.setProperty("SHOW_TERMINAL_NAME", MainApplicationWindow.this.chkShowName.isSelected());
            }
        });
        this.chkShowName.setSelected(Application.SETTINGS.getBoolean("SHOW_TERMINAL_NAME"));
        this.panel.setLayout(new GridLayout(1, 2, 0, 0));
        this.lblTotal = new JLabel("Total : " + Application.SERVER_MANAGER.getClients().size());
        this.panel.add(this.lblTotal);
        this.panel.add(this.chkShowName);
        this.panel.add(this.chkShowType);
        this.registerListeners();
        this.getContentPane().add((Component)splitPane, "Center");
        if (!SystemTray.isSupported()) {
            this.tray = null;
            this.trayIcon = null;
        } else {
            this.tray = SystemTray.getSystemTray();
            this.trayIcon = new TrayIcon(Resources.getImage("/res/app-icon.png"), Application.APP_NAME, null);
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && !MainApplicationWindow.this.authDialogVisible) {
                        MainApplicationWindow.this.setTray(false);
                        MainApplicationWindow.this.setExtendedState(0);
                        MainApplicationWindow.this.requestFocus();
                    }
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowIconified(WindowEvent e) {
                    if (MainApplicationWindow.this.chckbxmntmMinimizeToTray.isSelected()) {
                        MainApplicationWindow.this.setTray(true);
                    }
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    if (MainApplicationWindow.this.chckbxmntmMinimizeToTray.isSelected()) {
                        MainApplicationWindow.this.setTray(false);
                    }
                }
            });
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent e) {
                MainApplicationWindow.this.authorized = false;
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                if (MainApplicationWindow.this.chckbxmntmLockOnMinimize.isSelected() && !MainApplicationWindow.this.authorized) {
                    MainApplicationWindow.this.requestUserAuthentication();
                }
            }
        });
        this.retranslateUi();
        this.setMinimumSize(new Dimension(640, 480));
        this.pack();
    }

    private void setTray(boolean set) {
        if (SystemTray.isSupported()) {
            if (set) {
                if (!this.inTray) {
                    try {
                        this.tray.add(this.trayIcon);
                        this.inTray = true;
                        this.setVisible(false);
                    }
                    catch (AWTException aWTException) {}
                }
            } else if (this.inTray) {
                this.tray.remove(this.trayIcon);
                this.inTray = false;
                this.setVisible(true);
            }
        }
    }

    private void requestUserAuthentication() {
        if (!this.authDialogVisible) {
            this.setExtendedState(1);
            if (this.chckbxmntmMinimizeToTray.isSelected()) {
                this.setTray(true);
            }
            AuthenticationDialog authDialog = new AuthenticationDialog(){
                private static final long serialVersionUID = 1L;

                @Override
                protected void onClose(Object result) {
                    super.onClose(result);
                    MainApplicationWindow.this.authDialogVisible = false;
                    if (result != null) {
                        MainApplicationWindow.this.authorized = true;
                        MainApplicationWindow.this.launched = true;
                        if (MainApplicationWindow.this.chckbxmntmMinimizeToTray.isSelected()) {
                            MainApplicationWindow.this.setTray(false);
                        }
                        MainApplicationWindow.this.setExtendedState(6);
                        MainApplicationWindow.this.requestFocus();
                    } else if (!MainApplicationWindow.this.launched) {
                        MainApplicationWindow.this.dispose();
                        Application.EVENT_LOOP.stop();
                        System.exit(0);
                    }
                }
            };
            this.authDialogVisible = true;
            authDialog.setVisible(true);
            authDialog.requestFocus();
        }
    }

    private void retranslateUi() {
        this.menuSettings.setText(J18N.tr("Settings", new Object[0]));
        this.mntmLanguage.setText(J18N.tr("Language", new Object[0]));
        this.rdbtnmntmEnglish.setText(J18N.tr("English", new Object[0]));
        this.rdbtnmntmSpanish.setText(J18N.tr("Spanish", new Object[0]));
        this.rdbtnmntmPortuguese.setText(J18N.tr("Portuguese", new Object[0]));
        this.mntmSecurity.setText(J18N.tr("Security", new Object[0]));
        this.mntmChangePassword.setText(J18N.tr("Change password", new Object[0]) + "...");
        this.chckbxmntmLockOnMinimize.setText(J18N.tr("Lock on minimize/start", new Object[0]));
        this.chckbxmntmMinimizeToTray.setText(J18N.tr("Minimize to tray", new Object[0]));
        this.chckbxmntmAutoInit501.setText(J18N.tr("Autoinit SC501 server", new Object[0]));
        this.chckbxmntmAutoInit504.setText(J18N.tr("Autoinit SC504 server", new Object[0]));
        this.chckbxmntmAutoInitHttp.setText(J18N.tr("Autoinit HTTP server", new Object[0]));
        this.mntmTerminalGrouping.setText(J18N.tr("Terminal grouping", new Object[0]) + "...");
        this.menuReports.setText(J18N.tr("Reports", new Object[0]));
        this.mntmApplicationLog.setText(J18N.tr("Application log", new Object[0]) + "...");
        this.menuUpdate.setText(J18N.tr("Update", new Object[0]));
        this.mntmUpdateDevices.setText(J18N.tr("Update Devices", new Object[0]));
        this.menuHelp.setText(J18N.tr("Help", new Object[0]));
        this.mntmAbout.setText(J18N.tr("About", new Object[0]) + "...");
        this.mntmHelp.setText(J18N.tr("Manual", new Object[0]));
        this.tabbedPane.setTitleAt(0, J18N.tr("Server", new Object[0]));
        this.tabbedPane.setTitleAt(1, J18N.tr("Products", new Object[0]));
        this.lblConnectedClients.setText(J18N.tr("Connected devices", new Object[0]));
        this.chkShowName.setText(J18N.tr("Show name", new Object[0]));
        this.chkShowType.setText(J18N.tr("Show type", new Object[0]));
        if (!DataBlock.verifyDate()) {
            this.lblMsgWarning.setVisible(true);
            this.lblMsgWarning.setForeground(Color.red);
            this.lblMsgWarning.setText(J18N.tr("Audio evaluation period expired.", new Object[0]));
            this.lblMsgWarning.setHorizontalAlignment(0);
        } else {
            this.lblMsgWarning.setVisible(false);
        }
    }

    @Override
    public void onLocaleChange(Locale newLocale) {
        this.tcTree.retranslateUi();
        this.scrollPane.setViewportView(this.tcTree);
        this.retranslateUi();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.launched && this.chckbxmntmLockOnMinimize.isSelected()) {
            this.requestUserAuthentication();
        }
    }

    public void setTotal(int total) {
        this.lblTotal.setText(J18N.tr("Total", new Object[0]) + " : " + total);
    }

    private void registerListeners() {
        Application.SERVER_MANAGER.register501Listener(new Sc501ServerListener.Sc501ServerAdapter(){

            @Override
            public void onHandshakeComplete(Sc501Server server, Sc501Connection connection) {
                MainApplicationWindow.this.setTotal(Application.SERVER_MANAGER.getClients().size());
            }

            @Override
            public void onClientDrop(TcpServer server, SocketConnection client) {
                MainApplicationWindow.this.setTotal(Application.SERVER_MANAGER.getClients().size());
            }
        });
        Application.SERVER_MANAGER.register504Listener(new Sc504ServerListener.Sc504ServerAdapter(){

            @Override
            public void onHandshakeComplete(Sc504Server server, Sc504Connection connection) {
                MainApplicationWindow.this.setTotal(Application.SERVER_MANAGER.getClients().size());
            }

            @Override
            public void onClientDrop(TcpServer server, SocketConnection client) {
                MainApplicationWindow.this.setTotal(Application.SERVER_MANAGER.getClients().size());
            }
        });
    }
}

