/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.ApplicationSettings;
import br.com.gertec.tc.server.DbMode;
import br.com.gertec.tc.server.dao.AbstractJdbcProductDao;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.dao.TextDbProductDao;
import br.com.gertec.tc.server.gui.ConfigProdTableDefDialog;
import br.com.gertec.tc.server.gui.SwingUtils;
import br.com.gertec.tc.server.gui.util.GuiDialog;
import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.gui.util.PasswordField;
import br.com.gertec.tc.server.gui.util.ProgressBarBuilder;
import br.com.gertec.tc.server.gui.util.TextField;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.util.jdbc.JdbcConnection;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ProductDbDialog
extends GuiDialog {
    private static final long serialVersionUID = 1L;
    private static File lastJarDir = null;
    private static File lastTxtDir = null;
    private final JPanel contentPanel = new GuiPanel();
    private final JPanel managementModePanel;
    private final TitledBorder managementModeBorder;
    private final ButtonGroup btnGroup;
    private final JRadioButton rdbtnInternal;
    private final JRadioButton rdbtnExternalJDBC;
    private final JRadioButton rdbtnExternalFile;
    private final JPanel externalJdbcPanel;
    private final TitledBorder externalJdbcBorder;
    private final TextField txtJar;
    private final JButton btnBrowseJar;
    private final TextField txtDriverClass;
    private final TextField txtUrl;
    private final TextField txtUser;
    private final PasswordField txtPassword;
    private final TextField txtProductTable;
    private final JButton btnAdvanced;
    private final JButton btnTest;
    private final JLabel lbljar;
    private final JLabel lblDriverClass;
    private final JLabel lblUrl;
    private final JLabel lblUser;
    private final JLabel lblPassword;
    private final JLabel lblTableProduct;
    private final Component rigidArea;
    private final JPanel externalTxtPanel;
    private final TitledBorder externalTxtBorder;
    private final JLabel lblFile;
    private final JButton btnBrowseTxtFile;
    private final TextField txtFile;
    private final JLabel lblUpdateInterval;
    private final JSpinner updateIntervalSpinner;
    private final JButton btnOk;
    private final JButton btnCancel;
    private JLabel lblsSeroAceitos;
    private Product.LoadedDataListener loadedDataListener;
    private Product.ProductTableDefinition currentTableDef = Product.ProductTableDefinition.loadFromConfig();
    private Window parentWindow = FocusManager.getCurrentManager().getActiveWindow();
    private Frame parentFrame;
    private JDialog dlg;

    public ProductDbDialog(Product.LoadedDataListener loadedDataListener) {
        this.loadedDataListener = loadedDataListener;
        this.setMinimumSize(new Dimension(475, 165));
        this.setModal(true);
        this.setResizable(false);
        this.btnGroup = new ButtonGroup();
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gblContentPanel = new GridBagLayout();
        gblContentPanel.columnWidths = new int[]{0};
        gblContentPanel.rowHeights = new int[]{0};
        gblContentPanel.columnWeights = new double[]{1.0};
        gblContentPanel.rowWeights = new double[]{1.0, 0.0, 1.0, 0.0};
        this.contentPanel.setLayout(gblContentPanel);
        this.managementModePanel = new GuiPanel();
        this.managementModeBorder = new TitledBorder(null, J18N.tr("Database management mode", new Object[0]), 4, 2, null, null);
        this.managementModePanel.setBorder(this.managementModeBorder);
        GridBagConstraints gbcManagementModePanel = new GridBagConstraints();
        gbcManagementModePanel.fill = 1;
        gbcManagementModePanel.gridx = 0;
        gbcManagementModePanel.gridy = 0;
        this.contentPanel.add((Component)this.managementModePanel, gbcManagementModePanel);
        GridBagLayout gblManagementModePanel = new GridBagLayout();
        gblManagementModePanel.columnWidths = new int[]{0, 0};
        gblManagementModePanel.rowHeights = new int[]{0, 0, 0, 0};
        gblManagementModePanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gblManagementModePanel.rowWeights = new double[]{1.0, 1.0, 1.0, Double.MIN_VALUE};
        this.managementModePanel.setLayout(gblManagementModePanel);
        this.rdbtnInternal = new JRadioButton(J18N.tr("Internal", new Object[0]));
        this.rdbtnInternal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductDbDialog.this.setManagementMode(DbMode.INTERNAL);
            }
        });
        this.btnGroup.add(this.rdbtnInternal);
        GridBagConstraints gbcRdbtnInternal = new GridBagConstraints();
        gbcRdbtnInternal.fill = 1;
        gbcRdbtnInternal.insets = new Insets(5, 5, 0, 5);
        gbcRdbtnInternal.gridx = 0;
        gbcRdbtnInternal.gridy = 0;
        this.managementModePanel.add((Component)this.rdbtnInternal, gbcRdbtnInternal);
        this.rdbtnExternalJDBC = new JRadioButton(J18N.tr("External (JDBC)", new Object[0]));
        this.rdbtnExternalJDBC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductDbDialog.this.setManagementMode(DbMode.EXTERNAL_JDBC);
            }
        });
        this.btnGroup.add(this.rdbtnExternalJDBC);
        GridBagConstraints gbcRdbtnExternalJDBC = new GridBagConstraints();
        gbcRdbtnExternalJDBC.fill = 1;
        gbcRdbtnExternalJDBC.insets = new Insets(5, 5, 0, 5);
        gbcRdbtnExternalJDBC.gridx = 0;
        gbcRdbtnExternalJDBC.gridy = 1;
        this.managementModePanel.add((Component)this.rdbtnExternalJDBC, gbcRdbtnExternalJDBC);
        this.rdbtnExternalFile = new JRadioButton(J18N.tr("External (text file)", new Object[0]));
        this.rdbtnExternalFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductDbDialog.this.setManagementMode(DbMode.EXTERNAL_TXT);
            }
        });
        this.btnGroup.add(this.rdbtnExternalFile);
        GridBagConstraints gbcRdbtnExternalFile = new GridBagConstraints();
        gbcRdbtnExternalFile.insets = new Insets(5, 5, 5, 5);
        gbcRdbtnExternalFile.fill = 1;
        gbcRdbtnExternalFile.gridx = 0;
        gbcRdbtnExternalFile.gridy = 2;
        this.managementModePanel.add((Component)this.rdbtnExternalFile, gbcRdbtnExternalFile);
        this.externalJdbcPanel = new GuiPanel();
        this.externalJdbcBorder = new TitledBorder(null, J18N.tr("External (JDBC)", new Object[0]), 4, 2, null, null);
        this.externalJdbcPanel.setBorder(this.externalJdbcBorder);
        GridBagConstraints gbcExternalJdbcPanel = new GridBagConstraints();
        gbcExternalJdbcPanel.fill = 1;
        gbcExternalJdbcPanel.insets = new Insets(5, 0, 0, 0);
        gbcExternalJdbcPanel.gridx = 0;
        gbcExternalJdbcPanel.gridy = 1;
        this.contentPanel.add((Component)this.externalJdbcPanel, gbcExternalJdbcPanel);
        GridBagLayout gblExternalJdbcPanel = new GridBagLayout();
        gblExternalJdbcPanel.columnWidths = new int[]{0, 0, 0, 0};
        gblExternalJdbcPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        gblExternalJdbcPanel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gblExternalJdbcPanel.rowWeights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        this.externalJdbcPanel.setLayout(gblExternalJdbcPanel);
        this.lbljar = new JLabel(J18N.tr("JAR", new Object[0]) + ":");
        GridBagConstraints gbcLbljar = new GridBagConstraints();
        gbcLbljar.fill = 2;
        gbcLbljar.insets = new Insets(5, 5, 0, 0);
        gbcLbljar.gridx = 0;
        gbcLbljar.gridy = 0;
        this.externalJdbcPanel.add((Component)this.lbljar, gbcLbljar);
        this.txtJar = new TextField(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                ProductDbDialog.this.refreshUi();
            }
        };
        this.txtJar.setColumns(10);
        GridBagConstraints gbcTxtJar = new GridBagConstraints();
        gbcTxtJar.fill = 2;
        gbcTxtJar.insets = new Insets(5, 5, 0, 0);
        gbcTxtJar.gridx = 1;
        gbcTxtJar.gridy = 0;
        this.externalJdbcPanel.add((Component)this.txtJar, gbcTxtJar);
        this.btnBrowseJar = new JButton(J18N.tr("Browse", new Object[0]) + "...");
        this.btnBrowseJar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductDbDialog.this.setLanguageFileChooser();
                JFileChooser fileChooser = new JFileChooser();
                JList list = SwingUtils.getDescendantOfType(JList.class, fileChooser, "Enabled", true);
                JPopupMenu popup = list.getComponentPopupMenu();
                popup.remove(0);
                ProductDbDialog.this.disableComponent(fileChooser);
                if (lastJarDir == null) {
                    lastJarDir = new File(System.getProperty("user.home"));
                }
                fileChooser.setCurrentDirectory(lastJarDir);
                int result = fileChooser.showOpenDialog(ProductDbDialog.this);
                if (result == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    lastJarDir = selectedFile.getParentFile();
                    ProductDbDialog.this.txtJar.setText(selectedFile.getAbsolutePath());
                }
            }
        });
        GridBagConstraints gbcBtnSearch = new GridBagConstraints();
        gbcBtnSearch.fill = 2;
        gbcBtnSearch.insets = new Insets(5, 5, 0, 5);
        gbcBtnSearch.gridx = 2;
        gbcBtnSearch.gridy = 0;
        this.externalJdbcPanel.add((Component)this.btnBrowseJar, gbcBtnSearch);
        this.lblDriverClass = new JLabel(J18N.tr("Driver class", new Object[0]) + ":");
        GridBagConstraints gbcLblDriver = new GridBagConstraints();
        gbcLblDriver.fill = 2;
        gbcLblDriver.insets = new Insets(5, 5, 0, 0);
        gbcLblDriver.gridx = 0;
        gbcLblDriver.gridy = 1;
        this.externalJdbcPanel.add((Component)this.lblDriverClass, gbcLblDriver);
        this.txtDriverClass = new TextField(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                ProductDbDialog.this.refreshUi();
            }
        };
        this.txtDriverClass.setColumns(10);
        GridBagConstraints gbcTxtDriver = new GridBagConstraints();
        gbcTxtDriver.fill = 2;
        gbcTxtDriver.insets = new Insets(5, 5, 0, 0);
        gbcTxtDriver.gridx = 1;
        gbcTxtDriver.gridy = 1;
        this.externalJdbcPanel.add((Component)this.txtDriverClass, gbcTxtDriver);
        this.lblUrl = new JLabel(J18N.tr("URL", new Object[0]) + ":");
        GridBagConstraints gbcLblUri = new GridBagConstraints();
        gbcLblUri.fill = 2;
        gbcLblUri.insets = new Insets(5, 5, 0, 0);
        gbcLblUri.gridx = 0;
        gbcLblUri.gridy = 2;
        this.externalJdbcPanel.add((Component)this.lblUrl, gbcLblUri);
        this.txtUrl = new TextField(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                ProductDbDialog.this.refreshUi();
            }
        };
        this.txtUrl.setColumns(10);
        GridBagConstraints gbcTxtUri = new GridBagConstraints();
        gbcTxtUri.fill = 2;
        gbcTxtUri.insets = new Insets(5, 5, 0, 0);
        gbcTxtUri.gridx = 1;
        gbcTxtUri.gridy = 2;
        this.externalJdbcPanel.add((Component)this.txtUrl, gbcTxtUri);
        this.lblUser = new JLabel(J18N.tr("User", new Object[0]) + ":");
        GridBagConstraints gbcLblUser = new GridBagConstraints();
        gbcLblUser.insets = new Insets(5, 5, 0, 0);
        gbcLblUser.fill = 2;
        gbcLblUser.gridx = 0;
        gbcLblUser.gridy = 3;
        this.externalJdbcPanel.add((Component)this.lblUser, gbcLblUser);
        this.txtUser = new TextField();
        this.txtUser.setColumns(10);
        GridBagConstraints gbcTxtUser = new GridBagConstraints();
        gbcTxtUser.fill = 2;
        gbcTxtUser.insets = new Insets(5, 5, 0, 0);
        gbcTxtUser.gridx = 1;
        gbcTxtUser.gridy = 3;
        this.externalJdbcPanel.add((Component)this.txtUser, gbcTxtUser);
        this.lblPassword = new JLabel(J18N.tr("Password", new Object[0]) + ":");
        GridBagConstraints gbcLblPassword = new GridBagConstraints();
        gbcLblPassword.fill = 2;
        gbcLblPassword.insets = new Insets(5, 5, 0, 0);
        gbcLblPassword.gridx = 0;
        gbcLblPassword.gridy = 4;
        this.externalJdbcPanel.add((Component)this.lblPassword, gbcLblPassword);
        this.txtPassword = new PasswordField();
        this.txtPassword.setColumns(10);
        GridBagConstraints gbcTxtPassword = new GridBagConstraints();
        gbcTxtPassword.fill = 2;
        gbcTxtPassword.insets = new Insets(5, 5, 0, 0);
        gbcTxtPassword.gridx = 1;
        gbcTxtPassword.gridy = 4;
        this.externalJdbcPanel.add((Component)this.txtPassword, gbcTxtPassword);
        this.lblTableProduct = new JLabel(J18N.tr("Product view", new Object[0]) + ":");
        GridBagConstraints gbcLblTableProduct = new GridBagConstraints();
        gbcLblTableProduct.fill = 2;
        gbcLblTableProduct.insets = new Insets(5, 5, 0, 0);
        gbcLblTableProduct.gridx = 0;
        gbcLblTableProduct.gridy = 5;
        this.externalJdbcPanel.add((Component)this.lblTableProduct, gbcLblTableProduct);
        this.txtProductTable = new TextField(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                ProductDbDialog.this.refreshUi();
            }
        };
        this.txtProductTable.setColumns(10);
        GridBagConstraints gbcTxtTableProduct = new GridBagConstraints();
        gbcTxtTableProduct.fill = 2;
        gbcTxtTableProduct.insets = new Insets(5, 5, 0, 0);
        gbcTxtTableProduct.gridx = 1;
        gbcTxtTableProduct.gridy = 5;
        this.externalJdbcPanel.add((Component)this.txtProductTable, gbcTxtTableProduct);
        this.btnAdvanced = new JButton(J18N.tr("Advanced", new Object[0]) + "...");
        this.btnAdvanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigProdTableDefDialog dialog = new ConfigProdTableDefDialog(ProductDbDialog.this.currentTableDef){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void onClose(Object result) {
                        super.onClose(result);
                        Product.ProductTableDefinition tableDef = (Product.ProductTableDefinition)result;
                        if (tableDef != null) {
                            tableDef.setName(ProductDbDialog.this.currentTableDef.getName());
                            ProductDbDialog.this.currentTableDef = tableDef;
                        }
                    }
                };
                dialog.setLocationRelativeTo(ProductDbDialog.this);
                dialog.setVisible(true);
            }
        });
        GridBagConstraints gbcBtnAdvanced = new GridBagConstraints();
        gbcBtnAdvanced.fill = 2;
        gbcBtnAdvanced.anchor = 11;
        gbcBtnAdvanced.insets = new Insets(5, 5, 0, 5);
        gbcBtnAdvanced.gridx = 2;
        gbcBtnAdvanced.gridy = 5;
        this.externalJdbcPanel.add((Component)this.btnAdvanced, gbcBtnAdvanced);
        this.btnTest = new JButton(J18N.tr("Test Connection", new Object[0]));
        this.btnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductDbDialog.this.testExternalJdbc();
            }
        });
        GridBagConstraints gbcBtnTest = new GridBagConstraints();
        gbcBtnTest.fill = 2;
        gbcBtnTest.insets = new Insets(5, 5, 5, 0);
        gbcBtnTest.gridx = 0;
        gbcBtnTest.gridy = 6;
        this.externalJdbcPanel.add((Component)this.btnTest, gbcBtnTest);
        this.rigidArea = Box.createRigidArea(new Dimension(20, 20));
        GridBagConstraints gbcRigidArea = new GridBagConstraints();
        gbcRigidArea.gridwidth = 2;
        gbcRigidArea.fill = 1;
        gbcRigidArea.insets = new Insets(5, 5, 5, 5);
        gbcRigidArea.gridx = 1;
        gbcRigidArea.gridy = 6;
        this.externalJdbcPanel.add(this.rigidArea, gbcRigidArea);
        this.externalTxtPanel = new GuiPanel();
        this.externalTxtBorder = new TitledBorder(null, J18N.tr("External (text file)", new Object[0]), 4, 2, null, null);
        this.externalTxtPanel.setBorder(this.externalTxtBorder);
        GridBagConstraints gbcExternalTxtPanel = new GridBagConstraints();
        gbcExternalTxtPanel.fill = 1;
        gbcExternalTxtPanel.insets = new Insets(5, 0, 0, 0);
        gbcExternalTxtPanel.gridx = 0;
        gbcExternalTxtPanel.gridy = 2;
        this.contentPanel.add((Component)this.externalTxtPanel, gbcExternalTxtPanel);
        GridBagLayout gblExternalTxtPanel = new GridBagLayout();
        gblExternalTxtPanel.columnWidths = new int[]{0, 320, 0};
        gblExternalTxtPanel.rowHeights = new int[]{0, 0, 0, 0};
        gblExternalTxtPanel.columnWeights = new double[]{0.0, 1.0, 0.0};
        gblExternalTxtPanel.rowWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        this.externalTxtPanel.setLayout(gblExternalTxtPanel);
        this.lblFile = new JLabel(J18N.tr("File", new Object[0]) + ":");
        GridBagConstraints gbcLblFile = new GridBagConstraints();
        gbcLblFile.fill = 2;
        gbcLblFile.insets = new Insets(5, 5, 5, 5);
        gbcLblFile.gridx = 0;
        gbcLblFile.gridy = 0;
        this.externalTxtPanel.add((Component)this.lblFile, gbcLblFile);
        this.txtFile = new TextField(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                ProductDbDialog.this.refreshUi();
            }
        };
        this.txtFile.setColumns(20);
        this.txtFile.setEditable(false);
        GridBagConstraints gbcTxtFile = new GridBagConstraints();
        gbcTxtFile.fill = 1;
        gbcTxtFile.insets = new Insets(5, 5, 5, 5);
        gbcTxtFile.gridx = 1;
        gbcTxtFile.gridy = 0;
        this.externalTxtPanel.add((Component)this.txtFile, gbcTxtFile);
        this.txtFile.setText(ApplicationSettings.getInstance().getProperty("PATH_FILE_PRODUCT"));
        this.btnBrowseTxtFile = new JButton(J18N.tr("Browse", new Object[0]) + "...");
        this.btnBrowseTxtFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductDbDialog.this.setLanguageFileChooser();
                JFileChooser fileChooser = new JFileChooser();
                JList list = SwingUtils.getDescendantOfType(JList.class, fileChooser, "Enabled", true);
                JPopupMenu popup = list.getComponentPopupMenu();
                popup.remove(0);
                ProductDbDialog.this.disableComponent(fileChooser);
                if (lastTxtDir == null) {
                    lastTxtDir = new File(System.getProperty("user.home"));
                }
                fileChooser.setCurrentDirectory(lastTxtDir);
                int result = fileChooser.showOpenDialog(ProductDbDialog.this);
                if (result == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    lastTxtDir = selectedFile.getParentFile();
                    ProductDbDialog.this.txtFile.setText(selectedFile.getAbsolutePath());
                }
            }
        });
        GridBagConstraints gbcBtnSearchFile = new GridBagConstraints();
        gbcBtnSearchFile.insets = new Insets(5, 5, 5, 0);
        gbcBtnSearchFile.fill = 2;
        gbcBtnSearchFile.gridx = 2;
        gbcBtnSearchFile.gridy = 0;
        this.externalTxtPanel.add((Component)this.btnBrowseTxtFile, gbcBtnSearchFile);
        this.lblsSeroAceitos = new JLabel(J18N.tr("(Use UTF-8 as the encoding for .txt file)", new Object[0]));
        this.lblsSeroAceitos.setBackground(Color.BLUE);
        this.lblsSeroAceitos.setFont(new Font("Tahoma", 0, 9));
        GridBagConstraints gbcLblsSeroAceitos = new GridBagConstraints();
        gbcLblsSeroAceitos.insets = new Insets(0, 0, 5, 5);
        gbcLblsSeroAceitos.gridx = 1;
        gbcLblsSeroAceitos.gridy = 1;
        this.externalTxtPanel.add((Component)this.lblsSeroAceitos, gbcLblsSeroAceitos);
        this.lblUpdateInterval = new JLabel(J18N.tr("Update interval (minutes)", new Object[0]) + ":");
        GridBagConstraints gbcLblUpdateInterval = new GridBagConstraints();
        gbcLblUpdateInterval.insets = new Insets(5, 5, 0, 5);
        gbcLblUpdateInterval.gridx = 0;
        gbcLblUpdateInterval.gridy = 2;
        this.externalTxtPanel.add((Component)this.lblUpdateInterval, gbcLblUpdateInterval);
        this.updateIntervalSpinner = new JSpinner();
        this.updateIntervalSpinner.setModel(new SpinnerNumberModel(new Integer(10), new Integer(10), null, new Integer(1)));
        ((JSpinner.DefaultEditor)this.updateIntervalSpinner.getEditor()).getTextField().setEditable(false);
        ((JSpinner.DefaultEditor)this.updateIntervalSpinner.getEditor()).getTextField().setColumns(8);
        GridBagConstraints gbcUpdateIntervalSpinner = new GridBagConstraints();
        gbcUpdateIntervalSpinner.anchor = 17;
        gbcUpdateIntervalSpinner.insets = new Insets(5, 5, 0, 5);
        gbcUpdateIntervalSpinner.gridx = 1;
        gbcUpdateIntervalSpinner.gridy = 2;
        this.externalTxtPanel.add((Component)this.updateIntervalSpinner, gbcUpdateIntervalSpinner);
        GuiPanel buttonPane = new GuiPanel();
        GridBagConstraints gbcButtonPane = new GridBagConstraints();
        gbcButtonPane.insets = new Insets(5, 0, 0, 0);
        gbcButtonPane.fill = 1;
        gbcButtonPane.gridx = 0;
        gbcButtonPane.gridy = 3;
        this.contentPanel.add((Component)buttonPane, gbcButtonPane);
        FlowLayout flButtonPane = new FlowLayout(2);
        flButtonPane.setVgap(0);
        flButtonPane.setHgap(0);
        buttonPane.setLayout(flButtonPane);
        GuiPanel panel = new GuiPanel();
        ((Container)buttonPane).add(panel);
        panel.setLayout(new GridLayout(0, 2, 5, 0));
        this.btnOk = new JButton(J18N.tr("OK", new Object[0]));
        ((Container)panel).add(this.btnOk);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductDbDialog.this.parentFrame = (Frame)ProductDbDialog.this.parentWindow;
                ProductDbDialog.this.dlg = ProgressBarBuilder.build(ProductDbDialog.this.parentFrame, J18N.tr("Loading products", new Object[0]));
                Application.EVENT_LOOP.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProductDbDialog.this.dlg.setVisible(true);
                    }
                });
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        ProductDbDialog.this.save();
                        return null;
                    }

                    @Override
                    protected void done() {
                        Application.EVENT_LOOP.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProductDbDialog.this.refreshUi();
                            }
                        });
                    }
                }.execute();
            }
        });
        this.btnCancel = new JButton(J18N.tr("Cancel", new Object[0]));
        ((Container)panel).add(this.btnCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductDbDialog.this.dispose();
            }
        });
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(this.btnCancel);
        this.loadConfig();
        this.pack();
        loadedDataListener = new Product.LoadedDataListener(){

            @Override
            public void onLoadedData() {
                ProductDbDialog.this.contentPanel.revalidate();
                ProductDbDialog.this.contentPanel.repaint();
            }
        };
    }

    public void disableComponent(Container c) {
        int len = c.getComponentCount();
        for (int i = 0; i < len; ++i) {
            Component comp = c.getComponent(i);
            if (comp instanceof JToggleButton) {
                comp.setEnabled(false);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.disableComponent((Container)comp);
        }
    }

    private void setLanguageFileChooser() {
        UIManager.put("FileChooser.openDialogTitleText", J18N.tr("Open", new Object[0]));
        UIManager.put("FileChooser.lookInLabelText", J18N.tr("Look in:", new Object[0]));
        UIManager.put("FileChooser.fileNameLabelText", J18N.tr("File Name:", new Object[0]));
        UIManager.put("FileChooser.filesOfTypeLabelText", J18N.tr("Files of Type:", new Object[0]));
        UIManager.put("FileChooser.openButtonText", J18N.tr("Open", new Object[0]));
        UIManager.put("FileChooser.cancelButtonText", J18N.tr("Cancel", new Object[0]));
        UIManager.put("FileChooser.upFolderToolTipText", J18N.tr("Up One Level", new Object[0]));
        UIManager.put("FileChooser.newFolderToolTipText", J18N.tr("Create New Folder", new Object[0]));
        UIManager.put("FileChooser.listViewButtonToolTipText", J18N.tr("List", new Object[0]));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", J18N.tr("Details", new Object[0]));
        UIManager.put("FileChooser.openButtonToolTipText", J18N.tr("Open selected file", new Object[0]));
        UIManager.put("FileChooser.cancelButtonToolTipText", J18N.tr("Abort file chooser dialog", new Object[0]));
        UIManager.put("FileChooser.newFolderErrorText", J18N.tr("Error creating new folder", new Object[0]));
        UIManager.put("FileChooser.viewMenuLabelText", J18N.tr("View", new Object[0]));
        UIManager.put("FileChooser.refreshActionLabelText", J18N.tr("Refresh", new Object[0]));
        UIManager.put("FileChooser.newFolderActionLabelText", J18N.tr("New Folder", new Object[0]));
        UIManager.put("FileChooser.detailsViewActionLabelText", J18N.tr("Details", new Object[0]));
        UIManager.put("FileChooser.listViewActionLabelText", J18N.tr("List", new Object[0]));
        UIManager.put("FileChooser.acceptAllFileFilterText", J18N.tr("All Files", new Object[0]));
    }

    private void loadConfig() {
        ApplicationSettings settings = ApplicationSettings.getInstance();
        this.txtJar.setText(settings.getProperty("DB_PATH_JAR", ""));
        this.txtDriverClass.setText(settings.getProperty("DB_DRIVER", ""));
        this.txtUrl.setText(settings.getProperty("DB_URL", ""));
        this.txtUser.setText(settings.getEncryptedProperty("DB_USER", ""));
        this.txtPassword.setText(settings.getEncryptedProperty("DB_PASSWORD", ""));
        this.txtProductTable.setText(settings.getProperty("DB_PRODUCT_TABLE_NAME", "PRODUCTS"));
        this.updateIntervalSpinner.setValue(Integer.parseInt(settings.getProperty("TXT_DB_RELOAD_INTERVAL_MIN", "")));
        this.setManagementMode(DbMode.loadFromConfig());
    }

    private void showExternalJdbcOptions(boolean show) {
        this.externalJdbcPanel.setVisible(show);
        this.pack();
    }

    private void showExternalTxtOptions(boolean show) {
        this.externalTxtPanel.setVisible(show);
        this.pack();
    }

    private void refreshUi() {
        DbMode dbMode = this.getUiDbMode();
        if (dbMode == null) {
            return;
        }
        switch (this.getUiDbMode()) {
            case INTERNAL: {
                this.showExternalJdbcOptions(false);
                this.showExternalTxtOptions(false);
                this.btnOk.setEnabled(true);
                this.pack();
                break;
            }
            case EXTERNAL_TXT: {
                this.showExternalJdbcOptions(false);
                this.showExternalTxtOptions(true);
                File selectedFile = new File(this.txtFile.getText());
                this.txtFile.setValid(selectedFile.exists() && selectedFile.isFile());
                this.txtFile.setToolTipText(this.txtFile.isValid() ? "" : J18N.tr("Path does not exist or points do a directory", new Object[0]));
                this.btnOk.setEnabled(this.txtFile.isValid());
                this.pack();
                break;
            }
            case EXTERNAL_JDBC: {
                this.showExternalJdbcOptions(true);
                this.showExternalTxtOptions(false);
                boolean allowedTrySave = true;
                allowedTrySave = allowedTrySave && !this.txtJar.getText().isEmpty();
                allowedTrySave = allowedTrySave && !this.txtDriverClass.getText().isEmpty();
                allowedTrySave = allowedTrySave && !this.txtUrl.getText().isEmpty();
                allowedTrySave = allowedTrySave && !this.currentTableDef.getName().isEmpty();
                this.btnOk.setEnabled(allowedTrySave);
                this.pack();
            }
        }
    }

    private void setManagementMode(DbMode mode) {
        this.rdbtnInternal.setSelected(mode == DbMode.INTERNAL);
        this.rdbtnInternal.setFocusPainted(mode == DbMode.INTERNAL);
        this.rdbtnExternalJDBC.setSelected(mode == DbMode.EXTERNAL_JDBC);
        this.rdbtnExternalJDBC.setFocusPainted(mode == DbMode.EXTERNAL_JDBC);
        this.rdbtnExternalFile.setSelected(mode == DbMode.EXTERNAL_TXT);
        this.rdbtnExternalFile.setFocusPainted(mode == DbMode.EXTERNAL_TXT);
        this.refreshUi();
    }

    private DbMode getUiDbMode() {
        if (this.rdbtnInternal.isSelected()) {
            return DbMode.INTERNAL;
        }
        if (this.rdbtnExternalJDBC.isSelected()) {
            return DbMode.EXTERNAL_JDBC;
        }
        if (this.rdbtnExternalFile.isSelected()) {
            return DbMode.EXTERNAL_TXT;
        }
        return null;
    }

    private void testExternalJdbc() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    File jarFile = new File(ProductDbDialog.this.txtJar.getText());
                    String driverClass = ProductDbDialog.this.txtDriverClass.getText();
                    ProductDbDialog.this.currentTableDef.setName(ProductDbDialog.this.txtProductTable.getText());
                    JdbcConnection connection = JdbcConnection.getConnection(jarFile, driverClass, ProductDbDialog.this.txtUrl.getText(), ProductDbDialog.this.txtUser.getText(), new String(ProductDbDialog.this.txtPassword.getPassword()), 3000L);
                    AbstractJdbcProductDao.ExternalJdbcProductDao dao = new AbstractJdbcProductDao.ExternalJdbcProductDao(connection, ProductDbDialog.this.currentTableDef);
                    dao.init();
                    dao.close();
                    GuiUtils.showInfoMessage(ProductDbDialog.this, J18N.tr("Connection success", new Object[0]));
                    ProductDbDialog.this.contentPanel.setEnabled(true);
                }
                catch (Exception ex) {
                    GuiUtils.showErrorMessage(ProductDbDialog.this, J18N.tr("Connection failed: ", new Object[0]) + J18N.tr("Check database settings", new Object[0]));
                    ProductDbDialog.this.contentPanel.setEnabled(true);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private void showSaveError(Throwable error) {
        GuiUtils.showErrorMessage(this, J18N.tr("Error setting product database: ", new Object[0]) + J18N.tr("Check database settings", new Object[0]));
    }

    private void saveInternalJdbcDao() {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    boolean modeChanged;
                    boolean bl = modeChanged = DbMode.loadFromConfig() != DbMode.INTERNAL;
                    if (modeChanged) {
                        AbstractJdbcProductDao.InternalJdbcProductDao dao = new AbstractJdbcProductDao.InternalJdbcProductDao(Application.INTERNAL_PRODUCT_DB_FILE);
                        dao.setLoadedDataListener(ProductDbDialog.this.loadedDataListener);
                        dao.init();
                        Product.setCurrentDao(dao);
                        Application.SETTINGS.setProperty("DB_MODE", DbMode.INTERNAL.getConfigValue());
                        Log.infoTag("DB", J18N.tr("Switched to internal mode", new Object[0]), new Object[0]);
                    }
                    ProductDbDialog.this.dispose(Product.getCurrentDao());
                }
                catch (Throwable t) {
                    ProductDbDialog.this.showSaveError(t);
                    ProductDbDialog.this.contentPanel.setEnabled(true);
                }
                return null;
            }

            @Override
            protected void done() {
                Application.EVENT_LOOP.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProductDbDialog.this.dispose(Product.getCurrentDao());
                        ProductDbDialog.this.dlg.setVisible(false);
                    }
                });
            }
        }.execute();
    }

    private void saveExternalJdbcDao() {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    DbMode currentMode = DbMode.loadFromConfig();
                    File jarFile = new File(ProductDbDialog.this.txtJar.getText());
                    String driverClass = ProductDbDialog.this.txtDriverClass.getText();
                    ProductDbDialog.this.currentTableDef.setName(ProductDbDialog.this.txtProductTable.getText());
                    JdbcConnection connection = JdbcConnection.getConnection(jarFile, driverClass, ProductDbDialog.this.txtUrl.getText(), ProductDbDialog.this.txtUser.getText(), new String(ProductDbDialog.this.txtPassword.getPassword()), 3000L);
                    AbstractJdbcProductDao.ExternalJdbcProductDao dao = new AbstractJdbcProductDao.ExternalJdbcProductDao(connection, ProductDbDialog.this.currentTableDef);
                    dao.setLoadedDataListener(ProductDbDialog.this.loadedDataListener);
                    dao.init();
                    Product.setCurrentDao(dao);
                    ApplicationSettings settings = Application.SETTINGS;
                    settings.setProperty("DB_PATH_JAR", ProductDbDialog.this.txtJar.getText());
                    settings.setProperty("DB_DRIVER", ProductDbDialog.this.txtDriverClass.getText());
                    settings.setProperty("DB_URL", ProductDbDialog.this.txtUrl.getText());
                    settings.setEncryptedProperty("DB_USER", ProductDbDialog.this.txtUser.getText());
                    settings.setEncryptedProperty("DB_PASSWORD", new String(ProductDbDialog.this.txtPassword.getPassword()));
                    settings.setProperty("DB_PRODUCT_TABLE_NAME", ProductDbDialog.this.currentTableDef.getName());
                    settings.setProperty("DB_COL_BARCODE", ProductDbDialog.this.currentTableDef.getColBarcode());
                    settings.setProperty("DB_COL_DESCRIPITION", ProductDbDialog.this.currentTableDef.getColDescription());
                    settings.setProperty("DB_COL_PRICE1", ProductDbDialog.this.currentTableDef.getColPrice1());
                    settings.setProperty("DB_COL_PRICE2", ProductDbDialog.this.currentTableDef.getColPrice2() == null ? "" : ProductDbDialog.this.currentTableDef.getColPrice2());
                    settings.setProperty("DB_MODE", DbMode.EXTERNAL_JDBC.getConfigValue());
                    if (currentMode != DbMode.EXTERNAL_JDBC) {
                        Log.infoTag("DB", J18N.tr("Switched to external mode (JDBC)", new Object[0]), new Object[0]);
                    } else {
                        Log.infoTag("DB", J18N.tr("Reloaded external database (JDBC)", new Object[0]), new Object[0]);
                    }
                }
                catch (Exception ex) {
                    ProductDbDialog.this.showSaveError(ex);
                    ProductDbDialog.this.contentPanel.setEnabled(true);
                }
                return null;
            }

            @Override
            protected void done() {
                Application.EVENT_LOOP.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProductDbDialog.this.dispose(Product.getCurrentDao());
                        ProductDbDialog.this.dlg.setVisible(false);
                    }
                });
            }
        }.execute();
    }

    private void saveExternalTxtDao() {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    DbMode oldMode = DbMode.loadFromConfig();
                    String oldFilePath = oldMode == DbMode.EXTERNAL_TXT ? Application.SETTINGS.getProperty("PATH_FILE_PRODUCT") : null;
                    String oldReloadInterval = oldMode == DbMode.EXTERNAL_TXT ? Application.SETTINGS.getProperty("TXT_DB_RELOAD_INTERVAL_MIN") : null;
                    String newFilePath = ProductDbDialog.this.txtFile.getText();
                    String newReloadInterval = ProductDbDialog.this.updateIntervalSpinner.getValue().toString();
                    if (oldMode != DbMode.EXTERNAL_TXT || !Objects.equals(oldFilePath, newFilePath) || !Objects.equals(oldReloadInterval, newReloadInterval)) {
                        TextDbProductDao dao = new TextDbProductDao(Application.EVENT_LOOP, new File(ProductDbDialog.this.txtFile.getText()), Long.parseLong(newReloadInterval) * 60000L){

                            @Override
                            protected void onAutoReload() {
                                super.onAutoReload();
                                Log.debugTag("DB", J18N.tr("DB was automatically reloaded", new Object[0]), new Object[0]);
                            }
                        };
                        dao.setLoadedDataListener(ProductDbDialog.this.loadedDataListener);
                        dao.init();
                        Product.setCurrentDao(dao);
                        Application.SETTINGS.setProperty("PATH_FILE_PRODUCT", ProductDbDialog.this.txtFile.getText());
                        Application.SETTINGS.setProperty("TXT_DB_RELOAD_INTERVAL_MIN", ProductDbDialog.this.updateIntervalSpinner.getValue().toString());
                        Application.SETTINGS.setProperty("DB_MODE", DbMode.EXTERNAL_TXT.getConfigValue());
                        if (oldMode != DbMode.EXTERNAL_TXT) {
                            Log.infoTag("DB", J18N.tr("Switched to external mode (text) - update interval: %s minutes", newReloadInterval), new Object[0]);
                        } else {
                            Log.infoTag("DB", J18N.tr("Reloaded external database (text)  - update interval: %s minutes", newReloadInterval), new Object[0]);
                        }
                    }
                }
                catch (Throwable e) {
                    ProductDbDialog.this.showSaveError(e);
                    ProductDbDialog.this.contentPanel.setEnabled(true);
                }
                return null;
            }

            @Override
            protected void done() {
                Application.EVENT_LOOP.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProductDbDialog.this.dispose(Product.getCurrentDao());
                        ProductDbDialog.this.dlg.setVisible(false);
                    }
                });
            }
        }.execute();
    }

    private void save() {
        DbMode dbMode = this.getUiDbMode();
        switch (dbMode) {
            case INTERNAL: {
                this.saveInternalJdbcDao();
                break;
            }
            case EXTERNAL_JDBC: {
                this.saveExternalJdbcDao();
                break;
            }
            case EXTERNAL_TXT: {
                this.saveExternalTxtDao();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + dbMode.name());
            }
        }
    }
}

