/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiTcDialog;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.sc501.commands.Config02;
import br.com.gertec.tc.server.protocol.sc501.commands.Config02Q;
import br.com.gertec.tc.server.protocol.sc501.commands.REConf02;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

public class REConf02Dialog
extends GuiTcDialog {
    private static final long serialVersionUID = 1L;
    private final GuiPanel contentPanel = new GuiPanel();
    private JTextField txtServerIp;
    private JTextField txtTerminalIp;
    private JTextField txtNetmask;
    private JTextField txtLine1;
    private JTextField txtLine2;
    private JTextField txtLine3;
    private JTextField txtLine4;
    private JSpinner spinnerExhibTime;
    private JButton btnOk;
    private JButton btnCancel;

    private REConf02Dialog() {
        super((AbstractTcConnection)null, true);
        this.init();
    }

    public REConf02Dialog(AbstractTcConnection connection) {
        super(connection);
        this.init();
    }

    private void init() {
        this.initGui();
        this.registerListeners();
        this.requestTerminalInfo();
    }

    private void initGui() {
        this.setTitle("#reconf02");
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gblContentPanel = new GridBagLayout();
        gblContentPanel.columnWidths = new int[]{0, 0, 0};
        gblContentPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        gblContentPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gblContentPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gblContentPanel);
        JLabel lblServerIp = new JLabel(J18N.tr("Server IP:", new Object[0]));
        GridBagConstraints gbcLblServerIp = new GridBagConstraints();
        gbcLblServerIp.fill = 1;
        gbcLblServerIp.insets = new Insets(0, 0, 5, 5);
        gbcLblServerIp.gridx = 0;
        gbcLblServerIp.gridy = 0;
        this.contentPanel.add((Component)lblServerIp, gbcLblServerIp);
        this.txtServerIp = new JTextField();
        GridBagConstraints gbcTxtServerIp = new GridBagConstraints();
        gbcTxtServerIp.insets = new Insets(0, 0, 5, 0);
        gbcTxtServerIp.fill = 1;
        gbcTxtServerIp.gridx = 1;
        gbcTxtServerIp.gridy = 0;
        this.contentPanel.add((Component)this.txtServerIp, gbcTxtServerIp);
        this.txtServerIp.setColumns(10);
        JLabel lblTerminalIp = new JLabel(J18N.tr("Terminal IP:", new Object[0]));
        GridBagConstraints gbcLblTerminalIp = new GridBagConstraints();
        gbcLblTerminalIp.fill = 1;
        gbcLblTerminalIp.insets = new Insets(0, 0, 5, 5);
        gbcLblTerminalIp.gridx = 0;
        gbcLblTerminalIp.gridy = 1;
        this.contentPanel.add((Component)lblTerminalIp, gbcLblTerminalIp);
        this.txtTerminalIp = new JTextField();
        GridBagConstraints gbcTxtTerminalIp = new GridBagConstraints();
        gbcTxtTerminalIp.insets = new Insets(0, 0, 5, 0);
        gbcTxtTerminalIp.fill = 1;
        gbcTxtTerminalIp.gridx = 1;
        gbcTxtTerminalIp.gridy = 1;
        this.contentPanel.add((Component)this.txtTerminalIp, gbcTxtTerminalIp);
        this.txtTerminalIp.setColumns(10);
        JLabel lblNetmask = new JLabel(J18N.tr("Netmask:", new Object[0]));
        GridBagConstraints gbcLblNetmask = new GridBagConstraints();
        gbcLblNetmask.fill = 1;
        gbcLblNetmask.insets = new Insets(0, 0, 5, 5);
        gbcLblNetmask.gridx = 0;
        gbcLblNetmask.gridy = 2;
        this.contentPanel.add((Component)lblNetmask, gbcLblNetmask);
        this.txtNetmask = new JTextField();
        GridBagConstraints gbcTxtNetmask = new GridBagConstraints();
        gbcTxtNetmask.insets = new Insets(0, 0, 5, 0);
        gbcTxtNetmask.fill = 1;
        gbcTxtNetmask.gridx = 1;
        gbcTxtNetmask.gridy = 2;
        this.contentPanel.add((Component)this.txtNetmask, gbcTxtNetmask);
        this.txtNetmask.setColumns(10);
        JLabel lblLine1 = new JLabel(J18N.tr("Line1:", new Object[0]));
        GridBagConstraints gbcLblLine1 = new GridBagConstraints();
        gbcLblLine1.fill = 1;
        gbcLblLine1.insets = new Insets(0, 0, 5, 5);
        gbcLblLine1.gridx = 0;
        gbcLblLine1.gridy = 3;
        this.contentPanel.add((Component)lblLine1, gbcLblLine1);
        this.txtLine1 = new JTextField();
        GridBagConstraints gbcTxtLine1 = new GridBagConstraints();
        gbcTxtLine1.insets = new Insets(0, 0, 5, 0);
        gbcTxtLine1.fill = 1;
        gbcTxtLine1.gridx = 1;
        gbcTxtLine1.gridy = 3;
        this.contentPanel.add((Component)this.txtLine1, gbcTxtLine1);
        this.txtLine1.setColumns(10);
        JLabel lblLine2 = new JLabel(J18N.tr("Line2:", new Object[0]));
        GridBagConstraints gbcLblLine2 = new GridBagConstraints();
        gbcLblLine2.fill = 1;
        gbcLblLine2.insets = new Insets(0, 0, 5, 5);
        gbcLblLine2.gridx = 0;
        gbcLblLine2.gridy = 4;
        this.contentPanel.add((Component)lblLine2, gbcLblLine2);
        this.txtLine2 = new JTextField();
        GridBagConstraints gbcTxtLine2 = new GridBagConstraints();
        gbcTxtLine2.insets = new Insets(0, 0, 5, 0);
        gbcTxtLine2.fill = 1;
        gbcTxtLine2.gridx = 1;
        gbcTxtLine2.gridy = 4;
        this.contentPanel.add((Component)this.txtLine2, gbcTxtLine2);
        this.txtLine2.setColumns(10);
        JLabel lblLine3 = new JLabel(J18N.tr("Line3:", new Object[0]));
        GridBagConstraints gbcLblLine3 = new GridBagConstraints();
        gbcLblLine3.fill = 1;
        gbcLblLine3.insets = new Insets(0, 0, 5, 5);
        gbcLblLine3.gridx = 0;
        gbcLblLine3.gridy = 5;
        this.contentPanel.add((Component)lblLine3, gbcLblLine3);
        this.txtLine3 = new JTextField();
        GridBagConstraints gbcTxtLine3 = new GridBagConstraints();
        gbcTxtLine3.insets = new Insets(0, 0, 5, 0);
        gbcTxtLine3.fill = 1;
        gbcTxtLine3.gridx = 1;
        gbcTxtLine3.gridy = 5;
        this.contentPanel.add((Component)this.txtLine3, gbcTxtLine3);
        this.txtLine3.setColumns(10);
        JLabel lblLine4 = new JLabel(J18N.tr("Line4:", new Object[0]));
        GridBagConstraints gbcLblLine4 = new GridBagConstraints();
        gbcLblLine4.fill = 1;
        gbcLblLine4.insets = new Insets(0, 0, 5, 5);
        gbcLblLine4.gridx = 0;
        gbcLblLine4.gridy = 6;
        this.contentPanel.add((Component)lblLine4, gbcLblLine4);
        this.txtLine4 = new JTextField();
        GridBagConstraints gbcTxtLine4 = new GridBagConstraints();
        gbcTxtLine4.insets = new Insets(0, 0, 5, 0);
        gbcTxtLine4.fill = 1;
        gbcTxtLine4.gridx = 1;
        gbcTxtLine4.gridy = 6;
        this.contentPanel.add((Component)this.txtLine4, gbcTxtLine4);
        this.txtLine4.setColumns(10);
        JLabel lblExhibitionTime = new JLabel(J18N.tr("Exhibition time:", new Object[0]));
        GridBagConstraints gbcLblExhibitionTime = new GridBagConstraints();
        gbcLblExhibitionTime.fill = 1;
        gbcLblExhibitionTime.insets = new Insets(0, 0, 0, 5);
        gbcLblExhibitionTime.gridx = 0;
        gbcLblExhibitionTime.gridy = 7;
        this.contentPanel.add((Component)lblExhibitionTime, gbcLblExhibitionTime);
        this.spinnerExhibTime = new JSpinner();
        this.spinnerExhibTime.setModel(new SpinnerNumberModel(3, 1, 10, 1));
        GridBagConstraints gbcSpinnerExhibTime = new GridBagConstraints();
        gbcSpinnerExhibTime.fill = 1;
        gbcSpinnerExhibTime.gridx = 1;
        gbcSpinnerExhibTime.gridy = 7;
        this.contentPanel.add((Component)this.spinnerExhibTime, gbcSpinnerExhibTime);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btnOk = new JButton("OK");
        this.btnOk.setActionCommand("OK");
        buttonPane.add(this.btnOk);
        this.getRootPane().setDefaultButton(this.btnOk);
        this.setDefaultButton(this.btnOk);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setActionCommand("Cancel");
        buttonPane.add(this.btnCancel);
        this.setCancelButton(this.btnCancel);
        this.contentPanel.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.pack();
    }

    private void registerListeners() {
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                REConf02Dialog.this.save();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                REConf02Dialog.this.dispose();
            }
        });
        this.registerSc501CommandListener("#config02", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Config02.ConfigParams params = ((Config02)command).getParams();
                REConf02Dialog.this.txtServerIp.setText(params.serverIp);
                REConf02Dialog.this.txtTerminalIp.setText(params.terminalIp);
                REConf02Dialog.this.txtNetmask.setText(params.netmask);
                REConf02Dialog.this.txtLine1.setText(params.line1);
                REConf02Dialog.this.txtLine2.setText(params.line2);
                REConf02Dialog.this.txtLine3.setText(params.line3);
                REConf02Dialog.this.txtLine4.setText(params.line4);
                REConf02Dialog.this.spinnerExhibTime.setValue(params.exhibTime);
                REConf02Dialog.this.btnOk.setEnabled(true);
                REConf02Dialog.this.contentPanel.setEnabled(true);
            }
        });
        this.registerSc501CommandListener("#reconf02_error\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Log.error(J18N.tr("Terminal Configuration Error", new Object[0]), new Object[0]);
            }
        });
    }

    private void requestTerminalInfo() {
        this.getConnection().writeCommand(new Config02Q());
    }

    private void save() {
        Config02.ConfigParams params = new Config02.ConfigParams();
        params.serverIp = this.txtServerIp.getText();
        params.terminalIp = this.txtTerminalIp.getText();
        params.netmask = this.txtNetmask.getText();
        params.line1 = this.txtLine1.getText();
        params.line2 = this.txtLine2.getText();
        params.line3 = this.txtLine3.getText();
        params.line4 = this.txtLine4.getText();
        params.exhibTime = (Integer)this.spinnerExhibTime.getValue();
        Log.debug("=====" + J18N.tr("MANUAL COMMAND", new Object[0]) + " =====", new Object[0]);
        this.getConnection().writeCommand(new REConf02(params));
        this.dispose();
    }
}

