/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.bean.Slide;
import br.com.gertec.tc.server.gui.SlideTable;
import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.commands.GetListMedias;
import br.com.gertec.tc.server.protocol.sc501.commands.GetListMediasQ;
import br.com.gertec.tc.server.protocol.sc501.commands.GetMediasConf;
import br.com.gertec.tc.server.protocol.sc501.commands.GetMediasConfQ;
import br.com.gertec.tc.server.protocol.sc501.commands.SaveMediasConf;
import br.com.gertec.tc.server.util.GrouppedSettings;
import br.com.gertec.tc.server.util.Playlist;
import br.com.gertec.tc.server.util.Settings;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class Sc501ESlideShowPanel
extends GuiPanel {
    private static final long serialVersionUID = 1L;
    public static final String TC_CONFIG_PATH_PREFIX = "CONF_DIR/";
    public static final String ALL_MEDIAS_CONF_FILENAME = "all_medias.conf";
    private static final String INT_MEM_PREFIX = "INT_MEM";
    private final SlideTable slideTable;
    private final JButton btnDel;
    private final JButton btnUp;
    private final JButton btnDown;
    private final Sc501Connection connection;
    private final String playlistFilename;
    private String listMedia;
    private GrouppedSettings gpSettings;

    public Sc501ESlideShowPanel(Sc501Connection connection, String playlistFilename) {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        if (connection == null) {
            throw new IllegalArgumentException("Null connection");
        }
        this.connection = connection;
        if (playlistFilename == null || playlistFilename.trim().isEmpty()) {
            throw new IllegalArgumentException("Null/empty playlist filename");
        }
        this.playlistFilename = playlistFilename;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{1.0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0};
        this.setLayout(gridBagLayout);
        this.slideTable = new SlideTable(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSelection() {
                Sc501ESlideShowPanel.this.refreshGui();
            }
        };
        JScrollPane scrollSlideTable = new JScrollPane(this.slideTable);
        GridBagConstraints gbcScrollSlideTable = new GridBagConstraints();
        gbcScrollSlideTable.fill = 2;
        gbcScrollSlideTable.weighty = 1.0;
        gbcScrollSlideTable.gridx = 0;
        gbcScrollSlideTable.gridy = 0;
        gbcScrollSlideTable.weightx = 1.0;
        gbcScrollSlideTable.fill = 1;
        this.add((Component)scrollSlideTable, gbcScrollSlideTable);
        GuiPanel buttonPanel = new GuiPanel();
        GridBagConstraints gbcButtonPanel = new GridBagConstraints();
        gbcButtonPanel.insets = new Insets(0, 5, 0, 0);
        gbcButtonPanel.fill = 1;
        gbcButtonPanel.gridx = 1;
        gbcButtonPanel.gridy = 0;
        this.add((Component)buttonPanel, gbcButtonPanel);
        GridBagLayout gblButtonPanel = new GridBagLayout();
        gblButtonPanel.columnWidths = new int[]{0, 0};
        gblButtonPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gblButtonPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gblButtonPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        buttonPanel.setLayout(gblButtonPanel);
        JButton btnNew = new JButton(J18N.tr("New", new Object[0]));
        btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc501ESlideShowPanel.this.slideTable.addRow();
            }
        });
        GridBagConstraints gbcBtnNew = new GridBagConstraints();
        gbcBtnNew.fill = 2;
        gbcBtnNew.gridx = 0;
        gbcBtnNew.gridy = 0;
        ((Container)buttonPanel).add((Component)btnNew, gbcBtnNew);
        this.btnDel = new JButton(J18N.tr("Delete", new Object[0]));
        this.btnDel.setEnabled(false);
        this.btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc501ESlideShowPanel.this.slideTable.deleteSelected();
            }
        });
        GridBagConstraints gbcBtnDel = new GridBagConstraints();
        gbcBtnDel.fill = 2;
        gbcBtnDel.insets = new Insets(5, 0, 0, 0);
        gbcBtnDel.gridx = 0;
        gbcBtnDel.gridy = 1;
        ((Container)buttonPanel).add((Component)this.btnDel, gbcBtnDel);
        this.btnUp = new JButton("/\\");
        this.btnUp.setEnabled(false);
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc501ESlideShowPanel.this.slideTable.moveSelection(-1);
            }
        });
        GridBagConstraints gbcBtnUp = new GridBagConstraints();
        gbcBtnUp.fill = 2;
        gbcBtnUp.insets = new Insets(5, 0, 0, 0);
        gbcBtnUp.gridx = 0;
        gbcBtnUp.gridy = 2;
        ((Container)buttonPanel).add((Component)this.btnUp, gbcBtnUp);
        this.btnDown = new JButton("\\/");
        this.btnDown.setEnabled(false);
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc501ESlideShowPanel.this.slideTable.moveSelection(1);
            }
        });
        GridBagConstraints gbcBtnDown = new GridBagConstraints();
        gbcBtnDown.fill = 2;
        gbcBtnDown.insets = new Insets(5, 0, 0, 0);
        gbcBtnDown.gridx = 0;
        gbcBtnDown.gridy = 3;
        ((Container)buttonPanel).add((Component)this.btnDown, gbcBtnDown);
        JButton btnSave = new JButton(J18N.tr("Save", new Object[0]));
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc501ESlideShowPanel.this.save();
            }
        });
        GridBagConstraints gbcBtnSave = new GridBagConstraints();
        gbcBtnSave.fill = 2;
        gbcBtnSave.insets = new Insets(5, 0, 0, 0);
        gbcBtnSave.gridx = 0;
        gbcBtnSave.gridy = 4;
        ((Container)buttonPanel).add((Component)btnSave, gbcBtnSave);
        Component verticalStrut = Box.createVerticalStrut(20);
        GridBagConstraints gbcVerticalStrut = new GridBagConstraints();
        gbcVerticalStrut.insets = new Insets(5, 0, 0, 0);
        gbcVerticalStrut.gridx = 0;
        gbcVerticalStrut.gridy = 5;
        ((Container)buttonPanel).add(verticalStrut, gbcVerticalStrut);
        this.init();
    }

    public final Sc501Connection getConnection() {
        return this.connection;
    }

    public final String getPlaylistFilename() {
        return this.playlistFilename;
    }

    private void init() {
        this.setupListeners();
        this.requestTerminalData();
    }

    private void setupListeners() {
        this.registerSc501CommandListener("#getmediasconf", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                GetMediasConf response = (GetMediasConf)command;
                String file = response.getFile();
                if (file.length() > 0) {
                    Sc501ESlideShowPanel.this.onAllMediasConf(Sc501ESlideShowPanel.this.listMedia);
                    Sc501ESlideShowPanel.this.slideTable.setData(Playlist.loadMediaConf(file));
                    Sc501ESlideShowPanel.this.setEnabled(true);
                    Sc501ESlideShowPanel.this.refreshGui();
                }
            }
        });
        this.registerSc501CommandListener("#getlistmedias", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                GetListMedias response = (GetListMedias)command;
                Sc501ESlideShowPanel.this.listMedia = response.getFile();
                Sc501ESlideShowPanel.this.getConnection().writeCommand(new GetMediasConfQ());
            }
        });
        this.registerSc501CommandListener("#getlistmedias_error\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Log.error(J18N.tr("Error getting media from Terminal", new Object[0]), new Object[0]);
            }
        });
    }

    private void onAllMediasConf(String file) {
        LinkedList<String> pathList = new LinkedList<String>();
        try {
            this.gpSettings = GrouppedSettings.loadListMediaConf(file);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Settings intMemSection = this.gpSettings.getSection(INT_MEM_PREFIX);
        if (intMemSection != null) {
            for (Map.Entry<String, String> entry : intMemSection.entrySet()) {
                pathList.add(entry.getValue());
            }
        }
        this.slideTable.setPathList(pathList);
    }

    private void requestTerminalData() {
        this.setEnabled(false);
        this.getConnection().writeCommand(new GetListMediasQ());
    }

    private void refreshGui() {
        boolean hasSelection = this.slideTable.getSelectedRowCount() != 0;
        this.btnDel.setEnabled(hasSelection);
        this.btnUp.setEnabled(hasSelection);
        this.btnDown.setEnabled(hasSelection);
    }

    private void save() {
        int result;
        StringBuilder txtFile = new StringBuilder("<\n");
        List<Slide> slides = this.slideTable.getData();
        if (slides.isEmpty() && (result = JOptionPane.showConfirmDialog(this, J18N.tr("Slideshow is empty. Do you want to proceed?", new Object[0]), Application.APP_NAME, 0, 2)) == 1) {
            this.setEnabled(true);
            return;
        }
        boolean allowEmptyPath = false;
        int count = 0;
        for (Slide s : slides) {
            if (!allowEmptyPath && s.getMainFile().trim().isEmpty()) {
                int result2 = JOptionPane.showConfirmDialog(this, J18N.tr("Slideshow contains an entry with empty path. Do you want to proceed?", new Object[0]), Application.APP_NAME, 0, 2);
                if (result2 == 1) {
                    this.setEnabled(true);
                    return;
                }
                allowEmptyPath = true;
            }
            txtFile.append(String.format("media_" + String.valueOf(count) + "=%s|%d|%d|\n", s.getMainFile().replaceAll("\r", ""), s.getDuration(), s.getRepetitions()));
            ++count;
        }
        txtFile.append(">");
        this.sendFile(txtFile.toString());
    }

    private void sendFile(String data) {
        Sc501Connection connection = this.getConnection();
        SaveMediasConf saveMediasConf = new SaveMediasConf(data);
        connection.writeCommand(saveMediasConf);
    }
}

