/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.bean.Slide;
import br.com.gertec.tc.server.gui.util.NumberSpinnerEditor;
import br.com.gertec.tc.server.util.Util;
import br.org.reconcavo.j18n.J18N;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SlideTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private final NumberSpinnerEditor durationEditor = new NumberSpinnerEditor(1, 0, 60, 1);
    private final NumberSpinnerEditor repetitionEditor = new NumberSpinnerEditor(1, 0, 60, 1);
    private List<String> pathList = null;
    private PathEditor pathEditor = null;

    public SlideTable() {
        this.setModel(new SlideTableModel());
        this.putClientProperty("terminateEditOnFocusLost", true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoCreateRowSorter(false);
        this.setFillsViewportHeight(true);
        this.setSelectionMode(1);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SlideTable.this.onSelection();
            }
        });
    }

    protected void onSelection() {
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    private PathEditor getPathEditor(int row, int column) {
        if (this.pathEditor == null) {
            this.pathEditor = this.pathList == null ? new PathEditor() : new PathEditor(this.pathList, 1, 1);
        }
        return this.pathEditor;
    }

    public void setPathList(List<String> pathList) {
        this.pathList = pathList;
        this.pathEditor = null;
    }

    public List<String> getPathList() {
        return this.pathList;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        switch (column) {
            case 0: {
                return this.getPathEditor(row, column);
            }
            case 1: {
                return this.durationEditor;
            }
            case 2: {
                return this.repetitionEditor;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (!this.isRowSelected(row)) {
            c.setBackground(row % 2 == 0 ? this.getBackground() : UIManager.getColor("Button.background"));
        }
        return c;
    }

    public void addRow() {
        ((SlideTableModel)this.getModel()).addRow();
    }

    public void addRow(Slide slide) {
        ((SlideTableModel)this.getModel()).addSlide(slide);
    }

    public void deleteSelected() {
        int[] rows = this.getSelectedRows();
        ((SlideTableModel)this.getModel()).removeRows(rows[0], rows.length);
    }

    public void moveSelection(int offset) {
        SlideTableModel model = (SlideTableModel)this.getModel();
        int[] rows = this.getSelectedRows();
        if (rows[0] + offset < 0) {
            return;
        }
        if (rows[rows.length - 1] + offset > this.getRowCount() - 1) {
            return;
        }
        model.moveRow(rows[0], rows[rows.length - 1], rows[0] + offset);
        this.setRowSelectionInterval(rows[0] + offset, rows[rows.length - 1] + offset);
    }

    public void setData(List<Slide> data) {
        this.setModel(new SlideTableModel(data));
    }

    public List<Slide> getData() {
        return ((SlideTableModel)this.getModel()).getSlides();
    }

    public static class PathEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        private static JComboBox<String> getCombo(final List<String> pathList, final int row, final int column) {
            final JComboBox<String> combo = new JComboBox<String>();
            combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.myBox(evt);
                }

                protected void myBox(ActionEvent evt) {
                    String ext;
                    if (combo.getSelectedItem() != null && ((ext = combo.getSelectedItem().toString().split("\\.")[1]).equalsIgnoreCase("mp4") || ext.equalsIgnoreCase("mp3"))) {
                        System.out.println("N\u00e3o se aplica : " + row + " - " + column);
                    }
                }
            });
            combo.setModel(new DefaultComboBoxModel<String>(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getElementAt(int index) {
                    return (String)pathList.get(index);
                }

                @Override
                public int getIndexOf(Object anObject) {
                    System.out.println(anObject);
                    for (int i = 0; i < pathList.size(); ++i) {
                        if (!Objects.equals(anObject, pathList.get(i))) continue;
                        return i;
                    }
                    return -1;
                }

                @Override
                public int getSize() {
                    return pathList.size();
                }
            });
            return combo;
        }

        public PathEditor(List<String> pathList, int row, int column) {
            super(PathEditor.getCombo(pathList, row, column));
        }

        public PathEditor() {
            super(new JTextField());
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            if (evt instanceof MouseEvent) {
                return ((MouseEvent)evt).getClickCount() >= 2;
            }
            return true;
        }
    }

    public static class SlideTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final int MAX_SIZE = 254;
        private static final int COLUMN_COUNT = 3;
        public static final int COL_PATH_INDEX = 0;
        public static final int COL_DURATION_INDEX = 1;
        public static final int COL_REPETITION_INDEX = 2;
        private static final String DEFAULT_PATH = "";
        private static final int DEFAULT_DURATION = 1;
        private static final int DEFAULT_REPETITIONS = 1;
        private List<Slide> slides;

        public SlideTableModel() {
            this(new LinkedList<Slide>());
        }

        public SlideTableModel(List<Slide> slides) {
            this.setData(slides);
        }

        public void setData(List<Slide> slides) {
            if (slides == null) {
                throw new IllegalArgumentException("Slides cannot be null");
            }
            this.slides = slides;
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Slide slide = this.slides.get(row);
            switch (column) {
                case 0: {
                    return slide.getMainFile();
                }
                case 1: {
                    return slide.getDuration();
                }
                case 2: {
                    return slide.getRepetitions();
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return J18N.tr("Path", new Object[0]);
                }
                case 1: {
                    return J18N.tr("Duration (seconds)", new Object[0]);
                }
                case 2: {
                    return J18N.tr("Repetition", new Object[0]);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.slides.size();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Slide slide = this.slides.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    slide.setMainFile((String)aValue);
                    break;
                }
                case 1: {
                    slide.setDuration((Integer)aValue);
                    break;
                }
                case 2: {
                    slide.setRepetitions((Integer)aValue);
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public void addSlide(Slide slide) {
            if (slide == null) {
                throw new IllegalArgumentException("Slide cannot be null");
            }
            this.slides.add(slide);
            if (this.slides.size() > 254) {
                this.slides.remove(0);
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsInserted(this.slides.size() - 1, this.slides.size() - 1);
            }
        }

        public final void addRow() {
            this.addSlide(new Slide(DEFAULT_PATH, DEFAULT_PATH, 1, 1));
        }

        public void removeRow(int index) {
            this.slides.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void removeRows(int start, int count) {
            for (int i = 0; i < count; ++i) {
                this.removeRow(start);
            }
        }

        public List<Slide> getSlides() {
            return this.slides;
        }

        public void moveRow(int start, int end, int to) {
            Util.move(this.slides, start, end, to);
        }
    }
}

