/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.util;

import br.org.reconcavo.j18n.J18N;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class EnumCombo<E extends Enum<?>>
extends JComboBox<E> {
    private static final long serialVersionUID = 1L;
    private final Class<E> enumClass;

    public EnumCombo(Class<E> enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("Missing enum class");
        }
        this.enumClass = enumClass;
        this.setModel(new EnumModel());
        this.setRenderer(new EnumListCellRenderer());
    }

    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    private class EnumModel
    extends DefaultComboBoxModel<E> {
        private static final long serialVersionUID = 1L;
        private final List<E> enumList = new ArrayList();

        public EnumModel() {
            for (Enum e : (Enum[])EnumCombo.this.getEnumClass().getEnumConstants()) {
                this.enumList.add(e);
            }
            Collections.sort(this.enumList, new Comparator<E>(){

                @Override
                public int compare(E e1, E e2) {
                    String e1Name = J18N.tr(((Enum)e1).name(), new Object[0]);
                    String e2Name = J18N.tr(((Enum)e2).name(), new Object[0]);
                    return e1Name.compareTo(e2Name);
                }
            });
        }

        @Override
        public void addElement(E anObject) {
            this.enumList.add(anObject);
        }

        @Override
        public E getElementAt(int index) {
            return (Enum)this.enumList.get(index);
        }

        @Override
        public int getIndexOf(Object anObject) {
            return this.enumList.indexOf(anObject);
        }

        @Override
        public int getSize() {
            return this.enumList.size();
        }

        @Override
        public void insertElementAt(E anObject, int index) {
            this.enumList.add(index, anObject);
        }

        @Override
        public void removeAllElements() {
            this.enumList.clear();
        }

        @Override
        public void removeElement(Object anObject) {
            this.enumList.remove(anObject);
        }

        @Override
        public void removeElementAt(int index) {
            this.enumList.remove(index);
        }
    }

    private class EnumListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private EnumListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel superComponent = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                superComponent.setText(J18N.tr(((Enum)value).name(), new Object[0]));
            }
            return superComponent;
        }
    }

    public static class EnumCellEditor<E extends Enum<?>>
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public EnumCellEditor(Class<E> enumClass) {
            super(new EnumCombo<E>(enumClass));
            this.setClickCountToStart(2);
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)anEvent;
                if (keyEvent.getKeyCode() == 525) {
                    return false;
                }
                return super.isCellEditable(anEvent);
            }
            return super.isCellEditable(anEvent);
        }

        private EnumCombo<E> getCombo() {
            return (EnumCombo)this.getComponent();
        }

        @Override
        public Object getCellEditorValue() {
            return this.getCombo().getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            EnumCombo<E> combo = this.getCombo();
            combo.setSelectedItem(value);
            return combo;
        }
    }

    public static class EnumCellRenderer<E extends Enum<?>>
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        protected void setValue(Object value) {
            this.setText(J18N.tr(((Enum)value).name(), new Object[0]));
        }
    }
}

