/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.util;

import br.com.gertec.tc.server.gui.util.GuiNode;
import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.ConnectionListener;
import br.com.gertec.tc.server.protocol.ListenerGroup;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class GuiDialog
extends JDialog
implements GuiNode {
    private static final long serialVersionUID = 1L;
    private Object result = null;
    private boolean disposed = false;
    private final List<GuiNode> childGuiNodes = new LinkedList<GuiNode>();
    private final Object managedObject;
    private final GuiPanel contentPanel = new GuiPanel();

    public GuiDialog() {
        this((Object)null);
    }

    public GuiDialog(Object managedObject) {
        this.contentPanel.setParentNode(this);
        this.setPane(this.contentPanel);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                GuiDialog.this.onClose(GuiDialog.this.result);
            }
        });
        this.managedObject = managedObject;
    }

    public final Object getManagedObject() {
        return this.managedObject;
    }

    public void dispose(Object result) {
        if (!this.disposed) {
            this.disposed = true;
            this.result = result;
            ListenerGroup.getInstance().unregisterListenerGroup(this);
            for (GuiNode guiNode : this.childGuiNodes) {
                guiNode.dispose();
            }
            super.dispose();
        }
    }

    @Override
    public final GuiNode getParentNode() {
        return null;
    }

    @Override
    public final void setParentNode(GuiNode parentNode) {
        throw new UnsupportedOperationException("A dialog is a top-level GUI node");
    }

    @Override
    public void removeChildNode(GuiNode node) {
        if (this.childGuiNodes.contains(node)) {
            this.childGuiNodes.remove(node);
            node.setParentNode(null);
        }
    }

    @Override
    public final void addChildNode(GuiNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (!this.childGuiNodes.contains(node)) {
            this.childGuiNodes.add(node);
            node.setParentNode(this);
        }
    }

    @Override
    public final void dispose() {
        this.dispose(null);
    }

    private void setPane(Container contentPane) {
        super.setContentPane(contentPane);
    }

    @Override
    public final void setContentPane(Container contentPane) {
        throw new UnsupportedOperationException();
    }

    protected void onClose(Object result) {
    }

    public void setDefaultButton(JButton button) {
        this.getRootPane().setDefaultButton(button);
    }

    public void setCancelButton(JButton button) {
        final JButton fButton = button;
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(listener, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void registerSc504CommandListener(short cmdId, CommandListener listener) {
        ListenerGroup.getInstance().registerSc504CommandListener(this, cmdId, listener);
    }

    public void registerSc501CommandListener(String cmdId, CommandListener listener) {
        ListenerGroup.getInstance().registerSc501CommandListener(this, cmdId, listener);
    }

    public void registerListener(ConnectionListener listener) {
        ListenerGroup.getInstance().registerListener((Object)this, listener);
    }

    public void registerListener(Sc504Connection.FileReceiveListener listener) {
        ListenerGroup.getInstance().registerListener((Object)this, listener);
    }

    public void registerListener(Sc504Connection.FileSendListener listener) {
        ListenerGroup.getInstance().registerListener((Object)this, listener);
    }
}

