/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.util;

import br.com.gertec.tc.server.gui.util.GuiNode;
import br.com.gertec.tc.server.protocol.ListenerGroup;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class GuiTabbedPane
extends JTabbedPane
implements GuiNode {
    private static final long serialVersionUID = 1L;
    private final List<Component> childComponents = new LinkedList<Component>();
    private final List<GuiNode> childGuiNodes = new LinkedList<GuiNode>();
    private GuiNode parentNode;

    @Override
    public final GuiNode getParentNode() {
        return this.parentNode;
    }

    @Override
    public final void setParentNode(GuiNode parentNode) {
        if (!Objects.equals(this.parentNode, parentNode)) {
            if (this.getParentNode() != null) {
                this.getParentNode().removeChildNode(this);
            }
            this.parentNode = parentNode;
            if (parentNode != null) {
                parentNode.addChildNode(this);
            }
        }
    }

    @Override
    public void removeChildNode(GuiNode node) {
        if (this.childGuiNodes.contains(node)) {
            this.childGuiNodes.remove(node);
            node.setParentNode(null);
        }
    }

    @Override
    public final void addChildNode(GuiNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (!this.childGuiNodes.contains(node)) {
            this.childGuiNodes.add(node);
            node.setParentNode(this);
        }
    }

    @Override
    public void dispose() {
        ListenerGroup.getInstance().unregisterListenerGroup(this);
        for (GuiNode guiNode : this.childGuiNodes) {
            guiNode.dispose();
        }
    }

    private void addComponent(Component component) {
        if (!this.childComponents.contains(component)) {
            this.childComponents.add(component);
            if (component instanceof GuiNode) {
                GuiNode guiNode = (GuiNode)((Object)component);
                guiNode.setParentNode(this);
            }
        }
    }

    @Override
    public Component add(Component component) {
        Component result = super.add(component);
        this.addComponent(component);
        return result;
    }

    @Override
    public Component add(String title, Component component) {
        Component result = super.add(title, component);
        this.addComponent(component);
        return result;
    }

    @Override
    public Component add(Component component, int index) {
        Component result = super.add(component, index);
        this.addComponent(component);
        return result;
    }

    @Override
    public void add(Component component, Object constraints) {
        super.add(component, constraints);
        this.addComponent(component);
    }

    @Override
    public void add(Component component, Object constraints, int index) {
        super.add(component, constraints, index);
        this.addComponent(component);
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String tip) {
        super.addTab(title, icon, component, tip);
        this.addComponent(component);
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        super.addTab(title, icon, component);
        this.addComponent(component);
    }

    @Override
    public void addTab(String title, Component component) {
        super.addTab(title, component);
        this.addComponent(component);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component component : this.childComponents) {
            component.setEnabled(enabled);
        }
    }
}

