/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.util;

import br.com.gertec.tc.server.Application;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JOptionPane;

public class GuiUtils {
    private GuiUtils() {
    }

    private static void showMessageDialog(final Component parent, final String message, final int messageType) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(parent, message, Application.APP_NAME, messageType);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public static void showErrorMessage(Component parent, String message) {
        GuiUtils.showMessageDialog(parent, message, 0);
    }

    public static void showErrorMessage(String message) {
        GuiUtils.showErrorMessage(null, message);
    }

    public static void showWarningMessage(Component parent, String message) {
        GuiUtils.showMessageDialog(parent, message, 2);
    }

    public static void showWarningMessage(String message) {
        GuiUtils.showWarningMessage(null, message);
    }

    public static void showInfoMessage(Component parent, String message) {
        GuiUtils.showMessageDialog(parent, message, 1);
    }

    public static void showInfoMessage(String message) {
        GuiUtils.showInfoMessage(null, message);
    }
}

