/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.util;

import br.com.gertec.tc.server.util.NamedColor;
import br.org.reconcavo.j18n.J18N;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class NamedColorChooserPanel
extends AbstractColorChooserPanel {
    private static final long serialVersionUID = 3177381174526543409L;
    private List<JToggleButton> colorButtons = new ArrayList<JToggleButton>();
    private Color selectedColor = null;

    @Override
    public void updateChooser() {
        Color color = this.getColorFromModel();
        for (JToggleButton btn : this.colorButtons) {
            btn.setSelected(false);
            if (!color.equals(btn.getBackground())) continue;
            this.selectedColor = btn.getBackground();
            btn.setBorder(new LineBorder(Color.ORANGE, 3));
        }
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new GridLayout(5, 4));
        NamedColorChooserListener listener = new NamedColorChooserListener();
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        for (NamedColor color : NamedColor.values()) {
            JToggleButton tButton = new JToggleButton();
            tButton.addActionListener(listener);
            tButton.setBorder(border);
            tButton.setBackground(new Color(color.getRgb()));
            tButton.setToolTipText(color.name());
            tButton.setPreferredSize(new Dimension(40, 40));
            this.colorButtons.add(tButton);
            this.add(tButton);
        }
    }

    @Override
    public String getDisplayName() {
        return J18N.tr("Color Chooser", new Object[0]);
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    private void clearBorderes() {
        for (JToggleButton button : this.colorButtons) {
            Border emptyBorder = BorderFactory.createEmptyBorder();
            button.setBorder(emptyBorder);
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    class NamedColorChooserListener
    implements ActionListener {
        NamedColorChooserListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NamedColorChooserPanel.this.clearBorderes();
            JToggleButton source = (JToggleButton)e.getSource();
            source.setBorder(new LineBorder(Color.ORANGE, 3));
            NamedColorChooserPanel.this.getColorSelectionModel().setSelectedColor(source.getBackground());
        }
    }
}

