/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.http;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.http.BarcodeServlet;
import br.com.gertec.tc.server.http.PriceXmlServlet;
import br.com.gertec.tc.server.util.Resources;
import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.j18n.J18N;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.eclipse.jetty.apache.jsp.JettyJasperInitializer;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class TcHttpServer {
    static final File WEBROOT_DIR = new File(Application.APP_DIR, "webroot");
    static final URI WEB_ROOT_URI;
    static final String ATTR_SERVER;
    private final List<HttpServerListener> listeners = new LinkedList<HttpServerListener>();
    private final EventLoop eventLoop;
    private Integer port;
    private Server server;
    private URI serverUri;

    public TcHttpServer(EventLoop eventLoop) {
        if (eventLoop == null) {
            throw new IllegalArgumentException("Event-loop cannot be null");
        }
        this.eventLoop = eventLoop;
    }

    public final EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public int getRunningPort() {
        return this.port != null ? this.port : -1;
    }

    public boolean isRunning() {
        return this.server != null && this.server.isRunning();
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    public void start(int port) {
        this.stop();
        this.port = port;
        final int fPort = port;
        Runnable serverThreadRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    TcHttpServer.this.server = new Server();
                    ServerConnector connector = TcHttpServer.this.getConnector(TcHttpServer.this.server, fPort);
                    ServletContextHandler sch = TcHttpServer.this.getServletContextHandler(WEB_ROOT_URI, TcHttpServer.this.getScratchDir());
                    TcHttpServer.this.server.addConnector(connector);
                    TcHttpServer.this.server.setHandler(sch);
                    TcHttpServer.this.server.start();
                    TcHttpServer.this.serverUri = TcHttpServer.this.getServerUri(connector);
                    br.com.gertec.tc.server.log.Log.debug(J18N.tr("HTTP server is running on port %d (URI: %s)", TcHttpServer.this.getRunningPort(), TcHttpServer.this.getServerUri()), new Object[0]);
                    TcHttpServer.this.notifyListenersAboutStart();
                }
                catch (Exception e) {
                    TcHttpServer.this.notifyListenersAboutError(e);
                }
            }
        };
        new Thread(serverThreadRunnable).start();
    }

    public void stop() {
        if (this.isRunning()) {
            try {
                this.server.stop();
                this.notifyListenersAboutStop();
                br.com.gertec.tc.server.log.Log.debug(J18N.tr("HTTP server stopped", new Object[0]), new Object[0]);
            }
            catch (Exception ex) {
                this.notifyListenersAboutError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(HttpServerListener listener) {
        List<HttpServerListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    protected void onBarcodeQuery(InetAddress client, String barcode, Product product) {
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    protected void onError(Throwable error) {
    }

    void notifyListenersAboutBarcodeQuery(final InetAddress client, final String barcode, final Product product) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TcHttpServer.this.onBarcodeQuery(client, barcode, product);
                List list = TcHttpServer.this.listeners;
                synchronized (list) {
                    for (HttpServerListener listener : TcHttpServer.this.listeners) {
                        listener.onBarcodeQuery(TcHttpServer.this, client, barcode, product);
                    }
                }
            }
        };
        this.getEventLoop().invokeLater(runnable);
    }

    private void notifyListenersAboutStart() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TcHttpServer.this.onStart();
                List list = TcHttpServer.this.listeners;
                synchronized (list) {
                    for (HttpServerListener listener : TcHttpServer.this.listeners) {
                        listener.onStart(TcHttpServer.this);
                    }
                }
            }
        };
        this.getEventLoop().invokeLater(runnable);
    }

    private void notifyListenersAboutStop() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TcHttpServer.this.onStop();
                List list = TcHttpServer.this.listeners;
                synchronized (list) {
                    for (HttpServerListener listener : TcHttpServer.this.listeners) {
                        listener.onStop(TcHttpServer.this);
                    }
                }
            }
        };
        this.getEventLoop().invokeLater(runnable);
    }

    private void notifyListenersAboutError(final Throwable t) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TcHttpServer.this.onError(t);
                List list = TcHttpServer.this.listeners;
                synchronized (list) {
                    for (HttpServerListener listener : TcHttpServer.this.listeners) {
                        listener.onError(TcHttpServer.this, t);
                    }
                }
            }
        };
        this.getEventLoop().invokeLater(runnable);
    }

    private ServerConnector getConnector(Server server, int port) {
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(port);
        return connector;
    }

    private File getScratchDir() throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File scratchDir = new File(tempDir.toString(), "embedded-jetty-jsp");
        if (!scratchDir.exists() && !scratchDir.mkdirs()) {
            throw new IOException("Unable to create scratch directory: " + scratchDir);
        }
        return scratchDir;
    }

    private URI getServerUri(ServerConnector connector) throws URISyntaxException {
        String scheme = "http";
        for (ConnectionFactory connectFactory : connector.getConnectionFactories()) {
            if (!connectFactory.getProtocol().equals("SSL-http")) continue;
            scheme = "https";
        }
        String host = connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = connector.getLocalPort();
        this.serverUri = new URI(String.format("%s://%s:%d/", scheme, host, port));
        return this.serverUri;
    }

    private ServletContextHandler getServletContextHandler(URI baseUri, File scratchDir) {
        ServletContextHandler sch = new ServletContextHandler(1);
        sch.setAttribute(ATTR_SERVER, this);
        sch.setContextPath("/");
        sch.setAttribute("javax.servlet.context.tempdir", scratchDir);
        sch.setResourceBase(baseUri.toASCIIString());
        sch.setAttribute(InstanceManager.class.getName(), new SimpleInstanceManager());
        sch.addBean(new JspStarter(sch));
        sch.setClassLoader(this.getUrlClassLoader());
        sch.addServlet(this.jspServletHolder(), "*.jsp");
        sch.addServlet(PriceXmlServlet.class, "/price_checker.xml");
        sch.addServlet(BarcodeServlet.class, "/barcode");
        sch.addServlet(this.defaultServletHolder(baseUri), "/");
        return sch;
    }

    private ClassLoader getUrlClassLoader() {
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        return jspClassLoader;
    }

    private ServletHolder jspServletHolder() {
        ServletHolder holderJsp = new ServletHolder("jsp", JettyJspServlet.class);
        holderJsp.setInitOrder(0);
        holderJsp.setInitParameter("logVerbosityLevel", "DEBUG");
        holderJsp.setInitParameter("fork", "false");
        holderJsp.setInitParameter("xpoweredBy", "false");
        holderJsp.setInitParameter("compilerTargetVM", "1.7");
        holderJsp.setInitParameter("compilerSourceVM", "1.7");
        holderJsp.setInitParameter("keepgenerated", "true");
        return holderJsp;
    }

    private ServletHolder defaultServletHolder(URI baseUri) {
        ServletHolder holderDefault = new ServletHolder("default", DefaultServlet.class);
        holderDefault.setInitParameter("resourceBase", baseUri.toASCIIString());
        holderDefault.setInitParameter("dirAllowed", "true");
        return holderDefault;
    }

    static {
        ATTR_SERVER = TcHttpServer.class.getName() + ".ATTR_SERVER";
        try {
            if (!WEBROOT_DIR.exists() && !WEBROOT_DIR.mkdirs()) {
                throw new RuntimeException("Cannot create webroot dir: " + WEBROOT_DIR.getCanonicalPath());
            }
            WEB_ROOT_URI = WEBROOT_DIR.toURI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        File indexJsp = new File(WEBROOT_DIR, "index.jsp");
        if (!indexJsp.exists()) {
            try {
                Resources.extractEmbeddedZip("/res/default-web-root.zip", WEBROOT_DIR.getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!PriceXmlServlet.PRICE_CHECKER_XML.exists()) {
            try {
                Resources.copyResource("/res/price_checker.xml", PriceXmlServlet.PRICE_CHECKER_XML.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        Log.setLog(new NoLogging());
    }

    public static class NoLogging
    implements Logger {
        @Override
        public String getName() {
            return "no";
        }

        @Override
        public void warn(String msg, Object ... args) {
        }

        @Override
        public void warn(Throwable thrown) {
        }

        @Override
        public void warn(String msg, Throwable thrown) {
        }

        @Override
        public void info(String msg, Object ... args) {
        }

        @Override
        public void info(Throwable thrown) {
        }

        @Override
        public void info(String msg, Throwable thrown) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public void setDebugEnabled(boolean enabled) {
        }

        @Override
        public void debug(String msg, Object ... args) {
        }

        @Override
        public void debug(Throwable thrown) {
        }

        @Override
        public void debug(String msg, Throwable thrown) {
        }

        @Override
        public Logger getLogger(String name) {
            return this;
        }

        @Override
        public void ignore(Throwable ignored) {
        }

        @Override
        public void debug(String msg, long value) {
        }
    }

    public static interface HttpServerListener {
        public void onBarcodeQuery(TcHttpServer var1, InetAddress var2, String var3, Product var4);

        public void onStart(TcHttpServer var1);

        public void onStop(TcHttpServer var1);

        public void onError(TcHttpServer var1, Throwable var2);

        public static class HttpServerAdapter
        implements HttpServerListener {
            @Override
            public void onBarcodeQuery(TcHttpServer server, InetAddress client, String barcode, Product product) {
            }

            @Override
            public void onStart(TcHttpServer server) {
            }

            @Override
            public void onStop(TcHttpServer server) {
            }

            @Override
            public void onError(TcHttpServer server, Throwable t) {
            }
        }
    }

    private static class JspStarter
    extends AbstractLifeCycle
    implements ServletContextHandler.ServletContainerInitializerCaller {
        JettyJasperInitializer sci = new JettyJasperInitializer();
        ServletContextHandler context;

        public JspStarter(ServletContextHandler context) {
            this.context = context;
            this.context.setAttribute("org.apache.tomcat.JarScanner", new StandardJarScanner());
        }

        @Override
        protected void doStart() throws Exception {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.context.getClassLoader());
            try {
                this.sci.onStartup(null, this.context.getServletContext());
                super.doStart();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }
}

