/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.ConnectionListener;
import br.com.gertec.tc.server.protocol.GenericTc;
import br.com.gertec.tc.server.protocol.ListenerGroup;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.util.IdleTimer;
import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.event.Timer;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.event.comm.socket.RawSocketConnection;
import br.org.reconcavo.event.comm.socket.SocketCmdConnection;
import br.org.reconcavo.j18n.J18N;
import java.util.Objects;

public abstract class AbstractTcConnection
extends SocketCmdConnection {
    protected static final long DEFAULT_WRITE_WAIT_TIMEOUT = 5000L;
    private static final long IDLE_TIMEOUT = 15000L;
    private static final long LIVE_INTERVAL = 10000L;
    private GenericTc terminal;
    private final Timer liveTimer;
    private final IdleTimer idleTimer;

    public AbstractTcConnection(EventLoop eventLoop) {
        super(new RawSocketConnection(eventLoop));
        this.idleTimer = new IdleTimer(eventLoop, 15000L, "idleTimer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onIdleTimeout() {
                AbstractTcConnection abstractTcConnection = AbstractTcConnection.this;
                synchronized (abstractTcConnection) {
                    AbstractTcConnection.this.onConnectionTimeout(AbstractTcConnection.this.idleTimer);
                }
            }
        };
        this.liveTimer = new Timer(this.getEventLoop(), "liveTimer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onTimeout() {
                super.onTimeout();
                AbstractTcConnection abstractTcConnection = AbstractTcConnection.this;
                synchronized (abstractTcConnection) {
                    AbstractTcConnection.this.checkLive();
                }
            }
        };
    }

    public final GenericTc getTerminal() {
        return this.terminal;
    }

    protected final void setTerminal(GenericTc terminal) {
        this.terminal = terminal;
        terminal.setConnection(this);
    }

    protected void onConnectionTimeout(IdleTimer idleTimer) {
        if (this.getLocalPort() != 6503) {
            this.close();
            Log.debug(J18N.tr("Connection closed with client %s due to", new Object[0]) + J18N.tr(" CONNECTION_TIMEOUT", new Object[0]), this.getInetAddress().getHostAddress());
        }
    }

    public abstract void sendRestartTerminal();

    @Override
    protected void onOpen() {
        super.onOpen();
        this.idleTimer.start();
    }

    @Override
    protected void onCommandRead(Command command) {
        super.onCommandRead(command);
        this.idleTimer.resetTimer();
    }

    protected abstract void checkLive();

    protected void onHandshakeCompleted() {
        if (this.getLocalPort() != 6503) {
            this.liveTimer.start(10000L);
        }
    }

    @Override
    protected void onClose() {
        this.liveTimer.stop();
        this.idleTimer.stop();
        super.onClose();
        for (ConnectionListener listener : ListenerGroup.getInstance().getAllConnectionListeners()) {
            listener.onClose(this);
        }
    }

    public boolean isSc504() {
        return this.getTerminal().isSc504();
    }

    public boolean isSc501() {
        return this.getTerminal().isSc501();
    }

    public boolean isSc501Media() {
        return this.getTerminal().isTcWithMedia();
    }

    public boolean isLiveTimerActive() {
        return this.liveTimer.isActive();
    }

    public void enableLiveTimer(boolean enable) {
        if (!Objects.equals(this.isLiveTimerActive(), enable)) {
            if (enable) {
                this.liveTimer.start();
                this.idleTimer.start();
            } else {
                this.liveTimer.stop();
                this.idleTimer.stop();
            }
            this.onLiveTimerChanged(enable);
        }
    }

    protected void onLiveTimerChanged(boolean enabled) {
    }

    public TerminalType getTerminalType() {
        return this.getTerminal().getType();
    }
}

