/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol;

import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.ConnectionListener;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import br.com.gertec.tc.server.util.ListenerMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ListenerGroup {
    private static ListenerGroup singleton;
    private final Map<Object, Group> listenerGroups = new HashMap<Object, Group>();

    public static ListenerGroup getInstance() {
        if (singleton == null) {
            singleton = new ListenerGroup();
        }
        return singleton;
    }

    private ListenerGroup() {
    }

    private Group getListenerGroup(Object groupCaller) {
        Group group = this.listenerGroups.get(groupCaller);
        if (group == null) {
            group = new Group();
            this.listenerGroups.put(groupCaller, group);
        }
        return group;
    }

    private List<CommandListener> __getAllCommandListeners(short cmdId) {
        LinkedList<CommandListener> result = new LinkedList<CommandListener>();
        for (Map.Entry<Object, Group> entry : this.listenerGroups.entrySet()) {
            Group group = entry.getValue();
            result.addAll(group.getListeners504().getListeners(cmdId));
        }
        return Collections.unmodifiableList(result);
    }

    public List<CommandListener> getAllCommandListeners(Tc504Command command) {
        return this.__getAllCommandListeners(command.getId());
    }

    private List<CommandListener> __getAllCommandListeners(String cmdId) {
        LinkedList<CommandListener> result = new LinkedList<CommandListener>();
        for (Map.Entry<Object, Group> entry : this.listenerGroups.entrySet()) {
            Group group = entry.getValue();
            result.addAll(group.getListeners501().getListeners(cmdId));
        }
        return result;
    }

    public List<CommandListener> getAllCommandListeners(AbstractSc501Command command) {
        return this.__getAllCommandListeners(command.getId());
    }

    public List<ConnectionListener> getAllConnectionListeners() {
        LinkedList<ConnectionListener> result = new LinkedList<ConnectionListener>();
        for (Map.Entry<Object, Group> entry : this.listenerGroups.entrySet()) {
            Group group = entry.getValue();
            result.addAll(group.getConnListeners());
        }
        return Collections.unmodifiableList(result);
    }

    public List<Sc504Connection.FileReceiveListener> getAllFileReceiveListeners() {
        ArrayList<Sc504Connection.FileReceiveListener> result = new ArrayList<Sc504Connection.FileReceiveListener>();
        for (Map.Entry<Object, Group> entry : this.listenerGroups.entrySet()) {
            Group group = entry.getValue();
            result.addAll(group.getFileReceiveListeners());
        }
        return Collections.unmodifiableList(result);
    }

    public List<Sc504Connection.FileSendListener> getAllFileSendListeners() {
        ArrayList<Sc504Connection.FileSendListener> result = new ArrayList<Sc504Connection.FileSendListener>();
        for (Map.Entry<Object, Group> entry : this.listenerGroups.entrySet()) {
            Group group = entry.getValue();
            result.addAll(group.getFileSendListeners());
        }
        return Collections.unmodifiableList(result);
    }

    public void registerSc504CommandListener(Object groupCaller, short cmdId, CommandListener listener) {
        if (groupCaller == this) {
            throw new IllegalArgumentException(String.format("Group caller instance cannot be a %s instance", Group.class.getName()));
        }
        this.getListenerGroup(groupCaller).getListeners504().addListener(cmdId, listener);
    }

    public void registerSc501CommandListener(Object groupCaller, String cmdId, CommandListener listener) {
        if (groupCaller == this) {
            throw new IllegalArgumentException(String.format("Group caller instance cannot be a %s instance", Group.class.getName()));
        }
        this.getListenerGroup(groupCaller).getListeners501().addListener(cmdId, listener);
    }

    public void registerListener(Object groupCaller, ConnectionListener listener) {
        if (groupCaller == this) {
            throw new IllegalArgumentException(String.format("Group caller instance cannot be a %s instance", Group.class.getName()));
        }
        List<ConnectionListener> listeners = this.getListenerGroup(groupCaller).getConnListeners();
        if (!listeners.contains(listeners)) {
            listeners.add(listener);
        }
    }

    public void registerListener(Object groupCaller, Sc504Connection.FileReceiveListener listener) {
        if (groupCaller == this) {
            throw new IllegalArgumentException(String.format("Group caller instance cannot be a %s instance", Group.class.getName()));
        }
        List<Sc504Connection.FileReceiveListener> listeners = this.getListenerGroup(groupCaller).getFileReceiveListeners();
        if (!listeners.contains(listeners)) {
            listeners.add(listener);
        }
    }

    public void registerListener(Object groupCaller, Sc504Connection.FileSendListener listener) {
        if (groupCaller == this) {
            throw new IllegalArgumentException(String.format("Group caller instance cannot be a %s instance", Group.class.getName()));
        }
        List<Sc504Connection.FileSendListener> listeners = this.getListenerGroup(groupCaller).getFileSendListeners();
        if (!listeners.contains(listeners)) {
            listeners.add(listener);
        }
    }

    public void unregisterListenerGroup(Object groupCaller) {
        this.listenerGroups.remove(groupCaller);
    }

    private static class Group {
        private final ListenerMap<String, CommandListener> listeners501 = new ListenerMap();
        private final ListenerMap<Short, CommandListener> listeners504 = new ListenerMap();
        private final List<ConnectionListener> connListeners = new LinkedList<ConnectionListener>();
        private final List<Sc504Connection.FileReceiveListener> fileReceiveListeners = new LinkedList<Sc504Connection.FileReceiveListener>();
        private final List<Sc504Connection.FileSendListener> fileSendListeners = new LinkedList<Sc504Connection.FileSendListener>();

        private Group() {
        }

        public ListenerMap<String, CommandListener> getListeners501() {
            return this.listeners501;
        }

        public ListenerMap<Short, CommandListener> getListeners504() {
            return this.listeners504;
        }

        public List<ConnectionListener> getConnListeners() {
            return this.connListeners;
        }

        public List<Sc504Connection.FileReceiveListener> getFileReceiveListeners() {
            return this.fileReceiveListeners;
        }

        public List<Sc504Connection.FileSendListener> getFileSendListeners() {
            return this.fileSendListeners;
        }
    }
}

