/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol;

public enum WiFiSecurity {
    NONE,
    WEP,
    WPA,
    WPA2;

    private static final int SC504_NONE = 0;
    private static final int SC504_WEP = 1;
    private static final int SC504_WPA = 2;
    private static final int SC504_WPA2 = 3;
    private static final byte SC501_NONE = 0;
    private static final byte SC501_WEP = 1;
    private static final byte SC501_WPA = 3;
    private static final byte SC501_WPA2 = 4;
    private int sc504Val;
    private byte sc501Val;

    public static WiFiSecurity fromSc504Val(int val) {
        switch (val) {
            case 0: {
                return NONE;
            }
            case 1: {
                return WEP;
            }
            case 2: {
                return WPA;
            }
            case 3: {
                return WPA2;
            }
        }
        return null;
    }

    public static WiFiSecurity fromSc501Val(byte val) {
        switch (val) {
            case 0: {
                return NONE;
            }
            case 1: {
                return WEP;
            }
            case 3: {
                return WPA;
            }
            case 4: {
                return WPA2;
            }
        }
        return null;
    }

    public int getSc504Value() {
        return this.sc504Val;
    }

    public byte getSc501Value() {
        return this.sc501Val;
    }

    public String toString() {
        return this.name();
    }

    static {
        WiFiSecurity.NONE.sc504Val = 0;
        WiFiSecurity.NONE.sc501Val = 0;
        WiFiSecurity.WEP.sc504Val = 1;
        WiFiSecurity.WEP.sc501Val = 1;
        WiFiSecurity.WPA.sc504Val = 2;
        WiFiSecurity.WPA.sc501Val = (byte)3;
        WiFiSecurity.WPA2.sc504Val = 3;
        WiFiSecurity.WPA2.sc501Val = (byte)4;
    }
}

