/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.GenericTc;
import br.com.gertec.tc.server.protocol.ListenerGroup;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.Fw2533;
import br.com.gertec.tc.server.protocol.sc501.listener.Sc501UpdateServerListener;
import br.com.gertec.tc.server.util.UpdateFirmwareUtils;
import br.org.reconcavo.event.Event;
import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.event.Listener;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.event.comm.socket.SocketConnection;
import br.org.reconcavo.event.comm.socket.TcpServer;
import br.org.reconcavo.j18n.J18N;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class Sc501UpdateServer
extends TcpServer {
    public boolean ready = false;
    public static final Event EVT_COMMAND_READ = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            if (listener instanceof Sc501UpdateServerListener && args[2] instanceof AbstractSc501Command) {
                ((Sc501UpdateServerListener)listener).onCommandRead((Sc501UpdateServer)args[0], (Sc501Connection)args[1], (AbstractSc501Command)args[2]);
            }
        }

        @Override
        public void onEvent(Object ... args) {
            if (args[2] instanceof AbstractSc501Command) {
                ((Sc501UpdateServer)args[0]).onCommandRead((Sc501Connection)args[1], (AbstractSc501Command)args[2]);
            }
        }
    };
    public static final Event EVT_COMMAND_WRITE = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            if (listener instanceof Sc501UpdateServerListener && args[2] instanceof AbstractSc501Command) {
                ((Sc501UpdateServerListener)listener).onCommandWrite((Sc501UpdateServer)args[0], (Sc501Connection)args[1], (AbstractSc501Command)args[2]);
            }
        }

        @Override
        public void onEvent(Object ... args) {
            if (args[2] instanceof AbstractSc501Command) {
                ((Sc501UpdateServer)args[0]).onCommandWrite((Sc501Connection)args[1], (AbstractSc501Command)args[2]);
            }
        }
    };
    public static final Event EVT_HANDSHAKE_COMPLETE = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            if (listener instanceof Sc501UpdateServerListener) {
                ((Sc501UpdateServerListener)listener).onHandshakeComplete((Sc501UpdateServer)args[0], (Sc501Connection)args[1]);
            }
        }

        @Override
        public void onEvent(Object ... args) {
            ((Sc501UpdateServer)args[0]).onHandshakeComplete((Sc501Connection)args[1]);
        }
    };

    public Sc501UpdateServer(EventLoop eventLoop) {
        super(eventLoop);
    }

    @Override
    protected SocketConnection getClientConnection(EventLoop serverEventLoop) {
        return new Sc501Connection(serverEventLoop){

            @Override
            protected void onCommandRead(Command command) {
                String idCommand;
                super.onCommandRead(command);
                AbstractSc501Command protocolCmd = (AbstractSc501Command)command;
                Sc501UpdateServer.this.notifyEvent(EVT_COMMAND_READ, Sc501UpdateServer.this, this, protocolCmd);
                Log.debug(J18N.tr("Received command %s from %s", command, this.getInetAddress().getHostAddress()), new Object[0]);
                GenericTc terminal = this.getTerminal();
                switch (idCommand = protocolCmd.getId()) {
                    case "#tc506s": {
                        terminal.getConnection().enableLiveTimer(false);
                        terminal.setType(TerminalType.TC_506_S);
                        terminal.setTerminalVersion(protocolCmd.getTerminalVersion());
                        terminal.setProtocolId(protocolCmd.getId());
                        terminal.setInetAddress(this.getInetAddress());
                        this.writeCommand(new Fw2533());
                        break;
                    }
                    case "#tc406": {
                        terminal.getConnection().enableLiveTimer(false);
                        System.out.println("VOU RECEBER O COMANDO NO SERVIDOR DE UPDATE");
                        terminal.setType(TerminalType.TC_406);
                        terminal.setTerminalVersion(protocolCmd.getTerminalVersion());
                        terminal.setProtocolId(protocolCmd.getId());
                        terminal.setInetAddress(this.getInetAddress());
                        this.writeCommand(new Fw2533());
                        break;
                    }
                    case "#restartsoft_ok\u0000": {
                        Log.debug(J18N.tr("Closing connection (%s) due to restart", this.getInetAddress().getHostAddress()), new Object[0]);
                        this.close();
                        break;
                    }
                    case "#fw2533_ok": {
                        File fl = new File(Application.APP_DIR, (Object)((Object)terminal.getType()) + ".xgh");
                        try {
                            BufferedReader br = new BufferedReader(new FileReader(fl));
                            String path = br.readLine();
                            boolean is_S = Boolean.parseBoolean(br.readLine());
                            if (is_S) {
                                UpdateFirmwareUtils.sendFirmware_S(new File(path), terminal.getConnection());
                                break;
                            }
                            UpdateFirmwareUtils.sendFirmwareBPG2(new File(path), terminal.getConnection());
                            break;
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                    }
                }
            }

            @Override
            protected void onCommandWrite(Command command) {
                super.onCommandWrite(command);
                Sc501UpdateServer.this.notifyEvent(EVT_COMMAND_WRITE, Sc501UpdateServer.this, this, command);
                String terminalTypeStr = this.getTerminalType() == null ? "" : String.format(" (%s)", this.getTerminalType().name());
                Log.debug(J18N.tr("Command sent %s to %s%s", command, this.getInetAddress().getHostAddress(), terminalTypeStr), new Object[0]);
            }
        };
    }

    @Override
    protected void onNewClient(SocketConnection client) {
        super.onNewClient(client);
        Log.debug(J18N.tr("New client: %s", client.getInetAddress()), new Object[0]);
    }

    @Override
    protected void onStart() {
        super.onStart();
        Log.debug(J18N.tr("SC501 Update server is running on port %s", this.getLocalPort()), new Object[0]);
    }

    @Override
    protected void onStop() {
        super.onStop();
        Log.debug(J18N.tr("SC501 Update server stopped", new Object[0]), new Object[0]);
    }

    protected void onCommandRead(Sc501Connection connection, AbstractSc501Command command) {
    }

    protected void onCommandWrite(Sc501Connection connection, AbstractSc501Command command) {
    }

    protected void onHandshakeComplete(Sc501Connection connection) {
    }

    public void registerSc501CascadeCommandListener(String cmdId, CommandListener listener) {
        ListenerGroup.getInstance().registerSc501CommandListener(this + "sc501CascadeCommands", cmdId, listener);
    }

    public void unregisterSc501CascadeCommandListener() {
        ListenerGroup.getInstance().unregisterListenerGroup(this + "sc501CascadeCommands");
    }
}

