/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc501.Sc501CommDefs;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.IncompleteCommandException;
import br.org.reconcavo.event.comm.DataBuffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class Config02
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private final ConfigParams params = new ConfigParams();

    private Config02() {
        super("#config02");
    }

    public Config02(String serverIp, String terminalIp, String netmask, String line1, String line2, String line3, String line4, int exhibTime) {
        this();
        this.params.serverIp = serverIp;
        this.params.terminalIp = terminalIp;
        this.params.netmask = netmask;
        this.params.line1 = line1;
        this.params.line2 = line2;
        this.params.line3 = line3;
        this.params.line4 = line4;
        this.params.exhibTime = exhibTime;
    }

    public Config02(ConfigParams params) {
        this();
        this.params.serverIp = params.serverIp;
        this.params.terminalIp = params.terminalIp;
        this.params.netmask = params.netmask;
        this.params.line1 = params.line1;
        this.params.line2 = params.line2;
        this.params.line3 = params.line3;
        this.params.line4 = params.line4;
        this.params.exhibTime = params.exhibTime;
    }

    public Config02(DataBuffer dataBuffer) throws IncompleteCommandException {
        this();
        ByteBuffer bb = ByteBuffer.wrap(dataBuffer.copy());
        int dataSize = 0;
        try {
            this.params.serverIp = CommUtils.getProtocolString(bb);
            dataSize += this.params.serverIp.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.terminalIp = CommUtils.getProtocolString(bb);
            dataSize += this.params.terminalIp.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.netmask = CommUtils.getProtocolString(bb);
            dataSize += this.params.netmask.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.line1 = CommUtils.getProtocolString(bb);
            dataSize += this.params.line1.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.line2 = CommUtils.getProtocolString(bb);
            dataSize += this.params.line2.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.line3 = CommUtils.getProtocolString(bb);
            dataSize += this.params.line3.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.line4 = CommUtils.getProtocolString(bb);
            dataSize += this.params.line4.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.exhibTime = CommUtils.getRealByte(bb.get());
            ++dataSize;
            dataBuffer.readBytes(++dataSize);
        }
        catch (BufferUnderflowException ex) {
            throw new IncompleteCommandException(ex);
        }
    }

    public final ConfigParams getParams() {
        return this.params;
    }

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer buffer = new DataBuffer();
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.serverIp);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.terminalIp);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.netmask);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.line1);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.line2);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.line3);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.line4);
        buffer.put(CommUtils.getProtocolByte((byte)this.params.exhibTime));
        return buffer.readBytes();
    }

    @Override
    public String toString() {
        return String.format("%s %s", this.getId(), this.getParams().toString());
    }

    public static class ConfigParams {
        public String serverIp;
        public String terminalIp;
        public String netmask;
        public String line1;
        public String line2;
        public String line3;
        public String line4;
        public int exhibTime;

        public ConfigParams() {
        }

        public ConfigParams(ConfigParams other) {
            this.serverIp = other.serverIp;
            this.terminalIp = other.terminalIp;
            this.netmask = other.netmask;
            this.line1 = other.line1;
            this.line2 = other.line2;
            this.line3 = other.line3;
            this.line4 = other.line4;
            this.exhibTime = other.exhibTime;
        }

        public String toString() {
            return String.format("{ serverIp: %s, terminalIp: %s, netmask: %s, line1: %s, line2: %s, line3: %s, line4: %s, exhibitionTime: %d}", this.serverIp, this.terminalIp, this.netmask, this.line1, this.line2, this.line3, this.line4, this.exhibTime);
        }
    }
}

