/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc501.Sc501CommDefs;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.IncompleteCommandException;
import br.org.reconcavo.event.comm.DataBuffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ExtConfig
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private final ConfigParams params = new ConfigParams();

    private ExtConfig() {
        super("#extconfig");
    }

    public ExtConfig(String serverIp, String terminalIp, String netmask, String gateway, String terminalName, String line1, String line2, int exhibTime, boolean dynamicIp) {
        this();
        this.params.serverIp = serverIp;
        this.params.terminalIp = terminalIp;
        this.params.netmask = netmask;
        this.params.gateway = gateway;
        this.params.terminalName = terminalName;
        this.params.line1 = line1;
        this.params.line2 = line2;
        this.params.dynamicIp = dynamicIp;
        this.params.exhibTime = exhibTime;
    }

    public ExtConfig(ConfigParams params) {
        this(params.serverIp, params.terminalIp, params.netmask, params.gateway, params.terminalName, params.line1, params.line2, params.exhibTime, params.dynamicIp);
    }

    public ExtConfig(DataBuffer dataBuffer) throws IncompleteCommandException {
        this();
        ByteBuffer bb = ByteBuffer.wrap(dataBuffer.copy());
        int dataSize = 0;
        try {
            this.params.serverIp = CommUtils.getProtocolString(bb);
            dataSize += this.params.serverIp.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.terminalIp = CommUtils.getProtocolString(bb);
            dataSize += this.params.terminalIp.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.netmask = CommUtils.getProtocolString(bb);
            dataSize += this.params.netmask.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.gateway = CommUtils.getProtocolString(bb);
            dataSize += this.params.gateway.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            String notSupported = CommUtils.getProtocolString(bb);
            dataSize += notSupported.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.terminalName = CommUtils.getProtocolString(bb);
            dataSize += this.params.terminalName.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.line1 = CommUtils.getProtocolString(bb);
            dataSize += this.params.line1.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.line2 = CommUtils.getProtocolString(bb);
            dataSize += this.params.line2.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            notSupported = CommUtils.getProtocolString(bb);
            dataSize += notSupported.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            notSupported = CommUtils.getProtocolString(bb);
            dataSize += notSupported.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            notSupported = CommUtils.getProtocolString(bb);
            dataSize += notSupported.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.params.exhibTime = CommUtils.getRealByte(bb.get());
            ++dataSize;
            boolean bl = this.params.dynamicIp = CommUtils.getRealByte(bb.get()) == 1;
            if (dataBuffer.available() - ++dataSize <= 2 && dataBuffer.available() - dataSize > 0 && dataBuffer.available() - ++dataSize == 1) {
                ++dataSize;
            }
            dataBuffer.readBytes(dataSize);
        }
        catch (BufferUnderflowException ex) {
            throw new IncompleteCommandException(ex);
        }
    }

    public final ConfigParams getParams() {
        return this.params;
    }

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer buffer = new DataBuffer();
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.serverIp);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.terminalIp);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.netmask);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.gateway);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.terminalName);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.line1);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.line2);
        buffer.put(this.params.dynamicIp ? (byte)1 : 0);
        buffer.put(CommUtils.getProtocolByte((byte)this.params.exhibTime));
        return buffer.readBytes();
    }

    public static class ConfigParams {
        public String serverIp;
        public String terminalIp;
        public String netmask;
        public String gateway;
        public String terminalName;
        public String line1;
        public String line2;
        public int exhibTime;
        public boolean dynamicIp;

        public ConfigParams() {
        }

        public ConfigParams(ConfigParams other) {
            this.serverIp = other.serverIp;
            this.terminalIp = other.terminalIp;
            this.netmask = other.netmask;
            this.gateway = other.gateway;
            this.terminalName = other.terminalName;
            this.line1 = other.line1;
            this.line2 = other.line2;
            this.exhibTime = other.exhibTime;
            this.dynamicIp = other.dynamicIp;
        }
    }
}

