/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.org.reconcavo.event.comm.DataBuffer;

public class ImageHeader
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    public static final short INDEX_IMMEDIATELY = 0;
    public static final short INDEX_CLEAR = 255;
    private short index;
    private short loops;
    private short delay;
    private short frames;
    private int frameSize;
    private int checksum;
    private byte separator = (byte)23;

    public ImageHeader() {
        super("#img");
    }

    public void setHeader(short index, short loops, short delay, short frames, int frameSize, int checksum) {
        this.index = index;
        this.loops = loops;
        this.delay = delay;
        this.frames = frames;
        this.frameSize = frameSize;
        this.checksum = checksum;
    }

    public void setHeader(int index, int loops, int delay, int frames, int frameSize, int checksum) {
        this.index = (short)index;
        this.loops = (short)loops;
        this.delay = (short)delay;
        this.frames = (short)frames;
        this.frameSize = frameSize;
        this.checksum = checksum;
    }

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer dataBuffer = new DataBuffer();
        String header = new String();
        header = header + String.format("%02X", this.index);
        header = header + String.format("%02X", this.loops);
        header = header + String.format("%02X", this.delay);
        header = header + String.format("%02X", this.frames);
        header = header + String.format("%04X", this.frameSize);
        header = header + String.format("%04X", this.checksum);
        dataBuffer.putString(header);
        dataBuffer.put(this.separator);
        return dataBuffer.readBytes();
    }

    @Override
    public String toString() {
        return String.format("%s (index: %d, loops: %d, delay: %d, frames: %d, frameSize: %d)", "#img", this.index, this.loops, this.delay, this.frames, this.frameSize);
    }
}

