/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc501.Sc501CommDefs;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.IncompleteCommandException;
import br.org.reconcavo.event.comm.DataBuffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class PegaMacAddr
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private String macAddress;
    private byte iface;

    private PegaMacAddr() {
        super("#macaddr");
    }

    public PegaMacAddr(String macAddress, byte iface) {
        this();
        if (macAddress == null || macAddress.isEmpty()) {
            throw new IllegalArgumentException("Null/Empty macAddress");
        }
        this.macAddress = macAddress;
        this.iface = iface;
    }

    public PegaMacAddr(DataBuffer dataBuffer) throws IncompleteCommandException {
        this();
        ByteBuffer bb = ByteBuffer.wrap(dataBuffer.copy());
        int dataSize = 0;
        try {
            this.iface = CommUtils.getRealByte(bb.get());
            ++dataSize;
            this.macAddress = CommUtils.getProtocolString(bb);
            dataSize += this.macAddress.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            dataBuffer.readBytes(++dataSize);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public byte getIface() {
        return this.iface;
    }

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer dataBuffer = new DataBuffer();
        CommUtils.putProtocolStringIntoBuffer(dataBuffer, this.getMacAddress());
        dataBuffer.put(CommUtils.getProtocolByte(this.iface));
        return dataBuffer.readBytes();
    }
}

