/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.ExtConfig;
import br.org.reconcavo.event.comm.DataBuffer;
import java.nio.ByteBuffer;

public class RExtConf
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private final ExtConfig.ConfigParams configParams = new ExtConfig.ConfigParams();

    private RExtConf() {
        super("#rextconf");
    }

    public RExtConf(String serverIp, String terminalIp, String netmask, String gateway, String terminalName, String line1, String line2, int exhibTime, boolean dynamicIp) {
        this();
        this.configParams.serverIp = serverIp;
        this.configParams.terminalIp = terminalIp;
        this.configParams.netmask = netmask;
        this.configParams.gateway = gateway;
        this.configParams.terminalName = terminalName;
        this.configParams.line1 = line1;
        this.configParams.line2 = line2;
        this.configParams.exhibTime = exhibTime;
        this.configParams.dynamicIp = dynamicIp;
    }

    public RExtConf(ByteBuffer buffer) {
        this();
        this.configParams.serverIp = CommUtils.getProtocolString(buffer);
        this.configParams.terminalIp = CommUtils.getProtocolString(buffer);
        this.configParams.netmask = CommUtils.getProtocolString(buffer);
        this.configParams.gateway = CommUtils.getProtocolString(buffer);
        this.configParams.terminalName = CommUtils.getProtocolString(buffer);
        this.configParams.line1 = CommUtils.getProtocolString(buffer);
        this.configParams.line2 = CommUtils.getProtocolString(buffer);
        this.configParams.exhibTime = CommUtils.getProtocolByte(buffer.get());
        this.configParams.dynamicIp = CommUtils.getProtocolByte(buffer.get()) == 1;
    }

    public RExtConf(ExtConfig.ConfigParams params) {
        this(params.serverIp, params.terminalIp, params.netmask, params.gateway, params.terminalName, params.line1, params.line2, params.exhibTime, params.dynamicIp);
    }

    public final ExtConfig.ConfigParams getParams() {
        return this.configParams;
    }

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer buffer = new DataBuffer();
        this.checkIfIsComplete();
        CommUtils.putProtocolStringIntoBuffer(buffer, this.configParams.serverIp);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.configParams.terminalIp);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.configParams.netmask);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.configParams.gateway);
        CommUtils.putProtocolStringIntoBuffer(buffer, "");
        CommUtils.putProtocolStringIntoBuffer(buffer, this.configParams.terminalName);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.configParams.line1);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.configParams.line2);
        CommUtils.putProtocolStringIntoBuffer(buffer, "");
        CommUtils.putProtocolStringIntoBuffer(buffer, "");
        CommUtils.putProtocolStringIntoBuffer(buffer, "");
        buffer.put(CommUtils.getProtocolByte(this.configParams.exhibTime > 0 ? (byte)this.configParams.exhibTime : (byte)1));
        buffer.put(CommUtils.getProtocolByte(this.configParams.dynamicIp ? (byte)1 : 0));
        buffer.put((byte)0);
        return buffer.readBytes();
    }

    private void checkIfIsComplete() {
        if (this.configParams.serverIp == null) {
            throw new RuntimeException("Server Ip is null.");
        }
        if (this.configParams.terminalIp == null) {
            throw new RuntimeException("Terminal Ip is null.");
        }
        if (this.configParams.netmask == null) {
            throw new RuntimeException("netmask is null.");
        }
        if (this.configParams.gateway == null) {
            throw new RuntimeException("gateway is null.");
        }
        if (this.configParams.terminalName == null) {
            throw new RuntimeException("terminal name is null.");
        }
        if (this.configParams.line1 == null) {
            throw new RuntimeException("line 1 is null.");
        }
        if (this.configParams.line2 == null) {
            throw new RuntimeException("line 2 is null.");
        }
    }
}

