/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.org.reconcavo.event.comm.DataBuffer;

public class RUpdConfig
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private final UpdConfigParams params;

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer buffer = new DataBuffer();
        this.checkIfIsComplete();
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.gateway);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.dns);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.terminalName);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.unused1);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.unused2);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.unused3);
        return buffer.readBytes();
    }

    private void checkIfIsComplete() {
        if (this.params.gateway == null) {
            throw new RuntimeException("Gateway is null");
        }
        if (this.params.dns == null) {
            throw new RuntimeException("dns is null");
        }
        if (this.params.terminalName == null) {
            throw new RuntimeException("Terminal Name is null.");
        }
        if (this.params.unused1 == null) {
            throw new RuntimeException("unused 1 is null.");
        }
        if (this.params.unused2 == null) {
            throw new RuntimeException("unused 2 is null.");
        }
        if (this.params.unused3 == null) {
            throw new RuntimeException("unused 3 is null.");
        }
    }

    public RUpdConfig(UpdConfigParams params) {
        super("#rupdconfig");
        this.params = params;
    }

    public static class UpdConfigParams {
        public String gateway;
        public String dns;
        public String terminalName;
        public String unused1;
        public String unused2;
        public String unused3;

        public UpdConfigParams() {
        }

        public UpdConfigParams(String gateway, String terminalName) {
            this.gateway = gateway;
            this.terminalName = terminalName;
            this.dns = new String();
            this.unused1 = new String();
            this.unused2 = new String();
            this.unused3 = new String();
        }
    }
}

