/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.WiFiSecurity;
import br.com.gertec.tc.server.protocol.WifiMode;
import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.WlanConfig;
import br.org.reconcavo.event.comm.DataBuffer;

public class RWlanConfig
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private final WlanConfig.ConfigParams params = new WlanConfig.ConfigParams();

    public RWlanConfig() {
        super("#rwlanconfig");
    }

    public RWlanConfig(boolean enabled, WifiMode wifiMode, String ssid, byte channel, WiFiSecurity wifiSecurity, String wepKey) {
        this();
        this.params.enabled = enabled;
        this.params.wifiMode = wifiMode;
        this.params.ssid = ssid;
        this.params.channel = channel;
        this.params.wifiSecurity = wifiSecurity;
        this.params.wepKey = wepKey;
    }

    public final WlanConfig.ConfigParams getParams() {
        return this.params;
    }

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer buffer = new DataBuffer();
        this.checkIfIsComplete();
        buffer.put(CommUtils.getProtocolByte(this.params.enabled ? (byte)1 : 0));
        buffer.put(CommUtils.getProtocolByte(this.params.wifiMode.getSc501Value()));
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.ssid);
        buffer.put(this.params.channel);
        buffer.put(this.params.wifiSecurity.getSc501Value());
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.wepKey);
        buffer.put((byte)0);
        return buffer.readBytes();
    }

    private void checkIfIsComplete() {
        if (this.params.ssid == null) {
            throw new RuntimeException("ssid is null.");
        }
        if (this.params.wepKey == null) {
            throw new RuntimeException("wepKey is null.");
        }
    }
}

