/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.org.reconcavo.event.comm.DataBuffer;

public class SendGIF
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    public static final short INDEX_IMMEDIATELY = 0;
    public static final short INDEX_IMAGE_LOOP = 1;
    public static final short INDEX_PRICE_QUERY = 254;
    public static final short INDEX_CLEAR = 255;
    private short type;
    private short loops;
    private short duration;
    private byte[] imageLength;
    private String imglen;
    private int imageLen;
    private short checksum = 0;
    private byte etb = (byte)23;

    public SendGIF() {
        super("#gif");
        this.imageLength = new byte[3];
    }

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer dataBuffer = new DataBuffer();
        String header = new String();
        header = header + String.format("%02X", this.type);
        header = header + String.format("%02X", this.loops);
        header = header + String.format("%02X", this.duration);
        header = header + String.format("%04X", this.imageLen);
        header = header + String.format("%02X", this.checksum);
        dataBuffer.putString(header);
        dataBuffer.put(this.etb);
        return dataBuffer.readBytes();
    }

    public void setHeader(short type, short loops, short duration, int imageLength) {
        this.type = this.getType(type);
        this.loops = loops;
        this.duration = duration;
        this.setImageLength(imageLength);
        this.setImglen(Integer.toHexString(imageLength));
        this.imageLen = imageLength;
    }

    private void setImageLength(int imageLength) {
        this.imageLength[0] = (byte)(imageLength >> 8 & 0xFF);
        this.imageLength[1] = (byte)(imageLength >> 16 & 0xFF);
        this.imageLength[2] = (byte)(imageLength >> 24 & 0xFF);
    }

    private short getType(short type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 254: {
                return 254;
            }
            case 255: {
                return 255;
            }
        }
        return 0;
    }

    @Override
    public String toString() {
        String header = new String();
        header = header + "#gif";
        header = header + String.format("%02X", this.type);
        header = header + String.format("%02X", this.loops);
        header = header + String.format("%02X", this.duration);
        header = header + String.format("%04X", this.imageLen);
        header = header + String.format("%02X", this.checksum);
        header = header + String.format("%02X", this.etb);
        return header;
    }

    public String getImglen() {
        return this.imglen;
    }

    public void setImglen(String imglen) {
        this.imglen = imglen;
    }
}

