/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.Sc501CommDefs;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.IncompleteCommandException;
import br.org.reconcavo.event.comm.DataBuffer;
import br.org.reconcavo.j18n.J18N;
import java.io.UnsupportedEncodingException;

public class TerminalTypeCommand
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private final String terminalVersion;

    public TerminalTypeCommand(String commandId, String version) {
        super(commandId);
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("Null/Empty terminal version");
        }
        this.terminalVersion = version;
    }

    public TerminalTypeCommand(String commandId, DataBuffer buffer) throws IncompleteCommandException {
        super(commandId);
        byte[] data = buffer.copy();
        String version = null;
        if (data.length <= 1 && data[0] == 0) {
            Log.debug("Clearing a single \\0 out of the input buffer", new Object[0]);
            buffer.clear();
        } else {
            for (int cursor = 0; cursor < data.length; ++cursor) {
                if (data[cursor] != 0) continue;
                version = new String(data, 1, cursor - 1, Sc501CommDefs.DEFAULT_CHARSET);
                Log.debug(J18N.tr("Version: %s", version), new Object[0]);
                break;
            }
        }
        if (version == null) {
            throw new IncompleteCommandException();
        }
        this.terminalVersion = version;
        this.setTerminalVersion(this.terminalVersion);
        buffer.readBytes(2 + this.terminalVersion.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length);
    }

    public TerminalType getTerminalType() {
        return TerminalType.fromSc501Id(this.getId());
    }

    public String getVersion() {
        return this.terminalVersion;
    }

    @Override
    protected byte[] getSerializedPayload() {
        try {
            DataBuffer buffer = new DataBuffer();
            buffer.put((byte)124);
            buffer.putString(this.terminalVersion, Sc501CommDefs.DEFAULT_CHARSET.name());
            buffer.put((byte)0);
            return buffer.readBytes();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

