/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.listener;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.Sc501UpdateServer;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.Barcode;
import br.com.gertec.tc.server.protocol.sc501.listener.Sc501UpdateServerListener;
import br.com.gertec.tc.server.query.QueryExecutor;
import br.com.gertec.tc.server.query.Sc501QueryExecutor;
import br.org.reconcavo.event.comm.socket.SocketConnection;
import br.org.reconcavo.event.comm.socket.TcpServer;
import br.org.reconcavo.j18n.J18N;

public class Sc501UpdateServerListenerImpl
extends Sc501UpdateServerListener.Sc501ServerAdapter
implements Sc501UpdateServerListener {
    @Override
    public void onError(TcpServer server, Throwable error) {
        Log.error(J18N.tr("SC501 server error: %s", error.getMessage()), new Object[0]);
    }

    @Override
    public void onStart(TcpServer server) {
        Log.info(J18N.tr("SC501 server is running on port %d", server.getLocalPort()), new Object[0]);
    }

    @Override
    public void onStop(TcpServer server) {
        Log.warning(J18N.tr("SC501 server stopped", new Object[0]), new Object[0]);
    }

    @Override
    public void onClientDrop(TcpServer server, SocketConnection client) {
        Sc501Connection connection = (Sc501Connection)client;
        Log.warning(J18N.tr("Client drop: %s (%s)", connection.getInetAddress().getHostAddress(), connection.getTerminalType().getMarketName()), new Object[0]);
    }

    @Override
    public void onHandshakeComplete(Sc501UpdateServer server, Sc501Connection connection) {
        String ipAddress = connection.getInetAddress().getHostAddress();
        String marketName = connection.getTerminalType().getMarketName();
        String version = connection.getTerminal().getTerminalVersion();
        String audioStatus = connection.getTerminal().getLogAudioStatus();
        String macETH = connection.getTerminal().getMacAddress();
        String macWifi = connection.getTerminal().getMacWifi();
        Log.info(J18N.tr("Terminal connected: %s (%s - Version %s - Audio Query %s - MAC ETH %s - MAC WIFI %s)", ipAddress, marketName, version, audioStatus, macETH, macWifi), new Object[0]);
    }

    @Override
    public void onCommandRead(Sc501UpdateServer server, Sc501Connection connection, AbstractSc501Command command) {
        QueryExecutor queryExecutor;
        if (!(command instanceof Barcode)) {
            return;
        }
        Barcode cmdBarcode = (Barcode)command;
        TerminalType terminalType = connection.getTerminalType();
        QueryExecutor queryExecutor2 = queryExecutor = terminalType != null ? terminalType.getQueryExecutor() : new Sc501QueryExecutor();
        if (command.getId().contains("\u001d")) {
            String[] dataMatrix = command.getId().split("\u001d");
            String gtin = dataMatrix[0].substring(3, 17);
            if (gtin.startsWith("0")) {
                gtin = dataMatrix[0].substring(4, 17);
            }
            queryExecutor.execute(connection, gtin, command.getId());
        } else {
            String barcode = cmdBarcode.getBarcode().trim();
            queryExecutor.execute(connection, barcode);
        }
    }
}

