/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc504.commands;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc504.commands.DwordCommand;
import br.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import br.org.reconcavo.event.comm.DataBuffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class RIDGetMACAddress
extends DwordCommand
implements Tc504Command.Tc504Response {
    private final int LEN_SC501_PROTOCOL_FORMAT = 38;
    private final int LEN_ADAPTED_PROTOCOL_FORMAT = 35;
    private final int LEN_MAC_ADDRESS = 17;
    private String macEth;
    private byte macEthIsAble;
    private String macWifi;
    private byte macWifiIsAble;

    public RIDGetMACAddress(byte[] data) {
        super((short)219, data);
        DataBuffer dataBuffer = new DataBuffer().put(data);
        ByteBuffer bb = ByteBuffer.wrap(dataBuffer.copy());
        int dataLen = data.length;
        if (dataLen == 38) {
            this.getBySc501Model(bb);
        } else if (dataLen == 35) {
            this.getByAdaptedModel(bb);
        } else {
            this.getBySc501Model(bb);
        }
        dataBuffer.clear();
    }

    private void getByAdaptedModel(ByteBuffer bb) {
        try {
            this.macEthIsAble = 0;
            this.macWifiIsAble = 0;
            this.macEth = CommUtils.getString(bb, 17);
            bb.get();
            this.macWifi = CommUtils.getString(bb, 17);
        }
        catch (BufferUnderflowException ex) {
            Log.warning("Problema de protocolo no comando RIDGetMACAddress", new Object[0]);
        }
    }

    private void getBySc501Model(ByteBuffer bb) {
        try {
            this.macEthIsAble = bb.get();
            byte stringSize = CommUtils.getRealByte(bb.get());
            this.macEth = CommUtils.getString(bb, stringSize);
            this.macWifiIsAble = bb.get();
            stringSize = CommUtils.getRealByte(bb.get());
            this.macWifi = CommUtils.getString(bb, stringSize);
        }
        catch (BufferUnderflowException ex) {
            Log.warning("Problema de protocolo no comando RIDGetMACAddress", new Object[0]);
        }
    }

    public String getMacEth() {
        return this.macEth;
    }

    public byte getMacEthIsAble() {
        return this.macEthIsAble;
    }

    public String getMacWifi() {
        return this.macWifi;
    }

    public byte getMacWifiIsAble() {
        return this.macWifiIsAble;
    }
}

