/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc504.commands;

import br.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import br.com.gertec.tc.server.util.Util;
import br.org.reconcavo.event.comm.DataBuffer;
import java.io.Serializable;

public class RIDvGetUID
extends Tc504Command
implements Tc504Command.Tc504Response {
    private static final long serialVersionUID = 1L;
    private static final int TERMINAL_NAME_MAX_LENGTH = 32;
    private final ArgUid argUid;

    public RIDvGetUID(byte[] macAddress, String terminalName) {
        this(new ArgUid(macAddress, terminalName).getSerializedData());
    }

    public RIDvGetUID(byte[] data) {
        super((short)28, data);
        this.argUid = new ArgUid(data);
    }

    public final byte[] getMacAddress() {
        return this.getArgUid().macAddress;
    }

    public final String getTerminalName() {
        return this.getArgUid().terminalName;
    }

    protected ArgUid getArgUid() {
        return this.argUid;
    }

    @Override
    public String toString() {
        return String.format("%s (%s)", this.getClass().getSimpleName(), this.getArgUid().toString());
    }

    protected static class ArgUid
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final byte[] macAddress;
        public final String terminalName;

        public ArgUid(byte[] data) {
            DataBuffer buffer = new DataBuffer();
            buffer.put(data);
            this.macAddress = buffer.readBytes(6);
            this.terminalName = Util.getCString(buffer.readString(32));
        }

        public ArgUid(byte[] macAddress, String terminalName) {
            if (macAddress.length != 6) {
                throw new IllegalArgumentException("Invalid MAC address: " + this.toString(macAddress));
            }
            if (terminalName.getBytes().length > 32) {
                throw new IllegalArgumentException("Terminal name is too long: " + terminalName);
            }
            this.macAddress = macAddress;
            this.terminalName = terminalName;
        }

        private String toString(byte[] macAddress) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < macAddress.length; ++i) {
                if (i > 0) {
                    sb.append(":");
                }
                sb.append(String.format("%02x", macAddress[i]));
            }
            return sb.toString();
        }

        public String toString() {
            return String.format("mac: %s, terminalName: %s", this.toString(this.macAddress), this.terminalName);
        }

        public byte[] getSerializedData() {
            DataBuffer buffer = new DataBuffer();
            buffer.put(this.macAddress);
            buffer.putString(this.terminalName, 32);
            return buffer.readBytes();
        }
    }
}

