/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc504.listener;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.Sc504Server;
import br.com.gertec.tc.server.protocol.sc504.commands.IDbReadScanner;
import br.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import br.com.gertec.tc.server.protocol.sc504.listener.Sc504ServerListener;
import br.com.gertec.tc.server.query.QueryExecutor;
import br.com.gertec.tc.server.query.Sc504QueryExecutor;
import br.org.reconcavo.event.comm.socket.SocketConnection;
import br.org.reconcavo.event.comm.socket.TcpServer;
import br.org.reconcavo.j18n.J18N;

public class Sc504ServerListenerImpl
extends Sc504ServerListener.Sc504ServerAdapter
implements Sc504ServerListener {
    @Override
    public void onError(TcpServer server, Throwable error) {
        Log.error(J18N.tr("SC504 server error: %s", error.getMessage()), new Object[0]);
    }

    @Override
    public void onStart(TcpServer server) {
        Log.info(J18N.tr("SC504 server is running on port %d", server.getLocalPort()), new Object[0]);
        Application.SETTINGS.setProperty("LAST_PORT_504", server.getLocalPort());
    }

    @Override
    public void onStop(TcpServer server) {
        Log.warning(J18N.tr("SC504 server stopped", new Object[0]), new Object[0]);
    }

    @Override
    public void onClientDrop(TcpServer server, SocketConnection client) {
        if (client != null) {
            Sc504Connection connection = (Sc504Connection)client;
            Log.warning(J18N.tr("Client drop: %s (%s)", connection.getInetAddress().getHostAddress(), connection.getTerminalType().name()), new Object[0]);
        }
    }

    @Override
    public void onHandshakeComplete(Sc504Server server, Sc504Connection connection) {
        String ipAddress = connection.getInetAddress().getHostAddress();
        String marketName = connection.getTerminalType().getMarketName();
        String version = connection.getTerminal().getTerminalVersion();
        String audioStatus = connection.getTerminal().getLogAudioStatus();
        String macETH = connection.getTerminal().getMacAddress();
        String macWifi = connection.getTerminal().getMacWifi();
        String firmwareVersion = connection.getTerminal().getFirmwareVersion();
        if (firmwareVersion.equals("")) {
            Log.info(J18N.tr("Terminal connected: %s (%s - Version %s - Audio Query %s - MAC ETH %s - MAC WIFI %s)", ipAddress, marketName, version, audioStatus, macETH, macWifi), new Object[0]);
        } else {
            Log.info(J18N.tr("Terminal connected: %s (%s - Version %s - Firmware %s - Audio Query %s - MAC ETH %s - MAC WIFI %s)", ipAddress, marketName, version, firmwareVersion, audioStatus, macETH, macWifi), new Object[0]);
        }
    }

    @Override
    public void onCommandReceived(Sc504Server server, Sc504Connection connection, Tc504Command command) {
        switch (command.getId()) {
            case 89: {
                IDbReadScanner iDbReadScanner = (IDbReadScanner)command;
                String barcode = iDbReadScanner.getCode().trim();
                TerminalType terminalType = connection.getTerminalType();
                QueryExecutor queryExecutor = terminalType != null ? terminalType.getQueryExecutor() : new Sc504QueryExecutor();
                queryExecutor.execute(connection, barcode);
                break;
            }
            case 30: {
                Log.debug(J18N.tr("%s always-live mode for %s (%s)", new Object[0]), connection.isLiveTimerActive() ? J18N.tr("Disabled", new Object[0]) : J18N.tr("Enabled", new Object[0]), connection.getInetAddress().getHostAddress(), connection.getTerminalType().name());
            }
        }
    }
}

