/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.query;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.customer.GifQueryBPG2;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.commands.Jpg;
import br.com.gertec.tc.server.protocol.sc501.commands.NotFound;
import br.com.gertec.tc.server.protocol.sc501.commands.PlayAudioWithMsg;
import br.com.gertec.tc.server.protocol.sc501.commands.ProductResponse;
import br.com.gertec.tc.server.query.QueryExecutor;
import br.com.gertec.tc.server.tts.GenerateAudioImpl;
import br.com.gertec.tc.server.tts.JobGenerateAudio;
import br.com.gertec.tc.server.util.DataBlock;
import br.com.gertec.tc.server.util.Util;
import br.com.gertec.tc.server.util.VolumeConfig;
import br.com.gertec.tc.server.util.WeightBarcode;
import br.com.gertec.tc.server.util.version.VersionsWithAudio;
import br.org.reconcavo.j18n.J18N;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Currency;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.SwingWorker;
import org.h2.message.DbException;

public class BPG2EQueryExecutor
extends QueryExecutor {
    @Override
    public void execute(AbstractTcConnection connection, String barcode) {
        this.doSc501Query(connection, barcode);
    }

    @Override
    public void execute(AbstractTcConnection connection, String barcode, String dataMatrix) {
        BPG2EQueryExecutor.doSc501Query(connection, barcode, dataMatrix);
    }

    private void doSc501Query(final AbstractTcConnection connection, String barcode) {
        String commandMsg = "#playaudiowithmessage".replace("#", "");
        if (barcode.contains(commandMsg)) {
            return;
        }
        try {
            Product product = Product.get(barcode);
            WeightBarcode weightBarcode = new WeightBarcode(barcode, connection);
            if (product == null && weightBarcode.checkWeightBarcode(barcode)) {
                product = weightBarcode.getFormatedProduct();
            } else {
                Application.logQuery(connection.getInetAddress(), product, barcode);
            }
            if (product != null) {
                if (product.getDescription() == null) {
                    product.setDescription("Problema de descri\u00e7\u00e3o.");
                }
                if (product.getPrice1() == null) {
                    product.setPrice1("R$");
                }
                Product produtoClonado = this.clonaProduto(product);
                Exhibition defaultExhibition = Application.SETTINGS.getDefaultExhibition(connection.getTerminalType());
                Exhibition customExhibition = product.getExhibition(connection.getTerminalType());
                product = BPG2EQueryExecutor.formatAndAddPrices(product);
                if (connection.getTerminalType() == TerminalType.TC_406_E) {
                    String description = product.getDescription();
                    String price1 = product.getPrice1();
                    String price2 = product.getPrice2();
                    String priceFormat = this.verifyQueryPriceG2(Util.convertToValidCurrencyFormat(price1), Util.convertToValidCurrencyFormat(price2), true);
                    description = this.verifyQueryDescG2(description);
                    price1 = this.verifyQueryPriceG2(price1, price2, false);
                    GifQueryBPG2 queryGif = new GifQueryBPG2();
                    if (VersionsWithAudio.isTC406Audio(connection.getTerminal().getTerminalVersion()) && DataBlock.verifyDate() && connection.getTerminal().getAudioStatus()) {
                        try {
                            File audio = this.getAudio(description, priceFormat, connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
                            PlayAudioWithMsg commandAudio = new PlayAudioWithMsg("#playaudiowithmessage");
                            commandAudio.setAudioHeader(true, audio, this.getTimeAudioMp3(audio.length()), VolumeConfig.getAudioBpg2(), description, price1);
                            final byte[] audioBytes = this.getBytes(audio);
                            connection.writeCommand(commandAudio);
                            Runnable sendAudio = new Runnable(){

                                @Override
                                public void run() {
                                    connection.write(audioBytes);
                                }
                            };
                            Executors.newSingleThreadScheduledExecutor().schedule(sendAudio, 3000L, TimeUnit.MILLISECONDS);
                        }
                        catch (UnsupportedAudioFileException e) {
                            e.printStackTrace();
                        }
                    } else if (queryGif.searchGif(barcode, connection.getTerminalType())) {
                        queryGif.getJpgQueryStandard(barcode, product, customExhibition);
                        File generatedJpg = new File("QueryImageStandard.jpg");
                        connection.writeCommand(new Jpg(generatedJpg, Jpg.ExhibitionMode.QUERY, 0, 5));
                    } else if (defaultExhibition.getMediaType() == Exhibition.MediaType.SERVER_IMAGE) {
                        queryGif.getJpgQueryStandard(barcode, product, defaultExhibition);
                        File generatedJpg = new File("QueryImageStandard.jpg");
                        connection.writeCommand(new Jpg(generatedJpg, Jpg.ExhibitionMode.QUERY, 0, 5));
                    } else {
                        connection.writeCommand(new ProductResponse(produtoClonado));
                    }
                }
            } else if (VersionsWithAudio.isTC406Audio(connection.getTerminal().getTerminalVersion()) && connection.getTerminalType() == TerminalType.TC_406_E && DataBlock.verifyDate() && connection.getTerminal().getAudioStatus()) {
                try {
                    JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioNotFoundG2("Produto n\u00e3o encontrado", connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
                    final File audio = returnValue.getAudioFinalFile();
                    if (!returnValue.isFromICTS()) {
                        Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
                    }
                    final PlayAudioWithMsg commandAudio = new PlayAudioWithMsg("#playaudiowithmessage");
                    commandAudio.setAudioHeader(false, audio, this.getTimeAudioMp3(audio.length()), (short)3, null, null);
                    SwingWorker<Void, Void> sw1 = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            connection.writeCommand(commandAudio);
                            Thread.sleep(3000L);
                            return null;
                        }

                        @Override
                        protected void done() {
                            connection.write(BPG2EQueryExecutor.this.getBytes(audio));
                        }
                    };
                    sw1.execute();
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
            } else {
                connection.writeCommand(new NotFound());
            }
        }
        catch (DbException e) {
            connection.writeCommand(new NotFound());
            Log.warningTag("QUERY", J18N.tr("Perda de conex\u00e3o com o banco : %s", new Object[0]), e.getMessage());
        }
    }

    private File getAudio(String description, String price1, String filename) throws UnsupportedAudioFileException {
        try {
            JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioQueryG2(description, price1, 1.0, false, filename);
            File audio = returnValue.getAudioFinalFile();
            if (!returnValue.isFromICTS()) {
                Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
            } else if (audio.length() > 45000L && (audio = (returnValue = GenerateAudioImpl.getAudioQueryG2(description, price1, 1.5, false, filename)).getAudioFinalFile()).length() > 45000L) {
                returnValue = GenerateAudioImpl.getAudioQueryG2(GenerateAudioImpl.fileUnavailable, "", filename);
                return returnValue.getAudioFinalFile();
            }
            return audio;
        }
        catch (Exception e) {
            JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioQueryG2(GenerateAudioImpl.fileUnavailable, "", filename);
            if (!returnValue.isFromICTS()) {
                Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
            }
            return returnValue.getAudioFinalFile();
        }
    }

    private static void doSc501Query(AbstractTcConnection connection, String barcode, String dataMatrix) {
        try {
            String dataMatrixTratada;
            boolean isDataMatrix;
            Product product = Product.get(barcode);
            Application.logQuery(connection.getInetAddress(), product, barcode);
            if (product != null) {
                if (product.getDescription() == null) {
                    product.setDescription("Problema de descri\u00e7\u00e3o.");
                }
                if (product.getPrice1() == null) {
                    product.setPrice1("R$");
                }
                connection.writeCommand(new ProductResponse(product));
                Thread.sleep(2000L);
            }
            if (isDataMatrix = Application.checkDataMatrix(dataMatrixTratada = dataMatrix.substring(1))) {
                connection.writeCommand(new ProductResponse(dataMatrixTratada.split("\u001d")));
            }
        }
        catch (DbException e) {
            connection.writeCommand(new NotFound());
        }
        catch (InterruptedException ex) {
            connection.writeCommand(new NotFound());
            Log.warningTag("QUERY", J18N.tr("Problema na leitura do c\u00f3digo 2D: %s", new Object[0]), ex.getMessage());
        }
    }

    private Product clonaProduto(Product product) {
        Product produtoClonado = new Product();
        produtoClonado.setBarcode(product.getBarcode());
        produtoClonado.setDescription(product.getDescription());
        produtoClonado.setPrice1(product.getPrice1());
        if (product.getPrice2() == null) {
            produtoClonado.setPrice2("");
        } else {
            produtoClonado.setPrice2(product.getPrice2());
        }
        return produtoClonado;
    }

    private String verifyQueryDescG2(String desc) {
        if (desc.length() > 80) {
            String[] oldDesc = desc.split("");
            String newDesc = "";
            for (int i = 0; i < 80; ++i) {
                newDesc = newDesc + oldDesc[i];
            }
            return newDesc;
        }
        return desc;
    }

    private String verifyQueryPriceG2(String price1, String price2, boolean isAudioGeneration) {
        String label1 = "";
        String fprice1 = price1;
        String label2 = "";
        String fprice2 = price2;
        try {
            label1 = fprice1 != null && !price1.trim().isEmpty() ? Application.SETTINGS.getProperty("LABEL1") : "";
            label2 = fprice2 != null && !price2.trim().isEmpty() ? Application.SETTINGS.getProperty("LABEL2") : "";
        }
        catch (NullPointerException e) {
            label1 = "";
            label2 = "";
        }
        String prices = label1 + " " + price1 + " " + label2 + " " + price2;
        if (prices.length() > 20 && !isAudioGeneration) {
            String[] oldPrice = prices.split("");
            String newPrice = "";
            for (int i = 0; i < 20; ++i) {
                newPrice = newPrice + oldPrice[i];
            }
            return newPrice;
        }
        return prices;
    }

    private short getTimeAudioMp3(long len) {
        int magicNumber = 10000;
        int timeAudio = Math.round((float)len / (float)magicNumber);
        return (short)timeAudio;
    }

    private byte[] getBytes(File file) {
        int len = (int)file.length();
        byte[] sendBuf = new byte[len];
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(file);
            inFile.read(sendBuf, 0, len);
            inFile.close();
        }
        catch (FileNotFoundException fnfex) {
            System.out.println("APPLICATION -- " + fnfex.getMessage());
        }
        catch (IOException ioex) {
            System.out.println("APPLICATION -- " + ioex.getMessage());
        }
        return sendBuf;
    }

    protected static Product formatAndAddPrices(Product product) {
        String price2;
        Product productClone = new Product().setBarcode(product.getBarcode()).setDescription(product.getDescription()).setPrice1(product.getPrice1()).setPrice2(product.getPrice2());
        String currencyCode = Application.SETTINGS.getProperty("CURRENCY");
        Currency currency = currencyCode != null && !currencyCode.isEmpty() ? Currency.getInstance(currencyCode) : null;
        String currencyPrefix = currency == null ? "" : (currency.getSymbol() == null || currency.getSymbol().isEmpty() ? currency.getCurrencyCode() + "" : currency.getSymbol() + "");
        String price1 = productClone.getPrice1();
        if (price1 != null && !price1.trim().isEmpty()) {
            productClone.setPrice1(String.format("%s%s", currencyPrefix, productClone.getPrice1()));
        }
        if ((price2 = productClone.getPrice2()) != null && !price2.trim().isEmpty()) {
            productClone.setPrice2(String.format("%s%s", currencyPrefix, productClone.getPrice2()));
        }
        return productClone;
    }
}

