/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.query;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.dao.ProductExhibition;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvDispClear;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvPlayAudio;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowImg;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowText;
import br.com.gertec.tc.server.query.Sc504QueryExecutor;
import br.com.gertec.tc.server.tts.GenerateAudioImpl;
import br.com.gertec.tc.server.tts.JobGenerateAudio;
import br.com.gertec.tc.server.util.CommandToImage;
import br.com.gertec.tc.server.util.Util;
import br.com.gertec.tc.server.util.WeightBarcode;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.h2.message.DbException;

public class GerBotQueryExecutor
extends Sc504QueryExecutor {
    @Override
    public void execute(AbstractTcConnection connection, String barcode) {
        this.doSc504Query(connection, barcode);
    }

    private void doSc504Query(AbstractTcConnection connection, String barcode) {
        Product product = Product.get(barcode);
        WeightBarcode weightBarcode = new WeightBarcode(barcode, connection);
        if (product == null && weightBarcode.checkWeightBarcode(barcode)) {
            product = weightBarcode.getFormatedProduct();
        } else {
            Application.logQuery(connection.getInetAddress(), product, barcode);
        }
        if (product == null) {
            File audioFile = this.getAudioByProduct(product, connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
            connection.writeCommand(new IDvShowText("Produto n\u00e3o encontrado"));
            connection.writeCommand(new IDvPlayAudio(connection.getTerminalType(), audioFile));
        } else {
            product = this.verifyProduct(product);
            Application.logQuery(connection.getInetAddress(), product, barcode);
            Exhibition defaultExhibition = Application.SETTINGS.getDefaultExhibition(connection.getTerminalType());
            Exhibition exhibition = ProductExhibition.get(barcode, connection.getTerminalType());
            exhibition = Exhibition.combine(defaultExhibition, exhibition);
            if (exhibition.getMediaType() == Exhibition.MediaType.SERVER_IMAGE) {
                List<Command> cmdList = this.createCommandList(exhibition, product);
                product = GerBotQueryExecutor.formatAndAddPrices(product, cmdList, exhibition);
                connection.writeCommand(new IDvShowImg(Util.getIndexedImageStream(CommandToImage.fromText(cmdList), connection.getTerminalType().getDisplayWidth(), connection.getTerminalType().getDisplayHeight())));
                File audioFile = this.getAudioByProduct(product, connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
                connection.writeCommand(new IDvPlayAudio(connection.getTerminalType(), audioFile));
            } else if (exhibition.getMediaType() == Exhibition.MediaType.TERMINAL_IMAGE) {
                LinkedList<Command> cmdList = new LinkedList<Command>();
                product = GerBotQueryExecutor.formatAndAddPrices(product, cmdList, exhibition);
                String queryProduct = this.concatProductInfo(product);
                File audioFile = this.getAudioByProduct(product, connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
                connection.writeCommand(new IDvShowText(queryProduct));
                connection.writeCommand(new IDvPlayAudio(connection.getTerminalType(), audioFile));
            } else {
                LinkedList<Command> cmdList = new LinkedList<Command>();
                product = GerBotQueryExecutor.formatAndAddPrices(product, cmdList, exhibition);
                String queryProduct = this.concatProductInfo(product);
                File audioFile = this.getAudioByProduct(product, connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
                connection.writeCommand(new IDvShowText(queryProduct));
                connection.writeCommand(new IDvPlayAudio(connection.getTerminalType(), audioFile));
            }
        }
    }

    private List<Command> createCommandList(Exhibition exhibition, Product product) {
        LinkedList<Command> cmdList = new LinkedList<Command>();
        cmdList.add(new IDvDispClear(exhibition.getBgColor().getId()));
        cmdList.add(new IDvShowText(product.getBarcode(), exhibition.getBarcode()));
        String description = product.getDescription();
        if (description != null && !description.trim().isEmpty()) {
            cmdList.add(new IDvShowText(product.getDescription(), exhibition.getDescription()));
        }
        return cmdList;
    }

    public String concatProductInfo(Product product) {
        String separator = "|";
        String concat = product.getDescription();
        concat = concat + separator;
        concat = concat + product.getPrice1();
        concat = concat + separator;
        concat = concat + product.getPrice2();
        return concat;
    }

    private Product verifyProduct(Product product) {
        if (product.getDescription() == null) {
            product.setDescription("Problema de descri\u00e7\u00e3o.");
        }
        if (product.getPrice1() == null) {
            product.setPrice1("");
        }
        if (product.getPrice2() == null) {
            product.setPrice2("");
        }
        return product;
    }

    private File getAudioByProduct(Product product, String filename) {
        File file;
        block7: {
            JobGenerateAudio.ReturnValues returnValue = null;
            file = null;
            try {
                if (product == null) {
                    returnValue = GenerateAudioImpl.getAudioNotFoundGBot("Produto n\u00e3o encontrado", filename);
                    if (!returnValue.isFromICTS()) {
                        Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
                    }
                    file = returnValue.getAudioFinalFile();
                    break block7;
                }
                String label1 = "";
                String price1 = product.getPrice1();
                String label2 = "";
                String price2 = product.getPrice2();
                try {
                    label1 = price1 != null && !price1.trim().isEmpty() ? Application.SETTINGS.getProperty("LABEL1") : "";
                    label2 = price2 != null && !price2.trim().isEmpty() ? Application.SETTINGS.getProperty("LABEL2") : "";
                }
                catch (NullPointerException e) {
                    label1 = "";
                    label2 = "";
                }
                returnValue = GenerateAudioImpl.getAudioQueryGBot(product.getDescription(), label1 + ", " + Util.convertToValidCurrencyFormat(price1), Util.convertToValidCurrencyFormat(price2) + ", " + product.getPrice2(), filename);
                if (!returnValue.isFromICTS()) {
                    Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
                }
                file = returnValue.getAudioFinalFile();
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private Product getProductByBarcode(String barcode) {
        Product product = null;
        try {
            product = Product.get(barcode);
            return product;
        }
        catch (DbException e) {
            Log.warningTag("QUERY", J18N.tr("Perda de conex\u00e3o com o banco : %s", new Object[0]), e.getMessage());
            return null;
        }
    }
}

