/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.query;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.dao.ExhibitionParam;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.dao.ProductExhibition;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.commands.IDShowLocalMedia;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvDispClear;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvPlayAudio;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowFrame;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowImg;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowText;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDbReadScanner;
import br.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import br.com.gertec.tc.server.query.QueryExecutor;
import br.com.gertec.tc.server.tts.GenerateAudioImpl;
import br.com.gertec.tc.server.tts.JobGenerateAudio;
import br.com.gertec.tc.server.util.CommandToImage;
import br.com.gertec.tc.server.util.DataBlock;
import br.com.gertec.tc.server.util.PassParameter;
import br.com.gertec.tc.server.util.Util;
import br.com.gertec.tc.server.util.WeightBarcode;
import br.com.gertec.tc.server.util.version.VersionsWithAudio;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.io.File;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.h2.message.DbException;

public class Sc504QueryExecutor
extends QueryExecutor {
    @Override
    public void execute(AbstractTcConnection connection, String barcode) {
        this.doSc504Query(connection, barcode);
    }

    private void doSc504Query(AbstractTcConnection connection, String barcode) {
        boolean isDataMatrix;
        connection.writeCommand(new RIDbReadScanner());
        LinkedList<Command> cmdList = new LinkedList<Command>();
        Product product = null;
        try {
            product = Product.get(barcode);
            WeightBarcode weightBarcode = new WeightBarcode(barcode, connection);
            if (product == null && weightBarcode.checkWeightBarcode(barcode)) {
                product = weightBarcode.getFormatedProduct();
            } else {
                Application.logQuery(connection.getInetAddress(), product, barcode);
            }
        }
        catch (DbException e) {
            Sc504QueryExecutor.notFoundProduct(connection, cmdList);
            for (Command command : cmdList) {
                connection.writeCommand(command);
            }
            Log.warningTag("QUERY", J18N.tr("Perda de conex\u00e3o com o banco : %s", new Object[0]), e.getMessage());
        }
        Exhibition defaultExhibition = Application.SETTINGS.getDefaultExhibition(connection.getTerminalType());
        if (connection.getTerminalType() == TerminalType.TC_506_MIDIA) {
            ((Sc504Connection)connection).setLenient(true);
        }
        if (isDataMatrix = Application.checkDataMatrix(barcode)) {
            product = this.doDataMatrixQuery(connection, barcode, product, cmdList);
        } else if (product == null) {
            Sc504QueryExecutor.notFoundProduct(connection, cmdList);
        } else {
            if (product.getDescription() == null) {
                product.setDescription("Problema de descri\u00e7\u00e3o.");
            }
            if (product.getPrice1() == null) {
                product.setPrice1("R$");
            }
            Object exhibition = ProductExhibition.get(barcode, connection.getTerminalType());
            exhibition = Exhibition.combine(defaultExhibition, (Exhibition)exhibition);
            cmdList.add(new IDvDispClear(((Exhibition)exhibition).getBgColor().getId()));
            Tc504Command mediaExhibCmd = Sc504QueryExecutor.getMediaExhibCommand((Exhibition)exhibition, connection.getTerminalType());
            if (mediaExhibCmd != null) {
                cmdList.add(mediaExhibCmd);
            }
            cmdList.add(new IDvShowText(product.getBarcode(), ((Exhibition)exhibition).getBarcode()));
            String description = product.getDescription();
            if (description != null && !description.trim().isEmpty()) {
                cmdList.add(new IDvShowText(product.getDescription(), ((Exhibition)exhibition).getDescription()));
            }
            Sc504QueryExecutor.formatAndAddPrices(product, cmdList, (Exhibition)exhibition);
        }
        if (connection.getTerminalType() != TerminalType.TC_504) {
            for (Command command : cmdList) {
                connection.writeCommand(command);
            }
            if (connection.getTerminalType() == TerminalType.TC_506_MIDIA) {
                if (VersionsWithAudio.isTC506MAudio(connection.getTerminal().getTerminalVersion()) && DataBlock.verifyDate()) {
                    ((Sc504Connection)connection).setLenient(false);
                    try {
                        File file;
                        JobGenerateAudio.ReturnValues returnValue = null;
                        PassParameter.setVersion506M(connection.getTerminal().getTerminalVersion());
                        if (product == null) {
                            returnValue = GenerateAudioImpl.getAudioNotFound("Produto n\u00e3o encontrado", connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
                            if (!returnValue.isFromICTS()) {
                                Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
                            }
                            file = returnValue.getAudioFinalFile();
                        } else {
                            try {
                                returnValue = GenerateAudioImpl.getAudioQuery(product.getDescription(), Util.convertToValidCurrencyFormat(product.getPrice1()), Util.convertToValidCurrencyFormat(product.getPrice2()), connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
                                if (!returnValue.isFromICTS()) {
                                    Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
                                }
                                file = returnValue.getAudioFinalFile();
                            }
                            catch (Exception e) {
                                returnValue = GenerateAudioImpl.getAudioQuery(GenerateAudioImpl.fileUnavailable, "", "", connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
                                if (!returnValue.isFromICTS()) {
                                    Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
                                }
                                file = returnValue.getAudioFinalFile();
                            }
                        }
                        IDvPlayAudio command = new IDvPlayAudio(connection.getTerminalType(), file);
                        connection.writeCommand(command);
                    }
                    catch (UnsupportedAudioFileException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            connection.writeCommand(new IDvShowImg(Util.getIndexedImageStream(CommandToImage.fromText(cmdList), connection.getTerminalType().getDisplayWidth(), connection.getTerminalType().getDisplayHeight())));
        }
    }

    protected Product doDataMatrixQuery(AbstractTcConnection connection, String barcode, Product product, List<Command> cmdList) {
        String[] dataMatrix = barcode.split("\u001d");
        String gtin = "GTIN";
        String code = dataMatrix[0].substring(2, 16);
        if (code.startsWith("0")) {
            code = dataMatrix[0].substring(3, 16);
        }
        String regAnvisa = "Registro ANVISA: ";
        String numAnvisa = dataMatrix[0].substring(19);
        String codSerial = "C\u00f3digo Serial: ";
        String numSerial = dataMatrix[1].substring(2);
        String dateValidade = "Validade: ";
        String data = dataMatrix[2].substring(4, 6) + "/" + dataMatrix[2].substring(2, 4);
        String lote = "N\u00b0 Lote: ";
        String numlote = dataMatrix[2].substring(10);
        try {
            product = Product.get(code);
            Application.logQuery(connection.getInetAddress(), product, code);
            if (product != null) {
                Exhibition defaultExhibitionDataMatrix = Application.SETTINGS.getDataMatrixExhibition();
                cmdList.add(new IDvDispClear(defaultExhibitionDataMatrix.getBgColor().getId()));
                cmdList.add(new IDvShowText(product.getDescription(), defaultExhibitionDataMatrix.getDescription()));
                cmdList.add(new IDvShowText(product.getPrice1(), defaultExhibitionDataMatrix.getPrice1()));
                if (product.getPrice2() != null) {
                    cmdList.add(new IDvShowText(product.getPrice2(), defaultExhibitionDataMatrix.getPrice2()));
                }
                cmdList.add(new IDvShowText(gtin, defaultExhibitionDataMatrix.getGTIN()));
                cmdList.add(new IDvShowText(product.getBarcode(), defaultExhibitionDataMatrix.getBarcode()));
                cmdList.add(new IDvShowText(regAnvisa, defaultExhibitionDataMatrix.getRegAnvisa()));
                cmdList.add(new IDvShowText(numAnvisa, defaultExhibitionDataMatrix.getNumAnvisa()));
                cmdList.add(new IDvShowText(codSerial, defaultExhibitionDataMatrix.getCodSerial()));
                cmdList.add(new IDvShowText(numSerial, defaultExhibitionDataMatrix.getNumSerial()));
                cmdList.add(new IDvShowText(dateValidade, defaultExhibitionDataMatrix.getDateVal()));
                cmdList.add(new IDvShowText(data, defaultExhibitionDataMatrix.getData()));
                cmdList.add(new IDvShowText(lote, defaultExhibitionDataMatrix.getLote()));
                cmdList.add(new IDvShowText(numlote, defaultExhibitionDataMatrix.getNumLote()));
            } else {
                this.notFoundProductDataMatrix(cmdList, gtin, code, regAnvisa, numAnvisa, codSerial, numSerial, dateValidade, data, lote, numlote);
            }
        }
        catch (DbException e) {
            for (Command command : cmdList) {
                connection.writeCommand(command);
            }
            Log.warningTag("QUERY", J18N.tr("Perda de conex\u00e3o com o banco : %s", new Object[0]), e.getMessage());
        }
        return product;
    }

    protected static void notFoundProduct(AbstractTcConnection connection, List<Command> cmdList) {
        Exhibition defaultExhibition = Application.SETTINGS.getDefaultExhibition(connection.getTerminalType());
        ExhibitionParam notFoundExhibitionParam = Application.SETTINGS.getNotFoundExhibitionParam(connection.getTerminalType());
        String notFoundMessage = Application.SETTINGS.getProperty("LABEL_NOT_FOUND");
        cmdList.add(new IDvDispClear(defaultExhibition.getBgColor().getId()));
        Tc504Command mediaExhibCmd = Sc504QueryExecutor.getMediaExhibCommand(defaultExhibition, connection.getTerminalType());
        if (mediaExhibCmd != null) {
            cmdList.add(mediaExhibCmd);
        }
        cmdList.add(new IDvShowText(notFoundMessage, notFoundExhibitionParam));
    }

    protected static Tc504Command getMediaExhibCommand(Exhibition exhibition, TerminalType terminalType) {
        if (exhibition.getMediaType() != null) {
            String mediaPath = exhibition.getMediaPath();
            switch (exhibition.getMediaType()) {
                case SERVER_IMAGE: {
                    File mediaFile = mediaPath != null && !mediaPath.isEmpty() ? new File(mediaPath) : null;
                    return mediaFile != null && mediaFile.exists() ? new IDvShowImg(Util.getIndexedImageStream(mediaFile, terminalType.getDisplayWidth(), terminalType.getDisplayHeight())) : null;
                }
                case TERMINAL_IMAGE: {
                    return mediaPath != null && !mediaPath.isEmpty() ? new IDShowLocalMedia(mediaPath) : null;
                }
                case PREIMAGE: {
                    return mediaPath != null && !mediaPath.isEmpty() ? new IDvShowFrame(Integer.parseInt(mediaPath)) : null;
                }
            }
            return null;
        }
        return null;
    }

    protected static Product formatAndAddPrices(Product product, List<Command> cmdList, Exhibition exhibition) {
        String price2;
        Product productClone = new Product().setBarcode(product.getBarcode()).setDescription(product.getDescription()).setPrice1(product.getPrice1()).setPrice2(product.getPrice2());
        String currencyCode = Application.SETTINGS.getProperty("CURRENCY");
        Currency currency = currencyCode != null && !currencyCode.isEmpty() ? Currency.getInstance(currencyCode) : null;
        String currencyPrefix = currency == null ? "" : (currency.getSymbol() == null || currency.getSymbol().isEmpty() ? currency.getCurrencyCode() + "" : currency.getSymbol() + "");
        String price1 = productClone.getPrice1();
        if (price1 != null && !price1.trim().isEmpty()) {
            String label1 = Application.SETTINGS.getProperty("LABEL1");
            if (label1 != null && !label1.isEmpty()) {
                cmdList.add(new IDvShowText(label1, exhibition.getLabel1()));
            }
            productClone.setPrice1(String.format("%s%s", currencyPrefix, productClone.getPrice1()));
        }
        if ((price2 = productClone.getPrice2()) != null && !price2.trim().isEmpty()) {
            String label2 = Application.SETTINGS.getProperty("LABEL2");
            if (label2 != null && !label2.isEmpty()) {
                cmdList.add(new IDvShowText(label2, exhibition.getLabel2()));
            }
            productClone.setPrice2(String.format("%s%s", currencyPrefix, productClone.getPrice2()));
        }
        cmdList.add(new IDvShowText(productClone.getPrice1(), exhibition.getPrice1()));
        cmdList.add(new IDvShowText(productClone.getPrice2(), exhibition.getPrice2()));
        return productClone;
    }

    private void notFoundProductDataMatrix(List<Command> cmdList, String gtin, String code, String regAnvisa, String numAnvisa, String codSerial, String numSerial, String dateValidade, String data, String lote, String numlote) {
        Exhibition defaultExhibitionDataMatrix = Application.SETTINGS.getDataMatrixExhibition();
        cmdList.add(new IDvDispClear(defaultExhibitionDataMatrix.getBgColor().getId()));
        cmdList.add(new IDvShowText(J18N.tr("Product not found", new Object[0]), defaultExhibitionDataMatrix.getDescription()));
        cmdList.add(new IDvShowText(gtin, defaultExhibitionDataMatrix.getGTIN()));
        cmdList.add(new IDvShowText(code, defaultExhibitionDataMatrix.getBarcode()));
        cmdList.add(new IDvShowText(regAnvisa, defaultExhibitionDataMatrix.getRegAnvisa()));
        cmdList.add(new IDvShowText(numAnvisa, defaultExhibitionDataMatrix.getNumAnvisa()));
        cmdList.add(new IDvShowText(codSerial, defaultExhibitionDataMatrix.getCodSerial()));
        cmdList.add(new IDvShowText(numSerial, defaultExhibitionDataMatrix.getNumSerial()));
        cmdList.add(new IDvShowText(dateValidade, defaultExhibitionDataMatrix.getDateVal()));
        cmdList.add(new IDvShowText(data, defaultExhibitionDataMatrix.getData()));
        cmdList.add(new IDvShowText(lote, defaultExhibitionDataMatrix.getLote()));
        cmdList.add(new IDvShowText(numlote, defaultExhibitionDataMatrix.getNumLote()));
    }
}

