/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.query;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.dao.ProductExhibition;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvDispClear;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvPlayAudio;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowImg;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowText;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDbReadScanner;
import br.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import br.com.gertec.tc.server.query.Sc504QueryExecutor;
import br.com.gertec.tc.server.tts.GenerateAudioImpl;
import br.com.gertec.tc.server.tts.JobGenerateAudio;
import br.com.gertec.tc.server.util.CommandToImage;
import br.com.gertec.tc.server.util.DataBlock;
import br.com.gertec.tc.server.util.PassParameter;
import br.com.gertec.tc.server.util.Util;
import br.com.gertec.tc.server.util.WeightBarcode;
import br.com.gertec.tc.server.util.version.VersionsWithAudio;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.io.File;
import java.util.LinkedList;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.h2.message.DbException;

public class TC506MQueryExecutor
extends Sc504QueryExecutor {
    @Override
    public void execute(AbstractTcConnection connection, String barcode) {
        boolean isDataMatrix;
        int newVersion = 400;
        connection.writeCommand(new RIDbReadScanner());
        LinkedList<Command> cmdList = new LinkedList<Command>();
        Product product = null;
        try {
            product = Product.get(barcode);
            WeightBarcode weightBarcode = new WeightBarcode(barcode, connection);
            if (product == null && weightBarcode.checkWeightBarcode(barcode)) {
                product = weightBarcode.getFormatedProduct();
            } else {
                Application.logQuery(connection.getInetAddress(), product, barcode);
            }
        }
        catch (DbException e) {
            TC506MQueryExecutor.notFoundProduct(connection, cmdList);
            for (Command command : cmdList) {
                connection.writeCommand(command);
            }
            Log.warningTag("QUERY", J18N.tr("Perda de conex\u00e3o com o banco : %s", new Object[0]), e.getMessage());
        }
        Exhibition defaultExhibition = Application.SETTINGS.getDefaultExhibition(connection.getTerminalType());
        if (connection.getTerminalType() == TerminalType.TC_506_MIDIA) {
            ((Sc504Connection)connection).setLenient(true);
        }
        if (isDataMatrix = Application.checkDataMatrix(barcode)) {
            product = this.doDataMatrixQuery(connection, barcode, product, cmdList);
        } else if (product == null) {
            TC506MQueryExecutor.notFoundProduct(connection, cmdList);
        } else {
            if (product.getDescription() == null) {
                product.setDescription("Problema de descri\u00e7\u00e3o.");
            }
            if (product.getPrice1() == null) {
                product.setPrice1("R$");
            }
            Object exhibition = ProductExhibition.get(barcode, connection.getTerminalType());
            exhibition = Exhibition.combine(defaultExhibition, (Exhibition)exhibition);
            cmdList.add(new IDvDispClear(((Exhibition)exhibition).getBgColor().getId()));
            Tc504Command mediaExhibCmd = TC506MQueryExecutor.getMediaExhibCommand((Exhibition)exhibition, connection.getTerminalType());
            if (mediaExhibCmd != null) {
                cmdList.add(mediaExhibCmd);
            }
            cmdList.add(new IDvShowText(product.getBarcode(), ((Exhibition)exhibition).getBarcode()));
            String description = product.getDescription();
            if (description != null && !description.trim().isEmpty()) {
                cmdList.add(new IDvShowText(product.getDescription(), ((Exhibition)exhibition).getDescription()));
            }
            product = TC506MQueryExecutor.formatAndAddPrices(product, cmdList, (Exhibition)exhibition);
        }
        if (connection.getTerminalType() != TerminalType.TC_504) {
            for (Command command : cmdList) {
                connection.writeCommand(command);
            }
            if (connection.getTerminalType() == TerminalType.TC_506_MIDIA) {
                if (VersionsWithAudio.isTC506MAudio(connection.getTerminal().getTerminalVersion()) && DataBlock.verifyDate()) {
                    if (Integer.parseInt(connection.getTerminal().getTerminalVersion()) >= 400 && !connection.getTerminal().getAudioStatus()) {
                        Log.debug("TC506MQuery", "Habilitar audio de consulta desabilitado");
                    } else {
                        ((Sc504Connection)connection).setLenient(false);
                        try {
                            File file;
                            JobGenerateAudio.ReturnValues returnValue = null;
                            PassParameter.setVersion506M(connection.getTerminal().getTerminalVersion());
                            if (product == null) {
                                returnValue = GenerateAudioImpl.getAudioNotFound("Produto n\u00e3o encontrado", connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
                                if (!returnValue.isFromICTS()) {
                                    Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
                                }
                                file = returnValue.getAudioFinalFile();
                            } else {
                                String price = this.verifyQueryPrice(product.getPrice1(), product.getPrice2());
                                file = this.getAudio(product.getDescription(), price, connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
                            }
                            IDvPlayAudio command = new IDvPlayAudio(connection.getTerminalType(), file);
                            connection.writeCommand(command);
                        }
                        catch (UnsupportedAudioFileException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        } else {
            connection.writeCommand(new IDvShowImg(Util.getIndexedImageStream(CommandToImage.fromText(cmdList), connection.getTerminalType().getDisplayWidth(), connection.getTerminalType().getDisplayHeight())));
        }
    }

    private File getAudio(String description, String price1, String filename) throws UnsupportedAudioFileException {
        try {
            JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioQuery(description, price1, "", filename);
            File audio = returnValue.getAudioFinalFile();
            return audio;
        }
        catch (Exception e) {
            JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioQuery(GenerateAudioImpl.fileUnavailable, "", "", filename);
            if (!returnValue.isFromICTS()) {
                Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
            }
            return returnValue.getAudioFinalFile();
        }
    }

    private String verifyQueryPrice(String price1, String price2) {
        String label1 = "";
        String fprice1 = price1;
        String label2 = "";
        String fprice2 = price2;
        try {
            label1 = fprice1 != null && !price1.trim().isEmpty() ? Application.SETTINGS.getProperty("LABEL1") : "";
            label2 = fprice2 != null && !price2.trim().isEmpty() ? Application.SETTINGS.getProperty("LABEL2") : "";
        }
        catch (NullPointerException e) {
            label1 = "";
            label2 = "";
        }
        return label1 + " " + price1 + " " + label2 + " " + price2;
    }
}

