/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.tts;

import br.com.gertec.tc.server.customer.audio.online.util.Paths;
import br.com.gertec.tc.server.tts.JobGenerateAudio;
import br.com.gertec.tc.server.util.DataBlock;
import br.com.gertec.tc.server.util.FileUtilities;
import br.com.gertec.tc.server.util.PassParameter;
import br.com.gertec.tc.server.util.VolumeConfig;
import br.com.gertec.tc.server.util.WordsReplace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class GenerateAudioImpl {
    private static final int MIN_SIZE_G2 = 20;
    private static final int MAX_SIZE_G2 = 60;
    private static final int MIN_SIZE_506_S = 20;
    private static final int MAX_SIZE_506_S = 60;
    private static final int MIN_SIZE_506M = 10;
    private static final int MIN_SIZE_GBOT = 10;
    private static final int MAX_SIZE_GBOT = 150;
    private static boolean waitProcess = false;
    private static FileUtilities tempFile = new FileUtilities();
    private static File baseDir = tempFile.getTemporaryAudio();
    private static String srcFile = "\\%s.mp3";
    private static String srcQueryFileWAV = "\\query%s.wav";
    private static String srcQueryFileMP3 = "\\query%s.mp3";
    public static String fileUnavailable = "Esta Descrissao de audio est\u00e1 indisponivel.";
    static double pitch;
    static double speed;

    public static void init() {
    }

    public static JobGenerateAudio.ReturnValues getAudioInputStream(String text) {
        Future<Object> futureAudioStream = Executors.newSingleThreadExecutor().submit(new JobGenerateAudio(text));
        try {
            return (JobGenerateAudio.ReturnValues)futureAudioStream.get(JobGenerateAudio.AUDIO_TIMEOUT.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return JobGenerateAudio.getAudioFromLocalFile();
        }
    }

    public static JobGenerateAudio.ReturnValues getAudioQuery(String description, String price1, String price2, String filename) throws UnsupportedAudioFileException {
        if (DataBlock.verifyDate()) {
            description = GenerateAudioImpl.textCorrectionForICTS(description);
            String text = description + " " + price1 + " " + price2;
            text = text.replaceAll("\\.", ",");
            String newTexto = (text = text.replaceAll("\\s+", " ")).replaceAll(" ", "");
            int len = newTexto.length();
            if (len > PassParameter.getAmountChar506M() || len < 10) {
                text = fileUnavailable;
                PassParameter.setInvalidAmount(true);
            } else {
                PassParameter.setInvalidAmount(false);
            }
            try {
                text = GenerateAudioImpl.replaceWords(text);
                JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioInputStream(text);
                AudioInputStream audioStream = returnValue.getAudioStream();
                AudioSystem.write(audioStream, AudioFileFormat.Type.WAVE, new File(baseDir + String.format(srcFile, filename)));
                File fileMp3 = new File(baseDir + String.format(srcFile, filename));
                GenerateAudioImpl.mp3ToWav(fileMp3, filename);
                GenerateAudioImpl.convertWithFfmpeg(filename);
                File file = new File(baseDir + String.format(srcQueryFileMP3, filename));
                returnValue.setAudioFinalFile(file);
                return returnValue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return null;
    }

    public static JobGenerateAudio.ReturnValues getAudioQueryGBot(String description, String price1, String price2, String filename) throws UnsupportedAudioFileException {
        if (DataBlock.verifyDate()) {
            description = GenerateAudioImpl.textCorrectionForICTS(description);
            String text = description + " " + price1 + " " + price2;
            text = text.replaceAll("\\.", ",");
            String newTexto = (text = text.replaceAll("\\s+", " ")).replaceAll(" ", "");
            int len = newTexto.length();
            if (len > 150 || len < 10) {
                text = fileUnavailable;
            }
            try {
                text = GenerateAudioImpl.replaceWords(text);
                JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioInputStream(text);
                AudioInputStream audioStream = returnValue.getAudioStream();
                AudioSystem.write(audioStream, AudioFileFormat.Type.WAVE, new File(baseDir + String.format(srcFile, filename)));
                File fileMp3 = new File(baseDir + String.format(srcFile, filename));
                GenerateAudioImpl.mp3ToWav(fileMp3, filename);
                GenerateAudioImpl.convertWithFfmpegGBot(filename);
                File file = new File(baseDir + String.format(srcQueryFileMP3, filename));
                returnValue.setAudioFinalFile(file);
                return returnValue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return null;
    }

    public static JobGenerateAudio.ReturnValues getAudioQueryG2(String description, String price1, String filename) throws UnsupportedAudioFileException {
        JobGenerateAudio.ReturnValues returnValue = null;
        try {
            description = GenerateAudioImpl.textCorrectionForICTS(description);
            returnValue = GenerateAudioImpl.getAudioQueryG2(description, price1, 1.0, true, filename);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static JobGenerateAudio.ReturnValues getAudioQueryG2(String description, String price1, double audioSpeed, Boolean hastringValidation, String filename) throws UnsupportedAudioFileException {
        if (DataBlock.verifyDate()) {
            description = GenerateAudioImpl.textCorrectionForICTS(description);
            String text = description + " " + price1;
            text = text.replaceAll("\\.", "");
            text = text.replaceAll("\\s+", " ");
            String newTexto = text.replaceAll(" ", "");
            int len = newTexto.length();
            text = GenerateAudioImpl.replaceWords(text);
            if ((len > 60 || len < 20) && hastringValidation.booleanValue()) {
                text = fileUnavailable;
                PassParameter.setInvalidAmount(true);
            } else {
                PassParameter.setInvalidAmount(false);
            }
            try {
                JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioInputStream(text);
                AudioInputStream audioStream = returnValue.getAudioStream();
                AudioSystem.write(audioStream, AudioFileFormat.Type.WAVE, new File(baseDir + String.format(srcFile, filename)));
                GenerateAudioImpl.convertToG2(audioSpeed, filename, false);
                File fileWav = new File(baseDir + String.format(srcQueryFileWAV, filename));
                returnValue.setAudioFinalFile(fileWav);
                return returnValue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return null;
    }

    public static JobGenerateAudio.ReturnValues getAudioQuery506S(String description, String price1, String filename) {
        description = GenerateAudioImpl.textCorrectionForICTS(description);
        JobGenerateAudio.ReturnValues returnValue = null;
        try {
            returnValue = GenerateAudioImpl.getAudioQuery506S(description, price1, 1.0, false, filename);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static JobGenerateAudio.ReturnValues getAudioQuery506S(String description, String price1, double audioSpeed, Boolean hastringValidation, String filename) throws UnsupportedAudioFileException {
        if (DataBlock.verifyDate()) {
            description = GenerateAudioImpl.textCorrectionForICTS(description);
            String text = description + " " + price1;
            text = text.replaceAll("\\.", "");
            text = text.replaceAll("\\s+", " ");
            String newTexto = text.replaceAll(" ", "");
            int len = newTexto.length();
            text = GenerateAudioImpl.replaceWords(text);
            if ((len > 60 || len < 20) && hastringValidation.booleanValue()) {
                text = fileUnavailable;
                PassParameter.setInvalidAmount(true);
            } else {
                PassParameter.setInvalidAmount(false);
            }
            try {
                JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioInputStream(text);
                AudioInputStream audioStream = returnValue.getAudioStream();
                AudioSystem.write(audioStream, AudioFileFormat.Type.WAVE, new File(baseDir + String.format(srcFile, filename)));
                GenerateAudioImpl.convertToTc506s(audioSpeed, filename, false);
                File fileWav = new File(baseDir + String.format(srcQueryFileWAV, filename));
                returnValue.setAudioFinalFile(fileWav);
                return returnValue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return null;
    }

    private static String textCorrectionForICTS(String description) {
        CharSequence[] arrayString = description.split(" ");
        if (arrayString[0].contains("o\u00e7")) {
            arrayString[0] = ((String)arrayString[0]).replace("o\u00e7", "oss");
        }
        return String.join((CharSequence)" ", arrayString);
    }

    public static JobGenerateAudio.ReturnValues getAudioNotFound(String msgNotFound, String filename) throws UnsupportedAudioFileException {
        if (DataBlock.verifyDate()) {
            try {
                JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioInputStream(msgNotFound);
                AudioInputStream audioStream = returnValue.getAudioStream();
                AudioSystem.write(audioStream, AudioFileFormat.Type.WAVE, new File(baseDir + String.format(srcFile, filename)));
                File fileMp3 = new File(baseDir + String.format(srcFile, filename));
                GenerateAudioImpl.mp3ToWav(fileMp3, filename);
                GenerateAudioImpl.convertWithFfmpeg(filename);
                File fileWav = new File(baseDir + String.format(srcQueryFileMP3, filename));
                returnValue.setAudioFinalFile(fileWav);
                return returnValue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return null;
    }

    public static JobGenerateAudio.ReturnValues getAudioNotFoundGBot(String msgNotFound, String filename) throws UnsupportedAudioFileException {
        if (DataBlock.verifyDate()) {
            try {
                JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioInputStream(msgNotFound);
                AudioInputStream audioStream = returnValue.getAudioStream();
                AudioSystem.write(audioStream, AudioFileFormat.Type.WAVE, new File(baseDir + String.format(srcFile, filename)));
                File fileMp3 = new File(baseDir + String.format(srcFile, filename));
                GenerateAudioImpl.mp3ToWav(fileMp3, filename);
                GenerateAudioImpl.convertWithFfmpegGBot(filename);
                File fileWav = new File(baseDir + String.format(srcQueryFileMP3, filename));
                returnValue.setAudioFinalFile(fileWav);
                return returnValue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return null;
    }

    public static JobGenerateAudio.ReturnValues getAudioNotFoundG2(String msgNotFound, String filename) throws UnsupportedAudioFileException {
        if (DataBlock.verifyDate()) {
            try {
                JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioInputStream(msgNotFound);
                AudioInputStream audioStream = returnValue.getAudioStream();
                AudioSystem.write(audioStream, AudioFileFormat.Type.WAVE, new File(baseDir + String.format(srcFile, filename)));
                GenerateAudioImpl.convertToG2(filename, true);
                File fileWav = new File(baseDir + String.format(srcQueryFileWAV, "1st" + filename));
                returnValue.setAudioFinalFile(fileWav);
                return returnValue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return null;
    }

    public static JobGenerateAudio.ReturnValues getAudioNotFound506S(String msgNotFound, String filename) throws UnsupportedAudioFileException {
        if (DataBlock.verifyDate()) {
            try {
                JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioInputStream(msgNotFound);
                AudioInputStream audioStream = returnValue.getAudioStream();
                AudioSystem.write(audioStream, AudioFileFormat.Type.WAVE, new File(baseDir + String.format(srcFile, filename)));
                GenerateAudioImpl.convertToTc506s(filename, true);
                File fileWav = new File(baseDir + String.format(srcQueryFileWAV, "1st" + filename));
                returnValue.setAudioFinalFile(fileWav);
                return returnValue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return null;
    }

    public static String getPath() {
        return srcQueryFileWAV;
    }

    public static byte[] getBytes(File file) {
        int len = (int)file.length();
        byte[] sendBuf = new byte[len];
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(file);
            inFile.read(sendBuf, 0, len);
            inFile.close();
        }
        catch (FileNotFoundException fnfex) {
            System.out.println(fnfex.getMessage());
        }
        catch (IOException ioex) {
            System.out.println(ioex.getMessage());
        }
        return sendBuf;
    }

    public static void mp3ToWav(File mp3Data, String filename) throws UnsupportedAudioFileException, IOException {
        AudioInputStream mp3Stream = AudioSystem.getAudioInputStream(mp3Data);
        AudioFormat sourceFormat = mp3Stream.getFormat();
        AudioFormat convertFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 24600.0f, 16, sourceFormat.getChannels(), sourceFormat.getChannels() * 2, 24600.0f, false);
        AudioInputStream converted = AudioSystem.getAudioInputStream(convertFormat, mp3Stream);
        AudioSystem.write(converted, AudioFileFormat.Type.WAVE, new File(baseDir + String.format(srcQueryFileWAV, filename)));
    }

    public static void convertToG2(String filename, boolean isNotFound) {
        GenerateAudioImpl.convertToG2(1.0, filename, isNotFound);
    }

    public static void convertToG2(double velocity, String filename, boolean isNotFound) {
        if (velocity < 1.0 || velocity > 2.0) {
            velocity = 1.0;
        }
        String atempoParam = "atempo = " + velocity;
        while (waitProcess) {
        }
        waitProcess = true;
        try {
            File oldFile = new File(baseDir + String.format(srcQueryFileWAV, filename));
            oldFile.delete();
            Process process = new ProcessBuilder(Paths.LOCAL_FFMPEG, "-y", "-i", baseDir + String.format(srcFile, filename), "-filter:a", "volume=" + String.valueOf(VolumeConfig.getFfmpegBpg2()), "-ar", "8000", "-ac", "1", "-af", atempoParam, "-acodec", "pcm_u8", baseDir + String.format(srcQueryFileWAV, "1st" + filename)).start();
            while (process.isAlive()) {
            }
            process.destroyForcibly();
            if (!isNotFound) {
                Process removeSilence = new ProcessBuilder(Paths.LOCAL_FFMPEG, "-y", "-i", Paths.tempAudioDir + String.format(srcQueryFileWAV, "1st" + filename), "-af", "silenceremove=start_periods=1:start_silence=0.1:start_threshold=-96dB,areverse,silenceremove=start_periods=1:start_silence=0.1:start_threshold=-96dB,areverse", "-acodec", "pcm_u8", Paths.tempAudioDir + String.format(srcQueryFileWAV, filename)).start();
                while (removeSilence.isAlive()) {
                }
                removeSilence.destroyForcibly();
            }
            waitProcess = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void convertToTc506s(String filename, boolean isNotFound) {
        GenerateAudioImpl.convertToTc506s(1.0, filename, isNotFound);
    }

    public static void convertToTc506s(double velocity, String filename, boolean isNotFound) {
        if (velocity < 1.0 || velocity > 2.0) {
            velocity = 1.0;
        }
        String atempoParam = "atempo = " + velocity;
        while (waitProcess) {
        }
        waitProcess = true;
        try {
            File oldFile = new File(baseDir + String.format(srcQueryFileWAV, filename));
            oldFile.delete();
            Process process = new ProcessBuilder(Paths.LOCAL_FFMPEG, "-y", "-i", baseDir + String.format(srcFile, filename), "-filter:a", "volume=" + String.valueOf(VolumeConfig.getFfmpegTc506s()), "-ar", "8000", "-ac", "1", "-af", atempoParam, "-acodec", "pcm_u8", Paths.tempAudioDir + String.format(srcQueryFileWAV, "1st" + filename)).start();
            while (process.isAlive()) {
            }
            process.destroyForcibly();
            if (!isNotFound) {
                Process removeSilence = new ProcessBuilder(Paths.LOCAL_FFMPEG, "-y", "-i", Paths.tempAudioDir + String.format(srcQueryFileWAV, "1st" + filename), "-af", "silenceremove=start_periods=1:start_silence=0.1:start_threshold=-96dB,areverse,silenceremove=start_periods=1:start_silence=0.2:start_threshold=-96dB,areverse", "-acodec", "pcm_u8", Paths.tempAudioDir + String.format(srcQueryFileWAV, filename)).start();
                while (removeSilence.isAlive()) {
                }
                removeSilence.destroyForcibly();
            }
            waitProcess = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void convertWithFfmpeg(String filename) {
        while (waitProcess) {
        }
        waitProcess = true;
        try {
            File oldFile = new File(baseDir + String.format(srcQueryFileMP3, filename));
            oldFile.delete();
            Process process = new ProcessBuilder(Paths.LOCAL_FFMPEG, "-y", "-i", baseDir + String.format(srcFile, filename), "-filter:a", "volume=" + String.valueOf(VolumeConfig.getFfmpegTC506M()), "-ar", "16000", Paths.tempAudioDir + String.format(srcQueryFileMP3, filename)).start();
            boolean i = false;
            while (process.isAlive()) {
            }
            process.destroyForcibly();
            waitProcess = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void convertWithFfmpegGBot(String filename) {
        while (waitProcess) {
        }
        waitProcess = true;
        try {
            File oldFile = new File(baseDir + String.format(srcQueryFileMP3, filename));
            oldFile.delete();
            Process process = new ProcessBuilder(Paths.LOCAL_FFMPEG, "-y", "-i", baseDir + String.format(srcFile, filename), "-filter:a", "volume=" + String.valueOf(VolumeConfig.getFfmpegGBot()), "-ar", "16000", Paths.tempAudioDir + String.format(srcQueryFileMP3, filename)).start();
            boolean i = false;
            while (process.isAlive()) {
            }
            process.destroyForcibly();
            waitProcess = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String replaceWords(String text) {
        String[] aux = text.split(" ");
        String replaced = "";
        for (int i = 0; i < aux.length; ++i) {
            replaced = replaced + WordsReplace.getReplacedWord(aux[i]) + " ";
        }
        return replaced;
    }
}

