/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvDispClear;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowText;
import br.com.gertec.tc.server.util.NamedColor;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;

public class CommandToImage {
    private static final int DEFAULT_WIDTH = 472;
    private static final int DEFAULT_HEIGHT = 280;

    public static File fromText(List<Command> commands) {
        return CommandToImage.fromText(commands, 472, 280);
    }

    public static File fromText(List<Command> commands, int WIDTH, int HEIGHT) {
        BufferedImage image = new BufferedImage(WIDTH, HEIGHT, 13);
        Graphics2D graphic2D = image.createGraphics();
        for (Command command : commands) {
            if (command instanceof IDvDispClear) {
                short colorId = ((IDvDispClear)command).getColor();
                Color c = new Color(NamedColor.fromId(colorId).getRgb(), true);
                graphic2D.setColor(c);
                graphic2D.fillRect(0, 0, WIDTH, HEIGHT);
            }
            if (!(command instanceof IDvShowText)) continue;
            IDvShowText cmdText = (IDvShowText)command;
            String[] token = cmdText.toString().split("\n");
            for (int i = 1; i < token.length; ++i) {
                token[i] = token[i].split(":")[1].trim();
            }
            int textX = Integer.parseInt(token[1]);
            int textY = Integer.parseInt(token[2]);
            Font font = new Font(token[4], 0, Integer.parseInt(token[5]));
            FontMetrics metrics = graphic2D.getFontMetrics(font);
            int fontHeight = metrics.getHeight();
            int fontWidth = metrics.stringWidth(token[3]);
            graphic2D.setColor(new Color(NamedColor.fromName(token[7]).getRgb(), true));
            graphic2D.fillRect(textX, textY - fontHeight + 4, fontWidth, fontHeight);
            graphic2D.setFont(font);
            Color c = new Color(NamedColor.fromName(token[6]).getRgb(), true);
            graphic2D.setColor(c);
            graphic2D.drawString(token[3], textX, textY);
        }
        graphic2D.dispose();
        File file = new File("file.png");
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            Log.error(J18N.tr("Error on image converting: %s", new Object[0]), e.getMessage());
            e.printStackTrace();
        }
        return file;
    }
}

