/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.event.Timer;
import java.util.Date;

public class IdleTimer
extends Timer {
    private final long idleTimeout;
    private volatile long previousTimeStamp;

    public static long getTimeStamp() {
        return new Date().getTime();
    }

    public IdleTimer(EventLoop eventLoop, long idleTimeout, String name) {
        super(eventLoop, name);
        this.idleTimeout = idleTimeout;
        this.setSingleshot(false);
        this.setDelay(idleTimeout < 0L ? 0L : idleTimeout);
        this.setInterval(idleTimeout);
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.resetTimer();
    }

    public void resetTimer() {
        this.previousTimeStamp = IdleTimer.getTimeStamp();
    }

    protected void onIdleTimeout() {
    }

    @Override
    protected void onTimeout() {
        super.onTimeout();
        long elapsed = IdleTimer.getTimeStamp() - this.previousTimeStamp;
        if (elapsed >= this.getIdleTimeout()) {
            this.onIdleTimeout();
            this.resetTimer();
        }
    }
}

