/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ListenerMap<K, L extends br.com.gertec.tc.server.util.Listener> {
    private final Map<K, MyList<L>> listenerMap = new LinkedHashMap<K, MyList<L>>();

    private MyList<L> myGetListeners(K key) {
        MyList<Object> list = this.listenerMap.get(key);
        if (list == null) {
            list = new MyList();
            this.listenerMap.put(key, list);
        }
        return list;
    }

    public List<L> getListeners(K key) {
        return this.myGetListeners(key).getReadOnly();
    }

    public void addListener(K key, L listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        MyList<L> listeners = this.myGetListeners(key);
        if (!listeners.contains(listeners)) {
            listeners.add(listener);
        }
    }

    public void removeListener(K key, L listener) {
        MyList<L> listeners = this.myGetListeners(key);
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            this.listenerMap.remove(key);
        }
    }

    public void removeListeners(K key) {
        this.listenerMap.remove(key);
    }

    public static interface Listener {
    }

    private static class MyList<T>
    extends LinkedList<T> {
        private List<T> readOnly;

        private MyList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<T> getReadOnly() {
            MyList myList = this;
            synchronized (myList) {
                if (this.readOnly == null) {
                    this.readOnly = Collections.unmodifiableList(this);
                }
                return this.readOnly;
            }
        }
    }
}

