/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;

public class Resources {
    private static final int BUFFER_SIZE = 8192;

    private static URL getResourceURL(String fileName) {
        URL url = Resources.class.getResource(fileName);
        return url;
    }

    public static String getPackageName() {
        return Resources.class.getPackage().toString().replace("package ", "");
    }

    public static ImageIcon getImageIcon(String imageName) {
        URL imageUrl = Resources.getResourceURL(imageName);
        if (imageUrl == null) {
            return new ImageIcon();
        }
        return new ImageIcon(imageUrl);
    }

    public static Image getImage(String imageName) {
        return Toolkit.getDefaultToolkit().getImage(Resources.getResourceURL(imageName));
    }

    public static ResourceBundle getResourceBundle(String baseFileName, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(Resources.getPackageName() + "." + baseFileName, locale);
    }

    public static InputStream getInputStream(String fileName) throws FileNotFoundException, IOException {
        InputStream is = Resources.class.getResourceAsStream(fileName);
        if (is == null) {
            throw new FileNotFoundException("Resource not found: " + fileName);
        }
        return is;
    }

    public static File copyResource(String embeddedPath, String destinationPath) throws FileNotFoundException, IOException {
        InputStream in = Resources.getInputStream(embeddedPath);
        File file = new File(destinationPath);
        File parentDir = file.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Cannot create dir: " + parentDir.getCanonicalPath());
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        int len = 0;
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) > -1) {
            ((OutputStream)out).write(buffer, 0, len);
        }
        ((OutputStream)out).close();
        in.close();
        return file;
    }

    public static File extractEmbeddedZip(String embeddedZipPath, String destinationDirPath) throws FileNotFoundException, IOException {
        byte[] buffer = new byte[1024];
        File destinationDir = new File(destinationDirPath);
        if (!destinationDir.exists() && !destinationDir.mkdirs()) {
            throw new IOException("Cannot create destination dir: " + destinationDirPath);
        }
        if (destinationDir.exists() && destinationDir.isFile()) {
            throw new IOException("Destination directory path points to a file");
        }
        InputStream is = Resources.getInputStream(embeddedZipPath);
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (!ze.isDirectory()) {
                    int len;
                    String fileName = ze.getName();
                    File newFile = new File(destinationDir, fileName);
                    File newParentFile = newFile.getParentFile();
                    if (!newParentFile.exists() && !newParentFile.mkdirs()) {
                        throw new IOException("Cannot create directory: " + newParentFile.getCanonicalPath());
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        return destinationDir;
    }
}

