/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.GenericTc;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UpdateFirmwareUtils {
    public static void sendFirmwareBPG2(File file, AbstractTcConnection connection) {
        int bytesRead = 0;
        int bloco = 0;
        try {
            FileInputStream initialStream = new FileInputStream(file);
            byte[] bufferFile = new byte[131077];
            byte[] bufferByte = new byte[131072];
            bufferFile[0] = 35;
            bufferFile[1] = 102;
            bufferFile[2] = 119;
            while ((bytesRead = ((InputStream)initialStream).read(bufferByte, 0, 131072)) != -1) {
                bufferFile[3] = (byte)(bloco + 48);
                bufferFile[4] = 0;
                for (int contador = 0; contador < bytesRead; ++contador) {
                    bufferFile[contador + 5] = bufferByte[contador];
                }
                connection.write(bufferFile);
                ++bloco;
                bufferByte = new byte[131072];
                Thread.sleep(3000L);
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void sendFirmware_S(File file, AbstractTcConnection connection) {
        int bytesRead = 0;
        int bloco = 0;
        try {
            FileInputStream initialStream = new FileInputStream(file);
            byte[] bufferFile = new byte[65540];
            byte[] bufferByte = new byte[65536];
            bufferFile[0] = 35;
            bufferFile[1] = 102;
            bufferFile[2] = 119;
            while ((bytesRead = ((InputStream)initialStream).read(bufferByte, 0, 65536)) != -1) {
                bufferFile[3] = (byte)bloco;
                for (int contador = 0; contador < bytesRead; ++contador) {
                    bufferFile[contador + 4] = bufferByte[contador];
                }
                connection.write(bufferFile);
                Thread.sleep(3000L);
                ++bloco;
                bufferByte = new byte[65536];
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean is406UpdateCompatible(GenericTc tc) {
        String version = tc.getTerminalVersion();
        System.out.println("VERSION " + version);
        int intVersion = Integer.parseInt(UpdateFirmwareUtils.removeUnnecessaryText(version));
        return intVersion >= 121 && intVersion <= 299;
    }

    public static boolean is406SUpdateCompatible(GenericTc tc) {
        String version = tc.getTerminalVersion();
        int intVersion = Integer.parseInt(UpdateFirmwareUtils.removeUnnecessaryText(version));
        return intVersion > 331 && version.toLowerCase().contains("s");
    }

    public static boolean is406S(GenericTc tc) {
        String version = tc.getTerminalVersion();
        int intVersion = Integer.parseInt(UpdateFirmwareUtils.removeUnnecessaryText(version));
        return intVersion > 299;
    }

    private static String removeUnnecessaryText(String version) {
        version = version.replace(".", "").replace(" ", "");
        version = version.replaceAll("[^\\d.]", "");
        return version;
    }
}

