/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class Util {
    public static Charset defaultCharset = Charset.forName("ISO-8859-1");

    public static int getUnsignedByte(byte b) {
        return b & 0xFF;
    }

    public static byte[] getBytesFromIpv4String(String ipv4String) {
        String[] splitIp = ipv4String.split("\\.");
        if (splitIp.length != 4) {
            throw new InvalidParameterException("Ip inv\u00e1lido com " + splitIp.length + " campos");
        }
        byte[] ipBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            Integer number = Integer.parseInt(splitIp[i]);
            ipBytes[i] = number.byteValue();
        }
        return ipBytes;
    }

    public static String removeSlash(InetAddress localAddress) {
        return localAddress.toString().substring(1);
    }

    public static byte[] stringToByteArray(String toConvert) {
        byte[] bytes = toConvert.getBytes(defaultCharset);
        return bytes;
    }

    public static byte[] stringToByteArray(String toConvert, String charset) {
        byte[] bytes = toConvert.getBytes(Charset.forName(charset));
        return bytes;
    }

    public static String getIpV4String(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(String.format("%d", Util.getUnsignedByte(bytes[i])));
        }
        return sb.toString();
    }

    public static byte[] getBytesFromMacString(String macAddress) {
        String[] splitMac = macAddress.split(":");
        byte[] macBytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            Integer hexa = Integer.parseInt(splitMac[i], 16);
            macBytes[i] = hexa.byteValue();
        }
        return macBytes;
    }

    public static String getStringFromMacBytes(byte[] macBytes) {
        if (macBytes.length != 6) {
            throw new InvalidParameterException("Array must have 6 bytes");
        }
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        int divider = 58;
        char[] hexChars = new char[macBytes.length * 2 + 5];
        int jump = 0;
        for (int i = 0; i < macBytes.length; ++i) {
            int v = macBytes[i] & 0xFF;
            hexChars[i * 2 + jump] = hexArray[v >>> 4];
            hexChars[i * 2 + 1 + jump] = hexArray[v & 0xF];
            if (i == macBytes.length - 1) continue;
            hexChars[i * 2 + 2 + jump] = 58;
            ++jump;
        }
        return new String(hexChars);
    }

    public static String getNullTerminatedString(byte[] bytes) {
        return Util.getNullTerminatedString(bytes, "ISO-8859-1");
    }

    public static String getNullTerminatedString(byte[] bytes, String charset) {
        return Util.getNullTerminatedString(bytes, Charset.forName(charset));
    }

    public static String getNullTerminatedString(byte[] bytes, Charset charset) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0) continue;
            return new String(bytes, 0, i, charset);
        }
        return new String(bytes, charset);
    }

    public static String getCString(String rawString) {
        char[] chars = rawString.toCharArray();
        int nullTerminatorIndex = chars.length;
        for (int i = 0; i < nullTerminatorIndex; ++i) {
            if (chars[i] != '\u0000') continue;
            nullTerminatorIndex = i;
            break;
        }
        return rawString.substring(0, nullTerminatorIndex);
    }

    public static BufferedImage getBitmap(byte[] data, int width, int height, int paletteColors) {
        int i;
        BufferedImage bitmap = new BufferedImage(width, height, 6);
        int[] argb888 = new int[width * height];
        for (i = 0; i < argb888.length; ++i) {
            argb888[i] = 0;
        }
        for (i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int tmpIndex = Util.getUnsignedByte(data[i + j + paletteColors * 3]);
                int r = Util.getUnsignedByte(data[tmpIndex * 3]);
                int g = Util.getUnsignedByte(data[tmpIndex * 3 + 1]);
                int b = Util.getUnsignedByte(data[tmpIndex * 3 + 2]);
                bitmap.setRGB(i, j, new Color(r, g, b).getRGB());
            }
        }
        return bitmap;
    }

    public static byte[] getIndexedImageStream(File imageFile, int width, int height) {
        try {
            BufferedImage originalImage = ImageIO.read(imageFile);
            int finalWidth = width;
            int finalHeight = height;
            if (finalWidth == -1) {
                finalWidth = originalImage.getWidth();
            }
            if (finalHeight == -1) {
                finalHeight = originalImage.getHeight();
            }
            BufferedImage resizedImage = new BufferedImage(finalWidth, finalHeight, 13);
            Graphics2D g = resizedImage.createGraphics();
            g.drawImage(originalImage, 0, 0, width, height, null);
            g.dispose();
            IndexColorModel colorModel = (IndexColorModel)resizedImage.getColorModel();
            byte[] reds = new byte[256];
            colorModel.getReds(reds);
            byte[] greens = new byte[256];
            colorModel.getGreens(greens);
            byte[] blues = new byte[256];
            colorModel.getBlues(blues);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int i = 0; i < 256; ++i) {
                baos.write(reds[i]);
                baos.write(greens[i]);
                baos.write(blues[i]);
            }
            byte[] rasterData = ((DataBufferByte)resizedImage.getRaster().getDataBuffer()).getData();
            baos.write(rasterData);
            return baos.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getFilenameFromCompletePath(String path) {
        String[] splitted = path.split("/");
        int last = splitted.length - 1;
        return splitted[last];
    }

    public byte[] get504ProtocolFilename(String filename) {
        int argFilenameSize = 128;
        byte[] resultBytes = new byte[argFilenameSize];
        byte[] nameBytes = filename.getBytes();
        if (nameBytes.length > argFilenameSize) {
            throw new RuntimeException("filename is too big. Max 128 bytes");
        }
        for (int i = 0; i < argFilenameSize; ++i) {
            resultBytes[i] = i < nameBytes.length ? nameBytes[i] : (byte)0;
        }
        return resultBytes;
    }

    private static int gcd(int i, int j) {
        return j == 0 ? i : Util.gcd(j, i % j);
    }

    private static void rotate(List v, int a, int b, int shift) {
        int size = b - a;
        int r = size - shift;
        int g = Util.gcd(size, r);
        for (int i = 0; i < g; ++i) {
            int to = i;
            Object tmp = v.get(a + to);
            int from = (to + r) % size;
            while (from != i) {
                v.set(a + to, v.get(a + from));
                to = from;
                from = (to + r) % size;
            }
            v.set(a + to, tmp);
        }
    }

    public static void move(List<?> items, int start, int end, int to) {
        int last;
        int first;
        System.out.printf("Selected elements: %s\n", items.subList(start, end + 1));
        int shift = to - start;
        if (shift < 0) {
            first = to;
            last = end;
        } else {
            first = start;
            last = to + end - start;
        }
        Util.rotate(items, first, last + 1, shift);
    }

    private Util() {
    }

    public static boolean isAUnixSystem() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("nix") || os.contains("nux") || os.contains("aix");
    }

    public static String convertToValidCurrencyFormat(String price) {
        if (price != "") {
            String regex = "\\b(\\d{1,7}([.,]\\d{2}))\\b";
            NumberFormat numberFormat = NumberFormat.getCurrencyInstance(new Locale("pt", "BR"));
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(price);
            if (matcher.find()) {
                String precoStr = matcher.group(1);
                precoStr = precoStr.replaceAll(",", ".");
                String newPrice = numberFormat.format(Double.parseDouble(precoStr));
                return newPrice;
            }
        }
        return price;
    }
}

