/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.org.reconcavo.j18n.J18N;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;

public class WeightBarcode {
    private String barcode;
    private String productBarcode;
    private double productWheight;
    private Product product;
    private String hostAddressString;
    private String weightPrice1;
    private String weightPrice2;
    private AbstractTcConnection connection;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    public static final String LOG_TAG_QUERY = "QUERY";
    public int firstDigit;
    public int initBarcode;
    public int endBarcode;
    public int initWeigth;
    public int endWeight;

    public WeightBarcode(String barcode, AbstractTcConnection connection) {
        this.hostAddressString = connection.getInetAddress().getHostAddress();
        this.barcode = barcode;
        this.connection = connection;
        this.initConfigSettings();
    }

    public String getProductBarcode() {
        return this.productBarcode;
    }

    public double getProductWheight() {
        return this.productWheight;
    }

    public void getProduct() {
        this.product = new Product();
        Product productBd = Product.get(this.productBarcode);
        this.product = productBd != null ? productBd.cloneProduct() : null;
    }

    public Product getFormatedProduct() {
        this.getProduct();
        if (this.product != null) {
            this.weightPrice1 = !this.product.getPrice1().isEmpty() && this.product.getPrice1() != null ? this.product.getPrice1() : "";
            this.weightPrice2 = !this.product.getPrice2().isEmpty() && this.product.getPrice2() != null ? this.product.getPrice2() : "";
            Application.logQuery(this.connection.getInetAddress(), this.product, this.productBarcode);
            Product formatedProduct = this.product;
            if (this.product.getPrice1() != null && !this.weightPrice1.isEmpty()) {
                try {
                    double price1 = Double.parseDouble(this.weightPrice1.replaceAll(",", ".").replaceAll("[^0-9.]", ""));
                    formatedProduct.setPrice1(DECIMAL_FORMAT.format(price1 * this.productWheight));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    formatedProduct.setPrice1("");
                }
            } else {
                formatedProduct.setPrice1("");
            }
            if (this.product.getPrice2() != null && !this.weightPrice2.isEmpty()) {
                try {
                    double price2 = Double.parseDouble(this.weightPrice2.replaceAll(",", ".").replaceAll("[^0-9.;,]", ""));
                    formatedProduct.setPrice2(DECIMAL_FORMAT.format(price2 * this.productWheight));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    formatedProduct.setPrice2("");
                }
            } else {
                formatedProduct.setPrice2("");
            }
            this.logWeightBarcodeQuery(formatedProduct.getPrice1(), formatedProduct.getPrice2());
            return formatedProduct;
        }
        return null;
    }

    private void logWeightBarcodeQuery(String price1, String price2) {
        Log.infoTag(LOG_TAG_QUERY, this.hostAddressString + ":" + J18N.tr("Weight / Quantity: %s", this.productWheight), new Object[0]);
        Log.infoTag(LOG_TAG_QUERY, this.hostAddressString + ":" + J18N.tr("Price KG / Price Quantity: %s", this.weightPrice1), new Object[0]);
        Log.infoTag(LOG_TAG_QUERY, this.hostAddressString + ":" + J18N.tr("Price1 final: %s", price1), new Object[0]);
        if (price2 != null && !price2.isEmpty()) {
            Log.infoTag(LOG_TAG_QUERY, this.hostAddressString + ":" + J18N.tr("Price KG / Price Quantity: %s", this.weightPrice2), new Object[0]);
            Log.infoTag(LOG_TAG_QUERY, this.hostAddressString + ":" + J18N.tr("Price2 final: %s", price2), new Object[0]);
        }
    }

    private void initConfigSettings() {
        File fl = new File(Application.APP_DIR, "weightBarcodeSettings.config");
        try {
            BufferedReader br = new BufferedReader(new FileReader(fl));
            String line = br.readLine();
            while (line != null) {
                String[] splittedLine = line.split(";");
                switch (splittedLine[0]) {
                    case "FIRST_DIGIT": {
                        try {
                            this.firstDigit = Integer.parseInt(splittedLine[1]);
                        }
                        catch (Exception e) {
                            Log.error(J18N.tr("The value of the %s variable is invalid. The default value %s will be set", "FIRST_DIGIT", "2"), new Object[0]);
                            this.firstDigit = Integer.parseInt("2");
                        }
                        break;
                    }
                    case "INIT_BARCODE": {
                        try {
                            this.initBarcode = Integer.parseInt(splittedLine[1]);
                        }
                        catch (Exception e) {
                            Log.error(J18N.tr("The value of the %s variable is invalid. The default value %s will be set", "INIT_BARCODE", "1"), new Object[0]);
                            this.initBarcode = Integer.parseInt("1");
                        }
                        break;
                    }
                    case "END_BARCODE": {
                        try {
                            this.endBarcode = Integer.parseInt(splittedLine[1]);
                        }
                        catch (Exception e) {
                            Log.error(J18N.tr("The value of the %s variable is invalid. The default value %s will be set", "END_BARCODE", "7"), new Object[0]);
                            this.endBarcode = Integer.parseInt("7");
                        }
                        break;
                    }
                    case "INIT_WEIGHT": {
                        try {
                            this.initWeigth = Integer.parseInt(splittedLine[1]);
                        }
                        catch (Exception e) {
                            Log.error(J18N.tr("The value of the %s variable is invalid. The default value %s will be set", "INIT_WEIGHT", "7"), new Object[0]);
                            this.initWeigth = Integer.parseInt("7");
                        }
                        break;
                    }
                    case "END_WEIGHT": {
                        try {
                            this.endWeight = Integer.parseInt(splittedLine[1]);
                            break;
                        }
                        catch (Exception e) {
                            Log.error(J18N.tr("The value of the %s variable is invalid. The default value %s will be set", "END_WEIGHT", "12"), new Object[0]);
                            this.endWeight = Integer.parseInt("12");
                        }
                    }
                }
                line = br.readLine();
            }
            this.productBarcode = this.formatBarcode(this.barcode);
            this.productWheight = Double.parseDouble(this.barcode.substring(this.initWeigth, this.endWeight)) / 1000.0;
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean checkWeightBarcode(String barcode) {
        boolean barcodeLength = barcode.length() == 13;
        boolean startsWith2 = barcode.startsWith(String.valueOf(this.firstDigit));
        return barcodeLength && startsWith2;
    }

    private String formatBarcode(String barcode) {
        String produto = barcode.substring(this.initBarcode, this.endBarcode);
        return this.firstDigit + produto + "000000";
    }
}

